<?php
class Email{

    /*
     * Envoie un email
     * @param   string/array (mail destinataire)
     * @param   string (mail expéditeur)
     * @param   string (nom expéditeur)
     * @param   string (sujet)
     * @param   string (message)
     * @param   int (temps d'attente entre les mails en sec.)
     * @param   array (stmtp paramètres)
     * @return  bool
     */
    static function send($recipients,$sender,$sender_name,$subject,$msg,$sleep=null,$smtp=null){

        include_once(_PS_SWIFT_DIR_.'Swift.php');
        include_once(_PS_SWIFT_DIR_.'Swift/Connection/SMTP.php');
        include_once(_PS_SWIFT_DIR_.'Swift/Connection/NativeMail.php');
        include_once(_PS_SWIFT_DIR_.'Swift/Plugin/Decorator.php');

        // via Smtp
        if(!empty($smtp)){
            $Connection = new Swift_Connection_SMTP($smtp['server'],$smtp['port'],$smtp['crypt']);
            $Connection->setUsername($smtp['user']);
            $Connection->setPassword($smtp['pw']);
        // via Mail
        }else{
            $Connection = new Swift_Connection_NativeMail();
        }

        $Swift = new Swift($Connection);
        $subject = Tools::htmlentitiesDecodeUTF8($subject);
        $Msg = new Swift_Message($subject,$msg,'text/html');
        $nbMailsSend = 0;

        if(is_array($recipients)){
            foreach($recipients as $recipient){
                $send = $Swift->send($Msg,$recipient,new Swift_Address($sender,$sender_name));
                $nbMailsSend++;
                if(!empty($sleep) && $sleep>0){
                    sleep($sleep);
                }
            }
        }else{
            $recipient = $recipients;
            $send = $Swift->send($Msg,$recipient,new Swift_Address($sender,$sender_name));
            $nbMailsSend++;
        }

        $Swift->disconnect();
        return $nbMailsSend;
    }

}
?>
