<?php

/**
  * Expeditor Inet tab for admin panel, AdminExpinet.php
  * @author Vinum Master
  * @copyright Vinum Master
  * @version 1.51  // compatible PS 1.5
  *
  */

include_once(_PS_ADMIN_DIR_.'/../classes/AdminTab.php');

class AdminExpinet extends AdminTab
{
	

	public function __construct()
	{
		 global $cookie;

	 	$this->table = 'expinet';
		$this->optionTitle = 'Expeditor Inet';
		
		$this->_directory = dirname(_PS_MODULE_DIR_).'/modules/presta2expinet/';
		$this->_filename = $this->_directory.'export.csv';
		$this->_filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/presta2expinet/export.csv';
		$this ->_filenameExport_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/presta2expinet/export.csv';
		$this->_adminDirectory= dirname(__FILE__).'/';
	
		
		parent::__construct();
		
	}
	private function _addToFeed($str)
	{
		if(file_exists($this->_filename))
		{
			$fp = fopen($this->_filename, 'ab');
			fwrite($fp, $str, strlen($str));
			fclose($fp);
		}
	}
	private function _postValidation()
	{
	
		@unlink($this->_filename);
		$fp = fopen($this->_filename, 'wb');
		fclose($fp);
		if (!file_exists($this->_filename))
		{
		echo '<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				Impossible d\'écrire '.realpath($this->_filename).'
  			</div>';
		}
	}
	public function postProcess()
	{
		global $currentIndex, $cookie;
		
		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		$importURL = Configuration::get('VINUM_EXPINET_IMPORTURL');
		$exportURL= Configuration::get('VINUM_EXPINET_EXPORTURL');
		$carriersString= Configuration::get('VINUM_EXPINET_CARRIERS');
		$stateExport = Configuration::get('VINUM_EXPINET_STATE_EXPORT');
	

		if (!empty($_POST))
		{
			   	$this->_postValidation();
		}
			
		if (Tools::isSubmit('Import'))
		{
			$content_dir = "../../modules/presta2expinet/";
		    $extensions_OK = array('csv', 'txt');
			if(empty($_FILES['ImportFile']['name']))
			{
				echo '<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				Aucun fichier sélectionné
  			</div>';
			}
			if( !is_uploaded_file($_FILES['ImportFile']['tmp_name']) )
			{
				echo '<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				Impossible de charger le fichier
  			</div>';
				
			}
			$tmp_file = $_FILES['ImportFile']['tmp_name'];
			$ext = strtolower( pathinfo($_FILES['ImportFile']['name'],  PATHINFO_EXTENSION) );
			if(!in_array($ext, $extensions_OK))
			{
				echo '<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				Format de fichier non autorisé (seulement txt ou csv)
  			</div>';
				
			}

			$name_file =$_FILES['ImportFile']['name'];
					
			if(!move_uploaded_file($tmp_file,$this->_directory.$name_file))
			{
			
				echo '<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				Impossible de copier le fichier '.realpath($this->_directory.$name_file).'
  			</div>';
				
			}
			else
			{
			
					if (($handle = fopen($this->_directory.$name_file, "r")) !== FALSE)
			{
					
					$newOrderStatusId = intval(Configuration::get('VINUM_EXPINET_STATE_ENVOIE'));
					
					while (($data = fgetcsv($handle, 0, ";")) !== FALSE) 
					{	

						$shipping_number = pSQL($data[0]);
						$order=new Order((int) $data[1]);
						$order->shipping_number = $shipping_number;   // pour compatibilité < PS 1.5
                        
                       	if(round(_PS_VERSION_,1)>=1.5)
                       	$id_order_carrier = Db::getInstance()->getValue('
						SELECT `id_order_carrier`
						FROM `'._DB_PREFIX_.'order_carrier`
						WHERE `id_order` = '.(int)$order->id);
                        
                        
                        
                        
                        if($data[1]!="" && $shipping_number!="")
                        {   
							$order->update();  // pour compatibilité < 1.5
                           	if(round(_PS_VERSION_,1)>=1.5)
                            {
                              $order_carrier = new OrderCarrier($id_order_carrier);  
						      $order_carrier->tracking_number=$shipping_number;
                              $order_carrier->update(); 
                            }
                            
					       
							$customer = new Customer((int)$order->id_customer);
					        $carrier = new Carrier((int)$order->id_carrier, $order->id_lang);
                            if(round(_PS_VERSION_,1)<1.5)
                            {
							$templateVars = array(
								'{followup}' => str_replace('@', $order->shipping_number, $carrier->url),
								'{firstname}' => $customer->firstname,
								'{lastname}' => $customer->lastname,
								'{id_order}' => (int)($order->id));
												 
                                $sujet= utf8_encode(Mail::l('Package in transit'));
                          		@Mail::Send((int)($order->id_lang), 'in_transit', $sujet, $templateVars, $customer->email, $customer->firstname.' '.$customer->lastname, NULL, NULL, NULL, NULL,_PS_MAIL_DIR_, true);
							}
                            else
                            {
                               	$templateVars = array(
    							'{followup}' => str_replace('@', $order->shipping_number, $carrier->url),
    							'{firstname}' => $customer->firstname,
    							'{lastname}' => $customer->lastname,
    							'{id_order}' => (int)($order->id),
    							'{order_name}' => $order->getUniqReference());
                                
                                @Mail::Send((int)$order->id_lang, 'in_transit', Mail::l('Package in transit', (int)$order->id_lang), $templateVars,
							$customer->email, $customer->firstname.' '.$customer->lastname, null, null, null, null,
							_PS_MAIL_DIR_, true, (int)$order->id_shop);
                                    
                            }
                                  
							
							$history = new OrderHistory();
							$history->id_order = (int)$data[1];
                            if(round(_PS_VERSION_,1)<1.5)
							$history->id_employee = (int)($cookie->id_employee);
                            else
                           	$history->id_employee = (int)$this->context->employee->id;

							$history->changeIdOrderState((int)($newOrderStatusId), (int)($data[1]));
							$query = 'INSERT INTO '._DB_PREFIX_.'order_history (id_order, id_order_state, date_add) VALUES ("'.(int) $data[1].'", "'.$newOrderStatusId.'", now())';
					       	Db::getInstance()->execute($query);
                        }
					} 
					
					echo '<script language="JavaScript">alert(\'Les N° de suivi ont été mis à jour et le statut passé à "En cours de Livraison"\'); </script>';
				}	
				else
				{
					echo '<div class="warning confirm">
					<img src="../img/admin/warning.gif" alt="" title="" />
					Impossible d\'ouvrir le fichier '.realpath($this->_directory.$name_file).'
					</div>';
				}
				
			}
		}	
		
		else
			parent::postProcess();
	
	}
	public function displayTop()
	{
		echo 
		'<fieldset style="background-color: #94B4C0;"><legend>Comment exportez vos commandes vers Expeditor Inet?</legend>'.
			'<ul>'.'
				<li>Les commandes pouvant être exportées vers Expeditor Inet sont affichées dans le tableau ci-dessous.<br />'.'</li>
				<li>Vous pouvez vérifier le détails des commandes en cliquant sur l\'icône dans la colonne "Voir Détails"</li>
				<li>Si toutes vos commandes sont effectivement prètes pour l\'export :</li>
				<li>Cliquez sur Exportez les commandes</li>
				<li>Sous le bouton Exportez les commandes apparaitra un lien vous permetant de sauvegarder le fichier export.csv sur votre ordinateur</li>
				<li>Pour faire cela, faites un clic droit et choisissez "Enregistrer la cible du lien sous ...". Sauvegardez le fichier dans le répertoire d\'import de expeditor Inet. Normalement c\'est C:/EXPINET/INT_AUTO/ ou C:/EXPINET/INTEG_AUTO/ (pour les nouvelles versions de Expeditor Inet)</li>
				<li>Une fois le fichier enregistré dans le répertoire d\'import de Expeditor Inet, vous pouvez ouvrir Expeditor Inet pour faire l\'Import dans ce logiciel. (voir la doc Expeditor Inet ou le fichier presta2expinet.pdf fourni avec le module)</li>
			</ul>
		</fieldset><br />';
	}
	public function displayForm($isMainTab = true)
	{
		global $currentIndex, $cookie;
		$stateExport = Configuration::get('VINUM_EXPINET_STATE_EXPORT');
		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		$carriersString= Configuration::get('VINUM_EXPINET_CARRIERS');
        $assurance=Configuration::get('VINUM_EXPINET_ASSURANCE');
		$recommandation=Configuration::get('VINUM_EXPINET_RECOMMANDATION');	
     
	
	$filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/presta2expinet/export.csv';
 
				
		$exportStateName = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('
		SELECT `name` 
		FROM `'._DB_PREFIX_.'order_state_lang`
		WHERE `id_order_state` = '.(int)($stateExport).'
		AND `id_lang` = '.(int) ($id_lang));
			
	echo '
	  
	
	<h2>Exportez les commandes avec le statut : "'.$exportStateName['name'].'"</h2>
		<fieldset style="background-color: #f9e3bd;"><legend>Exportez les commandes</legend>
		
		<script language="JavaScript">
    <!--
	function getXMLHttpRequest()
					{
						var xhr = null;
	
						if (window.XMLHttpRequest || window.ActiveXObject)
						{
							if (window.ActiveXObject) 
							{
								try
								{
									xhr = new ActiveXObject("Msxml2.XMLHTTP");
								} catch(e)
								{
									xhr = new ActiveXObject("Microsoft.XMLHTTP");
								}
							} else 
							{
								xhr = new XMLHttpRequest(); 
							}
						} 
						else
						{
							alert("Votre navigateur ne supporte pas l\'objet XMLHTTPRequest...");
							return null;
						}
	
						return xhr;
					}
		
    function request(callback) {

	var xhr = getXMLHttpRequest();
	
	xhr.onreadystatechange = function() {
	   
		if (xhr.readyState == 4 && (xhr.status == 200 || xhr.status == 0)) {
		
			callback(xhr.responseText);
			document.getElementById("loader").style.display = "none";
           
		}
		else if (xhr.readyState < 4)
		{
			document.getElementById("loader").style.display = "inline";
		}
	};
		var orderlist = "";
with(document.importExpeditor) 
{
	for(var i = 0; i < orderBox.length; i++)
	{
		if(orderBox[i].checked)
		{
		    newweight=(weight[i].value).replace(",",".");
            newassurance=(assuranceBox[i].value).replace(",",".");
            newrecommandation=recommandationBox[i].value;
            
         	size="N";
			if(sizeBox[i].checked)
			size="O";
			orderlist += "id_order=" + orderBox[i].value + "," + "weight=" + newweight + "," +"size=" +size + "," + "assurance=" +newassurance +"," + "recommandation=" +newrecommandation +",";
			
		}
		
	}
	if(orderBox.length==undefined)
	{
	
		newweight=(weight.value).replace(",",".");
        newassurance=(assuranceBox[i].value).replace(",",".");
        newrecommandation=recommandationBox[i].value;  
		size="N";
		if(sizeBox.checked)
		size="O";
		orderlist += "id_order=" + orderBox.value + "," + "weight=" + newweight + "," +"size=" +size + "," + "assurance=" +newassurance +"," + "recommandation=" +newrecommandation +",";
	
	}	
}	
	orderlist=orderlist.substr(0,orderlist.length-1);
	
	xhr.open("POST", "../modules/presta2expinet/OrdersExport.php",true);
    xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
	xhr.send("ordersID="+orderlist);

}
	function readData(sData) {
	document.getElementById(\'fileLink\').style.display=\'block\';
	
}
function loader()
{
document.getElementById("loader2").style.display = "inline";
	

}
function mycheckDelBoxes(whatobj)
{

with(document.importExpeditor) 
{

for(var ic = 0; ic < whatobj.length; ic++)
		{
			if(whatobj[ic].checked)
			{
			whatobj[ic].checked=false;
			}
			else
			whatobj[ic].checked=true;
		}
if(whatobj.length==undefined)
{
whatobj[0]=whatobj;
if(whatobj[0].checked)
			{
			whatobj[0].checked=false;
			}
			else
			whatobj[0].checked=true;
}		
}
}
    -->
    </script>
		
				<form name="importExpeditor" >';
		
					$sqllist='SELECT id_order FROM '._DB_PREFIX_.'orders o
								WHERE '.$stateExport.' = (
											SELECT id_order_state
											FROM '._DB_PREFIX_.'order_history oh
											WHERE oh.id_order = o .id_order
											ORDER BY date_add DESC, id_order_history DESC
											LIMIT 1)
								AND o.id_carrier IN ('.$carriersString.')'; 
           					
				$orders = Db::getInstance()->ExecuteS($sqllist);
					if ($orders!="")
					{
						
					 echo '<div align="center">
					<table cellspacing="0" cellpadding="0" class="table" name="mytab" style="text-align:center;">
						<tr>
							<th><input type="checkbox" name="checkme" class="noborder" onclick="mycheckDelBoxes(orderBox);" /></th>
							<th>ID</th>
							<th>Client</th>
							<th>Date</th>
							<th>Prix total</th>
							<th>Poids</th>
                          	<th>Assurance</th>
                            <th width="200px" >Recommandations</th>
                         	<th>Prix Transport</th>
							<th>Pays</th>
							<th>Transporteur</th>
							<th>Hors Gabarit</th>
							<th>Voir Détails</th>
						
						</tr>';
						$irow = 0;
				     foreach ($orders as $order)
						{
						
							$orderInfo=new Order($order['id_order']);
							$weight=$orderInfo->getTotalWeight();
							$addressDelivery = new Address($orderInfo->id_address_delivery, (int)($id_lang));
							$country=New Country($addressDelivery->id_country);
							$carrier=New Carrier($orderInfo->id_carrier);
							
							echo '<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">
								<td>'.'<input type="checkbox" name="orderBox"  id="orderBox_'.$order['id_order'].'" value="'.$order['id_order'].'" checked/></td>
								<td>'.$order['id_order'].'</td>
								<td><label for="orderBox_'.$order['id_order'].'" class="t">'.$addressDelivery->firstname." ".$addressDelivery->lastname.'</label></td>
								<td>'.$orderInfo->date_add.'</td>
								<td>'.$orderInfo->total_paid.'</td>
								<td><input type="text" name="weight" size="7" value="'.Tools::ps_round($weight,2).'"></td>
                             	<td><center>
                                
                                	<select id="assurance_'.$order['id_order'].'" name="assuranceBox" style="width:50px">
                                    <option value="0">0</option>';
                                    if($assurance && $orderInfo->total_paid<=150)
                                    echo '<option value="150" selected>150</option>';
                                    else
                                    echo '<option value="150" >150</option>';
                                    if($assurance && $orderInfo->total_paid>150 &&  $orderInfo->total_paid<=300)
                                   echo '<option value="300" selected>300</option>';
                                   else
                                     echo '<option value="300" >300</option>';
                                   if($assurance && $orderInfo->total_paid>300 &&  $orderInfo->total_paid<=450)
                                   echo '<option value="450" selected>450</option>';
                                   else
                                     echo '<option value="450" >450</option>';
                                 if($assurance && $orderInfo->total_paid>450 &&  $orderInfo->total_paid<=600)
                                   echo '<option value="600" selected>600</option>';
                                   else
                                     echo '<option value="600" >600</option>';
                                 if($assurance && $orderInfo->total_paid>600 &&  $orderInfo->total_paid<=750)
                                   echo '<option value="750" selected>750</option>';
                                   else
                                     echo '<option value="750" >750</option>';
                                 if($assurance && $orderInfo->total_paid>750 &&  $orderInfo->total_paid<=900)
                                   echo '<option value="900" selected>900</option>';
                                   else
                                     echo '<option value="900" >900</option>';
                                if($assurance && $orderInfo->total_paid>900 &&  $orderInfo->total_paid<=1050)
                                   echo '<option value="1050" selected>1050</option>';
                                   else
                                     echo '<option value="1050" >1050</option>';
                                if($assurance && $orderInfo->total_paid>1050 &&  $orderInfo->total_paid<=1200)
                                   echo '<option value="1200" selected>1200</option>';
                                   else
                                     echo '<option value="1200" >1200</option>';
                               if($assurance && $orderInfo->total_paid>1200 &&  $orderInfo->total_paid<=1350)
                                   echo '<option value="1350" selected>1350</option>';
                                   else
                                     echo '<option value="1350" >1350</option>';
                               if($assurance && $orderInfo->total_paid>1350)
                                   echo '<option value="1500" selected>1500</option>';
                                   else
                                     echo '<option value="1500" >1500</option>';
                                                               
                                  echo '</select></center></td>
                               	<td><center>
                                
                                	<select id="recommandation_'.$order['id_order'].'" name="recommandationBox" style="width:50px">
                                    <option value="0">R0</option>';
                                     if($recommandation && $orderInfo->total_paid<=50)
                                        echo '<option value="1" selected>R1</option>';
                                        else 
                                        echo '<option value="1" >R1</option>';
                                      if($recommandation && $orderInfo->total_paid>50 && $orderInfo->total_paid<=200)
                                         echo '<option value="2" selected>R2</option>';
                                        else
                                        echo '<option value="2" >R2</option>';
                                     if($recommandation && $orderInfo->total_paid>200)
                                         echo '<option value="3" selected>R3</option>';
                                        else 
                                        echo '<option value="3" >R3</option>';
                                    echo '</select>                                    
                                   </center></td>
							 
								<td>'.$orderInfo->total_shipping.'</td>
								<td>'.$country->name[$id_lang].'</td>
								<td>'.$carrier->name.'</td>
								<td>'.'<center><input type="checkbox" name="sizeBox"  id="sizeBox_'.$order['id_order'].'" /></center></td>
								<td><a href="?tab=AdminOrders&id_order='.$order['id_order'].'&vieworder&token='.Tools::getAdminToken('AdminOrders'.(int)(Tab::getIdFromClassName('AdminOrders')).(int)($cookie->id_employee)).'" target="_blank" ><img src="../img/admin/details.gif"</a></td>
							
							</tr>';
						}
						
					echo '</table></div><div class="margin-form" style="margin-top:10px">
					<p style="padding:0px; margin:10px 0px 10px 0px;">Sélectionnez toutes les commandes que vous voulez exporter vers Expeditor Inet (par défaut toutes)</p>
					</div>';
					} else
						echo '<p>Aucune commande prète pour l\'export</p>';
				
				echo  '<center><input type="button"
             value="Exportez les commandes"
             name="button1"
			 class="button" style="font-weight:bold; width:300px; height:50px; font-size:large"
             onClick="request(readData);"><br>
			<span id="loader" style="display: none;"><img src="../modules/presta2expinet/loader.gif" alt="loading" /></span></center>';		 
	
	echo '	</form>
	<div id="fileLink" style="display:none;">
			    	<br>Votre fichier CSV est en ligne à l\'adresse suivante :<br /><br><a href="'.$filename_http.'" target="_blanck"><b>'.$filename_http.'</b></a></p>
					</div>
		</fieldset><br><br>';
		
		echo 
		'<fieldset style="background-color: #94B4C0;"><legend>Comment importer de Expeditor Inet vers Prestashop afin de mettre à jour le N° de suivi du colis ainsi que le statut de la commande ?</legend>'.
			'<ul>'.'
				<li>Après la création des étiquettes d\'envoie, un fichier a été créé dans Expeditor Inet.(voir doc Expeditor Inet ou le fichier presta2expinet.pdf fourni avec le module)</li>
				<li>Choisissez ce fichier en cliquant sur le bouton "Parcourir" puis ensuite cliquez sur le bouton "Import".</li>
				<li>Une fois la mise à jour terminée une fenêtre Popup s\'ouvrira pour vous l\'indiquer.</li>
			</ul>
		</fieldset><br />';
		
		echo '<h2>Importez depuis Expeditor Inet pour changer le statut de la commande</h2>
			<fieldset style="background-color: #e89eb5;"><legend>Importez</legend>
			<form method="POST" action="'.$currentIndex.'&token='.$this->token.'" enctype="multipart/form-data" >
			<center>
			<input type="hidden" name="MAX_FILE_SIZE" value="2000000" /> 
			<input type="file" name="ImportFile" class="button" style="font-weight:bold; width:200px; height:30px; font-size:large" />
			<p><input type="submit" name="Import" value="Import" class="button" style="font-weight:bold; width:200px; height:50px; font-size:large" onClick="loader();"/></p>  
			</center>
			</form>	
			<center>
			<span id="loader2" style="display: none;"><img src="../modules/presta2expinet/loader.gif" alt="loading" /></span></center>
				
		</fieldset>';

		return parent::displayForm();
		
			
	}
		public function display()
	{
		$this->displayTop();
		$this->displayForm();
		
	}

	
}

?>