<?php

/**
  * Slideshow tab for admin panel, AdminHomeslideshow.php
  * @category admin
  *
  * @author Tiagop <contact@tiagop.com>
  * @copyright Tiagop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 1.0
  *
  */

include_once(PS_ADMIN_DIR.'/../classes/AdminTab.php');
include_once(PS_ADMIN_DIR.'/tabs/AdminPreferences.php');
require_once(_PS_ROOT_DIR_."/modules/homeslideshow/homeslideshow.php");

class AdminHomeslideshow extends AdminPreferences
{
	private $xml;
	private $HomeslideshowModule;
	
	public function __construct()
	{
		global $cookie;
		$this->HomeslideshowModule = new Homeslideshow();
		$this->xml = simplexml_load_file(_PS_ROOT_DIR_.$this->HomeslideshowModule->xml_file);
		parent::__construct();
	}
	
	public function postProcess()
	{
		global $currentIndex, $cookie;
		
		 $languages = Language::getLanguages();
		 $xml_file = _PS_ROOT_DIR_.$this->HomeslideshowModule->xml_file;
		 
		if (isset($_GET['submitDeleteSlide']))
		{	
			$id = intval(Tools::getValue('id_slide'));
			$element = $this->xml->slide[$id];
			
			@unlink(_PS_ROOT_DIR_.$this->HomeslideshowModule->save_path.$element['img']);
			unset($this->xml->slide[$id]);
			
			file_put_contents($xml_file, $this->xml->asXML());
			Tools::redirectAdmin($currentIndex.'&conf=1&token='.$this->token);
		 	//echo "DELETE";
			
		}elseif(isset($_GET['submitUpdateSlide'])){
		 	
			$id = intval(Tools::getValue('id_slide'));
			$element = $this->xml->slide[$id];
			$element['link'] = htmlspecialchars($_POST['link']);
			
			foreach ($languages as $language){
				
				$node = $this->xml->xpath("//slide[".($id+1)."]/lang[@name='".$language['iso_code']."']");
				$desc_value = htmlspecialchars($_POST['desc_'.$language['id_lang']]);
				$title_value = htmlspecialchars($_POST['title_'.$language['id_lang']]);
				
				if(isset($node[0])){
					$node[0][0] = $desc_value;
					$node[0][0]['title'] = $title_value;
				}else{
					$newlang = $element->addChild("lang",$desc_value);
					$newlang->addAttribute("name",$language['iso_code']);
					$newlang->addAttribute("title",$title_value);
				}
			}
			
			file_put_contents($xml_file, $this->xml->asXML());
			
			Tools::redirectAdmin($currentIndex.'&conf=4&token='.$this->token);
			
		}elseif(isset($_GET['submitAddSlide'])){
			
			//print_r($_FILES);
			if (isset($_FILES['slidefile']) && isset($_FILES['slidefile']['tmp_name']) AND !empty($_FILES['slidefile']['tmp_name']))
			{
				$tmp_file = $_FILES['slidefile']['tmp_name'];
				$file_name = $_FILES['slidefile']["name"];
				$save_path = _PS_ROOT_DIR_.$this->HomeslideshowModule->save_path;
				
				if (isset($_file["error"]) && $_file["error"] != 0) 
					$this->_errors[] = Tools::displayError('an error occurred while uploading image');
				if(!in_array(substr(strrchr($file_name,'.'), 1), $this->HomeslideshowModule->supported_formats))
					$this->_errors[] = Tools::displayError('image format not recognized, allowed formats are: .gif, .jpg, .png');		
				if (file_exists($save_path . $file_name))
					$this->_errors[] = Tools::displayError('an error occurred while uploading image');
				if (!@move_uploaded_file($tmp_file, $save_path . $file_name)) 
					$this->_errors[] = Tools::displayError('an error occurred while uploading image');		
			}else{
				$this->_errors[] = Tools::displayError('no file selected');	
			}
			
			if(!sizeof($this->_errors)){
				
				$link = htmlspecialchars($_POST['link']);
				$element = $this->xml->addChild("slide");
				$element->addAttribute("link",$link);
				$element->addAttribute("img",$file_name);
				
				foreach ($languages as $language){
					$desc = htmlspecialchars($_POST['desc_'.$language['id_lang']]);
					$title = htmlspecialchars($_POST['title_'.$language['id_lang']]);
					$newlang = $element->addChild("lang",$desc);
					$newlang->addAttribute("name",$language['iso_code']);
					$newlang->addAttribute("title",$title);
				}
				
				file_put_contents($xml_file, $this->xml->asXML());
				
				Tools::redirectAdmin($currentIndex.'&conf=3&token='.$this->token);
			}
		}	
	}
	
	public function display() {
		return $this->HomeslideshowModule->adminTabExec($this->token);
	}
	
	
}

?>