<?php
/*
* Un bloc pour afficher les moyens de paiements configurable
* basé sur le module blockreinsurance
*/

/** Classe de Prestashop V1.5 - a supprimer donc quand l'application aura ete migree en 1.5 */
/** require_once dirname(__FILE__) . '/ImageManager.php'; */

if (!defined('_PS_VERSION_'))
	exit;

class NnBlockPaymentLogo extends Module
{

	private $_max_nb_blocks = 15;

	public function __construct()
	{
		$this->name = 'nnblockpaymentlogo';
		if (version_compare(_PS_VERSION_, '1.4.0.0') >= 0)
			$this->tab = 'front_office_features';
		else
			$this->tab = 'Blocks';
		$this->version = '1.0';

		parent::__construct();

		$this->displayName = $this->l('NN Block payment logo');
		$this->description = $this->l('Add a block to display payment logos that can be configured');
	}
	
	public function install()
	{
		return (
			parent::install()
			&& $this->installDB()
			&& Configuration::updateValue('nnblockpaymentlogo_nbblocks', 5)
			&& Configuration::updateValue('nnblockpaymentlogo_cmsid', 0)
			&& $this->registerHook('leftColumn')
		);
	}
	
	public function installDB()
	{
		return Db::getInstance()->execute('
		CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'nnblockpaymentlogo` (
			`id_contactinfos` INT UNSIGNED NOT NULL AUTO_INCREMENT,
			`filename` VARCHAR(100) NOT NULL,
			`text` VARCHAR(300) NOT NULL,
			PRIMARY KEY (`id_contactinfos`)
		) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8 ;');
	}
	
	public function uninstall()
	{
		// Delete configuration
		return (
			Configuration::deleteByName('nnblockpaymentlogo_nbblocks')
			&& Configuration::deleteByName('nnblockpaymentlogo_cmsid')
			&& $this->uninstallDB()
			&& parent::uninstall()
		);
	}
	
	public function uninstallDB()
	{
		return Db::getInstance()->execute('
		DROP TABLE IF EXISTS `'._DB_PREFIX_.'nnblockpaymentlogo`');
	}
	
	public function addToDB()
	{
		if (isset($_POST['nbblocks']))
		{			
			for ($i = 1; $i <= (int)$_POST['nbblocks']; $i++)
			{
				$filename = explode('.', $_FILES['info'.$i.'_file']['name']);
				if (isset($_FILES['info'.$i.'_file']) && isset($_FILES['info'.$i.'_file']['tmp_name']) && !empty($_FILES['info'.$i.'_file']['tmp_name']))
				{
					if ($error = ImageManager::validateUpload($_FILES['info'.$i.'_file']))
						return false;
					elseif (!($tmpName = tempnam(_PS_TMP_IMG_DIR_, 'PS')) || !move_uploaded_file($_FILES['info'.$i.'_file']['tmp_name'], $tmpName))
						return false;
					elseif (!ImageManager::resize($tmpName, dirname(__FILE__).'/img/'.$filename[0].'.jpg'))
						return false;
					unlink($tmpName);
				}
				Db::getInstance()->execute('INSERT INTO `'._DB_PREFIX_.'nnblockpaymentlogo` (`filename`,`text`)
											VALUES ("'.((isset($filename[0]) && $filename[0] != '') ? pSQL($filename[0]) : '').
											'", "'.((isset($_POST['info'.$i.'_text']) && $_POST['info'.$i.'_text'] != '') ? pSQL($_POST['info'.$i.'_text']) : '').'")');
			}
			return true;
		} else
			return false;
	}
	
	public function removeFromDB()
	{		 
		$dir = opendir(dirname(__FILE__).'/img');
		while (false !== ($file = readdir($dir)))
		{
			$path = dirname(__FILE__).'/img/'.$file; 
			if ($file != '..' && $file != '.' && !is_dir($file))
				unlink($path);
		}
		closedir($dir);

		return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'nnblockpaymentlogo`');
	}
		
	public function getAllFromDB()
	{
		return Db::getInstance()->executeS('SELECT * FROM `'._DB_PREFIX_.'nnblockpaymentlogo`');
	}
		
	public function getContent()
	{
	
	    global $cookie;
	    
		// If we try to update the settings
		if (isset($_POST['submitModule']))
		{				
			Configuration::updateValue('nnblockpaymentlogo_nbblocks', ((isset($_POST['nbblocks']) && $_POST['nbblocks'] != '') ? (int)$_POST['nbblocks'] : ''));
			
			if (Validate::isUnsignedInt(Tools::getValue('id_cms')))
			{
				Configuration::updateValue('nnblockpaymentlogo_cmsid', (int)(Tools::getValue('id_cms')));
			}
			
			if ($this->removeFromDB() && $this->addToDB())
				echo '<div class="conf confirm"><img src="../img/admin/ok.gif"/>'.$this->l('Configuration updated').'</div>';
			else
				echo '<div class="conf error"><img src="../img/admin/disabled.gif"/>'.$this->l('An error occurred during the save').'</div>';
		}

		$cmss = CMS::listCms((int)($cookie->id_lang));
		
		$nb_blocks = Configuration::get('nnblockpaymentlogo_nbblocks');
		$infos = $this->getAllFromDB();

		$content = '
		<script type="text/javascript">
			$(document).ready(function(){
				var nb_blocks = 5;
				nb_blocks = $("select[name=nbblocks]").val();
				$("div.container_infos").each(function(){
					id_div = $(this).attr("id").split("container_infos");
					if(parseInt(id_div[1]) <= nb_blocks)
						$(this).show();
					else
						$(this).hide();
				});
					
				$("select[name=nbblocks]").change(function(){
					nb_blocks = $("select[name=nbblocks]").val();
					$("div.container_infos").each(function(){
						id_div = $(this).attr("id").split("container_infos");
						if(parseInt(id_div[1]) <= nb_blocks)
							$(this).show();
						else
							$(this).hide();
					});
				});	
			});	
		</script>
		<h2>'.$this->displayName.'</h2>
		<form method="post" action="'.Tools::htmlentitiesutf8($_SERVER['REQUEST_URI']).'" enctype="multipart/form-data">
			<fieldset class="width2">
				<select name="nbblocks">';	
					// Show by default $this->_max_nb_blocks blocks maximum
					for ($i = 1; $i <= $this->_max_nb_blocks; $i++)
						$content .= '<option value="'.$i.'" '.(($i == $nb_blocks) ? 'selected="selected"' : '').'>'.$i.' '.$this->l('block(s)').'</option>';
		$content .= '</select>
				<div class="clear">&nbsp;</div>';					
				// Show by default $this->_max_nb_blocks blocks maximum
				for ($i = 1; $i <= $this->_max_nb_blocks; $i++)
				{
					$content .= '<div id="container_infos'.$i.'" class="container_infos"><h3>'.$this->l('Block number').' '.$i.'</h3>'.
							((!empty($infos[$i - 1]) && $infos[$i - 1]['filename'] != '') ? '<img src="'.Tools::getHttpHost(true)._MODULE_DIR_.$this->name.'/img/'.$infos[$i - 1]['filename'].'.jpg" />' : '').
							'<div class="clear">&nbsp;</div>
							<p><label for="info'.$i.'_file">'.$this->l('Image for this block').' :</label>
							<input type="file" name="info'.$i.'_file" /></p>
							<p><label for="info'.$i.'_text">'.$this->l('Alternative text for this block').' :</label>
							<input type="text" id="info'.$i.'_text" name="info'.$i.'_text" value="'.((!empty($infos[$i - 1]) && $infos[$i - 1]['text'] != '') ? $infos[$i - 1]['text'] : '').'" /></p></div>';
				}					
		$content .= '<div class="clear">&nbsp;</div>';
		
		$content .= '
			<fieldset>
				<legend><img src="'.$this->_path.'/logo.gif" alt="" /> '.$this->l('Configure').'</legend>
				<label>'.$this->l('Page CMS for link').':</label>
				<div class="margin-form">
				<select name="id_cms"><option value="0">('.$this->l('Select a page').')</option>
		';
			foreach ($cmss as $cms)
			$content .= '<option value="'.$cms['id_cms'].'"'.(Configuration::get('PS_PAYMENT_LOGO_CMS_ID') == $cms['id_cms'] ? ' selected="selected"' : '').'>'.$cms['meta_title'].'</option>';
			
		$content .= '
				</select>
				</div>
			<!--	<p class="center"><input class="button" type="submit" name="submitConfiguration" value="'.$this->l('Save settings').'" /></p> -->
			</fieldset>
		';

		$content .= '
				<br /><center><input type="submit" name="submitModule" value="'.$this->l('Update settings').'" class="button" /></center>
			</fieldset>
		</form>';
		
		return $content;
	}

	public function hookLeftColumn($params)
	{	
		global $smarty, $cookie;
		
		$infos = $this->getAllFromDB();		

		if (!Configuration::get('nnblockpaymentlogo_cmsid')) return;
		$cms = new CMS((int)(Configuration::get('nnblockpaymentlogo_cmsid')), (int)($cookie->id_lang));
		if (!Validate::isLoadedObject($cms))
			return;
		
		$smarty->assign(array(
			'nbblocks' => Configuration::get('nnblockpaymentlogo_nbblocks'),
			'cms_payment_logo' => $cms,
			'infos' => $infos
		));
		return $this->display(__FILE__, 'nnblockpaymentlogo.tpl');
	}
}

?>
