<?php
/* 
 * Noir Ô Naturel, simple module to customize how product description is displayed
 *
 * As of standard, it is displayed in a single tab, this hook will split the 
 * description into three separate values, using H2 paragraphs as splitter 
 * It then fills the smarty env with those three values for display as separate 
 * tabs.     
 *
 * The same could probably be achieved using smarty coding directly, 
 * however I don't know smarty. 
 *  
 */

if (!defined('_PS_VERSION_'))
	exit;
	
class nnProductDescription extends Module
{
    
    public function __construct()
    {
        $this->name = 'nnproductdescription';
        $this->tab = 'front_office_features';
        $this->version = 1.0;
        $this->author = 'Noir Ô Naturel';
        $this->need_instance = 0;
        // Override for development
        $this->is_configurable = 0;
        
        parent::__construct();
        
        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Product Description');
        $this->description = $this->l('Allow splitting product description according to H2');
    }
    
    /**
     * Module installation (i.e. called when cliking on install button in administration/module tab
     */
    function install()
    {
    
        // Proceed with standard installation
        if (
          // Parent installation
          !parent::install() 
        
          // Hook registration on product page
          || !$this->registerHook('productTab') || !$this->registerHook('productTabContent')
          || !$this->registerHook('header')
          
        )
        return false;

        return true;
    }
        
    /**
     * Called when deinstalling the module, reverse installation
     */     
    public function uninstall()
    {
        if (!parent::uninstall()) 
        return false;
    
        return true;
    }
    
    /**
     * Hook productTab call
     * returns nnCategoriesForProductTab.tpl if anything to display
     * otherwise null
     */     
    public function hookProductTab($param)
    {
        global $smarty;
        
        // Check if product was assigned to smarty
        // if not useless to proceed as product is not available for display
        $product = $smarty->getTemplateVars('product');
        if (isset($product) && isset($product->description)) {
            // Split according to Header H2 
            $tab = preg_split ( 
                '/(<[h|H]2)/' ,    // pattern 
                $product->description , // string to split
                $limit = 4, // nb delimiters => 3      
                PREG_SPLIT_DELIM_CAPTURE // include delimiter 
            );
            // $tab should contain in full : text part, first h2, text part, second h2, text part, third h2, rest of description
            // that explain the work that follows
            $nb = count($tab);
            $vars['nn_description_1'] = ( $nb > 2 ? $tab[0].$tab[1].$tab[2] : $product->description );
            if ($nb > 3) {
                $vars['nn_description_2'] = ( $nb > 4 ? $tab[3].$tab[4] : $tab[3] );
                if ($nb > 5) {
                    $vars['nn_description_3'] = ( $nb > 6 ? $tab[5].$tab[6] : $tab[5] ); 
                }
            }
            /*
            $res = '';
            $res.= 'nn_1' . ':' . htmlspecialchars($vars['nn_description_1'], ENT_NOQUOTES, 'UTF-8') . '<br />';
            $res.= 'nn_2' . ':' . htmlspecialchars($vars['nn_description_2'], ENT_NOQUOTES, 'UTF-8') . '<br />';
            $res.= 'nn_3' . ':' . htmlspecialchars($vars['nn_description_3'], ENT_NOQUOTES, 'UTF-8') . '<br />';
            d($res);
            */
            
            $smarty->assign($vars);
        }
        return ($this->display(__FILE__, '/nnProductDescriptionTab.tpl'));
    }
    
    /**
     * Hook productTabContent call
     */     
    public function hookProductTabContent($params)
    {        
        return ($this->display(__FILE__, '/nnProductDescription.tpl'));
    }
    
    /**
     *  Hook to include the style sheet
     */
    function hookHeader($params)
	{
	   Tools::addCSS(($this->_path).'css/default.css', 'all');		
	}

}
