<?php

/*
* @author Julien 'delphiki' Villetorte <gdelphiki@gmail.com>
* http://www.delphiki.com/
* http://twitter.com/delphiki
*
*/

class ColissimoAPI{
    private $image_dir = './images/';
    private $host = 'http://www.laposte.fr';
    private $page = '/outilsuivi/web/suiviInterMetiers.php';
    private $user_agent = 'Dalvik/1.4.0 (Linux; U; Android 2.3.5; HTC Desire HD Build/GRJ90)';
    private $key;
    private $method;
    private $code;
    private $param_string;
    private $xmlResponse;
    private $jsonResponse;
    private $invalidResponse;
    private $parsedResponse = array();
    
    public function __construct($_key = 'd112dc5c716d443af02b13bf708f73985e7ee943'){
        $this->setKey($_key);
    }
    
    public function getStatus($_code, $_method = 'xml', $_plain = false)
	{
	
     //   if(!preg_match('#^[0-9]{1}[a-zA-Z]{1}[0-9]{11}#', $_code))
	//	 return 'N° invalide';
    		
        $this->code = $_code;
        $allowed_methods = array('xml', 'json', 'img');
        
        if(!in_array($_method, $allowed_methods))
         return 'Invalid method';
        
        $this->method = $_method;
        
        $this->param_string = '?key='.urlencode($this->key).'&code='.urlencode($this->code);
        
        $res = $this->host.$this->page.$this->param_string;
        switch($_method){
            case 'xml':
                $this->getXmlResponse();
            break;
            case 'json':
                $this->getJsonResponse();
            break;
            case 'img':
			default:
                $this->getImageResponse();
            break;
        }
        
        return ($_plain ? $this->getPlainResponse() : $this->parsedResponse);
    }

    private function getPlainResponse(){
        switch($this->method){
            case 'xml':
                $response = $this->xmlResponse;
            break;
            case 'json':
                $response = $this->jsonResponse;
            break;
            case 'img':
            default:
                $response = $this->image_dir.$this->code.'.jpg';
            break;
        }
        return $response;
    }

    public function setImageDir($_image_dir){
        $this->image_dir = $_image_dir;
        if(substr($this->image_dir, -1) !== '/')
            $this->image_dir .= '/';
        if(!is_writable($this->image_dir))
            throw new Exception('Image directory not writable.');
    }
    
    public function setKey($_key){
        if(preg_match('#^[a-zA-Z0-9]{40}$#', $_key))
            $this->key = $_key;
        else
            throw new Exception('Invalid key.');
    }

    public function setUserAgent($_user_agent){
        $this->user_agent = $_user_agent;
    }
    
    private function getXmlResponse(){
        $ch = curl_init();
        
        $url = $this->host.$this->page.$this->param_string.'&method=xml';
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, $this->user_agent);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FAILONERROR, true);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
curl_setopt($ch, CURLOPT_TIMEOUT, 3);
$data = curl_exec($ch);
curl_close($ch);
        
        $this->xmlResponse = $data;
        return $this->parseXmlResponse();
    }
    
    private function getJsonResponse(){
        $ch = curl_init();
        
        $url = $this->host.$this->page.$this->param_string.'&method=json';
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, $this->user_agent);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FAILONERROR, true);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
curl_setopt($ch, CURLOPT_TIMEOUT, 3);
$data = curl_exec($ch);
curl_close($ch);
        
        $this->jsonResponse = $data;
        return $this->parseJsonResponse();
    }
    
    private function getImageResponse(){
	
        $ch = curl_init();
        
        $url = $this->host.$this->page.$this->param_string;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, $this->user_agent);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FAILONERROR, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
        curl_setopt($ch, CURLOPT_TIMEOUT, 3);
        $data = curl_exec($ch);
        curl_close($ch);
        
        $newImg = imagecreatefromstring($data);
        imagejpeg($newImg, $this->image_dir.$this->code.'.jpg',100);

        $this->parsedResponse = array(
            'code' => $this->code,
            'image' => $this->image_dir.$this->code.'.jpg'
        );
    }

    private function parseXmlResponse(){
        $dom = new DOMDocument('1.0', 'utf-8');
        if(!$dom->loadXML($this->xmlResponse)){
            $this->invalidResponse = $this->xmlResponse;
            $this->xmlResponse = null;
            
            if($this->invalidResponse != '')
                return $this->invalidResponse;
            else
                throw new Exception("Invalid XML.\n\n".$this->invalidResponse);
        }
        
        $this->parsedResponse['status'] = $dom->getElementsByTagName('status')->item(0)->nodeValue;
        $this->parsedResponse['code'] = $dom->getElementsByTagName('code')->item(0)->nodeValue;
        $this->parsedResponse['client'] = $dom->getElementsByTagName('client')->item(0)->nodeValue;
        $this->parsedResponse['date'] = $dom->getElementsByTagName('date')->item(0)->nodeValue;
        $this->parsedResponse['message'] = $dom->getElementsByTagName('message')->item(0)->nodeValue;
        $this->parsedResponse['gamme'] = $dom->getElementsByTagName('gamme')->item(0)->nodeValue;
        $this->parsedResponse['base_label'] = $dom->getElementsByTagName('base_label')->item(0)->nodeValue;
        $this->parsedResponse['link'] = $dom->getElementsByTagName('link')->item(0)->nodeValue;
        $this->parsedResponse['error'] = $dom->getElementsByTagName('error')->item(0)->nodeValue;
       
        $this->parsedResponse = array_map('utf8_decode', $this->parsedResponse);
        
        return true;
    }
    
    private function parseJsonResponse(){
        if($this->jsonResponse === null){
            $this->invalidResponse = $this->jsonResponse;
            $this->jsonResponse = null;
            
            if($this->invalidResponse != '')
                return $this->invalidResponse;
            else
                throw new Exception("Invalid JSON.\n\n".$this->invalidResponse);
        }
        
        $this->parsedResponse = json_decode($this->jsonResponse, true);
        $this->parsedResponse = array_map('utf8_decode', $this->parsedResponse);
        
        return true;
    }
}