<?php

class FacebookLike extends Module
{
 	private $_html = '';
	private $_fl_layout = '';
	private $_fl_faces = '';
	private $_fl_width = '';
	private $_fl_text = '';
	private $_fl_font = '';
	private $_fl_color = '';
	private $_fl_send = '';
	
	
 	function __construct()
	{
		$this->name = 'facebooklike';
		$this->tab = floatval(substr(_PS_VERSION_,0,3))<1.4?'Presto-Changeo':'social_networks';
		$this->version = '1.3.1';
		if (floatval(substr(_PS_VERSION_,0,3)) >= 1.4)
			$this->author = 'Presto-Changeo';
		
		parent::__construct();
		$this->_refreshProperties();
		
		$this->displayName = $this->l('Facebook Like');
		$this->description = $this->l('Adds a Facebook "Like" button to product page');
	}
	
	
	function install()
	{
		if (!parent::install())
			return false;
		$hooked = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'hook` WHERE name = "facebookLike"');
		if (!is_array($hooked) || sizeof($hooked) == 0)
			Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'hook` (
			`id_hook` ,`name` ,`title` ,`description` ,`position`)
			VALUES (NULL , "facebookLike", "Facebook Like", "Custom hook for Facebook Like Module", "1");');
		if (!$this->registerHook('extraLeft') || !$this->registerHook('facebookLike') || !$this->registerHook('header'))
			return false;
		Configuration::updateValue('FL_LAYOUT','standard');			
		Configuration::updateValue('FL_FACES','false');			
		Configuration::updateValue('FL_WIDTH','260');			
		Configuration::updateValue('FL_TEXT','like');			
		Configuration::updateValue('FL_FONT','arial');			
		Configuration::updateValue('FL_COLOR','light');			
		Configuration::updateValue('FL_SEND','');			
		return true;
	}

	private function _refreshProperties()
	{
		$this->_fl_layout = Configuration::get('FL_LAYOUT');
		$this->_fl_faces = Configuration::get('FL_FACES');
		$this->_fl_width = max(intval(Configuration::get('FL_WIDTH')),$this->_fl_layout == "standard"?225:90);
		$this->_fl_text = Configuration::get('FL_TEXT');
		$this->_fl_font = Configuration::get('FL_FONT');
		$this->_fl_color = Configuration::get('FL_COLOR');
		$this->_fl_send = Configuration::get('FL_SEND');
	}

	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';
		$this->_postProcess();
		$this->_displayForm();
		return $this->_html;
	}
	
    private function _displayForm()
    {
    	global $cookie;
		$ps_version  = floatval(substr(_PS_VERSION_,0,3));
    	$this->_html .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" name="facebooklike_form" id="facebooklike_form" method="post">
			<fieldset class="width3" style="width:850px"><legend><img src="'.$this->_path.'logo.gif" />'.$this->l('Installation Instructions (Optional)').'</legend>
				<b style="color:blue">'.$this->l('To display the "Like" button in a different hook').'</b>:
				<br />
				<br />
				'.$this->l('Add').' <b style="color:green">'.$this->l('{$HOOK_FACEBOOK_LIKE}').'</b> '.$this->l('in the tpl file you want it to show').'.
				<br />
				<br />
				'.($ps_version >= 1.4?$this->l('Copy /modules/facebooklike/override/classes/FrontController.php to /override/classes/ (If the file already exists, you will have to merge both files)'):$this->l('Add').' <b style="color:green">\'HOOK_FACEBOOK_LIKE\' => Module::hookExec(\'facebookLike\'),</b> '.$this->l('to /header.php below HOOK_TOP around line #15')).'.
			</fieldset>
			<br />
		<fieldset class="width3" style="width:850px"><legend><img src="'.$this->_path.'logo.gif" />'.$this->l('Facebook Like Settings').'</legend>
			<table border="0" width="850">
			<tr height="30">
				<td align="left" valign="top" width="120">
					<b>'.$this->l('Layout Style').':</b> 
				</td>
				<td align="left" valign="top">
   					<select name="fl_layout" style="width:150px">
   						<option value="standard" '.(Tools::getValue('fl_layout', $this->_fl_layout) == "standard"?"selected":"").'>'.$this->l('Standard').'</option>
   						<option value="button_count" '.(Tools::getValue('fl_layout', $this->_fl_layout) == "button_count"?"selected":"").'>'.$this->l('Compact (Count)').'</option>
   						<option value="box_count" '.(Tools::getValue('fl_layout', $this->_fl_layout) == "box_count"?"selected":"").'>'.$this->l('Box (Count)').'</option>
   					</select>
				</td>
			</tr>
			<tr height="30">
				<td align="left" valign="top">
					<b>'.$this->l('Show Faces').':</b> 
				</td>
				<td align="left" valign="top">
   					<select name="fl_faces" style="width:150px">
   						<option value="false" '.(Tools::getValue('fl_faces', $this->_fl_faces) == "false"?"selected":"").'>'.$this->l('No').'</option>
   						<option value="true" '.(Tools::getValue('fl_faces', $this->_fl_faces) == "true"?"selected":"").'>'.$this->l('Yes').'</option>
   					</select>
				</td>
			</tr>
			<tr height="30">
				<td align="left" valign="top">
					<b>'.$this->l('Send Button').':</b> 
				</td>
				<td align="left" valign="top">
   					<select name="fl_send" style="width:150px">
   						<option value="false" '.(Tools::getValue('fl_send', $this->_fl_send) == "false"?"selected":"").'>'.$this->l('No').'</option>
   						<option value="true" '.(Tools::getValue('fl_send', $this->_fl_send) == "true"?"selected":"").'>'.$this->l('Yes').'</option>
   					</select>
				</td>
			</tr>
			<tr height="30">
				<td align="left" valign="top">
					<b>'.$this->l('Width').':</b> 
				</td>
				<td align="left" valign="top">
   					<input type="text" style="width:140px" name="fl_width" value="'.max(Tools::getValue('fl_width', $this->_fl_width),$this->_fl_layout == "standard"?225:90).'">
   					'.$this->l('Minimum 225 (Standard), 90 (Compact)').'
				</td>
			</tr>
			<tr height="30">
				<td align="left" valign="top">
					<b>'.$this->l('Text').':</b> 
				</td>
				<td align="left" valign="top">
   					<select name="fl_text" style="width:150px">
   						<option value="like" '.(Tools::getValue('fl_text', $this->_fl_text) == "like"?"selected":"").'>'.$this->l('Like').'</option>
   						<option value="recommend" '.(Tools::getValue('fl_text', $this->_fl_text) == "recommend"?"selected":"").'>'.$this->l('Recommend').'</option>
   					</select>
				</td>
			</tr>
			<tr height="30">
				<td align="left" valign="top">
					<b>'.$this->l('Font').':</b> 
				</td>
				<td align="left" valign="top">
   					<select name="fl_font" style="width:150px">
   						<option value="arial" '.(Tools::getValue('fl_font', $this->_fl_font) == "arial"?"selected":"").'>'.$this->l('Arial').'</option>
   						<option value="lucida grande" '.(Tools::getValue('fl_font', $this->_fl_font) == "lucida grande"?"selected":"").'>'.$this->l('Lucida Grande').'</option>
   						<option value="segoe ui" '.(Tools::getValue('fl_font', $this->_fl_font) == "segoe ui"?"selected":"").'>'.$this->l('Segoe Ui').'</option>
   						<option value="tahoma" '.(Tools::getValue('fl_font', $this->_fl_font) == "tahoma"?"selected":"").'>'.$this->l('Tahoma').'</option>
   						<option value="trebuchet ms" '.(Tools::getValue('fl_font', $this->_fl_font) == "trebuchet ms"?"selected":"").'>'.$this->l('Trebuchet MS').'</option>
   						<option value="verdana" '.(Tools::getValue('fl_font', $this->_fl_font) == "verdana"?"selected":"").'>'.$this->l('Verdana').'</option>
   					</select>
				</td>
			</tr>
			<tr height="30">
				<td align="left" valign="top">
					<b>'.$this->l('Color').':</b> 
				</td>
				<td align="left" valign="top">
   					<select name="fl_color" style="width:150px">
   						<option value="light" '.(Tools::getValue('fl_color', $this->_fl_color) == "light"?"selected":"").'>'.$this->l('Light').'</option>
   						<option value="dark" '.(Tools::getValue('fl_color', $this->_fl_color) == "dark"?"selected":"").'>'.$this->l('Dark').'</option>
   					</select>
				</td>
			</tr>
			<tr>
				<td colspan="2" align="center">
					<input type="submit" value="'.$this->l('Update').'" name="submitChanges" class="button" />
				</td>
			</tr>
			</table>
			</fieldset>
		</form>';
   	}
    	    
	private function _postProcess()
	{
		if (Tools::isSubmit('submitChanges'))
		{
			if (!Configuration::updateValue('FL_LAYOUT', Tools::getValue('fl_layout'))
				|| !Configuration::updateValue('FL_FACES', Tools::getValue('fl_faces'))
				|| !Configuration::updateValue('FL_WIDTH', Tools::getValue('fl_width'))
				|| !Configuration::updateValue('FL_TEXT', Tools::getValue('fl_text'))
				|| !Configuration::updateValue('FL_FONT', Tools::getValue('fl_font'))
				|| !Configuration::updateValue('FL_SEND', Tools::getValue('fl_send'))
				|| !Configuration::updateValue('FL_COLOR', Tools::getValue('fl_color')))
				$this->_html .= '<div class="alert error">'.$this->l('Cannot update settings').'</div>';
			else
				$this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />'.$this->l('Settings updated').'</div>';
		}
		$this->_refreshProperties();
	}
	
	function hookExtraLeft($params)
	{
		global $smarty;
		if (stripos($_SERVER['HTTP_USER_AGENT'],'bot') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'baidu') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'spider') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'Ask Jeeves') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'slurp') !== false ||
			 stripos($_SERVER['HTTP_USER_AGENT'],'crawl') !== false)
			return;
		$smarty->assign(array('fl_layout' => $this->_fl_layout, 'fl_faces' => $this->_fl_faces,'fl_width' => $this->_fl_width,
			'fl_height' => $this->_fl_faces == "true"?80:35,'fl_text' => $this->_fl_text,'fl_send' => $this->_fl_send,'fl_font' => $this->_fl_font,
			'fl_color' => $this->_fl_color, 'fl_page' => 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'],
			'fl_default_hook' => isset($params['fb_hookFacebookLike'])?0:1));
		return $this->display(__FILE__, 'facebooklike.tpl');
	}

	function hookHeader()
	{
		global $smarty, $cookie;
		if (stripos($_SERVER['HTTP_USER_AGENT'],'bot') !== false ||
			stripos($_SERVER['HTTP_USER_AGENT'],'baidu') !== false ||
			stripos($_SERVER['HTTP_USER_AGENT'],'spider') !== false ||
			stripos($_SERVER['HTTP_USER_AGENT'],'Ask Jeeves') !== false ||
			stripos($_SERVER['HTTP_USER_AGENT'],'slurp') !== false ||
			stripos($_SERVER['HTTP_USER_AGENT'],'crawl') !== false)
			return;
		$lang = strtolower(Language::getIsoById($cookie->id_lang));
		if ($lang == 'af')
			$lang = 'af_ZA';
		elseif ($lang == 'az')
			$lang = 'az_AZ';
		elseif ($lang == 'id')
			$lang = 'id_ID';
		elseif ($lang == 'ms')
			$lang = 'ms_MY';
		elseif ($lang == 'bs')
			$lang = 'bs_BA';
		elseif ($lang == 'ca')
			$lang = 'ca_ES';
		elseif ($lang == 'cs')
			$lang = 'cs_CZ';
		elseif ($lang == 'cy')
			$lang = 'cy_GB';
		elseif ($lang == 'da')
			$lang = 'da_DK';
		elseif ($lang == 'de')
			$lang = 'de_DE';
		elseif ($lang == 'et')
			$lang = 'et_EE';
		elseif ($lang == 'es')
			$lang = 'es_ES';
		elseif ($lang == 'tl')
			$lang = 'tl_PH';
		elseif ($lang == 'fr')
			$lang = 'fr_FR';
		elseif ($lang == 'it')
			$lang = 'it_IT';
		elseif ($lang == 'ka')
			$lang = 'ka_GE';
		elseif ($lang == 'sw')
			$lang = 'sw_KE';
		elseif ($lang == 'ku')
			$lang = 'ku_TR';
		elseif ($lang == 'lv')
			$lang = 'lv_LV';
		elseif ($lang == 'hu')
			$lang = 'hu_HU';
		elseif ($lang == 'nl')
			$lang = 'nl_NL';
		elseif ($lang == 'ja')
			$lang = 'ja_JP';
		elseif ($lang == 'no')
			$lang = 'no_NO';
		elseif ($lang == 'pl')
			$lang = 'pl_PL';
		elseif ($lang == 'pt')
			$lang = 'pt_PT';
		elseif ($lang == 'ro')
			$lang = 'ro_RO';
		elseif ($lang == 'ru')
			$lang = 'ru_RU';
		elseif ($lang == 'sq')
			$lang = 'sq_AL';
		elseif ($lang == 'sk')
			$lang = 'sk_SK';
		elseif ($lang == 'si')
			$lang = 'si_SI';
		elseif ($lang == 'fi')
			$lang = 'fi_FI';
		elseif ($lang == 'sv')
			$lang = 'sv_SE';
		elseif ($lang == 'th')
			$lang = 'th_TH';
		elseif ($lang == 'vi')
			$lang = 'vi_VN';
		elseif ($lang == 'tr')
			$lang = 'tr_TR';
		elseif ($lang == 'zh')
			$lang = 'zh_TW';
		elseif ($lang == 'tw')
			$lang = 'zh_TW';
		elseif ($lang == 'el')
			$lang = 'el_GR';
		elseif ($lang == 'be')
			$lang = 'be_BY';
		elseif ($lang == 'bg')
			$lang = 'bg_BG';
		elseif ($lang == 'mk')
			$lang = 'mk_MK';
		elseif ($lang == 'sr')
			$lang = 'sr_RS';
		elseif ($lang == 'uk')
			$lang = 'uk_UA';
		elseif ($lang == 'hy')
			$lang = 'hy_AM';
		elseif ($lang == 'he')
			$lang = 'he_IL';
		elseif ($lang == 'ar')
			$lang = 'ar_AR';
		elseif ($lang == 'ps')
			$lang = 'ps_AF';
		elseif ($lang == 'fa')
			$lang = 'fa_IR';
		elseif ($lang == 'ne')
			$lang = 'ne_NP';
		elseif ($lang == 'hi')
			$lang = 'hi_IN';
		elseif ($lang == 'bn')
			$lang = 'bn_IN';
		elseif ($lang == 'pa')
			$lang = 'pa_IN';
		elseif ($lang == 'ta')
			$lang = 'ta_IN';
		elseif ($lang == 'te')
			$lang = 'te_IN';
		elseif ($lang == 'ml')
			$lang = 'ml_IN';
		else
			$lang = 'en_US';
		$fb_cover = '';
		$protocol_link = @$_SERVER['HTTPS'] == "on"?"https://":"http://";
		$cover = Product::getCover(intval(Tools::getValue('id_product')));
		if (is_array($cover) && sizeof($cover) == 1)
			$fb_cover = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'img/p/'.Tools::getValue('id_product').'-'.$cover['id_image'].'.jpg';
		$smarty->assign(array('fl_protocol_link' => $protocol_link, 'fl_lang_code' => $lang, 'fl_default_image' => $fb_cover));
		return $this->display(__FILE__, 'header.tpl');
	}

	function hookHome($params)
	{
		$this->_fl_width = "560";
		return $this->hookExtraLeft($params);
	}

	function hookFacebookLike($params)
	{
		$params['fb_hookFacebookLike'] = 1;
		return $this->hookExtraLeft($params);
	}
}
?>