<?php
/*
* 2011-2012 Vinum Master
*
*  @author Vinum Master  <webmaster@vinummaster.com>
*  @copyright  2011-2012 Vinum Master
*  @version  1.51 version ajout compatibilité module socolissimo liberté // compatible PS 1.5
*  attention override/classes class OrderHistory.php
*/
class presta2expinet extends Module
{
		private $_postErrors = array();
		
	
	
	function __construct()
	{
		global $cookie;
		$this->_cookie = $cookie;
		$this->name = 'presta2expinet';
		$this->tab = 'export';
		$this->version = '1.51';
		
		/* The parent construct is required for translations */
		parent::__construct();
		
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Presta 2 Expeditor Inet');
		$this->description = $this->l('Export your orders to Expeditor Inet.');
		
		$this->_directory = dirname(__FILE__).'/';
		$this->_filename = $this->_directory.'export.csv';
		$this->_filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/presta2expinet/export.csv';
	
		
	}

	function install()
	{
		if (!Configuration::updateValue('VINUM_EXPINET_STATE_ENVOIE', 4) OR !parent::install() )
			return false;
		if (!Configuration::updateValue('VINUM_EXPINET_STATE_EXPORT', 3))
			return false;	
		if (!Configuration::updateValue('VINUM_EXPINET_CARRIERS', ''))
			return false;
        if (!Configuration::updateValue('VINUM_EXPINET_EXPERT_FR', ''))
			return false;    
        if (!Configuration::updateValue('VINUM_EXPINET_ACCESS_FR', ''))
			return false;    
        if (!Configuration::updateValue('VINUM_EXPINET_EXPERT_INT', ''))
			return false;     
        if (!Configuration::updateValue('VINUM_EXPINET_EXPERT_OM', ''))
			return false;    
        if (!Configuration::updateValue('VINUM_EXPINET_ACCESS_OM', ''))
			return false;    
        if (!Configuration::updateValue('VINUM_EXPINET_SOCOLISSIMO', ''))
			return false;   
         if (!Configuration::updateValue('VINUM_EXPINET_ASSURANCE', '1'))
			return false;    
        if (!Configuration::updateValue('VINUM_EXPINET_RECOMMANDATION', '1'))
			return false;    
        if (!$this->registerHook('adminOrder'))
			return false;
            
            
      				
		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		
		$tab=new tab();
		$tab->name[$id_lang]= 'Expeditor Inet';
		$tab->class_name= 'AdminExpinet';	
		$tab->id_parent=Tab::getIdFromClassName('AdminOrders'); 
		$tab->add();	
			
		return true;
	}
	
	  function uninstall()
    {
        if (!parent::uninstall()
			OR !Configuration::deleteByName('VINUM_EXPINET_STATE_ENVOIE')
			OR !Configuration::deleteByName('VINUM_EXPINET_STATE_EXPORT')
			OR !Configuration::deleteByName('VINUM_EXPINET_CARRIERS')
          	OR !Configuration::deleteByName('VINUM_EXPINET_EXPERT_FR')
          	OR !Configuration::deleteByName('VINUM_EXPINET_ACCESS_FR')
          	OR !Configuration::deleteByName('VINUM_EXPINET_EXPERT_INT')
          	OR !Configuration::deleteByName('VINUM_EXPINET_EXPERT_OM')
          	OR !Configuration::deleteByName('VINUM_EXPINET_ACCESS_OM')
          	OR !Configuration::deleteByName('VINUM_EXPINET_SOCOLISSIMO')
           	OR !Configuration::deleteByName('VINUM_EXPINET_ASSURANCE')
          	OR !Configuration::deleteByName('VINUM_EXPINET_RECOMMANDATION')
           
            
           )
			return false;
		$idtab=tab::getIdFromClassName('AdminExpinet');
		$tab=new tab($idtab);
		$tab->delete();	
		return true;	
    }
	
		private function _postValidation()
	{
		@unlink($this->_filename);
		$fp = fopen($this->_filename, 'wb');
		fclose($fp);
		if (!file_exists($this->_filename))
		{
		$this->_html .='<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				'.$this->l('Cannot write').' '.realpath($this->_filename).'
  			</div>';
		}
	}
	
	private function _addToFeed($str)
	{
		if(file_exists($this->_filename))
		{
			$fp = fopen($this->_filename, 'ab');
			fwrite($fp, $str, strlen($str));
			fclose($fp);
		}
	}
	

	function getContent()
	{
	
		set_time_limit(0);
		
		$this->_filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__."modules/presta2expinet/AdminExpinet.php";
		$adminpath=$this->cut_string_using_last('/', $_SERVER['REQUEST_URI'], 'left', true); 
		
		if(!file_exists("tabs/AdminExpinet.php"))
		{
			if(!@copy ("../modules/presta2expinet/AdminExpinet.php", "tabs/AdminExpinet.php"))
			{
				echo '<div class="alert error"><img src="'._PS_IMG_.'admin/forbbiden.gif" alt="nok" />&nbsp;Impossible de copier le fichier :<br>
					<i>'.$this->_filename_http.'</i><br>
					Dans le répertoire :<br>
					<i>http://'.$_SERVER['HTTP_HOST'].'/'.$adminpath.'tabs/</i><br>
					Vous devez le faire manuellement.</div>';
				return ;
			}			
		 }
          if(round(_PS_VERSION_,1)<1.5)
         {
		 $this->_filename_http_2 = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__."override/classes/OrderHistory.php";
		 $overridepath=$this->cut_string_using_last('/', '../'.$_SERVER['REQUEST_URI'], 'left', true); 
		
    		if(!file_exists("../override/classes/OrderHistory.php"))
    		{
    			if(!@copy ("../modules/presta2expinet/OrderHistory.php", "../override/classes/OrderHistory.php"))
    			{
    				echo '<div class="alert error"><img src="'._PS_IMG_.'admin/forbbiden.gif" alt="nok" />&nbsp;Impossible de copier le fichier :<br>
    					<i>'.$this->_filename_http_2.'</i><br>
    					Dans le répertoire :<br>
    					<i>http://'.$_SERVER['HTTP_HOST'].'/'.$overridepath.'/override/classes/</i><br>
    					Vous devez le faire manuellement.</div>';
    				return ;
    			}			
    		 } 
           }  
		
		
		
			if (!empty($_POST))
			{
			   	$this->_postValidation();
			}
				$this->_html = '<h2>'.$this->displayName.'</h2>';

			if (isset($_POST['submit']))
			{
			$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
			
				$carriers=$_POST['carrierBox'];
				$stateShipped=$_POST['shipped'];
				$stateExport=$_POST['stateExport'];
                $typesCarriers=$_POST['typeBox'];
				$carriersString=implode(",", $carriers);
                $assurance=$_POST['assurance'];
                $recommandation=$_POST['recommandation'];
				Configuration::updateValue('VINUM_EXPINET_STATE_ENVOIE', $stateShipped);
				Configuration::updateValue('VINUM_EXPINET_STATE_EXPORT', $stateExport);
				Configuration::updateValue('VINUM_EXPINET_CARRIERS', $carriersString);
                Configuration::updateValue('VINUM_EXPINET_ASSURANCE', $assurance);
                Configuration::updateValue('VINUM_EXPINET_RECOMMANDATION', $recommandation);
			 
            
                foreach ($typesCarriers as $typeCarrier)
                {
                    $type=$this->cut_string_using_last("_", $typeCarrier, "left", false);
                    $carrierAsso=$this->cut_string_using_last("_", $typeCarrier, "right", false);
                        if($type=="COL")
                   	        Configuration::updateValue('VINUM_EXPINET_EXPERT_FR', $carrierAsso);
		              	if($type=="COLD")
                   	        Configuration::updateValue('VINUM_EXPINET_ACCESS_FR', $carrierAsso);
				        if($type=="COLI")
                   	        Configuration::updateValue('VINUM_EXPINET_EXPERT_INT', $carrierAsso);
			            if($type=="CDS")
                   	        Configuration::updateValue('VINUM_EXPINET_EXPERT_OM', $carrierAsso);
		                if($type=="COM")
                   	        Configuration::updateValue('VINUM_EXPINET_ACCESS_OM', $carrierAsso);
			            if($type=="SOCOL")
                   	        Configuration::updateValue('VINUM_EXPINET_SOCOLISSIMO', $carrierAsso);
			
                }
                
                         
                
				$this->_html .= '<div class="conf confirm">
							<img src="../img/admin/ok.gif" alt="" title="" />
						  <p>'.$this->l('Your settings have been updated').'<br /><br /></div>';
					

					
			}	
	
			
			$this->_html.='
			<fieldset class="width3" style="width:900px;">
				
				
					
			</fieldset><br><br>';
			
				$this->_html.=$this->_displayForm();
	
			
			return $this->_html;
		
	
	}

	private function _displayForm()
	{
		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		$stateShipped = Configuration::get('VINUM_EXPINET_STATE_ENVOIE');
		$stateExport = Configuration::get('VINUM_EXPINET_STATE_EXPORT');
		$CarriersString= Configuration::get('VINUM_EXPINET_CARRIERS');
		$arrayCarriers=explode(",",$CarriersString);
        
        $expertFRCarrier="COL_".Configuration::get('VINUM_EXPINET_EXPERT_FR'); 
       	$accessFRCarrier= "COLD_".Configuration::get('VINUM_EXPINET_ACCESS_FR');
		$expertINTCarrier="COLI_". Configuration::get('VINUM_EXPINET_EXPERT_INT');
		$expertOMCarrier= "CDS_". Configuration::get('VINUM_EXPINET_EXPERT_OM');
		$accessOMCarrier= "COM_". Configuration::get('VINUM_EXPINET_ACCESS_OM');
		$socolCarrier= "SOCOL_". Configuration::get('VINUM_EXPINET_SOCOLISSIMO');
        $assurance=Configuration::get('VINUM_EXPINET_ASSURANCE');
		$recommandation=Configuration::get('VINUM_EXPINET_RECOMMANDATION');	
        
		if($assurance=="1")
        $assurance=true;
        else
        $assurance=false;

	   if($recommandation=="1")
        $recommandation=true;
        else
        $recommandation=false;
	
		$form='
		<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
	  <form method="post">';
	  		$states=OrderState::getOrderStates($id_lang);
			
	  $form.='<label style="text-align: left">'.$this->l('Export State :').'</label>
					<div class="margin-form" style="margin-top:10px">
					<select id="stateExport" name="stateExport">';
					foreach($states as $state)
					{
						$form .='<option value='.$state['id_order_state'];
						if($state['id_order_state']==$stateExport)
						{
							$form .=' selected>'.$state['name'].'</option>';
						}
						else
						{
							$form .='>'.$state['name'].'</option>';
						}
					}
						$form .='</select>
						<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Select state for which the orders can be exported to Expeditor Inet. (By default:Preparation in progress)').'</p></div><br>';
	  
		$form.='<label style="text-align: left">'.$this->l('Shipped State :').'</label>
					<div class="margin-form" style="margin-top:10px">
					<select id="shipped" name="shipped">';
					foreach($states as $state)
					{
						$form .='<option value='.$state['id_order_state'];
						if($state['id_order_state']==$stateShipped)
						{
							$form .=' selected>'.$state['name'].'</option>';
						}
						else
						{
							$form .='>'.$state['name'].'</option>';
						}
					}
						$form .='</select>
					<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Select state for which the orders are shipped.(By default:Shipped)').'</p></div><br>';
			
				$carriers=Carrier::getCarriers($id_lang, true , false,false, NULL, ALL_CARRIERS);

					if (sizeof($carriers))
					{
						
					$form.='<center><label style="text-align: left">'.$this->l('Carriers:').' </label></center>
					<table cellspacing="0" cellpadding="0" class="table" style="width: 29.5em;">
						<tr>
							<th><input type="checkbox" name="checkme" class="noborder" onclick="checkDelBoxes(this.form, \'carrierBox[]\', this.checked)" /></th>
							<th>'.$this->l('ID').'</th>
							<th>'.$this->l('Carrier name').'</th>
                            	<th>'.$this->l('shipping type').'</th>
						</tr>';
						$irow = 0;
						
						foreach ($carriers as $carrier)
						{
							if(in_array($carrier['id_carrier'],$arrayCarriers))
							$checked=true;
							else
							$checked=false;
							
							$form.='<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">';
							if($checked)
							{
							$form.='<td>'.'<input type="checkbox" name="carrierBox[]" class="carrierBox" id="carrierBox_'.$carrier['id_carrier'].'" value="'.$carrier['id_carrier'].'" checked='.$checked.' /></td>
								<td>'.$carrier['id_carrier'].'</td>
								<td><label for="carrierBox_'.$carrier['id_carrier'].'" class="t">'.$carrier['name'].'</label></td>
                                <td>
                                	<select id="shiptype_'.$carrier['id_carrier'].'" name="typeBox[]">
                                    <option value="COL_'.$carrier['id_carrier'].'"';
                                     if($expertFRCarrier=="COL_".$carrier['id_carrier'])
                                    	$form.=' selected="true">Colissimo Expert France</option>';
                                        else
                                        $form.='>Colissimo Expert France</option>';
                                   
                                    $form.='<option value="COLD_'.$carrier['id_carrier'].'"';
                                     if($accessFRCarrier=="COLD_".$carrier['id_carrier'])
                                    	$form.=' selected="true">Colissimo Access France</option>';
                                        else
                                        $form.='>Colissimo Access France</option>';
                                                                  
                                    $form.='<option value="COLI_'.$carrier['id_carrier'].'"';
                                     if($expertINTCarrier=="COLI_".$carrier['id_carrier'])
                                    	$form.=' selected="true">Colissimo Expert International</option>';
                                        else
                                        $form.='>Colissimo Expert International</option>';
                                        
                                    $form.='<option value="CDS_'.$carrier['id_carrier'].'"';
                                     if($expertOMCarrier=="CDS_".$carrier['id_carrier'])
                                    	$form.=' selected="true">Colissimo Expert OM</option>';
                                        else
                                        $form.='>Colissimo Expert OM</option>';
                                        
                                    $form.='<option value="COM_'.$carrier['id_carrier'].'"';
                                     if($accessOMCarrier=="COM_".$carrier['id_carrier'])
                                    	$form.=' selected="true">Colissimo Access OM</option>';
                                        else
                                        $form.='>Colissimo Access OM</option>';
                                        
                                    $form.='<option value="SOCOL_'.$carrier['id_carrier'].'"';
                                     if($socolCarrier=="SOCOL_".$carrier['id_carrier'])
                                    	$form.=' selected="true">SOColissimo</option>';
                                        else
                                        $form.='>SOColissimo</option>';                                
                                
					               $form.='</select>
                                
                                      </td>';
							}	
							else
							{
							$form.='<td>'.'<input type="checkbox" name="carrierBox[]" class="carrierBox" id="carrierBox_'.$carrier['id_carrier'].'" value="'.$carrier['id_carrier'].'" /></td>
								<td>'.$carrier['id_carrier'].'</td>
								<td><label for="carrierBox_'.$carrier['id_carrier'].'" class="t">'.$carrier['name'].'</label></td>
                                <td>
                              	<select id="shiptype_'.$carrier['id_carrier'].'" name="typeBox[]">
                                  
                                    <option value="COL_'.$carrier['id_carrier'].'" >Colissimo Expert France</option>
                                    <option value="COLD_'.$carrier['id_carrier'].'" >Colissimo Access France</option>
                                    <option value="COLI_'.$carrier['id_carrier'].'" >Colissimo Expert International</option>
                                    <option value="CDS_'.$carrier['id_carrier'].'" >Colissimo Expert OM</option>
                                    <option value="COM_'.$carrier['id_carrier'].'" >Colissimo Access OM</option>
                                    <option value="SOCOL_'.$carrier['id_carrier'].'" >SOColissimo</option>
                                
                                
					               </select></td>';
						
							}
							$form.='</tr>';
						}
                     
					$form.='</table><div class="margin-form" style="margin-top:10px">
					<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Check all carriers you want to link to Expeditor Inet').'</p>
					</div>';
                    if($assurance==true)
                    $form.='<div><input type="checkbox" name="assurance"  id="assurance" style="padding:0px; margin:5px 0px 10px 0px;" value="1" checked />';
                    else
                     $form.='<input type="checkbox" name="assurance"  id="assurance" style="padding:0px; margin:5px 0px 10px 0px;" value="1" />';
                   
                    $form.='<label style="text-align: left">'.$this->l('Select Automatic Warranty:').'</label>
                    <div class="margin-form" ><p style="padding:0px; margin:0px 0px 0px 0px;">'.$this->l('If Checked the warranty will be calculated switch order total price').'<br>
                    '.$this->l('Otherwise there will be no warranty selected.').'<br>
                    '.$this->l('In two cases you could update the waranty').'</p>
                    </div><br><br>';
                    
                     if($recommandation==true)
                     $form.='<div><input type="checkbox" name="recommandation"  id="recommandation" style="padding:0px; margin:5px 0px 10px 0px;" value="1" checked />';
                     else
                      $form.='<div><input type="checkbox" name="recommandation"  id="recommandation" style="padding:0px; margin:5px 0px 10px 0px;" value="1" />';
                
                    $form.='<label style="text-align: left">'.$this->l('Select Automatic Recommandation:').'</label>
                    <div class="margin-form" ><p style="padding:0px; margin:0px 0px 0px 0px;">'.$this->l('If Checked the recommandation will be calculated switch order total price').'<br>
                    '.$this->l('Otherwise the R0 will be selected.').'<br>
                    '.$this->l('In two cases you could update the recommandation').'</p>
                    </div><br><br>';
                      
                    
					} else
						$form.='<p>'.$this->l('No carrier created').'</p>';
					  	
		    $form.='  <br><br><center><input type="submit" name="submit" value="'.$this->l('Submit').'" /><br><br>';
	
		$form.='</form></fieldset>';
		
		return $form;
	
	}
public function setDeliveryExpinet($idorder)
	{
		$number = (int)(Configuration::get('PS_DELIVERY_NUMBER'));
		if (!(int)($number))
			die(Tools::displayError('Invalid delivery number'));
		
		Configuration::updateValue('PS_DELIVERY_NUMBER', $number + 1);

		$order=new Order($idorder);
		$order->delivery_number = $number;
		$order->update();
		
		return $number; 
	}	
 function hookAdminOrder($params)
 {
 Global $cookie;
 $filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/presta2expinet/export.csv';
 $orderInfo=new Order($params['id_order']);
 $weight=Tools::ps_round($orderInfo->getTotalWeight(),2);
 $carriersString= Configuration::get('VINUM_EXPINET_CARRIERS');
 $carriersTab=explode(",",$carriersString);
 
 $assurance=Configuration::get('VINUM_EXPINET_ASSURANCE');
 $recommandation=Configuration::get('VINUM_EXPINET_RECOMMANDATION');	
        
    if($assurance=="1")
    $assurance=true;
    else
    $assurance=false;

    if($recommandation=="1")
    $recommandation=true;
    else
    $recommandation=false;
	
 if($orderInfo->delivery_number==0)
 	$orderInfo->delivery_number=$this->setDeliveryExpinet($params['id_order']);
	
	
 
 
		$display='
<br /><fieldset style="width: 400px">
			<legend><img src="../modules/'.$this->name.'/modem.png" /> '.$this->l('Export Order To Expeditor Inet').'</legend>
	
	<script language="JavaScript">
    <!--
	function getXMLHttpRequest()
					{
						var xhr = null;
	
						if (window.XMLHttpRequest || window.ActiveXObject)
						{
							if (window.ActiveXObject) 
							{
								try
								{
									xhr = new ActiveXObject("Msxml2.XMLHTTP");
								} catch(e)
								{
									xhr = new ActiveXObject("Microsoft.XMLHTTP");
								}
							} else 
							{
								xhr = new XMLHttpRequest(); 
							}
						} 
						else
						{
							alert("Votre navigateur ne supporte pas l\'objet XMLHTTPRequest...");
							return null;
						}
	
						return xhr;
					}
		
    function request(callback) {

	var xhr = getXMLHttpRequest();
	
	
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && (xhr.status == 200 || xhr.status == 0)) {
		
			callback(xhr.responseText);
			document.getElementById("loader").style.display = "none";
		}
		else if (xhr.readyState < 4)
		{
			document.getElementById("loader").style.display = "inline";
		}
	};
	with(document.myForm) 
	{
		newweight=(weight.value).replace(",",".");
        newassurance=(assurance.value).replace(",",".");
        newrecommandation=recommandation.value;
        
		size="N";
		if(sizeBox.checked)
		size="O";
			
	}	
	xhr.open("GET", "../modules/presta2expinet/oneOrderExport.php?id_order='.$params["id_order"].'&weight="+newweight+"&size="+size+"&assurance="+newassurance+"&recommandation="+newrecommandation, true);
	xhr.send(null);
}
	function readData(sData) {
	document.getElementById(\'fileLink\').style.display=\'block\';
}
    -->
    </script>';
	
	if($orderInfo->getCurrentState()==Configuration::get('VINUM_EXPINET_STATE_EXPORT') &&(in_array($orderInfo->id_carrier,$carriersTab)))
	{
	
		$display.= '<a href="pdf.php?id_delivery='.$orderInfo->delivery_number.'">Bon de Livraison N°<b>'.Configuration::get('PS_DELIVERY_PREFIX', (int)($cookie->id_lang)).sprintf('%06d', $orderInfo->delivery_number).'</b></a><br><br>';
		$display.='<center>
		<form name="myForm">
		Changer le Poids : <input type="text" name="weight" id="weight" value="'.$weight.'" size="7"/>'.Configuration::get('PS_WEIGHT_UNIT').'<br><br>
		Colis Hors Gabarit : <input type="checkbox" name="sizeBox"  id="sizeBox" /><br><br>';
        $display.='Assurance : <select id="assurance" name="assurance" style="width:50px">
                                    <option value="0">0</option>';
                                    if($assurance && $orderInfo->total_paid<=150)
                                    $display.='<option value="150" selected>150</option>';
                                    else
                                    $display.='<option value="150" >150</option>';
                                    if($assurance && $orderInfo->total_paid>150 &&  $orderInfo->total_paid<=300)
                                   $display.='<option value="300" selected>300</option>';
                                   else
                                     $display.='<option value="300" >300</option>';
                                   if($assurance && $orderInfo->total_paid>300 &&  $orderInfo->total_paid<=450)
                                   $display.='<option value="450" selected>450</option>';
                                   else
                                    $display.='<option value="450" >450</option>';
                                 if($assurance && $orderInfo->total_paid>450 &&  $orderInfo->total_paid<=600)
                                   $display.='<option value="600" selected>600</option>';
                                   else
                                    $display.='<option value="600" >600</option>';
                                 if($assurance && $orderInfo->total_paid>600 &&  $orderInfo->total_paid<=750)
                                  $display.='<option value="750" selected>750</option>';
                                   else
                                    $display.='<option value="750" >750</option>';
                                 if($assurance && $orderInfo->total_paid>750 &&  $orderInfo->total_paid<=900)
                                  $display.='<option value="900" selected>900</option>';
                                   else
                                   $display.='<option value="900" >900</option>';
                                if($assurance && $orderInfo->total_paid>900 &&  $orderInfo->total_paid<=1050)
                                  $display.='<option value="1050" selected>1050</option>';
                                   else
                                  $display.='<option value="1050" >1050</option>';
                                if($assurance && $orderInfo->total_paid>1050 &&  $orderInfo->total_paid<=1200)
                                  $display.='<option value="1200" selected>1200</option>';
                                   else
                                   $display.='<option value="1200" >1200</option>';
                               if($assurance && $orderInfo->total_paid>1200 &&  $orderInfo->total_paid<=1350)
                                  $display.='<option value="1350" selected>1350</option>';
                                   else
                                  $display.='<option value="1350" >1350</option>';
                               if($assurance && $orderInfo->total_paid>1350)
                                  $display.='<option value="1500" selected>1500</option>';
                                   else
                                  $display.='<option value="1500" >1500</option>
                                  </select><br><br>';
                              $display.='Recommandation : <select id="recommandation" name="recommandation" style="width:50px">
                                    <option value="0">R0</option>';
                                     if($recommandation && $orderInfo->total_paid<=50)
                                        $display.='<option value="1" selected>R1</option>';
                                        else 
                                        $display.='<option value="1" >R1</option>';
                                      if($recommandation && $orderInfo->total_paid>50 && $orderInfo->total_paid<=200)
                                        $display.='<option value="2" selected>R2</option>';
                                        else
                                        $display.='<option value="2" >R2</option>';
                                     if($recommandation && $orderInfo->total_paid>200)
                                        $display.='<option value="3" selected>R3</option>';
                                        else 
                                       $display.='<option value="3" >R3</option>';
                                    $display.='</select><br><br> ';    
                              
                               
                                    
                                  
		 $display.='<input type="button" value="'.$this->l('Export Order to CSV file').'" name="button1" onClick="request(readData);"><br>
		<span id="loader" style="display: none;"><img src="../modules/presta2expinet/loader.gif" alt="loading" /></span>		 
		 
		</form> 
		</center>
		
		<div id="fileLink" style="display:none;">
						<br>Votre fichier CSV est en ligne à l\'adresse suivante :<br /><br><a href="'.$filename_http.'" target="_blanck"><b>'.$filename_http.'</b></a></p>
						</div>';
	}	
	else	
	{
     $display.='Le statut de la commande n\'est pas compatible avec l\'export vers Expeditor Inet';
	}
	$display.='	</fieldset>';
		
		return $display;
}
private function  cut_string_using_last($character, $string, $side, $keep_character=true)
	{
		$offset = ($keep_character ? 1 : 0);
		$whole_length = strlen($string);
		$right_length = (strlen(strrchr($string, $character)) - 1);
		$left_length = ($whole_length - $right_length - 1);
		switch($side)
		{
			case 'left':
            $piece = substr($string, 0, ($left_length + $offset));
            break;
			case 'right':
            $start = (0 - ($right_length + $offset));
            $piece = substr($string, $start);
            break;
			default:
            $piece = false;
            break;
		}
		return $piece;
	}

}