<?php

class Tool{

    /*
     * Trouve le nom du module courant
     * @param   -
     * @return  string (nom du module)
     */
    static function moduleName(){
        return Session::read('moduleName');
    }

    /*
     * Trouve le lastID
     * @param   string (nom table)
     * @return  int (id)
     */
    static function lastID($table){
       $res = Db::getInstance()->getRow('SELECT max(id_'.$table.') as nextID FROM '._DB_PREFIX_.$table);
       return $res['nextID'];
    }

    /*
     * Trouve le prochain ID
     * @param   string (nom table)
     * @return  int (id)
     */
    static function nextID($table){
       return Tool::lastID($table)+1;
    }

    /*
     * Echappe une chaine
     * @param   string (chaine)
     * @return  string (chaine escape)
     */
    static function esc($val){
        return mysql_real_escape_string($val);
    }

     /*
     * Redirige dans le back-office
     * @param   array
     * @param   array (paramètres)
     * @return  -
     */
    static function redirectBo($params){
        Tools::redirectLink(Html::linkBo(null,$params,null,true));
    }

    /*
     * Nom de l'hôte
     * @param  bool (préfix http)
     * @param  bool (html présent)
     * @return string (host)
     */
    static public function getHttpHost($http=true,$entities=true){
        $host = (isset($_SERVER['HTTP_X_FORWARDED_HOST']) ? $_SERVER['HTTP_X_FORWARDED_HOST'] : $_SERVER['HTTP_HOST']);
        if($entities)
            $host = htmlspecialchars($host, ENT_COMPAT, 'UTF-8');
        if($http)
            $host = (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').$host;
        return $host;
    }

    /*
     * Retourne la version de prestashop en float
     * @param  -
     * @return float (1 décimal)
     */
    static function getPsVersion(){
        return round(_PS_VERSION_,1);
    }

}

?>
