<?php

// config PHP
ini_set('display_errors',1);
error_reporting(E_ALL);
@session_start();

// Recharge les classes de PS sauf pour V 1.4 +
$psVersion = round(_PS_VERSION_,1);
if($psVersion<='1.3'){
    if(!function_exists('load_ps_classes')){
        function load_ps_classes($className){
            if(file_exists(dirname(__FILE__).'/../../../classes/'.$className.'.php')){
                require_once(dirname(__FILE__).'/../../../classes/'.$className.'.php');
            }
        }
        spl_autoload_register('load_ps_classes');
    }
}

// Charge les classes de devPRO
$classNames = array('CombinationProduct',
                    'Data',
                    'Debug',
                    'Email',
                    'Form',
                    'Front',
                    'Html',
                    'Jquery',
                    'JqueryUi',
                    'Session',
                    'Tool','Validation'
                );
foreach($classNames as $className){
    require_once(dirname(__FILE__).'/../classes/'.$className.'.php');
}

// global
global $currentIndex;
global $cookie;
Session::write('id_lang',$cookie->id_lang);
$moduleName = $this->name;

// Uniquement sur des pages non-ajax
// On peut avoir besoin de ces variable -> direct en session
$isAjax = false;
foreach($_GET as $k=>$v){
    if(substr($k,0,5)=='ajax_'){
        $isAjax = true;
        break;
    }
}
if(!$isAjax){
    // conserve les valeurs $_GET en session
    foreach($_GET as $k=>$v){
        Session::write($k,Tool::esc($v));
    }
    Session::write('currentIndex',$currentIndex);
    Session::write('moduleName',$moduleName);
}

// Charge le css par défaut du FK
Html::cssBo('../../devpro/css/default.css');

?>
