<?php
/**
 * visit our web
 * http://ardianys.com/
 * http://detovy.com/
 */


class gmfbcomment extends Module
{
	private $_html = '';
	private $_postErrors = array();

	public function __construct()
	{
		$this->name = 'gmfbcomment';
		$this->tab = 'Detovy.com';
		$this->version = '1';
		

		parent::__construct();

		$this->displayName = $this->l('Detovy Twitter Share & Facebook Comment');
		$this->description = $this->l('Integrate Twitter Share & Facebook Comment box with fbml');
	}

	public function install()
	{
		if (	!parent::install()
				OR !Configuration::updateValue('AFF_FB_ADMINS_ID', 'XXXX')
				OR !Configuration::updateValue('AFF_FB_APP_ID', 'XXXX')
				OR !Configuration::updateValue('AFF_MAIN_DOMAIN', 'detovy.com')
				OR !$this->registerHook('productfooter')
				OR !$this->registerHook('header')
				OR !$this->registerHook('footer')
				OR !$this->registerHook('rightColumn')
				)
			return false;
		return true;
	}

	private function _displayForm()
	{
		$this->_html .=
		'<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
			<legend><img src="../img/admin/contact.gif" />'.$this->l('Facebook Graph Settings').'</legend>
				<label>'.$this->l('AppID for XFBML version :').'</label>
				<div class="margin-form">
					<input type="text" name="AFF_FB_APP_ID" value="'.Configuration::get('AFF_FB_APP_ID').'"/>
					<p class="clear">'.$this->l('Don’t have one? Create here').' <a title="Register Your Site on Facebook" target="_blank" href="http://developers.facebook.com/setup/">Register Your Site on Facebook</a></p>
				</div>
				
				<label>'.$this->l('Admin Id :').'</label>
				<div class="margin-form">
					<input type="text" name="AFF_FB_ADMINS_ID" value="'.Configuration::get('AFF_FB_ADMINS_ID').'"/>
					<p class="clear">'.$this->l('Admins for your Fb App, multiple value separate with comma (,).').'<a target="_blank" href="http://www.facebook.com/insights/">'.$this->l('View Facebook Insight').'</a></p>
				</div>
				
				<label>'.$this->l('Facebook Fanpages url :').'</label>
				<div class="margin-form">
					<input type="text" name="AFF_FB_PAGES_URL" value="'.Configuration::get('AFF_FB_PAGES_URL').'"/>
					<p class="clear">'.$this->l('Your facebook fanpages url.').'<a target="_blank" href="http://www.facebook.com/pages/create.php">'.$this->l('Create here').'</a></p>
				</div>
				
				<label>'.$this->l('Preferred Local Language :').'</label>
				<div class="margin-form">
					<select name="AFF_FB_LOCALE">';
					
				$locales = $this->getFbLocales();
				$selected = Configuration::get('AFF_FB_LOCALE');
				foreach($locales as $locale => $language) {
					if ($locale == $selected) {
						$this->_html .= '<option value="' . htmlentities($locale) .'" selected="selected">'. htmlentities($language) .'</option>';
					} else {
						$this->_html .= '<option value="' . htmlentities($locale) .'">'. htmlentities($language) .'</option>';
					}
				}
					
			$this->_html .=		
					'</select>	
					<p class="clear">'.$this->l('If available language only in English, check your internet connection (local mode) or request your hosting provider (online mode) to provide cUrl extension for PHP').'</p>
				</div>
				
				<center><input type="submit" name="submitFb" value="'.$this->l('Save').'" class="button" /></center>
			
			<a href="http://detovy.com/" target="_blank"><img src="http://detovy.com/wp-content/themes/FOLIOS-THEME/images/logo.gif" /></a>	
			
			</fieldset>
			
		</form>
		
		';
		return $output;
		
	}
	
	
	public function getContent()
	{
		if (isset($_POST['submitFb']))
			$this-> _postProcessFb();
		$this->_displayForm();
		return $this->_html;
	}
	private function _postProcessFb()
	{
		Configuration::updateValue('AFF_FB_APP_ID', $_POST['AFF_FB_APP_ID']);
		Configuration::updateValue('AFF_FB_ADMINS_ID', $_POST['AFF_FB_ADMINS_ID']);
		Configuration::updateValue('AFF_FB_LOCALE', $_POST['AFF_FB_LOCALE']);
		Configuration::updateValue('AFF_FB_PAGES_URL', $_POST['AFF_FB_PAGES_URL']);
		$this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" /> '.$this->l('Facebook settings updated').'</div>';
	}
	function hookProductfooter($params)
	{
		global $smarty;
		
		$smarty->assign(array(
					'this_path' => $this->_path,
					'app_id' => Configuration::get('AFF_FB_APP_ID'),
					'fbadmins_id' => Configuration::get('AFF_FB_ADMINS_ID'),
					'locale' => Configuration::get('AFF_FB_LOCALE'),
					'url' => _PS_BASE_URL_.__PS_BASE_URI__.Tools::htmlentitiesUTF8(rawurldecode(substr($_SERVER['REQUEST_URI'],1))),
					'fbxid' => Configuration::get('AFF_FB_APP_ID').$params['product']->id,
					'height' => '40',
					'width' => '556'
				));
		return $this->display(__FILE__, 'gmfbcomment.tpl');
	}

	public function addFbXmlns($tpl_output, &$smarty)
	{ 
		$tpl_output = preg_replace('/<html /', '<html xmlns:og=\'http://opengraphprotocol.org/schema/\'
		xmlns:fb=\'http://www.facebook.com/2008/fbml\' ', $tpl_output);
		return $tpl_output;
	}
	public function hookHeader()
	{
		global $smarty, $cookie, $page_name;
		
		$lang = Configuration::get('PS_LANG_DEFAULT');
		if( $id_product = Tools::getValue('id_product') )
			$product = new Product($id_product, true, intval($lang));
		if( $id_category = Tools::getValue('id_category') )
			$category = new Category($id_category, intval($lang));
		$shopname = Configuration::get('PS_SHOP_NAME');
		$meta = '';
		$meta .= '<meta property="og:site_name" content="'.$shopname.'"/>';
		$meta .= '<meta property="fb:admins" content="'.Configuration::get('AFF_FB_ADMINS_ID').'"/>';
		$meta .= '<meta property="fb:app_id" content="'.Configuration::get('AFF_FB_APP_ID').'" />';
		
		if($page_name == 'index'){
			$fbshopname 	= $shopname;
			$fbtype 		= 'blog';
			$fbimage 		= _PS_BASE_URL_.__PS_BASE_URI__.'img/logo.jpg';
			$fbdescription 	= $shopname;
		} elseif ($page_name == 'product') {
			$fbshopname 	= $product->name.' - '.$shopname;
			$fbtype 		= 'product';
			$cover 			= Product::getCover($product->id);
			
			$fbimage 		= _PS_BASE_URL_.__PS_BASE_URI__.'img/p/'.$product->id.'-'.$cover['id_image'].'-medium.jpg';
			$fbdescription 	= preg_replace('/<[^>]*>/', '', $product->description_short);
		} elseif ($page_name == 'category') {
			$fbshopname 	= $category->name.' - '.$shopname;
			$fbtype 		= 'product';
			$fbimage 		= _PS_BASE_URL_.__PS_BASE_URI__.'img/c/'.$id_category.'-medium.jpg';
			$fbdescription 	= $category->description;
		}
		$meta .= '<meta property="og:url" content="'._PS_BASE_URL_.__PS_BASE_URI__.Tools::htmlentitiesUTF8(rawurldecode(substr($_SERVER['REQUEST_URI'],1))).'" />';
				
    /* ACO, passage en smarty v3 */
    //$smarty->register_outputfilter(array('gmfbcomment','addFbXmlns'));    
    $smarty->registerFilter('output',array('gmfbcomment','addFbXmlns'));
    
		$smarty->assign(array(
					'meta' => $meta,
					'fbshopname' => $fbshopname ,
					'fbtype' => $fbtype ,
					'fbimage' => $fbimage ,
					'fbdescription' => $fbdescription
				));	
		return ($this->display(__FILE__, '/gmfbcommentheader.tpl'));
	}
	private function getFbLocales(){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'http://www.facebook.com/translations/FacebookLocales.xml');
		curl_setopt($ch, CURLOPT_TIMEOUT, 180);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$data = curl_exec($ch);
		curl_close($ch);
		
		preg_match_all('/<locale>\s*<englishName>([^<]+)<\/englishName>\s*<codes>\s*<code>\s*<standard>.+?<representation>([^<]+)<\/representation>/s', utf8_decode($data), $data2, PREG_PATTERN_ORDER);

        foreach ($data2[1] as $i => $englishName) {
            $locales[$data2[2][$i]] = $englishName;
        }
		//echo p($locales);
		if (empty($locales)) {
			$locales = array('en_US' => 'English (US)');
		}
		return $locales;
	}
	public function hookRightColumn()
	{
		global $smarty;
		
		$smarty->assign(array(
			'fbpages_url' => Configuration::get('AFF_FB_PAGES_URL'),
			'rightcolumnwidth' => '191',
			'rightcolumnheight' => '250',
			'fbsite' => $_SERVER['HTTP_HOST'],
			'app_id' => Configuration::get('AFF_FB_APP_ID')
		));
		return ($this->display(__FILE__, '/gmfbcommentright.tpl'));
	}
	public function hookFooter()
	{
		global $smarty;
		
		$smarty->assign(array(
					'app_id' => Configuration::get('AFF_FB_APP_ID'),
					'locale' => Configuration::get('AFF_FB_LOCALE')
				));
		
		return ($this->display(__FILE__, '/gmfbcommentfooter.tpl'));//.ob_get_contents();
	}
}
