<?php

class ProductAccessories extends Module
{
	function __construct()
	{
		$this->name = 'productaccessories';
		$this->tab = floatval(substr(_PS_VERSION_,0,3))<1.4?'Presto-Changeo':'front_office_features';
		$this->version = '1.2';
		if (floatval(substr(_PS_VERSION_,0,3)) >= 1.4)
			$this->author = 'Presto-Changeo';
		
		parent::__construct();

		$this->displayName = $this->l('Product Accessories');
		$this->description = $this->l('Display product accessories in a more visible location.');
	}

	function install()
	{
		if (!parent::install())
			return false;
		if (!$this->registerHook('extraright') || !$this->registerHook('header'))
			return false;
		return true;
	}

	/**
	* Returns module content
	*
	* @param array $params Parameters
	* @return string Content
	*/
	function hookExtraRight($params)
	{
		global $smarty, $cookie, $protocol_content, $server_host;

		$product = new Product(intval($_GET['id_product']), true, intval($cookie->id_lang));
		$accessories = $product->getAccessories(intval($cookie->id_lang));
		if (sizeof($accessories) < 1)
			return;
		$images = $product->getImages(intval($cookie->id_lang));
		$smarty->assign('pa_is_image', sizeof($images));
		$smarty->assign('pa_accessories_dir', $protocol_content.$server_host.__PS_BASE_URI__.'/modules/'.$this->name.'/');
		$smarty->assign('accessories', $accessories);
		$smarty->assign('pa_old_img', floatval(substr(_PS_VERSION_,0,3)) < 1.2?'1':'');
		return $this->display(__FILE__, 'productaccessories.tpl');
	}

	function hookHeader()
	{
		global $smarty, $page_name;
		if ($page_name != 'product')
			return;
		$ps_version  = floatval(substr(_PS_VERSION_,0,3));
		if ($ps_version < 1.4)
			return $this->display(__FILE__, 'header.tpl');
		else
		{
			Tools::addCSS(($this->_path).'css/pa.css', 'all');
			Tools::addCSS(($this->_path).'css/jScrollPane.css', 'all');
			Tools::addJS(($this->_path).'js/jquery.mousewheel.js');
			Tools::addJS(($this->_path).'js/jScrollPane.js');
		}
	}
	
	function hookProductFooter($params)
	{
		global $smarty, $cookie, $protocol_content, $server_host;

		$product = new Product(intval($_GET['id_product']), true, intval($cookie->id_lang));
		$accessories = $product->getAccessories(intval($cookie->id_lang));
		if (sizeof($accessories) < 1)
			return;
		$images = $product->getImages(intval($cookie->id_lang));
		$smarty->assign('pa_is_image', sizeof($images));
		$smarty->assign('pa_accessories_dir', $protocol_content.$server_host.__PS_BASE_URI__.'/modules/'.$this->name.'/');
		$smarty->assign('accessories', $accessories);
		$smarty->assign('pa_old_img', floatval(substr(_PS_VERSION_,0,3)) < 1.2?'1':'');
		return $this->display(__FILE__, 'productaccessoriescenter.tpl');
	}
}
?>