<?php
/** Module suivilaposte
  * file remboursementChronopost.php
  * @author Vinum Master
  * @copyright Vinum Master
  * @version 1.3
  *
  */
  
class suivilaposte extends Module
{
		private $_postErrors = array();
		
	

	function __construct()
	{
		global $cookie;
		$this->_cookie = $cookie;
		$this->name = 'suivilaposte';
		$this->tab = 'shipping_logistics';
		$this->version = '1.30';
		$this->author = 'Vinum Master';
		
		/* The parent construct is required for translations */
		parent::__construct();
		
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Suivi La Poste');
		$this->description = $this->l('Verify and update your orders statut with LA POSTE.');
		
		$this->_directory = dirname(__FILE__).'/';
		
		
	}

	function install()
	{
		if (!Configuration::updateValue('VINUM_STATUT_LIVRAISON', 4) OR !parent::install() )
			return false;
		if (!Configuration::updateValue('VINUM_STATUT_CARRIERS', 3))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_LIVRE', 5))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_PREPARATION', 3))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_SOCIETE', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_SIRET', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_COMPTELAPOSTE', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_NAME', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_ADDRESS1', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_ADDRESS2', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_POSTAL', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_VILLE', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_TEL', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_GSM', ""))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_WHERE', "bureau"))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_POSTE', "Ville de votre bureau de Poste"))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_DIEFAX', "Fax Poste de ST DIE"))
			return false;	
		if (!Configuration::updateValue('VINUM_STATUT_DIEPOSTE', "Service Clients - Réclamation - BP 7500  88107 ST DIE CEDEX"))
			return false;			
		if (!Configuration::updateValue('VINUM_STATUT_DEPOT', "Bureau de Poste de dépot des colis"))
			return false;			
		if (!Configuration::updateValue('VINUM_STATUT_MODEDEPOT', "Guichet ou colecte etc..."))
			return false;
		if (!Configuration::updateValue('VINUM_STATUT_EXCELFILE', "Email envoie fichier excel"))
			return false;			

						
			
		if (!$this->registerHook('adminOrder'))
			return false;
			
		//creat config table in database
		$sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'suivilaposte` (
				  `id_order` int(10) NOT NULL,
				  `date_envoie` varchar(10) NOT NULL,
				  `statutlaposte` varchar(64) NOT NULL,
				  `statutmd5` varchar(40) NOT NULL,
				  `date_statut` varchar(10) NOT NULL,
				  `jours` tinyint(2),
				  `reclamation` varchar(64) NOT NULL,
				  `numcolis` varchar(64) NOT NULL,
				  `message` varchar(128) NOT NULL,
				   PRIMARY KEY  (`id_order`)
				) DEFAULT CHARSET=utf8;';

		if (!Db::getInstance()->Execute($sql))
			return false;	
				
		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		
		$tab=new tab();
		$tab->name[$id_lang]= 'Suivi La Poste';
		$tab->class_name= 'AdminLaPoste';	
		$tab->id_parent=Tab::getIdFromClassName('AdminOrders'); 
		$tab->add();

		return true;
	}
	
	  function uninstall()
    {
         if (!parent::uninstall()
			OR !Configuration::deleteByName('VINUM_STATUT_LIVRAISON')
			OR !Configuration::deleteByName('VINUM_STATUT_CARRIERS')
			OR !Configuration::deleteByName('VINUM_STATUT_LIVRE')
			OR !Configuration::deleteByName('VINUM_STATUT_PREPARATION')
			OR !Configuration::deleteByName('VINUM_STATUT_SOCIETE')
			OR !Configuration::deleteByName('VINUM_STATUT_SIRET')
			OR !Configuration::deleteByName('VINUM_STATUT_COMPTELAPOSTE')
			OR !Configuration::deleteByName('VINUM_STATUT_NAME')
			OR !Configuration::deleteByName('VINUM_STATUT_ADDRESS1')
			OR !Configuration::deleteByName('VINUM_STATUT_ADDRESS2')
			OR !Configuration::deleteByName('VINUM_STATUT_POSTAL')
			OR !Configuration::deleteByName('VINUM_STATUT_VILLE')
			OR !Configuration::deleteByName('VINUM_STATUT_TEL')
			OR !Configuration::deleteByName('VINUM_STATUT_GSM')
			OR !Configuration::deleteByName('VINUM_STATUT_WHERE')
			OR !Configuration::deleteByName('VINUM_STATUT_POSTE')
			OR !Configuration::deleteByName('VINUM_STATUT_DIEFAX')
			OR !Configuration::deleteByName('VINUM_STATUT_DIEPOSTE')
			OR !Configuration::deleteByName('VINUM_STATUT_DEPOT')
			OR !Configuration::deleteByName('VINUM_STATUT_MODEDEPOT')
			OR !Configuration::deleteByName('VINUM_STATUT_EXCELFILE')
	
		  )
			return false;
		
	$sql = 'DROP TABLE `'._DB_PREFIX_.'suivilaposte`'; 		
		if (!Db::getInstance()->Execute($sql))
			return false;		
		$idtab=tab::getIdFromClassName('AdminLaPoste');
		$tab=new tab($idtab);
		$tab->delete();	
		return true;		
    }
	
		private function _postValidation()
	{
		
	}
	
	private function _addToFeed($str)
	{
		
	}
	
	

	function getContent()
	{
	
		set_time_limit(0);
		
			if (!empty($_POST))
			{
			   	$this->_postValidation();
			}
				$this->_html = '<h2>'.$this->displayName.'</h2>';

			if (isset($_POST['submit']))
			{
			$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
			
				$carriers=$_POST['carrierBox'];
				$stateShipped=$_POST['shipped'];
				$carriersString=implode(",", $carriers);
				$stateLivre=$_POST['delivered'];
				$statePreparation=$_POST['preparation'];
				$societe=$_POST['societe'];
				$siret=$_POST['siret'];
				$compte=$_POST['compte'];
				$nomprenom=$_POST['name'];
				$adresse=$_POST['address1'];
				$adresse2=$_POST['address2'];
				$cpostal=$_POST['cpostal'];
				$ville=$_POST['ville'];
				$tel=$_POST['telephone'];
				$telgsm=$_POST['telgsm'];
				$where=$_POST['where'];
				$posteInfo=$_POST['posteInfo'];
				$dieFaxInfo=$_POST['dieFaxInfo'];
				$diePosteInfo=$_POST['diePosteInfo'];
				$depot=$_POST['depot'];
				$mode=$_POST['mode'];
				$excelFileInfo=$_POST['excelFileInfo'];
				
				Configuration::updateValue('VINUM_STATUT_LIVRAISON', $stateShipped);
				Configuration::updateValue('VINUM_STATUT_CARRIERS', $carriersString);
				Configuration::updateValue('VINUM_STATUT_LIVRE', $stateLivre);
				Configuration::updateValue('VINUM_STATUT_PREPARATION', $statePreparation);
				Configuration::updateValue('VINUM_STATUT_SOCIETE',$societe);
				Configuration::updateValue('VINUM_STATUT_SIRET',$siret);
				Configuration::updateValue('VINUM_STATUT_COMPTELAPOSTE',$compte);
				Configuration::updateValue('VINUM_STATUT_NAME',$nomprenom);
				Configuration::updateValue('VINUM_STATUT_ADDRESS1',$adresse);
				Configuration::updateValue('VINUM_STATUT_ADDRESS2',$adresse2);
				Configuration::updateValue('VINUM_STATUT_POSTAL',$cpostal);
				Configuration::updateValue('VINUM_STATUT_VILLE',$ville);
				Configuration::updateValue('VINUM_STATUT_TEL',$tel);
				Configuration::updateValue('VINUM_STATUT_GSM',$telgsm);
				Configuration::updateValue('VINUM_STATUT_WHERE',$where);
				Configuration::updateValue('VINUM_STATUT_POSTE',$posteInfo);
				Configuration::updateValue('VINUM_STATUT_DIEFAX',$dieFaxInfo);
				Configuration::updateValue('VINUM_STATUT_DIEPOSTE',$diePosteInfo);
				Configuration::updateValue('VINUM_STATUT_DEPOT',$depot);
				Configuration::updateValue('VINUM_STATUT_MODEDEPOT',$mode);
				Configuration::updateValue('VINUM_STATUT_EXCELFILE',$excelFileInfo);
	
				
				$query='UPDATE '._DB_PREFIX_.'order_state SET delivery=0 WHERE id_order_state="'.$statePreparation.'"';
				mysql_query($query);
				
				$this->_html .= '<div class="conf confirm">
							<img src="../img/admin/ok.gif" alt="" title="" />
						  <p>'.$this->l('Your settings have been updated').'<br /><br /></div>';
					

					
			}	
	
			
			$this->_html.='
			<fieldset class="width3" style="width:900px;">
				
				
					
			</fieldset><br><br>';
			
				$this->_html.=$this->_displayForm();
	
			
			return $this->_html;
		
	
	}

	private function _displayForm()
	{
		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		$stateShipped = Configuration::get('VINUM_STATUT_LIVRAISON');
		$CarriersString= Configuration::get('VINUM_STATUT_CARRIERS');
		$arrayCarriers=explode(",",$CarriersString);
		$stateLivre= Configuration::get('VINUM_STATUT_LIVRE');
		$statePreparation= Configuration::get('VINUM_STATUT_PREPARATION');
		$societe = Configuration::get('VINUM_STATUT_SOCIETE');
		$siret = Configuration::get('VINUM_STATUT_SIRET');
		$compte = Configuration::get('VINUM_STATUT_COMPTELAPOSTE');
		$nomprenom = Configuration::get('VINUM_STATUT_NAME');
		$adresse = Configuration::get('VINUM_STATUT_ADDRESS1');
		$adresse2 = Configuration::get('VINUM_STATUT_ADDRESS2');
		$cpostal = Configuration::get('VINUM_STATUT_POSTAL');
		$ville = Configuration::get('VINUM_STATUT_VILLE');
		$tel = Configuration::get('VINUM_STATUT_TEL');
		$telgsm = Configuration::get('VINUM_STATUT_GSM');
		$where = Configuration::get('VINUM_STATUT_WHERE');
		$posteInfo = Configuration::get('VINUM_STATUT_POSTE');
		$dieFaxInfo = Configuration::get('VINUM_STATUT_DIEFAX');
		$diePosteInfo = Configuration::get('VINUM_STATUT_DIEPOSTE');
		$depot = Configuration::get('VINUM_STATUT_DEPOT');
		$mode = Configuration::get('VINUM_STATUT_MODEDEPOT');
	   	$excelFileInfo = Configuration::get('VINUM_STATUT_EXCELFILE');
	
		$form='
		<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
	  <form method="post">';
	    $form.='<label style="text-align: left">Société :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text" size="50" name="societe" id="societe" value="'.$societe.'" />
					<span style="color: rgb(130, 130, 130);">(Si contrat Pro :
obligatoire pour envoyer les réclamations par fichier excel</span>
					</div>';
		$form.='<label style="text-align: left">SIRET :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text" name="siret" id="siret" value="'.$siret.'" />
					<span style="color: rgb(130, 130, 130);">(Si contrat Pro :
obligatoire pour envoyer les réclamations par fichier excel</span>
					</div>';	
		$form.='<label style="text-align: left">Compte La Poste :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text" name="compte" id="compte" value="'.$compte.'" />
					<span style="color: rgb(130, 130, 130);">(Si contrat Pro :
obligatoire pour envoyer les réclamations par fichier excel</span>
					</div>';						
	    $form.='<label style="text-align: left">NOM Prénom :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text" size="50" name="name" id="name" value="'.$nomprenom.'" />
					</div>';
		$form.='<label style="text-align: left">Adresse 1 :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text"  size="50" name="address1" id="address1" value="'.$adresse.'" />
					</div>';
		$form.='<label style="text-align: left">Adresse 2 :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text"  size="50" name="address2" id="address2" value="'.$adresse2.'" />
					</div>';
		$form.='<label style="text-align: left">Code Postal :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text" size="10" name="cpostal" id="cpostal" value="'.$cpostal.'" />
					</div>';
		$form.='<label style="text-align: left">Ville :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text" name="ville" id="ville" value="'.$ville.'" />
					</div>';
		$form.='<label style="text-align: left">Téléphone :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text" name="telephone" id="telephone" value="'.$tel.'" />
					</div>';
		$form.='<label style="text-align: left">Téléphone Portable :</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="text" name="telgsm" id="telgsm" value="'.$telgsm.'" />
					</div><br>';	
					
					$bureau_statut="unchecked";
					$dieFax_statut="unchecked";
					$diePoste_statut="unchecked";
					$excelFile="unchecked";
					switch ($where)
					{
						case "bureau":
						$bureau_statut="checked";
						break;
						case "dieFax":
						$dieFax_statut="checked";
						break;
						case "diePoste":
						$diePoste_statut="checked";
						break;
						case "excelFile":
						$excelFile="checked";
						break;
						default:
						$dieFax_statut="checked";
						break;
					}

		$form.='<label style="text-align: left">Ou envoyer la réclamation ?</label>
					<div class="margin-form" style="margin-top:10px">
					<input type="radio" name="where" value="bureau" '.$bureau_statut.'> Bureau de Poste
				<input type="text" size="50" name="posteInfo" value="'.$posteInfo.'"><br><br>
				<input type="radio" name="where" value="dieFax" '.$dieFax_statut.'> ST DIE par Fax
				<input type="text" name="dieFaxInfo" value="'.$dieFaxInfo.'"><br><br>
				<input type="radio" name="where" value="diePoste" '.$diePoste_statut.'> ST DIE par courrier
				<input type="text" size="70" name="diePosteInfo" value="'.$diePosteInfo.'"><br><br>	
				<input type="radio" name="where" value="excelFile" '.$excelFile.'> Fichier Excel Par email
				<input type="text" size="70" name="excelFileInfo" value="'.$excelFileInfo.'"><br>					
				</div><br>
				
				<label style="text-align: left">Bureau de dépot des colis :</label>
					<div class="margin-form" style="margin-top:10px">
				<input type="text" size="50" name="depot" value="'.$depot.'"><br></div><br>
				
				<label style="text-align: left">Mode de dépot des colis :</label>
					<div class="margin-form" style="margin-top:10px">
				<input type="text" size="50" name="mode" value="'.$mode.'"><br></div>';			
					
	  		$states=OrderState::getOrderStates($id_lang);
			
		 $form.='<label style="text-align: left">'.$this->l('Preparation State :').'</label>
					<div class="margin-form" style="margin-top:10px">
					<select id="preparation" name="preparation">';
					foreach($states as $state)
					{
						$form .='<option value='.$state['id_order_state'];
						if($state['id_order_state']==$statePreparation)
						{
							$form .=' selected>'.$state['name'].'</option>';
						}
						else
						{
							$form .='>'.$state['name'].'</option>';
						}
					}
						$form .='</select>
					<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Select state for which the orders are Prepared.(By default:Preparation in Progress)').'</p></div><br>';
				
			
	    $form.='<label style="text-align: left">'.$this->l('Shipped State :').'</label>
					<div class="margin-form" style="margin-top:10px">
					<select id="shipped" name="shipped">';
					foreach($states as $state)
					{
						$form .='<option value='.$state['id_order_state'];
						if($state['id_order_state']==$stateShipped)
						{
							$form .=' selected>'.$state['name'].'</option>';
						}
						else
						{
							$form .='>'.$state['name'].'</option>';
						}
					}
						$form .='</select>
					<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Select state for which the orders are shipped.(By default:Shipped)').'</p></div><br>';
			
			$form.='<label style="text-align: left">'.$this->l('Delivered State :').'</label>
					<div class="margin-form" style="margin-top:10px">
					<select id="delivered" name="delivered">';
					foreach($states as $state)
					{
						$form .='<option value='.$state['id_order_state'];
						if($state['id_order_state']==$stateLivre)
						{
							$form .=' selected>'.$state['name'].'</option>';
						}
						else
						{
							$form .='>'.$state['name'].'</option>';
						}
					}
						$form .='</select>
					<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Select state for which the orders are Delivered.(By default:Delivered)').'</p></div><br>';
			
			
				$carriers=Carrier::getCarriers($id_lang, true , false,false, NULL, ALL_CARRIERS);

					if (sizeof($carriers))
					{
						
					$form.='<center><label>'.$this->l('Carriers:').' </label></center>
					<table cellspacing="0" cellpadding="0" class="table" style="width: 29.5em;">
						<tr>
							<th><input type="checkbox" name="checkme" class="noborder" onclick="checkDelBoxes(this.form, \'carrierBox[]\', this.checked)" /></th>
							<th>'.$this->l('ID').'</th>
							<th>'.$this->l('Carrier name').'</th>
						</tr>';
						$irow = 0;
						
						foreach ($carriers as $carrier)
						{
							if(in_array($carrier['id_carrier'],$arrayCarriers))
							$checked=true;
							else
							$checked=false;
							
							$form.='<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">';
							if($checked)
							{
							$form.='<td>'.'<input type="checkbox" name="carrierBox[]" class="carrierBox" id="carrierBox_'.$carrier['id_carrier'].'" value="'.$carrier['id_carrier'].'" checked='.$checked.' /></td>
								<td>'.$carrier['id_carrier'].'</td>
								<td><label for="carrierBox_'.$carrier['id_carrier'].'" class="t">'.$carrier['name'].'</label></td>';
							}	
							else
							{
							$form.='<td>'.'<input type="checkbox" name="carrierBox[]" class="carrierBox" id="carrierBox_'.$carrier['id_carrier'].'" value="'.$carrier['id_carrier'].'" /></td>
								<td>'.$carrier['id_carrier'].'</td>
								<td><label for="carrierBox_'.$carrier['id_carrier'].'" class="t">'.$carrier['name'].'</label></td>';
						
							}
							$form.='</tr>';
						}
						
					$form.='</table><div class="margin-form" style="margin-top:10px">
					<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Check all carriers you want to link to LA POSTE verify orders').'</p>
					</div>';
					} else
						$form.='<p>'.$this->l('No carrier created').'</p>';
					  	
		    $form.='  <center><input type="submit" name="submit" value="'.$this->l('Submit').'" /><br><br>';
	
		$form.='</form></fieldset>';
		
		return $form;
	
	
	
	}

}