<?php
#####################################################################################################
#
#					Module pour la plateforme de paiement Systempay
#						Version : V2.5
#									########################
#					Développé pour Prestashop
#						Version : 1.2.4.0
#									########################
#					Développé par Lyra Network
#						http://www.lyra-network.com/
#						09/06/2010
#						Contact : supportvad@lyra-network.com
#
#####################################################################################################

if(!defined('_PS_ROOT_DIR_'))
{
	include_once(dirname(__FILE__).'/vads_api.php');
}
else
{
	include_once(_PS_ROOT_DIR_ . '/modules/vads/vads_api.php');
}

class VADS extends PaymentModule
{
	private $_html = '';
	
	public function __construct()
	{
		$this->name = 'vads';
		$this->tab = 'Payment';
		$this->version = '2.5';
		
		parent::__construct();
		
		$this->displayName = $this->l('vads-type gateway');
		$this->description = $this->l('Pay with vads-type gateway');
	}

	private function _getAdminParameters() {
		return array(
			'VADS_SITE_ID' => '12345678',
			'VADS_LIEN_BANQUE' => 'https://systempay.cyberpluspaiement.com/vads-payment/',
			'VADS_MODE' => 'TEST',
			'VADS_DELAY' => '',
			'VADS_MONNAIE' => '978',
			'VADS_LANGAGE_DEFAUT' => 'fr',
			'VADS_CARTE_DISPO_ALL' => '1',
			'VADS_CARTE_DISPO_AMEX' => '0',
			'VADS_CARTE_DISPO_CB' => '0',
			'VADS_CARTE_DISPO_MASTER' => '0',
			'VADS_CARTE_DISPO_VISA' => '0',
			'VADS_TYPE_PAIEMENT' => 'SINGLE',
			'VADS_TYPE_VALIDATION' => '',
			'VADS_URL_DEFAUT' => 'http://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/'.$this->name.'/validation.php',
			'VADS_KEY_TEST' => '1234567898765432',
			'VADS_KEY_PROD' => '1234567898765432',
			'VADS_PERIOD' => '30',
			'VADS_XTIME' => '3'
		);
	}
	
	public function	install()
	{
		if (!parent::install()
			|| !$this->registerHook('payment')
			|| !$this->registerHook('paymentReturn'))
			return false;
			
		foreach($this->_getAdminParameters() as $name => $default)
			Configuration::updateValue($name,$default);
		
		return true;
	}

	public function	uninstall()
	{
		foreach($this->_getAdminParameters() as $name => $default)
			Configuration::deleteByName($name);
		
		return parent::uninstall();
	}
	
	public function postProcess()
	{
		$vars = $this->_getAdminParameters();
		foreach ($vars as $var => $default)
			Configuration::updateValue($var, $_POST[$var]);
		echo '<div class="conf confirm"><img src="../img/admin/ok.gif" />'.$this->l('Settings updated').'</div>';
	}
	
	public function getContent()
	{
		if (Tools::isSubmit('submitVADS'))
			$this->postProcess();
		
		$this->_admin_form();
		return $this->_html;
	}

	/**
	 * Returns the html code for the admin form
	 * @return string
	 */
	public function _admin_form()
	{
		// Settings fields
		$this->_html .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset class="width2"><legend><img src="../modules/'.$this->name.'/logo.gif" />'.$this->displayName.'</legend>';
		$this->_html .= $this->_admin_form_textinput('VADS_SITE_ID', $this->l('Site id'), $this->l('Site id provided by the payment gateway'));
		$this->_html .= $this->_admin_form_textinput('VADS_KEY_TEST', $this->l('Test certificate'), $this->l('Certificate provided by the gateway'));
		$this->_html .= $this->_admin_form_textinput('VADS_KEY_PROD', $this->l('Production certificate'), $this->l('Certificate provided by the gateway'));
		$this->_html .= $this->_admin_form_textinput('VADS_LIEN_BANQUE', $this->l('Gateway url'), $this->l('Url the client will be redirected to'), 'size="65"');
		$this->_html .='
				<label for="VADS_MODE">'.$this->l('Mode').'</label>
				<div class="margin-form">
					<select id="VADS_MODE" name="VADS_MODE">
						<option value="TEST" '.( Tools::getValue('VADS_MODE', Configuration::get('VADS_MODE'))=='TEST' ? 'selected="selected"' : '' ).' />Test</option>
						<option value="PRODUCTION" '.( Tools::getValue('VADS_MODE', Configuration::get('VADS_MODE'))=='PRODUCTION' ? 'selected="selected"' : '' ).' />Production</option>
					</select>
					<p>'.$this->l('Test or production mode').'</p>
				</div>';
		$this->_html .= $this->_admin_form_textinput('VADS_DELAY', $this->l('Delay'), $this->l('Delay before banking (in days)'));
		$this->_html .= '
				<label for="VADS_TYPE_VALIDATION">'.$this->l('Payment validation').'</label>
				<div class="margin-form">
					<select id="VADS_TYPE_VALIDATION" name="VADS_TYPE_VALIDATION">
						<option value="0" '.( Tools::getValue('VADS_TYPE_VALIDATION', Configuration::get('VADS_TYPE_VALIDATION'))=='0' ? 'selected="selected"' : '' ).'>'.$this->l('Automatic').'</option>
						<option value="1" '.( Tools::getValue('VADS_TYPE_VALIDATION', Configuration::get('VADS_TYPE_VALIDATION'))=='1' ? 'selected="selected"' : '' ).'>'.$this->l('Manual').'</option>
					</select>
					<p>'.$this->l('If manual is selected, you will have to confirm payments manually in your bank backoffice').'</p>
				</div>';
		$this->_html .= $this->_admin_form_textinput('VADS_MONNAIE', $this->l('Currency'), $this->l('Currency code as defined in standard').' <a href="http://www.iso.org/iso/support/currency_codes_list-1.htm" target="_blank" >ISO 4217</a> ; 978=euro');
		$this->_html .= '
				<label for="VADS_MONNAIE">'.$this->l('Currency').'</label>
				<div class="margin-form">
					<select id="VADS_LANGAGE_DEFAUT" name="VADS_LANGAGE_DEFAUT" size="4">
						<option value="de" '.( Tools::getValue('VADS_LANGAGE_DEFAUT', Configuration::get('VADS_LANGAGE_DEFAUT'))=='de' ? 'selected="selected"' : '' ).'>Allemand</option>
						<option value="en" '.( Tools::getValue('VADS_LANGAGE_DEFAUT', Configuration::get('VADS_LANGAGE_DEFAUT'))=='en' ? 'selected="selected"' : '' ).'>Anglais</option>
						<option value="sh" '.( Tools::getValue('VADS_LANGAGE_DEFAUT', Configuration::get('VADS_LANGAGE_DEFAUT'))=='sh' ? 'selected="selected"' : '' ).'>Chinois</option>
						<option value="es" '.( Tools::getValue('VADS_LANGAGE_DEFAUT', Configuration::get('VADS_LANGAGE_DEFAUT'))=='es' ? 'selected="selected"' : '' ).'>Espagnol</option>
						<option value="fr" '.( Tools::getValue('VADS_LANGAGE_DEFAUT', Configuration::get('VADS_LANGAGE_DEFAUT'))=='fr' ? 'selected="selected"' : '' ).'>Français</option>
						<option value="it" '.( Tools::getValue('VADS_LANGAGE_DEFAUT', Configuration::get('VADS_LANGAGE_DEFAUT'))=='it' ? 'selected="selected"' : '' ).'>Italien</option>
						<option value="ja" '.( Tools::getValue('VADS_LANGAGE_DEFAUT', Configuration::get('VADS_LANGAGE_DEFAUT'))=='ja' ? 'selected="selected"' : '' ).'>Japonais</option>
					</select>
					<p>'.$this->l('Default language for the payment gateway').'</p>
				</div>
				<label for="VADS_CARTE_DISPO">'.$this->l('Card type').'</label>
				<div class="margin-form">
					<input type="checkbox" id="VADS_CARTE_DISPO_ALL" name="VADS_CARTE_DISPO_ALL" value="ALL" '.(Tools::getValue('VADS_CARTE_DISPO_ALL', Configuration::get('VADS_CARTE_DISPO_ALL'))=='ALL' ? 'checked="checked"' : ( Tools::getValue('VADS_CARTE_DISPO_AMEX', Configuration::get('VADS_CARTE_DISPO_AMEX'))!='AMEX' && Tools::getValue('VADS_CARTE_DISPO_CB', Configuration::get('VADS_CARTE_DISPO_CB'))!='CB' && Tools::getValue('VADS_CARTE_DISPO_MASTERCARD', Configuration::get('VADS_CARTE_DISPO_MASTERCARD'))!='MASTERCARD' && Tools::getValue('VADS_CARTE_DISPO_VISA', Configuration::get('VADS_CARTE_DISPO_VISA'))!='VISA' ? 'checked="checked"' : '' ) ).'>TOUS<br/>
					<input type="checkbox" id="VADS_CARTE_DISPO_AMEX" name="VADS_CARTE_DISPO_AMEX" value="AMEX" '.(Tools::getValue('VADS_CARTE_DISPO_AMEX', Configuration::get('VADS_CARTE_DISPO_AMEX'))=='AMEX' ? 'checked="checked"' : '' ).'>Amex<br/>
					<input type="checkbox" id="VADS_CARTE_DISPO_CB" name="VADS_CARTE_DISPO_CB" value="CB" '.(Tools::getValue('VADS_CARTE_DISPO_CB', Configuration::get('VADS_CARTE_DISPO_CB'))=='CB' ? 'checked="checked"' : '' ).'>CB<br/>
					<input type="checkbox" id="VADS_CARTE_DISPO_MASTERCARD" name="VADS_CARTE_DISPO_MASTERCARD" value="MASTERCARD" '.(Tools::getValue('VADS_CARTE_DISPO_MASTERCARD', Configuration::get('VADS_CARTE_DISPO_MASTERCARD'))=='MASTERCARD' ? 'checked="checked"' : '' ).'>Mastercard<br/>
					<input type="checkbox" id="VADS_CARTE_DISPO_VISA" name="VADS_CARTE_DISPO_VISA" value="VISA" '.(Tools::getValue('VADS_CARTE_DISPO_VISA', Configuration::get('VADS_CARTE_DISPO_VISA'))=='VISA' ? 'checked="checked"' : '' ).'>Visa<br/>
					<p>'.$this->l("").'</p>
				</div>
				<label for="VADS_TYPE_PAIEMENT">'.$this->l('Payment type').'</label>
				<div class="margin-form">
					<select id="VADS_TYPE_PAIEMENT" name="VADS_TYPE_PAIEMENT">
						<option value="SINGLE" '.( Tools::getValue('VADS_TYPE_PAIEMENT', Configuration::get('VADS_TYPE_PAIEMENT'))=='SINGLE' ? 'selected="selected"' : '' ).'>'.$this->l('Unique').'</option>
					</select>
					<p>'.$this->l('Pay in one or many times').'. '.$this->l('Only single payments are possible with this module').'</p>
				</div>';
		$this->_html .= $this->_admin_form_textinput('VADS_URL_DEFAUT', $this->l('Default url'), $this->l('Default return url'), 'size="65"');
		$this->_html .= '
				<label>'.$this->l('Check url to copy in your bank backoffice').'</label>
				<div class="margin-form">
					<p>http://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/'.$this->name.'/validation.php</p>
				</div>';
		
		// Submit and contact info
		$this->_html .= '
				<div class="clear margin-form">
					<input type="submit" class="button" name="submitVADS" value="'.$this->l('Save').'" />
				</div>
			</fieldset>
		</form>
		<div class="clear">&nbsp;</div>
		<fieldset>
			<legend>Contact</legend>
			Module développé par <b><a href="http://www.lyra-network.com/">Lyra-Network</a></b>.<br/>
			Adresse Email de contact : <b>supportvad@lyra-network.com</b>.<br/>
			Version du module : Prestashop_2.5
		</fieldset>
		';
	}
	
	/**
	 *
	 */
	function _admin_form_textinput($name, $label, $description=null, $extra_attributes='') {
		$value = ($value===null) ? Configuration::get($name) : $value;
		$html  = '';
		$html .= '<label for="'.$name.'">'.$label.'</label>';
		$html .= '<div class="margin-form">
					<input type="text" id="'.$name.'" name="'.$name.'" value="'.$value.'" '.$extra_attributes.'/>
					<p>'.$description.'</p>
				</div>';
		return $html;
	}
	
	
	public function hookPayment($params)
	{
		global $smarty;
		$cookie = $params['cookie'];
		$cart = $params['cart'];
		$address = new Address($cart->id_address_invoice);
		$cust = new Customer(intval($cookie->id_customer));
		$pays = new Country($address->id_country);
		
		if(Configuration::get('VADS_CARTE_DISPO_ALL')!='ALL'){
			$card=(Configuration::get('VADS_CARTE_DISPO_AMEX') ? Configuration::get('VADS_CARTE_DISPO_AMEX') : '');
			$card.=(Configuration::get('VADS_CARTE_DISPO_CB') ? ( $card!='' ? ';' : '' ).Configuration::get('VADS_CARTE_DISPO_CB') : '');
			$card.=(Configuration::get('VADS_CARTE_DISPO_MASTERCARD') ? ( $card!='' ? ';' : '' ).Configuration::get('VADS_CARTE_DISPO_MASTERCARD') : '');
			$card.=(Configuration::get('VADS_CARTE_DISPO_VISA') ? ( $card!='' ? ';' : '' ).Configuration::get('VADS_CARTE_DISPO_VISA') : '');
		}
		else
			$card = '';
		
		$arrayLang=array('fr','de','en','it','zh','ja','es');
		
		if(in_array(strtolower($pays->iso_code),$arrayLang))
			$langage=strtolower($pays->iso_code);
		else
			$langage=Configuration::get('VADS_LANGAGE_DEFAUT');
		
		$vads_api=new VADS_API();
		$vads_api->set('platform_url',		Configuration::get('VADS_LIEN_BANQUE'));
		$vads_api->set('version',			'V1');
		$vads_api->set('key_test',			Configuration::get('VADS_KEY_TEST'));
		$vads_api->set('key_prod',			Configuration::get('VADS_KEY_PROD'));
		$vads_api->set('amount', 			(round($cart->getOrderTotal(),2)*100));
		$vads_api->set('capture_delay', 	Configuration::get('VADS_DELAY'));
		$vads_api->set('currency', 			Configuration::get('VADS_MONNAIE'));
		$vads_api->set('cust_email',		$cust->email);
		$vads_api->set('ctx_mode',			Configuration::get('VADS_MODE'));
		$vads_api->set('payment_cards',		$card);
		$vads_api->set('payment_config',	Configuration::get('VADS_TYPE_PAIEMENT'));
		$vads_api->set('site_id',			Configuration::get('VADS_SITE_ID'));
		$vads_api->set('validation_mode',	Configuration::get('VADS_TYPE_VALIDATION'));
		$vads_api->set('cust_id',			session_id());
		$vads_api->set('cust_name',			$cust->lastname.' '.$cust->firstname);
		$vads_api->set('cust_address',		$address->address1.' '.$address->address2);
		$vads_api->set('cust_zip',			$address->postcode);
		$vads_api->set('cust_city',			$address->city);
		$vads_api->set('cust_phone',		$address->phone);
		$vads_api->set('cust_country',		$pays->iso_code);
		$vads_api->set('language',			$langage);
		$vads_api->set('order_id',			$cart->id);
		$vads_api->set('url_return',		Configuration::get('VADS_URL_DEFAUT'));
		
		$form = $vads_api->getRequestHtmlForm('id="systempay_form" class="hidden"');

		$smarty->assign('vads_form', $form);
		return $this->display(__FILE__, 'ordervads.tpl');
	}
	
	public function hookPaymentReturn($params)
	{
		global $smarty;
		if (!$this->active)
			return ;
		
		switch ($_GET['error'])
		{
			case null:
			case '' :
				$error_msg = false;
				break;
			case 'cancel_on_accepted' :
				$error_msg = $this->l('Invalid payment code received but order has already been registered');
				break;
			case 'check_url_warning':
				$error_msg = $this->l('Order registered, but automatic confirmation has not been received. Have you properly configured the check url in the bank backoffice ?');
				break;
			default:
				$error_msg = $this->l('An error occured, your order has not been registered.');
		}
		
		if($error_msg===false)
		{
			$smarty->assign(array(
				'total_to_pay' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false, false),
				'status' => 'ok',
				'id_order' => $params['objOrder']->id
			));
		}
		else
		{
			$smarty->assign(array(
				'status' => 'failed',
				'error_msg' => $error_msg)
			);
		}
		return $this->display(__FILE__, 'payment_return.tpl');
	}
}
?>