<?php
#####################################################################################################
#
#					Module pour la plateforme de paiement Systempay
#						Version : V2.5
#									########################
#					Développé pour Prestashop
#						Version : 1.2.4.0
#									########################
#					Développé par Lyra Network
#						http://www.lyra-network.com/
#						09/06/2010
#						Contact : supportvad@lyra-network.com
#
#####################################################################################################

require(dirname(__FILE__).'/../../config/config.inc.php');

/*
 * The payment platform can use only one check url, but prestashop may have both standard payment module or the multi-payment module.
 * They need to have their validation code in the same place (i.e. here), so we detect the case and load the appropriate module.
 */
if(stripos($_POST['payment_config'],'MULTI') !== false || stripos($_POST['contrib'],'multi') !== false)
{
	require(dirname(__FILE__).'/../vadsmulti/vadsmulti.php');
	$vads_api = new VADS_MULTI_API();
	$vads_api->setResponseFromPost(
		$_POST,
		Configuration::get('VADS_MULTI_KEY_TEST'),
		Configuration::get('VADS_MULTI_KEY_PROD'),
		Configuration::get('VADS_MULTI_MODE')
	);
	$vads=new VADSMULTI();
}
else
{
	require(dirname(__FILE__).'/vads.php');
	$vads_api = new VADS_API();
	$vads_api->setResponseFromPost(
		$_POST,
		Configuration::get('VADS_KEY_TEST'),
		Configuration::get('VADS_KEY_PROD'),
		Configuration::get('VADS_MODE')
	);
	$vads=new VADS();
}


$id_cart=$_REQUEST['order_id'];
$from_server = isset($_REQUEST['hash']);

if( ! $vads_api->isAuthentifiedResponse() )
{
	if($from_server)
		die( $vads_api->getCheckUrlResponse('auth_fail') );
	// Goto index
	Tools::redirectLink(__PS_BASE_URI__);
}

/*
 * response is authentified
 */
// Retrieve cart
$cart = new Cart($_REQUEST['order_id']);
if( ! $cart )
{
	// unable to retrieve cart from db
	if($from_server)
		die( $vads_api->getCheckUrlResponse('order_not_found') );
	Tools::redirectLink(__PS_BASE_URI__.'order-confirmation.php?id_cart='.$id_cart
						.'&id_module='.$vads->id
						.'&id_order='.$o->id
						.'&key='.$o->secure_key
						.'&error=payment_error');
}

$id_order = intval(Order::getOrderByCartId($cart->id));
$order = new Order( $id_order );

if( ! $order->hasBeenPaid() )
{
	// Order has not been accepted yet
	if($vads_api->isAcceptedPayment())
	{
		// Payment OK
		$vads->validateOrder(
			$id_cart,
			_PS_OS_PAYMENT_,
			$cart->getOrderTotal(),
			$vads->displayName,
			$vads_api->getResponseMessage('detail').' '.$vads_api->getReponse3DSec()
		);
		
		// Reload order
		$id_order = intval(Order::getOrderByCartId($cart->id));
		$order = new Order( $id_order );
		
		// Display success message
		if($from_server)
		{
			// Display server code
			echo $vads_api->getCheckUrlResponse('payment_ok');
		}
		else
		{
			$extra_param = "";
			if($vads_api->get('ctx_mode') == 'TEST')
			{
				// !$from_server => this is a client return
				// ctx_mode=TEST => the user is the webmaster
				// order has not been paid, but we receive a successful payment code => automatic response didn't work
				// So we display a warning about the not working check_url
				$extra_param = "&error=check_url_warning";
			}
			Tools::redirectLink(__PS_BASE_URI__.'order-confirmation.php?id_cart='.$id_cart
								.'&id_module='.$vads->id
								.'&id_order='.$order->id
								.'&key='.$order->secure_key
								.$extra_param
			);
		}
	}
	else
	{
		// Payment KO
		if($from_server)
		{
			// Display payment error message
			die( $vads_api->getCheckUrlResponse('payment_ko') );
		}
		else
		{
			// Go back to payment methods screen
			Tools::redirectLink(__PS_BASE_URI__.'order.php?step=3');
		}
	}
}
else
{
	// Order already registered
	if($vads_api->isAcceptedPayment())
	{
		// Just display a confirmation message
		if($from_server)
		{
			die( $vads_api->getCheckUrlResponse('payment_ok_already_done') );
		}
		else
		{
			Tools::redirectLink(__PS_BASE_URI__.'order-confirmation.php?id_cart='.$id_cart
								.'&id_module='.$vads->id
								.'&id_order='.$order->id
								.'&key='.$order->secure_key
			);
		}
	}
	else
	{
		// Invalid payment code received, but order has already been registered !
		if($from_server)
		{			
			die( $vads_api->getCheckUrlResponse('payment_ko_on_order_ok') );
		}
		else
		{
			Tools::redirectLink(__PS_BASE_URI__.'order-confirmation.php?id_cart='.$id_cart
								.'&id_module='.$vads->id
								.'&id_order='.$order->id
								.'&key='.$order->secure_key
								.'&error=cancel_on_accepted');
		}
	}
}
?>