<?php

class Form extends Module{

    private $_table;
    private $_data;
    private $_fields_simple;
    private $_fields_multilang;
    private $_fieldset;
    public  $_errors;
    public  $_errors_fields;

    /*
     * Initialise un formulaire
     * @param   string (url action)
     * @param   string (nom table)
     * @param   méthode (post)
     * @param   array (champs & champs multilingues)
     * @param   string (légende)
     * @param   array (class, style etc..)
     * @return  -
     */
    function init($table,$action=null,$method='post',$fields=array(),$legend=null,$parameters=array()){

        if($_POST){$this->_data = $_POST;}  // conserver le post dans _data

        $this->_table = $table;
        if(!isset($fields['fields_simple'])){$fields['fields_simple']=array();}
        $this->_fields_simple = $fields['fields_simple'];
         if(!isset($fields['fields_multilang'])){$fields['fields_multilang']=array();}
        if(isset($fields['fields_multilang'])){$this->_fields_multilang = $fields['fields_multilang'];}else{$this->_fields_multilang = array();}

        if($action==null){$action = $_SERVER['REQUEST_URI'];}

        $html = '';
        if(!empty($legend)){
            $html.='<fieldset><legend>'.$legend.'</legend>';
            $this->_fieldset = true;
        }

        $class = $this->classInput($parameters);
        $html .= '<form method="'.$method.'" action="'.$action.'" '.$class.'>
                 <div><input type="hidden" name="table" id="table" value="'.$table.'"/></div>
                 ';
        return $html;
    }

    /*
     * Champ text
     * @param   string (nom du champ)
     * @param   string (label)
     * @param   string (valeur)
     * @param   array (paramètres)
     * @param   bool (champ de type password)
     * @return  string (html)
     */
    public function text($name,$label=null,$parameters=null,$typePassword=false){

        if(isset($this->_data[$name])){ $value = $this->_data[$name];}

        $style = $this->css(@$parameters['style']);
        $styleDiv = $this->css(@$parameters['styleDiv']);

        if($typePassword){$inputType='password';}else{$inputType='text';}

        // pour gérer les champs multilingues
        global $cookie;
        $defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
        $languages = Language::getLanguages();
        $iso = Language::getIsoById(intval($cookie->id_lang));
        // Crée une chaine des champs multilingues titre¤description¤etc....
        $divLangName = '';
        foreach($this->_fields_multilang as $dLangName){
            $divLangName .= $dLangName.'¤';
        }
        $divLangName = substr($divLangName,0,-2);
        
        $html = '<script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>';

        if(in_array($name,$this->_fields_multilang)){
            $errorMsg = $this->validation(@$parameters['validation'],'body_'.$name.'_'.$cookie->id_lang);
            $html .= '<div '.$styleDiv.'>';
                foreach($languages as $language){
                    $html .= '
                    <div id="'.$name.'_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left;">'.
                        $this->label($label,$name).'
                        <input type="'.$inputType.'" id="body_'.$name.'_'.$language['id_lang'].'" name="body_'.$name.'_'.$language['id_lang'].'" value="'.$this->getContentField($name.'_'.$language['id_lang']).'" '.$style.' />'.
                        $errorMsg.'
                    </div>';
                }
            $html .= $this->displayFlags($languages,$defaultLanguage,$divLangName,$name, true).'<div class="clear pspace"></div>';
            $html .= '</div>';
        }else{
            $errorMsg = $this->validation(@$parameters['validation'],$name);
            $html .=
            '<div '.$styleDiv.'>'.
                $this->label($label,$name).'
                <input type="'.$inputType.'" id="'.$name.'" value="'.$this->getContentField($name).'" name="'.$name.'" '.$style.'/>'.
                $errorMsg.'
                <div class="clear pspace"></div>
            </div>';
        }
        return $html;
    }
    
     /*
     * Champ textarea
     * @param   string (nom du champ)
     * @param   string (label)
     * @param   array (parametres)
     * @return  string (html)
     */
    public function textarea($name,$label=null,$parameters=null){

        $style = $this->css(@$parameters['style']);
        $styleDiv = $this->css(@$parameters['styleDiv']);

    	// pour gérer les champs multilingues
        global $cookie;
        $defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
        $languages = Language::getLanguages();
        $iso = Language::getIsoById(intval($cookie->id_lang));
        // Crée une chaine des champs multilingues titre¤description¤etc....
        $divLangName = '';
        foreach($this->_fields_multilang as $dLangName){
            $divLangName .= $dLangName.'¤';
        }
        $divLangName = substr($divLangName,0,-2);

        $divLangName = '';
        foreach($this->_fields_multilang as $dLangName){
            $divLangName .= $dLangName.'¤';
        }
        $divLangName = substr($divLangName,0,-2);

        if(substr(_PS_VERSION_,0,3)==='1.4'){ 
           $js = '
           <script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce/jscripts/tiny_mce/tiny_mce.js"></script>
                <script type="text/javascript">
                    tinyMCE.init({
                        mode : "textareas",
                        theme : "advanced",
                        plugins : "safari,pagebreak,style,layer,table,advimage,advlink,inlinepopups,media,searchreplace,contextmenu,paste,directionality,fullscreen",
                        // Theme options
                        theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
                        theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
                        theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
                        theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,pagebreak",
                        theme_advanced_toolbar_location : "top",
                        theme_advanced_toolbar_align : "left",
                        theme_advanced_statusbar_location : "bottom",
                        theme_advanced_resizing : false,
                        content_css : "'.__PS_BASE_URI__.'themes/'._THEME_NAME_.'/css/global.css",
                        document_base_url : "'.__PS_BASE_URI__.'",
                        width: "600",
                        height: "auto",
                        font_size_style_values : "8pt, 10pt, 12pt, 14pt, 18pt, 24pt, 36pt",
                        elements : "nourlconvert,ajaxfilemanager",
                        file_browser_callback : "ajaxfilemanager",
                        entity_encoding: "raw",
                        convert_urls : false,
                        language : "'.(file_exists(_PS_ROOT_DIR_.'/js/tinymce/jscripts/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en').'"
                    });
                    function ajaxfilemanager(field_name, url, type, win) {
                        var ajaxfilemanagerurl = "'.dirname($_SERVER["PHP_SELF"]).'/ajaxfilemanager/ajaxfilemanager.php";
                        switch (type) {
                            case "image":
                                break;
                            case "media":
                                break;
                            case "flash":
                                break;
                            case "file":
                                break;
                            default:
                                return false;
                    }
                    tinyMCE.activeEditor.windowManager.open({
                        url: "'.dirname($_SERVER["PHP_SELF"]).'/ajaxfilemanager/ajaxfilemanager.php",
                        width: 782,
                        height: 440,
                        inline : "yes",
                        close_previous : "no"
                    },{
                        window : win,
                        input : field_name
                    });
		}
	</script>';
        // 1.3 et -
        }else{
            $js = '
            <script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce/jscripts/tiny_mce/jquery.tinymce.js"></script>
            <script type="text/javascript">
            function tinyMCEInit(element){
                $().ready(function() {
                        $(element).tinymce({
                                // Location of TinyMCE script
                                script_url : \''.__PS_BASE_URI__.'js/tinymce/jscripts/tiny_mce/tiny_mce.js\',
                                // General options
                                theme : "advanced",
                                plugins : "safari,pagebreak,style,layer,table,advimage,advlink,inlinepopups,media,searchreplace,contextmenu,paste,directionality,fullscreen",
                                // Theme options
                                theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
                                theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
                                theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
                                theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,pagebreak",
                                theme_advanced_toolbar_location : "top",
                                theme_advanced_toolbar_align : "left",
                                theme_advanced_statusbar_location : "bottom",
                                theme_advanced_resizing : false,
                                content_css : "'.__PS_BASE_URI__.'themes/'._THEME_NAME_.'/css/global.css",
                                width: "582",
                                height: "auto",
                                font_size_style_values : "8pt, 10pt, 12pt, 14pt, 18pt, 24pt, 36pt",
                                elements : "nourlconvert",
                                convert_urls : false,
                                language : "'.(file_exists(_PS_ROOT_DIR_.'/js/tinymce/jscripts/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en').'"
                        });
                });
            }
            tinyMCEInit(\'textarea.rte\');
            </script>
            <script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>';
        }

        $html = $js.$this->label($label,$name);

        if(in_array($name,$this->_fields_multilang)){
            $html .= '<div '.$styleDiv.'>';
            foreach($languages as $language){
                $html .= '
                <div id="'.$name.'_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left;">
                    <textarea class="rte" cols="70" rows="30" id="body_'.$name.'_'.$language['id_lang'].'" name="body_'.$name.'_'.$language['id_lang'].'" '.$style.'>'.$this->getContentField($name.'_'.$language['id_lang']).'</textarea>
                </div>';
            }
            $html .= $this->displayFlags($languages, $defaultLanguage, $divLangName,$name, true).'<div class="clear pspace"></div>';
            $html .= '</div>';
        }else{
            $html .= '
            <div '.$styleDiv.'>
                <textarea class="rte" cols="70" rows="30" id="'.$name.'" name="'.$name.'">'.$this->getContentField($name).'</textarea>
                <div class="clear pspace"></div>
            </div>';
        }

        return $html;
    }

    /*
     * Champ select
     * @param   string (nom du champ)
     * @param   string (label)
     * @param   array (liste des valeurs)
     * @param   string (nom de l'id)
     * @param   string (nom du champ a afficher dans le select)
     * @param   array (paramètre)
     * @return  string (html)
     */
    public function select($name,$label=null,$values=array(),$display_field=null,$parameters=array()){

        $style = $this->css(@$parameters['style']);
        $styleDiv = $this->css(@$parameters['styleDiv']);

        $input = array();
        $input['type'] = 'select';
        $input['values'] = $values;
        $input['display_field'] = $display_field;
       
        $html =
        '<div '.$styleDiv.'>'.
            $this->label($label,$name).'&nbsp;
            <select id="'.$name.'" name="'.$name.'" '.$style.'>'.
                $this->getContentField($name,$input).
            '</select>
             <div class="clear pspace"></div>
        </div>';
        return $html;
    }

    /*
     * Checkbox
     * @param   string (nom du champ)
     * @param   string (label)
     * @param   string (valeur)
     * @param   array (paramètres)
     * @return  string (html)
     */
    public function checkbox($name,$label=null,$value=null,$parameters=array()){

        $style = $this->css(@$parameters['style']);
        $styleDiv = $this->css(@$parameters['styleDiv']);

        // une checkbox cochée vaut 1 par défaut
        if(empty($value)){$value = 1;}

        $input['type'] = 'checkbox';
        $input['value']  = $value;
        $html = '<div '.$styleDiv.'>'.$this->label($label,$name).'&nbsp;<input type="checkbox" id="'.$name.'" name="'.$name.'" value="'.$value.'" '.$this->getContentField($name,$input).' '.$style.'/></div>
                 <div class="clear pspace"></div>';
        return $html;
   }

   /*
    * Affiche le label
    * @param   string (label)
    * @param   string (field name)
    * @return  string (html)
    */
   public function label($label,$name){
       if(!empty($label)){
           return '<label for="'.$name.'" style="margin-right:5px;">'.$label.'&nbsp;</label>';
       }
   }

   /*
     * Champ submit
     * @param   string (nom du champ)
     * @param   string (label).
     * @param   array (parameters ex. css)
     * @return  string (html)
     */
    public function submit($name='submit',$label=null,$parameters=null){

        $style = $this->css(@$parameters['style']);
        $styleDiv = $this->css(@$parameters['styleDiv']);

        if(empty($label)){
            $label = $this->l('Sauver');
        }
        if($this->_fieldset){$fieldset='</fieldset>';}else{$fieldset ='';}

        $style = $this->css(@$parameters['style']);
        $class = $this->classInput($parameters);
        if(empty($parameters['class'])){$class='class="button"';}

        // Crée un espace pour l'alignement du bouton si on est dans le BO
        $labelSpace = '';
        if(!empty($label) && Tools::getValue('token')){ $labelSpace = '<label>&nbsp;</label>';}

        return  '<div '.$styleDiv.'>'.$labelSpace.'<input type="submit" name="'.$name.'" value="'.$label.'" '.$style.' '.$class.' /></div></form>'.$fieldset;
    }

    /*
     * Ferme le formulaire
     * @param   -
     * @return  string (html)
     */
    public function end(){
        return '</form>';
    }

   /*
     * Récupère les attributs CSS
     * @param   array (paramètres)
     * @return  string (html)
    */
    public function css($parameters){
        if(!is_array($parameters)){$parameters=array();}
        $style = '';
        foreach($parameters as $k=>$v){
            $style .= $k.':'.$v.';';
        }
        $style = 'style="'.$style.'"';
        return $style;
    }

    /*
     * Valide les erreurs du formulaires
     * @param   array (paramètres de validation)
     * @param   string (nom du champ)
     * @return  string (error)
    */
    public function validation($validations,$name){
        if($_POST){
            if(!is_array($validations)){$validations=array();}
            if(!empty($validations)){
                foreach($validations as $rule){
                    $checkValidation = Validation::$rule(Tools::getValue($name),$name);
                    if($checkValidation==='error'){
                        $this->_errors_fields[] = $name;
                        Session::write('formError',true); // erreur détectée dans le formulaire
                        $errorMsg = '';
                        switch($rule){
                            case 'notEmpty':
                                $errorMsg = $this->l('Veuillez remplir ce champ');
                                break;
                            case 'isDate':
                                $errorMsg = $this->l('Veuillez indiquer une date valide');
                                break;
                        }
                        return '<div class="devpro_error">'.$this->label('&nbsp;','&nbsp;').$errorMsg.'</div>';
                    }else{
                        if(empty($this->_errors_fields)){
                            Session::write('formError',false);
                        }
                    }
                }
            }
        }
    }

   /*
     * Récupère la classe
     * @param   array (attributs)
     * @return  string (html)
    */
    public function classInput($parameters){
        return 'class="'.@$parameters['class'].'"';
    }
    
    /*
     * Conserve/Charge le contenu d'un champ
     * @param   nom du champ
     * @param   array values (uniquement pour input type SELECT)
     * @return  -
     */
    function getContentField($name,$input=null){

        $data = Session::read('data');
        if(empty($data)){$data=array();}

        if(empty($input['type'])){
        
            // Conservation lors du post
            // champ standard
            if(isset($_POST[$name])){
                return $_POST[$name];
            // champ multilingue
            }else{
                if(isset($_POST['body_'.$name])){
                    return $_POST['body_'.$name];
                }
            }

            // Si c'est un champ simple chargé avec Configuration::get('xxx')
            if(!is_array($data)){
                $value = $data;
                $data = array();
                $data[0][$name] = $value;
            }

            // Si c'est un ensemble de champ simples
            if(!isset($data[0])){
                $dataArray = $data;
                $data = array();
                $data[0] = $dataArray;
            }
           
            // Remplissage des champs automatique via requête
            foreach($data as $fields){

                // Vérifie s'il s'agit bien d'enregistrement multilingues
                $multilang = 0;
                $nb_records = count($data);
                if(array_key_exists('id_lang',$fields) && $nb_records>1){
                    $multilang = 1;
                }

                foreach($fields as $fieldname=>$content){
                    // si multiligue
                    if($multilang){
                        if($fieldname.'_'.$fields['id_lang'] == $name){
                            return $content;
                        }else{
                            // si un champ non-multiligue est mélangé aux multiligue
                            if(in_array($name,$this->_fields_simple)){
                                return @$fields[$name];
                            }
                        }
                    // champ simple
                    }else{
                        if($fieldname == $name){         
                            return $content;
                        }
                    }
                }

            }
        // si c'est un input du type select
        }elseif($input['type']=='select'){
            $options = '';
            $display_field = $input['display_field'];

            foreach($input['values'] as $k=>$v){
                $selected = '';
                // conserve le POST
                if(isset($_POST[$name]) && $_POST[$name]==$v[$name]){$selected = 'selected';}
                // si chargement via $_GET
                if(isset($data[0][$name]) && $data[0][$name]==$k[$name] && $data[0][$name]!=$v[$name] ||
                   isset($data[0][$name]) && $data[0][$name]==$v[$name]){
                   $selected = 'selected';
                }

                if(!isset($data[$name])){
                    if(isset($data[0][$name])){$options .= '<option value="'.$v[$name].'" '.$selected.'>'.$v[$display_field];}
                }
                
                // si chargement via $_GET && données sur un niveau $data au lieu de $data[0]
                if(isset($data[$name]) && $data[$name]==$k){ $selected = 'selected';}
                if(isset($data[$name])){$options .= '<option value="'.$k.'" '.$selected.'>'.$v;}
            }
            return $options;
        // si c'est une checkbox
        }elseif($input['type']=='checkbox'){
            if(isset($data[0][$name]) && $data[0][$name]==1){
                return 'checked';
            }
            // données sur un niveau $data au lieu de $data[0]
            if(isset($data[$name]) && $data[$name]==1){
                return 'checked';
            }
        }
    }

   /*
    * Si le formulaire est posté
    * @param   string (nom du bouton)
    * @return  bool
    */
    function isSubmit($name){
        if(Tools::isSubmit($name)){
            $formError = Session::read('formError');
            if(empty($formError)){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }

   /*
    * Affiche un message de confirmation
    * @param   string (message)
    * @param   string (form redirection)
    * @return  -
   */
   public function msgConfirm($msg,$formRedirect=null){
        $msg = '<div class="conf confirm">'.Html::img('../../devpro/img/ok.png').'&nbsp;'.$msg.'</div>';
        Session::write('msgConfirm',$msg);
        if(empty($formRedirect)){$formRedirect='default';}
        if(!empty($formRedirect)){ Tool::redirectBo(array('form'=>$formRedirect));}
   }
    
}

?>
