<?php

class Html extends Module{

    /*
     * Attache une feuille CSS pour la partie publique
     * @param   string (nom du fichier avec extension placés dans /modules/votremodule/css/)
     * @return  string
     */
    static function css($filename){   
        $path_css = __PS_BASE_URI__.'modules/'.Tool::moduleName().'/css/';
    	$css_file = $path_css.$filename;
        // W3C
        global $css_files;
        $css_files[$css_file] = 'all';
        return '<link href="'.$css_file.'" rel="stylesheet" type="text/css">';
    }

     /*
     * Ajoute un fichier JS
     * @param   string (nom du fichier avec extension placés dans /modules/votremodule/js/)
     * @return  string
     */
    static function js($filename){
        $path_js = __PS_BASE_URI__.'modules/'.Tool::moduleName().'/js/';
    	$js_file = '<script type="text/javascript" src="'.$path_js.$filename.'" /></script>';
        echo  $js_file;
    }

    /*
     * Ouvre la balise pour ajouter du code JS
     * @param   -
     * @return  string
     */
    static function jsStartScript(){
        echo '<script type="text/javascript">';
    }

    /*
     * Ouvre la balise pour ajouter du code JS
     * @param   -
     * @return  string
     */
    static function jsCloseScript(){
        echo '</script>';
    }

    /*
     * Attache une feuille CSS pour le BO
     * @param   string (nom du fichier avec extension placés dans /modules/votremodule/css/
     * @return  string
     */
    static function cssBo($filename){
        // non W3C
         $path_css = __PS_BASE_URI__.'modules/'.Tool::moduleName().'/css/';
    	$css_file = $path_css.$filename;
        // connecté dans le back-office
        $connected_bo = Tools::getValue('token');
        if($connected_bo){
            echo '<link type="text/css" rel="stylesheet" href="'.$css_file.'" />';
        }
    }
    
    /*
     * Affiche un lien dans backoffice
     * @param   string (texte du lien)
     * @param   array (paramètres clé=>val)
     * @param   array (img=>nom de l'images sous /modules/votremodule/img & title=>titre image
     * @param   bool (retourner uniquement l'url
     * @return  string
     */
    static function linkBo($label=null,$params=null,$img=null,$url_only=false){

        global $currentIndex;
        $module_name = Tool::moduleName();

        // Paramètres gets
        $parameters = '';
        if(!empty($params)){
            foreach($params as $p=>$v){
                $parameters .= '&'.$p.'='.$v;
            }
        }

        // si un paramètre msg existe on va le faire afficher
        if(isset($params['msg'])){
            $msg = '<div class="conf confirm">'.Html::img('../../devpro/img/ok.png').'&nbsp;'.$params['msg'].'</div>';
            Session::write('msgConfirm',$msg);
        }

        // si c'est un lien delete
        $js = '';
        if($img['img']=='del.png'){ $js = 'onclick="return confirm(\'Supprimer ?\')"';}

        $url = $currentIndex.'&configure='.$module_name.'&token='.Tools::getValue('token').$parameters;
        if(!empty($img)){$img= '<img src="../modules/'.$module_name.'/img/'.$img['img'].'" title="'.@$img['title'].'" style="vertical-align:bottom" />&nbsp;';}
        $link = '<a href="'.$url.'" '.$js.'>'.$img.$label.'</a>';

        if($url_only){
            return $url;
        }else{
            return $link;
        }
        
    }

     /*
     * Affiche une image
     * @param   string (nom du fichier avec extension placé dans /modules/votremodule/img/)
     * @param   string (title)
     * @param   bool (image du type icone)
     * @return  string
     */
    static function img($filename,$title=null,$ico=false){
        $style = '';
        if($ico){$style = 'style="vertical-align:bottom"';}
        $img_file = __PS_BASE_URI__.'modules/'.Tool::moduleName().'/img/'.$filename;
        return '<img src="'.$img_file.'" title="'.$title.'" '.$style.'/>';
    }

}

?>
