<?php
class Freenewsletter extends Module{

    /*
     * Réalisé par Webbax
     * http://www.webbax.ch
     * contact@webbax.ch
     * 04.11.2010 Envoie une newsletter
     */

    /* Correctifs
     * V0.1 | 14.03.11 - image déclinaison / check si l'image existe sinon image par défaut du produit
     * V0.1 | 17.03.11 - externalisation de "devpro" sous /modules/
     *                 - correction de la classe de validation des erreurs
     *                 - diverses modifications au sein de "devpro"
     * V0.2 | 23.03.11 - compatible PS 1.4
     *                 - réduction de prix adaptation pour 1.4
     *                 - possibilité de se désinscrire de la newsletter
     *                 - "devpro" modification chargement des TPL
     *                 - "devpro" modification chargement des classes
     */

    private $_html = '';

    function __construct(){
        $this->name = 'freenewsletter';
        $this->tab = 'Tools';
        $this->version = 0.2;
        parent::__construct();
        $this->displayName = $this->l('Module Free Newsletter');
        $this->description = $this->l('Envoyez une Newsletter à vos clients');
        // devpro
        include(_PS_ROOT_DIR_.'/modules/devpro/init.php');
    }

    function install(){
        Configuration::updateValue('FREENEWSLETTER_SLEEP',0);
        // initialisation des tables
        Db::getInstance()->Execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'freenewsletter` (
              `id_freenewsletter` int(11) NOT NULL AUTO_INCREMENT,
              `date` date NOT NULL,
              `id_group` int(11) NOT NULL,
              `status` int(11) NOT NULL,
              `send_registered` tinyint(1) NOT NULL,
              `nb_mails_send` int(11) NOT NULL,
              PRIMARY KEY (`id_freenewsletter`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;');
        Db::getInstance()->Execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'freenewsletter_lang` (
              `id_freenewsletter` int(11) NOT NULL,
              `title` varchar(200) NOT NULL,
              `content` text NOT NULL,
              `id_lang` int(11) NOT NULL,
              KEY `id_freenewsletter` (`id_freenewsletter`)
            ) ENGINE=MyISAM DEFAULT CHARSET=latin1;');
        Db::getInstance()->Execute('
           CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'freenewsletter_product` (
            `id_freenewsletter_product` int(11) NOT NULL AUTO_INCREMENT,
            `id_freenewsletter` int(11) NOT NULL,
            `id_product` int(11) NOT NULL,
             `id_product_attribute` int(11) NOT NULL,
          PRIMARY KEY (`id_freenewsletter_product`)
        ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
        ');
        Db::getInstance()->Execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'freenewsletter_registered` (
              `id_freenewsletter_registered` int(11) NOT NULL AUTO_INCREMENT,
              `email` varchar(256) NOT NULL,
              PRIMARY KEY (`id_freenewsletter_registered`)
            ) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
        ');

        if(!parent::install() || !$this->registerHook('leftColumn'))
            return false;
        else
            return true;
    }

    function uninstall(){
        // retire les tables
        Db::getInstance()->Execute('DROP TABLE if exists `'._DB_PREFIX_.'freenewsletter`');
        Db::getInstance()->Execute('DROP TABLE if exists `'._DB_PREFIX_.'freenewsletter_lang`');
        Db::getInstance()->Execute('DROP TABLE if exists `'._DB_PREFIX_.'freenewsletter_product`');
        Db::getInstance()->Execute('DROP TABLE if exists `'._DB_PREFIX_.'freenewsletter_registered`');
        // retire la config.
        if(!Configuration::deleteByName('FREENEWSLETTER_SIGNATURE') OR 
            !Configuration::deleteByName('FREENEWSLETTER_SLEEP') OR
            !Configuration::deleteByName('FREENEWSLETTER_SMTP_ACTIVE') OR
            !Configuration::deleteByName('FREENEWSLETTER_SMTP_SERVER') OR
            !Configuration::deleteByName('FREENEWSLETTER_SMTP_USER') OR
            !Configuration::deleteByName('FREENEWSLETTER_SMTP_PW') OR
            !Configuration::deleteByName('FREENEWSLETTER_SMTP_CRYPT') OR
            !Configuration::deleteByName('FREENEWSLETTER_SMTP_PORT') OR
            !parent::uninstall())
            return false;
        return true;
    }

    function getContent(){
       return $this->_html;
    }

    function hookLeftColumn($params){
        return Front::loadTpl('freenewsletter');
    }

    function hookRightColumn($params){
        return $this->hookLeftColumn($params);
    }

    /*
     * Charge les paramètres SMTP
     * @param  -
     * @return array
     */
    function getSmtp(){
        $smtp = array();
        $smtp_active = Configuration::get('FREENEWSLETTER_SMTP_ACTIVE');
        if($smtp_active){
            $smtp['server'] = Configuration::get('FREENEWSLETTER_SMTP_SERVER');
            $smtp['user'] = Configuration::get('FREENEWSLETTER_SMTP_USER');
            $smtp['pw'] = Configuration::get('FREENEWSLETTER_SMTP_PW');
            $smtp['crypt'] = Configuration::get('FREENEWSLETTER_SMTP_CRYPT');
            $smtp['port'] = Configuration::get('FREENEWSLETTER_SMTP_PORT');
        }
        return $smtp;
    }

}
?>
