/*
	Prestashop Slideshow - jQuery slideshow Plugin
	Copyright (c) 2009 Tiago P
	Version:		1.0 (October 5, 2009)
*/

(function($) {

  $.fn.slideshow = function(options) {
	 var opt = $.extend($.fn.slideshow.defaults,options);
	 var s_id;
	 var s_panels;
	 var s_selected;
	 var s_filmstrip;
	 
	 return this.each(function() {   
	    $this = $(this);
	   	s_id = $(this).attr('id');
		if(opt.show_filmstrip == false){
			opt.frame_height = 0;
			opt.filmstrip_position = 'none';
		}else{
			opt.frame_height += 10;	
		}
		
		var panel_height = opt.panel_height + opt.frame_height;
		
		$(this).css({'position':'relative','display':'none','width':opt.panel_width+'px',
					 'height':panel_height+'px','background-color':opt.background,'border-color':opt.bordercolor,'padding':''});
		s_panels = $(".slideshow-panel",$this);
		s_panels.css("display",'none');
		
		if(opt.display_arrows == true && s_panels.length > 0){
			displayArrows();
			$(document).bind("mousemove",showHideArrows);
		}
		switch(opt.filmstrip_position){
				case 'bottom' : 
						s_panels.css({'position':'absolute','top':'','width':opt.panel_width+'px','height':opt.panel_height+'px'});
						$(".slideshow-filmstrip",$(this)).css({'bottom':$(this).css('paddingBottom'),'width':opt.panel_width+'px','position':'absolute'});
						$(".arrow-left",$(this)).css('top','20%');
						$(".arrow-right",$(this)).css('top','20%');
						break;
				case 'top' :	
						s_panels.css({'position':'absolute','bottom':$(this).css('paddingTop'),'width':opt.panel_width+'px','height':opt.panel_height+'px'});
						$(".slideshow-filmstrip",$(this)).css({'top':$(this).css('paddingTop'),'bottom':0,'width':opt.panel_width+'px','position':'absolute'});
						$(".arrow-left",$(this)).css('bottom','40%');
						$(".arrow-right",$(this)).css('bottom','40%');
						break;
				case 'none' : 
						s_panels.css({'position':'absolute','bottom':2,'width':opt.panel_width+'px','height':opt.panel_height+'px'});
						$(".slideshow-filmstrip",$this).css('display','none');
						$(".arrow-left",$(this)).css('bottom','50%');
						$(".arrow-right",$(this)).css('bottom','50%');
						break;
				case 'left' : break; //to do
				case 'right' : break; // to do
			}
		$('img',s_panels).attr('height',opt.panel_height);
		$('img',s_panels).attr('width',opt.panel_width);
		$(".slideshow-panel .info",$this).css({'display':'none','height':'0px','width':opt.panel_width+'px',
										 'position':'absolute','bottom':0,'left':0,'background':'url("modules/homeslideshow/js/img/transparent-bg.png")'});
		if(opt.show_filmstrip == true){
			s_filmstrip = $(".slideshow-filmstrip ul li",$this);
			$("img",s_filmstrip).css("border-color",opt.background);
			$(".slideshow-filmstrip",$this).css('display','block');
			s_filmstrip.each(function(index){			
				$("a",this).bind("click",function(){ loadPanel(index); return false; });	
			});
		}
		if(opt.show_overlay == false){
			$(".info",s_panels).remove();
		}
		loadPanel(0);
		$(this).css('display','block');
	 });

	function loadPanel(index){
		
		$("#"+s_id).stopTime("transition");
		if(s_selected != index){
			if(opt.show_filmstrip == true){
				s_filmstrip.eq(s_selected).removeClass("selected");	
				s_filmstrip.eq(index).addClass("selected");
				if(opt.filmstrip_selected_border){
					$("img",s_filmstrip.eq(s_selected)).css("border-color",opt.background);
					$("img",s_filmstrip.eq(index)).css("border",opt.filmstrip_selected_border);
				}
			}
			s_panels.fadeOut(400).eq(index).fadeIn(400)
			var curr_panel = s_panels.eq(index);
			var old_panel = s_panels.eq(s_selected);
			
			$(".info",old_panel).animate({'height':'0px'});
			if(opt.show_overlay == true){ $(".info",curr_panel).animate({'height':opt.overlay_height+'px'}); }
			curr_panel.css("zIndex","10");
			old_panel.css("zIndex","0");
			s_selected = index;
		}
		if(s_panels.length > 0) $("#"+s_id).everyTime(opt.transition_interval,"transition",nextPanel);
	} 
	function nextPanel(){
		next_selected = s_selected == s_panels.length-1 ? 0 : s_selected+1; 
		 loadPanel(next_selected);
	}
	function prevPanel(){
		prev_selected = s_selected == 0 ? s_panels.length-1 : s_selected-1; 
		 loadPanel(prev_selected);
	}
	function mouseIsOverGallery(e){
		 pos = s_panels.eq(s_selected).offset();
		//alert("mouseY "+e.pageY+" - mouseX "+e.pageX+" - top "+pos.top+" left - "+pos.left+" - maxLeft "+(pos.left + opt.panel_width)+" maxTop "+(pos.top + opt.panel_height));
		if(e.pageY >= pos.top && e.pageY < (pos.top + opt.panel_height) && e.pageX >= pos.left && e.pageX < (pos.left + opt.panel_width)) return true;
		return false;
	}
	function displayArrows(){
		var html_left = $('<a href="#" class="arrow-left"></a>');
		var html_right = $('<a href="#" class="arrow-right"></a>');
		html_left.appendTo("#"+s_id);
		html_right.appendTo("#"+s_id);
		$(".arrow-left","#"+s_id).css({'display':'none','position':'absolute','zIndex':'5000','left':'8px'});
		$(".arrow-right","#"+s_id).css({'display':'none','position':'absolute','zIndex':'5000','right':'8px'});	
		$(".arrow-left","#"+s_id).bind("click",function(){ prevPanel(); return false; });	
		$(".arrow-right","#"+s_id).bind("click",function(){ nextPanel(); return false; });
	}
	function showHideArrows(e){
		if(!mouseIsOverGallery(e)) {
			$(".arrow-left","#"+s_id).hide();
			$(".arrow-right","#"+s_id).hide();
		}else{
			$(".arrow-left","#"+s_id).show();
			$(".arrow-right","#"+s_id).show();
		}
	}
  };
  $.fn.slideshow.defaults = {
	 background:'',
	 bordercolor:'',
	 show_filmstrip: true,
	 panel_width:400,
	 panel_height : 320,
	 show_overlay : true,
	 transition_interval : 4000,
	 overlay_height : 70,
	 frame_width : 60,
	 frame_height : 50,
	 filmstrip_position : 'bottom',
	 display_arrows : true
  };
})(jQuery);