{*
 * Noir Ô Naturel
 * Display selected category logos for current product in dedicated tab
 * see {$HOOK_PRODUCT_TAB_CONTENT} in <theme>/product.tpl for integration point
*}

{if $categories}
    <!-- Module Categories for Product -->
    <ul id="idTab30" class="block_hidden_only_for_screen">
        <div id="nnCategoriesForProduct" class="clearfix">
            <h2>{l s='Labels for this product' mod='nncategoriesforproduct'}</h2>
            <ul class="inline_list">
                {foreach from=$categories item=category}
                	<li>
                		<a href="{$link->getCategoryLink($category.id_category, $category.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$category.name|escape:'htmlall':'UTF-8'}">
                			{if $category.id_image}
                				<img src="{$link->getCatImageLink($category.link_rewrite, $category.id_image, 'medium')}" alt="{$category.name|escape:'htmlall':'UTF-8'}" width="{$mediumSize.width}" height="{$mediumSize.height}" />
                			{else}
                				<img src="{$img_cat_dir}default-medium.jpg" alt="{$categoryProduct.name|htmlspecialchars}" width="{$mediumSize.width}" height="{$mediumSize.height}" />
                			{/if}
                		</a><br />
                		<a href="{$link->getCategoryLink($category.id_category, $category.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$category.name|escape:'htmlall':'UTF-8'}">
                        {$category.name|truncate:15:'...'|escape:'htmlall':'UTF-8'}
                        </a>
                	</li>
                {/foreach}
            </ul>
        </div>
    </ul>
{/if}
