--
-- This script contains database update to migrate into v1.4
-- to be run at the end of the installation process 
-- - when 1.4 is installed
-- - after importing label categories 
-- - before starting front office again
--
--

-- Affectation des catégories de labels aux labels v1.3
insert into ps_noncategory_product ( id_category, id_product, position )
select f.id_category, f.id_product, f.position
from 
(
    select pc.id_category,
           pc.id_product,
           case when (@last_cat <> pc.id_category) then @rownum:=0 else @rownum:=@rownum+1 end as position,  
           @last_cat:= pc.id_category as last_category      
    from        
    (    
        select 
            label.id_category,
            prod.id_product
        from ( 
            select id_product, labels 
            from ps_nonproduct_lang prod
            where id_lang = 2
        ) prod
        join 
        (
            select cat.id_category, lab.id_str, lab.name
            from
            (
                select '00' as id_str, 'none' as name
                union select '01','Agriculture biologique'
                union select '02','Ab'
                union select '03','Nature et progres'
                union select '04','Demeter'
                union select '05','Ecocert'
                union select '06','Bioequitable'
                union select '07','Global organic textil standard'
                union select '08','Oekotex 100'
                union select '09','Oekotex 1000'
                union select '10','Cosmebio eco'
                union select '11','Bdih'
                union select '12','Cosmebio bio'
                union select '13','Natrue'
                union select '14','Fsc'
                union select '15','Pefc'
                union select '16','Imprimvert'
                union select '17','Tropical forest trust'
                union select '18','Ecoeuropeen'
                union select '19','Eko'
                union select '20','Equitable solidaire responsable'
                union select '21','Max havelaar'
                union select '22','Nf environnement'
                union select '23','Leapingbunny'
                union select '24','Marine stewarship council'
                union select '25','Naturland'
                union select '26','Rainforest alliance'
                union select '27','Oko test'
                union select '28','Soil association'
                union select '29','Nordic ecolabel'
                union select '30','Nach eg oko verordnung'
                union select '31','Ecocert produits menagers'
                union select '32','Certificazione biologica gci'
                union select '33','Cent pourcent naturel'
                union select '34','Organic'
                union select '35','Bags of ethics'
            ) lab
            join ps_noncategory_lang cat on cat.name=lab.name and cat.id_lang=2
        ) label on prod.labels like concat('%',label.id_str,'%')
    ) pc, (select @rownum:=0, @last_cat:=0, @currnum:=0) r
    order by pc.id_category, pc.id_product
) f
;

/** Commented in case reverse operation needed 
 *
alter table ps_nonproduct_lang
drop column labels;
*/

