<?php

class colissyncclass {
    public $id_state_ready_to_go_total;// id state when order is ready to send
    public $id_state_taked_total;// id state when order is received by LaPoste
    public $id_state_delivered_total;// id state when order is delivered by LaPoste
    
    public $conf;
    public $first_step_statuts = Array();
    public $second_step_statuts = Array();
    
	private $login;
	private $password;
	
    public function init(){
    	@ini_set('display_errors', 'off');//parsing the coliposte webpage into xml can generate a lot of errors
			
        $this->conf = array('name' => 'ColiPoste',
               'link' => 'http://www.colissimo.fr/portail_colissimo/suivre.do?colispart={{NUM}}',
               'status' => array(),
            );
			
		$this->first_step_statuts = Array();
		foreach (explode("\n", str_replace('rn', "\n", Configuration::get('STATES_SYNC_1'))) as $state)
		{
			if(trim($state) != '')
				$this->first_step_statuts[]=trim($state);
		}
		foreach (explode("\n", str_replace('rn', "\n", Configuration::get('STATES_SYNC_2'))) as $state)
		{
			if(trim($state) != '')
				$this->second_step_statuts[]=trim($state);
		}
		
	    $this->login = Configuration::get('LOGIN_SYNC_1');// id state when order is ready to send
	    $this->password = Configuration::get('PASS_SYNC_1');// id state when order is ready to send
	    $this->id_state_ready_to_go_total = Configuration::get('COLISSYNC_STATE_EXPORT');// id state when order is ready to send
    	$this->id_state_taked_total = Configuration::get('COLISSYNC_STATE_RECU');// id state when order is received by LaPoste
	    $this->id_state_delivered_total = Configuration::get('COLISSYNC_STATE_LIVRE');// id state when order is delivered by LaPoste
    }

    
    private function getOrders($id_order_state){
         $sqlSelectOrder = '
		   SELECT 
                        DISTINCT o.`id_order`, shipping_number, (SELECT moh.`id_order_state` FROM `'._DB_PREFIX_.'order_history` moh WHERE moh.`id_order` = o.`id_order` ORDER BY moh.id_order_history DESC LIMIT 1) as id_order_state
                   FROM `'._DB_PREFIX_.'orders` o
		   JOIN `'._DB_PREFIX_.'order_history` oh ON (o.`id_order` = oh.`id_order`)
		   WHERE o.date_add > "2013-09-01" AND
                      (SELECT moh.`id_order_state` FROM `'._DB_PREFIX_.'order_history` moh WHERE moh.`id_order` = o.`id_order` ORDER BY moh.id_order_history DESC LIMIT 1) IN ('.implode(',', $id_order_state).')                          
           ORDER BY id_order DESC
			    ;';
		$selectedOrder = Db::getInstance()->ExecuteS($sqlSelectOrder);
                
		return $selectedOrder;
    }
    
    
    /*
     * Get all shipping numbers orders from a particular states
     * $arrayStates Array() list of order status id
     * $sync_poste state of the field sync_poste
     */
    public function getOrdersShippingNumbers($arrayStates, $sync_poste){
        //getting orders
        $ordersByState = $this->getOrders($arrayStates);
        $ordersShippingNumbers = Array();
        $i = 0;
        if($ordersByState){
            foreach($ordersByState as $order){
                
                // getting shipping_number
	    
	            $i++;
	            $ordersShippingNumbers[$i]['id_order'] = (int)$order['id_order'];
	            $ordersShippingNumbers[$i]['id_order_state'] = (int)$order['id_order_state'];
	            $ordersShippingNumbers[$i]['shipping_number'] = $order['shipping_number'];
            }
        }
        return $ordersShippingNumbers;
    }    
    
    /*
     * Sync with la post for expedition
     */
    public function sync1(){
        
        $ordersShippingNumbers = $this->getOrdersShippingNumbers( Array($this->id_state_ready_to_go_total), 0 );
   
        if(!$ordersShippingNumbers)
            return;
        
        //getting informations from laposte
        foreach ($ordersShippingNumbers as $ordersShippingNumber){
            $statut = $this->getStatus( $ordersShippingNumber['shipping_number'] );
            
            //display :
            echo '<br /> (step 1 ) Id order : '.$ordersShippingNumber['id_order'].' Shipping :'.$ordersShippingNumber['shipping_number'].' Statut : '.$statut;
            
            
            if(in_array($statut, $this->first_step_statuts) || in_array($statut, $this->second_step_statuts)){
                if($ordersShippingNumber['id_order_state'] !=$this->id_state_taked_total)
                    $this->changeState((int)$ordersShippingNumber['id_order'], $this->id_state_taked_total);
            }
        }
    }

    /*
     * Sync with la post for delivery
     */
    public function sync2(){
        $ordersShippingNumbers = $this->getOrdersShippingNumbers( Array($this->id_state_taked_total), 1 );
        
        if(!$ordersShippingNumbers)
            return;

        //getting informations from laposte
        foreach ($ordersShippingNumbers as $ordersShippingNumber){
            $statut = $this->getStatus( $ordersShippingNumber['shipping_number'] );
			
			if($statut == '')
				continue;

            //display :
            echo '<br /> (step 2 ) Id order : '.$ordersShippingNumber['id_order'].' Shipping :'.$ordersShippingNumber['shipping_number'].' Statut : '.$statut;
            $update = false;
            if(in_array($statut, $this->second_step_statuts)){
                $update = true;
            }
            
            if(in_array($statut, $this->second_step_statuts)){
                $update = true;
            } 
            
            if($update == true)
            {
                if($ordersShippingNumber['id_order_state'] != $this->id_state_delivered_total && $ordersShippingNumber['id_order_state'] == $this->id_state_taked_total )
                    $this->changeState((int)$ordersShippingNumber['id_order'], $this->id_state_delivered_total);                
            }
        }    
    }
 
    public function changeState($id_order, $id_order_state){
        echo '<br />' .$id_order . " State changes to ".$id_order_state;
     
        // Changer le statut de la commande
        $idTochange = (int)$id_order;
        $orderHistory = new OrderHistory();
        $orderHistory->id_order = (int)$id_order;
        $orderHistory->changeIdOrderState((int)$id_order_state,  $idTochange); //Expediee
        $orderHistory->save();
    }
    
    // get status with the id of a carrier configuration and a shipping number
// get status with the id of a carrier configuration and a shipping number
	//xml version
    public function getStatus($numColis)
	{
		$url = 'https://www.coliposte.fr/tracking-chargeur-cxf/TrackingServiceWS/track?accountNumber='.$this->login.'&password='.$this->password.'&skybillNumber='.$numColis;

		$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, $user_agent);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FAILONERROR, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);
        curl_setopt($ch, CURLOPT_COOKIESESSION, true);
        curl_setopt($ch, CURLOPT_FORBID_REUSE, true);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
        curl_setopt($ch, CURLOPT_DNS_CACHE_TIMEOUT, 0);
        $data = curl_exec($ch);
        curl_close($ch);
		$dom = new DOMDocument('1.0', 'utf-8');
		
         if(!$dom->loadXML($data)){
            return '';
        }
		return (string) $dom->getElementsByTagName('eventLibelle')->item(0)->nodeValue;  
	}
    
}
?>