<?php
/**
 * colissyncmagavenue class, colissyncmagavenue.php
 * Sync with La poste and export late boxes
 * @category modules
 *
 * @author Magavenue <contact@magavenue.com>
 * @copyright Magavenue
 * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
 * @version 2.0
 * @note  If you want to customize the module, contact us at contact@magavenue.com
 */
class colissyncmagavenue extends Module {
	// build
	public function __construct() {
		$this -> name = 'colissyncmagavenue';
		$this -> tab = 'shipping_logistics';
		$this->module_key = 'b19753797029fd60b2dce1d0fe270533';
		$this -> version = '2.0';
		$this -> author = 'MagAvenue';

		parent::__construct();

		$this -> displayName = $this->l('Synchronization with LaPoste');
		$this -> description = $this->l('Sync and export');
		$this -> confirmUninstall = $this->l('Are you sure you want to delete all your details ?');
	}

	// module install
	public function install() {
		if (!parent::install() OR !Configuration::updateValue('COLISSYNC_ID', 0))
			return false;
                
                Configuration::updateValue('COLISSYNC_SECURE_KEY', strtoupper(Tools::passwdGen(16)));
                
		return true;
	}

        public function uninstall()
	{
		Configuration::deleteByName('COLISSYNC_ID');
                Configuration::deleteByName('COLISSYNC_SECURE_KEY');
                Configuration::deleteByName('LOGIN_SYNC_1');
                Configuration::deleteByName('PASS_SYNC_1');
                Configuration::deleteByName('STATES_SYNC_2');
                Configuration::deleteByName('STATES_SYNC_1');
                Configuration::deleteByName('COLISSYNC_STATE_EXPORT');
                Configuration::deleteByName('COLISSYNC_STATE_RECU');
                Configuration::deleteByName('COLISSYNC_STATE_LIVRE');
                
		return parent::uninstall();
	}
        
	public function getContent() {
		global $cookie;

		if (isset($_POST['saveStates']) && $_POST['saveStates'] != NULL) {
			Configuration::updateValue('LOGIN_SYNC_1', Tools::getValue('LOGIN_SYNC_1'));
			Configuration::updateValue('PASS_SYNC_1', Tools::getValue('PASS_SYNC_1'));
			Configuration::updateValue('STATES_SYNC_2', Tools::getValue('STATES_SYNC_2'));
			Configuration::updateValue('STATES_SYNC_1', Tools::getValue('STATES_SYNC_1'));
			Configuration::updateValue('COLISSYNC_STATE_EXPORT', Tools::getValue('exportState'));
			Configuration::updateValue('COLISSYNC_STATE_RECU', Tools::getValue('priseState'));
			Configuration::updateValue('COLISSYNC_STATE_LIVRE', Tools::getValue('livreState'));
		}
		$server_host = htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8');
		$protocol = 'http://';
		$sqlSelectStates = 'SELECT DISTINCT id_order_state, name FROM `' . _DB_PREFIX_ . 'order_state_lang` WHERE `id_lang`="' . (int)$cookie -> id_lang . '";';
		$selectedStates = Db::getInstance() -> ExecuteS($sqlSelectStates);

		$this -> _html = '
           
            <form method="post" action="' . $_SERVER['REQUEST_URI'] . '">
                <fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this -> displayName.'</legend>
                    <p>' . $this->l('To see the use of this module handbook click ') . ' ' .'<a href="' . __PS_BASE_URI__.'modules/'.$this -> name.'/readme_' . $this->context->language->iso_code.'.pdf">' . $this->l('here.') . '</a></p>
                    <hr size="1" />        
                    <label for="LOGIN_SYNC_1">' . $this->l('Coliposte Login') . ' : </label>
                    <div class="margin-form">
                        <input type="text" id="LOGIN_SYNC_1" name="LOGIN_SYNC_1" value="' . str_replace('rn', "\n", Configuration::get('LOGIN_SYNC_1')) . '" />
                    </div>
                    <label for="PASS_SYNC_1">' . $this->l('Coliposte Password') . ' : </label>
                    <div class="margin-form">
                        <input type="text" id="PASS_SYNC_1" name="PASS_SYNC_1" value="' . str_replace('rn', "\n", Configuration::get('PASS_SYNC_1')) . '" />
                    </div>
                    <label for="STATES_SYNC_1">' . $this->l('Change status 1') . ' : </label>
                    <div class="margin-form">
                        <textarea id="STATES_SYNC_1" name="STATES_SYNC_1" cols="100" rows="15">' . str_replace('rn', "\n", Configuration::get('STATES_SYNC_1')) . '</textarea>
                        <p>' . $this->l('Text status on Colissimo, separated by a newline') . '</p>
                    </div>

                    <label for="STATES_SYNC_2">' . $this->l('Change status 2') . ' : </label>
                    <div class="margin-form">
                        <textarea id="STATES_SYNC_2" name="STATES_SYNC_2" cols="100" rows="15">' . str_replace('rn', "\n", Configuration::get('STATES_SYNC_2')) . '</textarea>
                        <p>' . $this->l('Text status on Colissimo, separated by a newline') . '</p>
                    </div>

	                <label>' . $this->l('Status consideration') . '</label>
					<div class="margin-form">
						<select name="exportState" id="exportState">
                            <option value="0">- - -</option>
                        ';
		foreach ($selectedStates as $state)
			$this -> _html .= '<option ' . ((int)$state['id_order_state'] == (int)Configuration::get('COLISSYNC_STATE_EXPORT') ? 'selected="selected"' : '') . ' value="' . $state['id_order_state'] . '">' . $state['name'] . '</option>';
		$this -> _html .= '
						</select>
						<p class="clear">' . $this->l('Orders with this status will be synchronized with LaPoste') . '</p>
					</div>
                    
	                <label>' . $this->l('Status supported') . '</label>
					<div class="margin-form">
						<select name="priseState" id="priseState">
                            <option value="0">- - -</option>
                        ';
		foreach ($selectedStates as $state)
			$this -> _html .= '<option ' . ((int)$state['id_order_state'] == (int)Configuration::get('COLISSYNC_STATE_RECU') ? 'selected="selected"' : '') . ' value="' . $state['id_order_state'] . '">' . $state['name'] . '</option>';
		$this -> _html .= '
						</select>
						<p class="clear">' . $this->l('Status order change when La Poste has retrieved the bag') . '</p>
					</div>
                    
	                <label>' . $this -> l('Delivered status') . '</label>
					<div class="margin-form">
						<select name="livreState" id="livreState">
                            <option value="0">- - -</option>
                        ';
		foreach ($selectedStates as $state)
			$this -> _html .= '<option ' . ((int)$state['id_order_state'] == (int)Configuration::get('COLISSYNC_STATE_LIVRE') ? 'selected="selected"' : '') . ' value="' . $state['id_order_state'] . '">' . $state['name'] . '</option>';
		$this -> _html .= '
						</select>
						<p class="clear">' . $this->l('Status order change when La Poste has delivered the bag') . '</p>
					</div>
                    
                    
                    <p><center><input type="submit" value="' . $this->l('Save') . '" name="saveStates" class="button" /></center></p>
                    <hr size="1" />
                    <p>'.$this->l('To update your orders automatically with their status on the website of La Poste Colissimo.').'<br />
                    '.$this->l('Define settings and place this URL in crontab or call it manually many time daily:').'
                    <b>'.__PS_BASE_URI__.'modules/'.$this -> name.'/cron.php?secure_key='.Configuration::get('COLISSYNC_SECURE_KEY').'</b></p>
				
                </fieldset>

                </form>
                ';
		return $this -> _html;
	}

}
?>
