<?php
class SendNewsLetter extends Module
{

        public function __construct()
	{
		$this->name = 'sendnewsletter';
		$this->version = '1.0';
		$this->tab = 'advertising_marketing';

		parent::__construct();

		$this->displayName = $this->l('Send my NewsLetter');
		$this->description = $this->l('Promote your shop with newsletter');
                $this->_html = '<h2>
                                       <img src="'.__PS_BASE_URI__.'modules/sendnewsletter/logo.gif"/>
                        '.$this->displayName.'</h2>';
	}

        public function install()
        {
                $query[] = '
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'sendnewsletter` (
				`id_newsletter` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                                `id_template` smallint(6) UNSIGNED NOT NULL,
			PRIMARY KEY (`id_newsletter`))';

                $query[] = '
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'sendnewsletter_lang` (
				`id_newsletter` smallint(6) UNSIGNED NOT NULL,
                                `id_lang` smallint(6) UNSIGNED NOT NULL,
                                `content` TEXT CHARACTER SET utf8,
                                `title` VARCHAR(255) CHARACTER SET utf8 NOT NULL,
			KEY (`id_newsletter`, `id_lang`))';

                $query[] = '
                        CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'sendnewsletter_template` (
				`id_template` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                                `name` VARCHAR(255) CHARACTER SET utf8 NOT NULL,
                                `id_header` smallint(6) UNSIGNED,
                                `id_footer` smallint(6) UNSIGNED,
			PRIMARY KEY (`id_template`))';

                $query[] = '
                        CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'sendnewsletter_stat` (
				`id_newsletter` smallint(6) UNSIGNED NOT NULL,
                                `unsuscribe` smallint(6) DEFAULT \'0\',
                                `opening` smallint(6) UNSIGNED,
                                `date_sending` TIMESTAMP,
                                `date_opening` TIMESTAMP,
                                `email` VARCHAR(255) CHARACTER SET utf8 NOT NULL,
				`id_stat` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
			PRIMARY KEY (`id_stat`))';

                $query[] = '
                        CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'sendnewsletter_header` (
                                `id_header` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                                `name` varchar(255) CHARACTER SET utf8 NOT NULL,
                                `content` TEXT CHARACTER SET utf8,
                        PRIMARY KEY (`id_header`))';

                $query[] = '
                        CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'sendnewsletter_footer` (
                                `id_footer` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
                                `name` varchar(255) CHARACTER SET utf8 NOT NULL,
                                `content` TEXT CHARACTER SET utf8,
                        PRIMARY KEY (`id_footer`))';


                $db = Db::getInstance();
                $response = true;
                foreach ($query as $qr)
                {
                        $response = $response AND (bool)$db->Execute($qr);
                }

                if($response)
                {
                        $response = $response AND (bool)$db->Execute('INSERT INTO `'._DB_PREFIX_.'sendnewsletter_footer`
                                                        (`id_footer`, `name`, `content`)
                                                        VALUES (1, \'default\', \'<div style="width: 100%; height: 15%; background-color: #61af73;"></div>\')');

                        $response = $response AND (bool)$db->Execute('INSERT INTO `'._DB_PREFIX_.'sendnewsletter_header`
                                                        (`id_header`, `name`, `content`)
                                                        VALUES (1, \'default\', \'<div style="width: 100%; height: 15%; background-color: #61af73;"></div>\')');

                        $response = $response AND (bool)$db->Execute('INSERT INTO `'._DB_PREFIX_.'sendnewsletter_template` (`id_template`, `name`, `id_header`, `id_footer`)
                                                                        VALUES (1, \'default template\', 1, 1)');

                }
                
                $response = parent::install() AND $response;
                $this->registerHook('AdminStatsModules');

                @chmod(_PS_ROOT_DIR_.'/modules/sendnewsletter/send.log', 0777);
                return $response;
        }


        public function uninstall()
        {
                $db = Db::getInstance();

                return parent::uninstall()
                        AND $db->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'sendnewsletter`')
                        AND $db->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'sendnewsletter_template`')
                        AND $db->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'sendnewsletter_stat`')
                        AND $db->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'sendnewsletter_header`')
                        AND $db->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'sendnewsletter_footer`')
                        AND $db->Execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'sendnewsletter_lang`');;
        }


        public function getContent()
        {
                $elements = array('footer', 'header', 'footer');

                $this->_html .= $this->displayJS();
                $this->_html .= $this->displayCSS();
                $this->_html .= '<div class="message_callback"></div>';
                $this->_html .= self::displayMainActions();

                return $this->_html;
        }


        private function displayMainActions()
        {
                return '
                        
                        <div>
                                <div class="tab-row">
                                        <h4 class="tab"><a href="#" name="templates_manager">'.$this->l('Templates manager').'</a></h4>
                                        <h4 class="tab selected"><a href="#" name="mails_manager">'.$this->l('Mails manager').'</a></h4>
                                        <h4 class="tab"><a href="#" name="stats_manager">'.$this->l('Stats manager').'</a></h4>
                                </div>
                                <div class="tab-page">'.$this->display_form_mails().'
                                </div>

                               
                        </div>
                ';

        }

        /**
         * Obtain a template or all edited templates
         *
         * @param $id integer, existing template id (optional)
         * 
         */
        public function getTemplate($id = null)
        {
                $query = '
                        SELECT `tpl`.`id_template`, `tpl`.`name` AS `name`,
                                `hd`.`id_header`, `hd`.`name` AS `header`,
                                `ft`.`id_footer`, `ft`.`name` AS `footer`
                        FROM `'._DB_PREFIX_.'sendnewsletter_template` `tpl`
                        LEFT JOIN  `'._DB_PREFIX_.'sendnewsletter_header` `hd`
                        ON `hd`.`id_header` = `tpl`.`id_header`
                        LEFT JOIN  `'._DB_PREFIX_.'sendnewsletter_footer` `ft`
                        ON `ft`.`id_footer` = `tpl`.`id_footer`
                        ';


                if(is_numeric($id))
                {
                        $query .= 'WHERE `tpl`.`id_template` = '.intval($id);
                        return DB::getInstance()->getRow($query);
                }

                return DB::getInstance()->ExecuteS($query);
        }

        /**
         * Obtain a footer or all edited footers
         *
         * @param $id integer, existing footer id (optional)
         *
         */
        public function getFooter($id=null)
        {
                return $this->getElement('footer', $id);
        }


        /**
         * Obtain an header or all edited headers
         *
         * @param $id integer, existing header id (optional)
         *
         */
        public function getHeader($id=null)
        {
                return $this->getElement('header', $id);
        }


        /**
         * Obtain an element or all edited elements
         *
         * @param string $element, type of element (footer or header)
         * @param integer $id, existing element id (optional)
         *
         */
        public function getElement($element, $id=null)
        {
                $query = '
                        SELECT `elt`.`id_'.$element.'`, `elt`.`name`,`elt`.`content`
                        FROM `'._DB_PREFIX_.'sendnewsletter_'.$element.'` `elt`
                        ';
                if(is_numeric($id))
                {
                        $query .= ' WHERE `elt`.`id_'.$element.'`= '.$id;
                        $return = DB::getInstance()->getRow($query);
                        $return['content'] = urldecode($return['content']);
                        return $return;
                }

                $return = DB::getInstance()->ExecuteS($query);

                foreach ($return AS $key=>$ret)
                {
                        $return[$key]['content'] = urldecode($return[$key]['content']);
                }
                return $return;
        }


        private function displayCSS()
        {

                return
'<style type="text/css">
.tab-pane {
    float: left;
    position: relative;
    width: 928px;
}

.tab-row .tab {
    background: none repeat scroll 0 0 #EFEFEF;
    display: inline;
    float: left;
    font-size: 1.1em;
    font-weight: bold;
    margin: 0px;
    padding: 2px 8px 3px;
    position: relative;
    text-align: center;
    white-space: nowrap;
    z-index: 1;
}
.tab-row .tab.selected {
    -moz-border-bottom-colors: none;
    -moz-border-image: none;
    -moz-border-left-colors: none;
    -moz-border-right-colors: none;
    -moz-border-top-colors: none;
    background: none repeat scroll 0 0 #FFF6D3;
    border-color: #CCCCCC #CCCCCC -moz-use-text-color;
    border-style: solid solid none;
    border-width: 1px 1px 0;
    margin: 1px -3px -3px 0;
    padding: 2px 25px 4px;
    top: -2px;
    z-index: 3;
}
.tab-page {
    background: none repeat scroll 0 0 #FFFFF0;
    border: 1px solid #CCCCCC;
    clear: both;
    padding: 10px;
    position: relative;
    z-index: 2;
}
.tab-page table tr td.col-left {
    vertical-align: top;
    width: 150px;
}
.tab-page table tr td p {
    color: #7F7F7F;
    font-size: 0.95em;
    margin: 0.5em 0 0;
    padding: 0 0 0.5em;
}
.tab-page table tr td p.block {
    clear: both;
    display: block;
}
.tab-row {
    white-space: nowrap;
    z-index: 1;
}
</style>';
        }



        /**
         * Display the form to add or update an element
         * Forms to add a footer or a header are identical, but not that to add a template
         * 
         * @param string $element, type of element (footer, header, template)
         * @param array $data, existing element data (optional)
         *
         */
        public function displayFormAddElement($element, $data = array())
        {
                global $cookie;

                $array = array('template', 'header', 'footer');
                if(!in_array($element, $array))
                        return ;

                $defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$iso = Language::getIsoById($defaultLanguage);
		$divLangName = 'cpara¤dd';


                foreach ($languages AS $language)
                {
                        $blocTitle[$language['id_lang']] =
                                    '
                                     <label>'.$this->l($language['name']).' : '.$this->l('Name').'</label>
                                     <input type="text" name="name_of_'.$element.'_'.$language['id_lang'].'" value="'.(isset($data['name']) ? $data['name'] :'').'" size=70 />
                                     <div class="clear">&nbsp;</div>';
                }
                
                $blocContent = '';


                $subString = '';
                if($element == 'template')
                {
                        $headers = $this->getHeader();
                        $footers = $this->getFooter();


                        $subString .= '
                                <fieldset style="float:left; width:46.5%;">
                                        <legend>'.$this->l('1. Choose an header').'</legend>
                                        <select name="id_header">';
                                foreach ($headers AS $header)
                                {
                                        $subString .= '<option value = "'.$header['id_header'].'" '
                                                .(isset($data['id_header']) AND $data['id_header'] == $header['id_header']?
                                                        'selected' : '').'>'.$header['name'].'</option>';

                                }
                         $subString .='</select>
                                        <div class="clear">&nbsp;</div>
                                        <span>
                                                <a href="javascript:AddElementDisplayForm(\'header\')">
                                                        <img title="Add a new header" src="'.__PS_BASE_URI__.'img/admin/add.gif"/>
                                                        '.$this->l('Add an header').'
                                                </a>
                                        </span>
                                </fieldset>';
                         
                         $subString .= '
                                <fieldset style="float:right; width:46.5%;">
                                        <legend>'.$this->l('2. Choose a footer').'</legend>
                                        <select name="id_footer">';
                                foreach ($footers AS $footer)
                                {
                                        $subString .= '<option value = "'.$footer['id_footer'].'"'
                                                .(isset($data['id_footer']) AND $data['id_footer'] == $footer['id_footer']?
                                                        'selected' : '').'>'.$footer['name'].'</option>';

                                }
                         $subString .='</select>
                                      <div class="clear">&nbsp;</div>
                                      
                                      <span>
                                                <a href="javascript:AddElementDisplayForm(\'footer\')">
                                                        <img title="Add a new footer" src="'.__PS_BASE_URI__.'img/admin/add.gif"/>
                                                        '.$this->l('Add a footer').'
                                                </a>
                                        </span>
                                </fieldset>';
                }
                else
                {
                        $blocContent = '<div class="clear">&nbsp;</div>
                                
                        <div>
                                <label>'.$this->l('Content Of ').' '.$this->l($element).'</label>
                                <textarea class="rte" cols="120" rows="20" name="content_of_'.$element.'">
                                        '.(isset($data['content']) ? $data['content'] :'').
                                '</textarea>
                        </div>';
                }


                
                return
                '
                 <div class="clear">&nbsp;</div>
                 <form method="post"  id="form_add_'.$element.'">
                        '.$subString.'
                        <div class="clear">&nbsp;</div>
                        <fieldset>
                                <legend>'.$this->l('Edit your ').' '.$this->l($element).'</legend>
                                <input type="hidden" name="id_'.$element.'" value="'.(isset($data['id_'.$element]) ? $data['id_'.$element] : '').'"/>

                                <label>'.$this->l('Name').'</label>
                                <input type="text" name="name_of_'.$element.'" value="'.(isset($data['name']) ? $data['name'] :'').'" size=70 />

                                <div class="clear">&nbsp;</div>
                                '.$blocContent.'

                                <div class="clear">&nbsp;</div>

                                <div class="clear">&nbsp;</div>
                                <input class="button" value="'.$this->l('Save').' '.$this->l($element).'"
                                        type="button" name="save_'.$element.'"
                                        onClick="javascript:SaveElement(\''.trim($element).'\')"/>

                        </fieldset>
                </form>';
        }

        /**
         * Return the shop domain
         */
        private function getShopDomain()
        {
                if(is_callable('Tools::getShopDomain'))
                        return Tools::getShopDomain(true);
                else if(is_callable('Tools::getHttpHost'))
                        return Tools::getHttpHost(true);
                
                $host = (isset($_SERVER['HTTP_X_FORWARDED_HOST']) ? $_SERVER['HTTP_X_FORWARDED_HOST'] : $_SERVER['HTTP_HOST']);
                $host = (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').$host;
		return $host;
        }


        /**
         * Show the page to publish(edit) and parametrize the sending of e-mails
         */
        public function display_form_mails()
        {
                global $cookie;


                $defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$iso = Language::getIsoById($defaultLanguage);
		$divLangName = 'title¤content';
                


                $blocContent = $blocTitle = '';
                foreach ($languages AS $language)
                        {
                                $blocTitle .= '
                                
                                <div id="title_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left;">
                                        <input type="text" name="title_'.$language['id_lang'].'" size=70 />
                                </div>';

                                $blocContent .= '
                                
                                <div id="content_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left;">
                                        <textarea class="rte" cols="70" rows="20" name="content_of_emails_'.$language['id_lang'].'">
                                        </textarea>
                                </div>';
                        }
                 $blocContent = '<label>'.$this->l('Language').'</label>'
				.$this->displayFlags($languages, $defaultLanguage, $divLangName, 'content', true)
                                .'<div class="clear">&nbsp;</div>'
                                .'<label>'.$this->l('Content Of emails').'</label>'.$blocContent;
                 
                 $blocTitle = '<label>'.$this->l('Title of newsletter').'</label>'
                                .$blocTitle
                                .$this->displayFlags($languages, $defaultLanguage, $divLangName, 'title', true);


                $templates = $this->getTemplate();
                if(!count($templates))
                        return $this->displayError($this->l('You must edit at least one template'));

                $choose_template =
                '<table class="table">
                        <thead>
                                <tr>
                                        <th></th>
                                        <th>'.$this->l('Name').'</th>
                                </tr>
                        </thead>
                        <tbody>';
                foreach ($templates as $template) {
                        $choose_template .=
                                '<tr>
                                        <td>
                                                <input name="id_template" type="radio" checked="checked" value="'.$template['id_template'].'"/>
                                        </td>
                                        <td>'.$template['name'].'</td>
                                </tr>';

                }
                $choose_template .=
                        '</tbody>
                </table>';

                $add_option = '';
                if(Module::isInstalled('blocknewsletter'))
                        $add_option = '<option value="2">'.$this->l('Not customers registered on the newsletter').'</option>';

                $return =
                '<form id="form_send_mails"><fieldset>
                        <legend>'.$this->l('Send a newsletter').'</legend>

                        <label>'.$this->l('From').'</label>
                        <div class="margin-form">
                                <input type="text" size="70" name="from" class="not_delete" value="'.Configuration::get('PS_SHOP_EMAIL').'"/>
                                <p>'.$this->l('Sender of e-mail.').'</p>
                        </div>

                        <label>'.$this->l('To').'</label>
                        <div class="margin-form">
                                <input type="text" size="70" name="to"/>
                                <p>'.$this->l('Addressee for test sending of newsletter').'</p>
                        </div>

                        <label>'.$this->l('Number of e-mails by package').'</label>
                        <div class="margin-form">
                                <input type="text" value="0" name="emails_by_pack" size="3" class="not_delete"/>
                                <p>'.$this->l('If this value is 0, all e-mails will be sent Simultaneously.')
                                    .' '.$this->l('Else package of N e-mails will be sent and the rest will be sent recorded.')
                                    .' '.$this->l('The deferred sending requires the configuration of a task Cron.')
                                    .' '.$this->l('URL to be executed :').'
                                        <br/>'.self::getShopDomain().__PS_BASE_URI__.'modules/sendnewsletter/send_deferred_emails.php
                                </p>
                        </div>

                        <div class="clear">&nbsp;</div>
                        <label>'.$this->l('Choose group of adressees').'</label>
                        <select name="adressees_of_emails" class="not_delete">
                                <option value="3">'.$this->l('Everybody').'</option>
                                '.$add_option.'
                                <option value="1">'.$this->l('Customers registered on the newsletter').'</option>
                                <option value="0">'.$this->l('All the subscribers in the newsletter').'</option>
                        </select>

                        <div class="clear">&nbsp;</div>
                        <label>'.$this->l('Choose the template').'</label>
                        '.$choose_template.'

                        <div class="clear">&nbsp;</div>
                        <label>'.$this->l('Languages').'</label>
                                
                        <div class="clear">&nbsp;</div>
                        '.$blocTitle.'<div class="clear">&nbsp;</div>'.$blocContent.'

                        
                        <div class="clear">&nbsp;</div>
                        <div class = "attempt_sending" style="float:right"></div>
                        <input type="button" class="button" value="'.$this->l('Send').'"
                                onClick="javascript:SendMails(false)"/>
                        <input type="button" class="button" value="'.$this->l('Send for test').'"
                                onClick="javascript:SendMails(true)"/>
                </fieldset></form>';


                return $return;
        }


        /**
         * Test if an address was already used for a newsletter
         *
         * @param string $customerEmail e-mail
         *
         * @return 1 : Addressee to whom the newsletter have been already sent
         * @return 2 : Customer registers on the newsletter to whom no newsletter was sent
         * @return -1 : Not customer
         * @return 0 : All other cases
         */
        public function isNewsletterRegistered($customerEmail)
	{
		if (Db::getInstance()->getRow('SELECT `email` FROM '._DB_PREFIX_.'sendnewsletter_stat WHERE SHA1(`email`) LIKE \''.pSQL($customerEmail).'\''))
			return 1;
		if (!$registered = Db::getInstance()->getRow('SELECT `newsletter` FROM '._DB_PREFIX_.'customer WHERE SHA1(`email`) LIKE \''.pSQL($customerEmail).'\''))
			return -1;
		if ($registered['newsletter'] == '1')
			return 2;
		return 0;
	}


        /**
         * Send back the addresses unsubscribed in the newsletter
         *
         */
        public function getUnsuscribe(){
                $query = '(SELECT `email` FROM '._DB_PREFIX_.'sendnewsletter_stat WHERE `unsuscribe` = 1)
                                UNION
                        (SELECT `email` FROM '._DB_PREFIX_.'customer WHERE `newsletter` = 0)';


                
                $query = Db::getInstance()->ExecuteS($query);

                $response = array();
                if(sizeof($query))
                {
                        foreach ($query as $q)
                        {
                                $response[] = $q['email'];
                        }
                }

                return $response;
        }






        public function save_element($element)
        {
                $element = trim($element);
                $array = array('template', 'header', 'footer');
                if(!in_array($element, $array))
                        return;

                $data['name'] = pSql(Tools::getValue('name_of_'.$element));

                if($element == 'template')
                {
                        $data['id_header'] = Tools::getValue('id_header');
                        $data['id_footer'] = Tools::getValue('id_footer');
                }
                else $data['content'] = urlencode(Tools::getValue('content_of_'.$element));

                $table = _DB_PREFIX_.'sendnewsletter_'.$element;

                $type = 'INSERT';
                $id = Tools::getValue('id_'.$element);
                $where = false;

                if(is_numeric($id))
                {
                        $type = 'UPDATE';
                        $where = '`id_'.$element.'` = '.(int)$id;
                }



                if(count($data['name']) > 0)
                {
                        $response = (bool)DB::getInstance()->autoExecute($table, $data, $type, $where);

                        if($response)
                                return $this->displayConfirmation($this->l($element).' '.$this->l(' saved successfully'));
                }

                return $this->displayError($this->l($element).' '.$this->l(' don\'t saved'));
        }


        function delete_element($element)
        {
                $element = trim($element);
                $array = array('template', 'header', 'footer');

                if(!in_array($element, $array))
                        return;

                $id = Tools::getValue('id_'.$element);


                $query = 'DELETE FROM `'._DB_PREFIX_.'sendnewsletter_'.$element.'`
                        WHERE `id_'.$element.'` = '.(int)$id;


                $response = (bool)DB::getInstance()->Execute($query);


                if($response)
                        return $this->displayConfirmation($this->l($element).' '.$this->l(' deleted successfully'));

                return $this->displayError($this->l($element).' '.$this->l(' don\'t deleted'));
        }




        private function getConnection()
	{
		$configuration = Configuration::getMultiple(array('PS_SHOP_EMAIL', 'PS_MAIL_METHOD', 'PS_MAIL_SERVER', 'PS_MAIL_USER', 'PS_MAIL_PASSWD', 'PS_SHOP_NAME', 'PS_MAIL_SMTP_ENCRYPTION', 'PS_MAIL_SMTP_PORT', 'PS_MAIL_METHOD', 'PS_MAIL_TYPE'));
		if (intval($configuration['PS_MAIL_METHOD']) == 2)
		{
			include_once(_PS_SWIFT_DIR_.'Swift/Connection/SMTP.php');
			$connection = new Swift_Connection_SMTP($configuration['PS_MAIL_SERVER'], $configuration['PS_MAIL_SMTP_PORT'], ($configuration['PS_MAIL_SMTP_ENCRYPTION'] == "ssl") ? Swift_Connection_SMTP::ENC_SSL : (($configuration['PS_MAIL_SMTP_ENCRYPTION'] == "tls") ? Swift_Connection_SMTP::ENC_TLS : Swift_Connection_SMTP::ENC_OFF));
			$connection->setTimeout(4);
			if (!$connection)
				return false;
			if (!empty($configuration['PS_MAIL_USER']) AND !empty($configuration['PS_MAIL_PASSWD']))
			{
				$connection->setUsername($configuration['PS_MAIL_USER']);
				$connection->setPassword($configuration['PS_MAIL_PASSWD']);
			}
		}
		else
		{
			include_once(_PS_SWIFT_DIR_.'Swift/Connection/NativeMail.php');
			$connection = new Swift_Connection_NativeMail();
		}
		return ($connection);
	}

       
        
        public function send_nl($data, $loop=0)
	{
                require_once(_PS_SWIFT_DIR_.'Swift.php');

		if (!$connection = self::getConnection())
			return false;

		@ini_set('max_execution_time', '7200');
                $begin = time();
                do
                {
                        try {
                                $swift = new Swift($connection);
                                $connected = true;
                        }
                        catch(Swift_ConnectionException $e)
                        {
                                if(time() > ($begin + 60))
                                        return $this->displayError($this->l('Connection to the server of e-mails failed'));
                                $connected = false;
                        }

                } while(!$connected);

                $defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$iso = Language::getIsoById($defaultLanguage);


                if(isset($data['from']))
                        $from = $data['from'];
                else $from = Configuration::get('PS_SHOP_EMAIL');

                $swift_msg = new Swift_message();
                $result = '';

                foreach ($languages AS $language)
                {
                        $id_lang = $language['id_lang'];

                        if(isset($data['test']) AND $data['test'] == 'test')
                        {
                                $to = Validate::isEmail($data['to']) ? $data['to'] : $from;
                                $test = '[TESTNEWSLETTER '.strtoupper($language['name']).']';

                                $key = sha1(trim($to));
                                $url = self::getShopDomain().__PS_BASE_URI__.'modules/sendnewsletter/image.php';
                                $tracking = '<img src="'.$url.'?key='.$key.'&id='.$data['id_newsletter'].'">';
                                $unsuscribe = '<br/><a href="'.self::getShopDomain().__PS_BASE_URI__.'modules/sendnewsletter/manage_stats.php?key='.$key.'">'
                                                                .$this->l('Not interested by the newsletter anymore ?')
                                                                .$this->l('Click here to unsubscribe.').'</a>';

                                $content[$id_lang] = $this->contructMail($data['id_template'], $data['body'][$id_lang], $data['title'][$id_lang]);
                                $msg = str_replace('%tracking%', $tracking, $content[$id_lang]);
                                $msg = str_replace('%unsuscribe%', $unsuscribe, $msg);
                                $message[$id_lang] = new Swift_message($test.' '.$data['title'][$id_lang], $msg, 'text/html', '8bit', 'utf-8');

                                $result[$id_lang] = (bool)$swift->Send($message[$id_lang], new Swift_Address($to), new Swift_Address($from));
                        }
                        else
                        {
                                $result[$id_lang] = $no_email[$id_lang] = false;
                                $to = $this->getEmails($data['adressees'], $id_lang, $data['nb_mails'], $loop);
                                if(!sizeof($to))
                                {
                                        $no_email[$id_lang] = true;
                                }
                                else
                                {

                                        $content[$id_lang] = $this->contructMail($data['id_template'], $data['body'][$id_lang], $data['title'][$id_lang]);
                                        $unsuscribers = $this->getUnsuscribe();

                                        foreach ($to AS $email)
                                        {
                                                if(!in_array($email['email'], $unsuscribers))
                                                {
                                                        $key = sha1(trim($email['email']));
                                                        $url1 = self::getShopDomain().__PS_BASE_URI__.'modules/sendnewsletter/image.php?key='.$key.'&id='.$data['id_newsletter'];
                                                        $url2 = self::getShopDomain().__PS_BASE_URI__.'modules/sendnewsletter/manage_stats.php?key='.$key;

                                                        $tracking = '<img src="'.$url1.'"/>';
                                                        $unsuscribe = '<br/><a href="'.$url2.'">'
                                                                .$this->l('Not interested by the newsletter anymore ?')
                                                                .$this->l('Click here to unsubscribe.').'</a>';

                                                        $msg = str_replace('%tracking%', $tracking, $content[$id_lang]);
                                                        $msg = str_replace('%unsuscribe%', $unsuscribe, $msg);

                                                        $message[$id_lang] = new Swift_Message($data['title'][$id_lang], $msg, 'text/html', '8bit', 'utf-8');

                                                        $email['email'] = trim($email['email']);

                                                        $res = false;
                                                        if(Validate::isEmail($email['email']))
                                                        {mail('dixilindez@prestashop.com', 'yes', print_r($email, true));
                                                                //$res = (bool)$swift->Send($message[$id_lang], new Swift_Address($email['email']), new Swift_Address($from));
                                                                $res = (bool)$swift->Send($message[$id_lang], new Swift_Address('dixi.kiyindou@prestashop.com'), new Swift_Address($from));
                                                                if($res)
                                                                {
                                                                        $sav_stat[$id_lang][] = array(
                                                                                'email' => $email['email'],
                                                                                'id_newsletter' => $data['id_newsletter'],
                                                                                'opening' => 0
                                                                        );
                                                                }


                                                        }
                                                }
                                        }
                                }
                        }
                }

                if($data['nb_mails'])
                {
                        $loop++;
                        Configuration::updateValue('SNL_loop', $loop);
                        Configuration::updateValue('SNL_data', urlencode(serialize($data)));
                }

                if(is_array($result))
                {
                        $error = $confirm = false;
                        $db = Db::getInstance();

                        foreach ($languages AS $language)
                        {
                                $id_lang = $language['id_lang'];

                                if(isset($sav_stat[$id_lang]))
                                        foreach ($sav_stat[$id_lang] AS $values)
                                        {
                                                $type = 'INSERT';
                                                $table = _DB_PREFIX_.'sendnewsletter_stat';
                                                $db->autoExecute($table, $values, $type);
                                        }

                                $date = date('F j, Y, g:i a');
                                if(isset($result[$id_lang]) AND $result[$id_lang])
                                {
                                                $confirm .= '<p>'.$language['name'].' : '.$this->l('messages sent').'</p>';
                                                @file_put_contents(dirname(__FILE__).'/send.log', $date."\t".$language['name'].' : '.$this->l('messages sent')."\n", FILE_APPEND);
                                }
                                elseif(isset($no_email[$id_lang]) AND $no_email[$id_lang])
                                {
                                        $error .= '<p>'.$language['name'].' : '.$this->l('no addressee found in the database for this language').'</p>';
                                }
                                else{
                                        $error .= '<p>'.$language['name'].' : '.$this->l('messages don\'t sent').'</p>';
                                        @file_put_contents(dirname(__FILE__).'/send.log', $date."\t".$language['name'].' : '.$this->l('messages don`t sent')."\n", FILE_APPEND);
                                }
                        }

                        $result ='';
                        if($error)
                                $result .= $this->displayError($error);
                        if($confirm)
                                $result .= $this->displayConfirmation($confirm);



                        return $result;
                }


                file_put_contents(dirname(__FILE__).'/send.log', date('F j, Y, g:i a')."\t".$this->l('Emails don\'t sent')."\n", FILE_APPEND);
                return $this->displayError($this->l('No Emails sent'));
	}


        public function send_emails($data)
        {
                $db = DB::getInstance();
                $languages = Language::getLanguages();
                
                //if($data['test'] != 'test')
                {
                        $db->Execute('
                                      INSERT INTO `'._DB_PREFIX_.'sendnewsletter`
                                      (`id_template`)
                                      VALUES ('.(int)$data['id_template'].')');

                        $res = $db->getRow('
                                      SELECT MAX(`id_newsletter`) AS lastID FROM `'._DB_PREFIX_.'sendnewsletter`');


                        $data['id_newsletter'] = $res['lastID'];


                        foreach ($languages AS $language)
                        {
                                $id_lang = (int)$language['id_lang'];

                                $table = _DB_PREFIX_.'sendnewsletter_lang';
                                $type = 'INSERT';
                                $values = array(
                                        'id_newsletter' => (int)$data['id_newsletter'],
                                        'id_lang' => $id_lang,
                                        'content' => $data['body'][$id_lang],
                                        'title' => $data['title'][$id_lang]
                                );
                                $db->autoExecute($table, $values, $type);
                        }
                        
                }
                
                if(is_numeric($data['nb_mails']) AND $data['nb_mails'] > 0)
                {
                        if(isset($data['test']))
                                empty($data['test']);

                        if(isset($data['to']))
                                empty($data['to']);
                        
                        return $this->send_deferred_nl($data);
                }

                return $this->send_nl($data);
        }


        public function send_deferred_nl($data)
	{
                $loop = 0;
                $result = $this->send_nl($data, $loop);
                $loop++;

                return $result;
	}

        private function getEmails($adressees, $id_lang, $nb_mails=null, $loop=null, $id_newsletter=null)
	{
                global $cookie;
                $db = Db::getInstance();
		
		$iso = Language::getIsoById($id_lang);
                $default = $limit = '';

                if($id_lang == $cookie->id_lang)
                        $default =  'OR `gu`.`accept_language` IS NULL';


                if(is_numeric($nb_mails) AND $nb_mails > 0 AND is_numeric($loop))
                {
                        $limit = ' LIMIT '.(intval($loop)*intval($nb_mails)).','.$nb_mails;

                        if(intval($loop) AND !is_null($id_newsletter))
                        {
                                $id_newsletter = intval($id_newsletter);
                                $date_first_sending = $db->getRow('SELECT MIN(`date_sending`) AS `date` FROM '._DB_PREFIX_.'sendnewsletter_stat WHERE `id_newsletter`='.$id_newsletter);
                                $date_first_sending = $date_first_sending['date'];

                                $date_add = '`cu`.`date_add` < '.$date_first_sending;
                                $date_add2 = '`newsletter_date_add` < '.$date_first_sending;

                        }
                }

                if(Module::isInstalled('blocknewsletter') AND ($id_lang == $cookie->id_lang))
                        $query2 = '(SELECT `email` FROM `'._DB_PREFIX_.'newsletter` '.(isset($date_add2) ? ' WHERE '.$date_add2 : '').' ORDER BY `newsletter_date_add`)';

		if ($adressees != 2)
                {
			$query = '
			( SELECT `cu`.`email`
			FROM `'._DB_PREFIX_.'customer` `cu`
			LEFT JOIN  `'._DB_PREFIX_.'guest` `gu` ON `cu`.`id_customer` = `gu`.`id_customer`
                        WHERE
			'.(($adressees == 3) ? ' ' : ' `cu`.`newsletter` = 1 AND ')
                         .(isset($date_add) ? $date_add.' AND ' : '').'
			(`gu`.`accept_language` LIKE "'.$iso.'%" '.$default.')
			GROUP BY `cu`.`id_customer` ORDER BY `date_upd`)';

                        if(isset($query2) AND ($adressees == 3 OR $adressees == 0))
                                $query .= ' UNION '.$query2;
                }
                else $query = $query2;

                $query .= $limit;

                $customers = $db->ExecuteS($query);

		foreach($customers as $key => $val)
		{
			$customers[$key]['iso_code'] = $iso;
			$customers[$key]['id_lang'] = $id_lang;
		}

		return $customers;
	}


        private function contructMail($id_template, $body, $title){
                $template = $this->getTemplate($id_template);
                $header = $this->getElement('header', $template['id_header']);
                $footer = $this->getElement('footer', $template['id_footer']);



                return ('
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/1999/REC-html401-19991224/strict.dtd">
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>'.$title.'</title>
  </head>
  <body>
        <div>'.(isset($header['content']) ? $header['content'] : '').'</div>
        <div>%tracking%'.$body.'</div>
	<div>'.(isset($footer['content']) ? $footer['content'] : '').'</div>

     <table>
        <tr><td>&nbsp;</td></tr>
        <tr>
                <td align="center" style="font-size:10px; border-top: 1px solid #D9DADE;">
                <!---/a>created with <a href="http://www.prestashop.com/" style="text-decoration:none; color:#374953;">PrestaShop™</a---->
                %unsuscribe%
                </td>
        </tr>
     </table>
  </body>
</html>');


        }


        public function display_form_stats()
        {
              $content =
                '<fieldset>
                        <legend>'.$this->l('Stats of newsletter').'</legend>
                        '.$this->displayStats().'
                </fiedset>';

              return $content;
        }


        private function getStats($filter = 0)
        {
                global $cookie;
                $db = DB::getInstance();
                switch ($filter) {
                        case 0:
                        {
                                $query = '
                                        SELECT `ns`.`id_newsletter`, `ns`.`date_sending` AS `date`, COUNT(`ns`.`email`) AS `sent`,
                                                (SELECT COUNT(`ns2`.`opening`)
                                                 FROM `'._DB_PREFIX_.'sendnewsletter_stat` `ns2`
                                                 WHERE `ns2`.`opening` <> 0 AND `ns`.`id_newsletter` = `ns2`.`id_newsletter`) AS `read`,
                                                (SELECT `sl`.`title`
                                                 FROM `'._DB_PREFIX_.'sendnewsletter_lang` `sl`
                                                 WHERE `ns`.`id_newsletter` = `sl`.`id_newsletter` AND `id_lang` = '.(int)$cookie->id_lang.') AS `title`
                                        FROM `'._DB_PREFIX_.'sendnewsletter_stat` `ns`

                                        GROUP BY `ns`.`id_newsletter`
                                ';
                                return $db->ExecuteS($query);
                        }

                        default:
                                break;
                }
        }

        public function displayStats()
	{
                $all = $this->getStats();

		$content = '
                        <!---label>'.$this->l('Filter').'</label>
                        <select name="filter">
                                <option value=1>'.$this->l('Language').'</option>
                                <option value=2>'.$this->l('Opening').'</option>
                        </select--->

                        <div class="clear">&nbsp;</div>
                        <label>'.$this->l('All data').'</label>
                        <table class="table">
                                <thead>
                                        <tr>
                                                <th></th>
                                                <th>'.$this->l('Title').'</th>
                                                <th>'.$this->l('Date').'</th>
                                                <th>'.$this->l('Sent').'</th>
                                                <th>'.$this->l('Read').'</th>
                                        </tr>
                                </thead>

                                <tbody>';

                foreach ($all as $value) {

                        $content .= '
                                        <tr>
                                                <td>'.$value['id_newsletter'].'</td>
                                                <td>'.$value['title'].'</td>
                                                <td>'.$value['date'].'</td>
                                                <td>'.$value['sent'].'</td>
                                                <td>'.$value['read'].'</td>
                                        </tr>';
                }

                $content .= '
                                </tbody>
                        </table>

                        ';
                
		return $content;
	}


        public function hookAdminStatsModules($params)
	{
                return $this->displayStats();
        }


        public function displayJS()
        {

                // Languages preliminaries
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$iso = Language::getIsoById($defaultLanguage);
		$divLangName = 'cpara¤dd';
                $ad = dirname($_SERVER["PHP_SELF"]);


                 $js ='<script type="text/javascript">
                                var iso = "'.(file_exists(_PS_ROOT_DIR_.'/js/tinymce/jscripts/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en').'" ;
                                var pathCSS = "'._THEME_CSS_DIR_.'" ;
                                var ad = "'.$ad.'" ;
                       </script>';

                if(version_compare(_PS_VERSION_, '1.4.1.0') >= 0)
                {
                        $js .='
                        <script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
                        <script type="text/javascript">
                                function initTinyMCE(){
                                        tinyMCE.init({
                                        mode : "specific_textareas",
                                        theme : "advanced",
                                        skin:"cirkuit",
                                        editor_selector : "rte",
                                        editor_deselector : "noEditor",
                                        plugins : "safari,pagebreak,style,table,advimage,advlink,inlinepopups,media,contextmenu,paste,fullscreen,xhtmlxtras,preview",
                                        // Theme options
                                        theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
                                        theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
                                        theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
                                        theme_advanced_buttons4 : "styleprops,|,cite,abbr,acronym,del,ins,attribs,pagebreak",
                                        theme_advanced_toolbar_location : "top",
                                        theme_advanced_toolbar_align : "left",
                                        theme_advanced_statusbar_location : "bottom",
                                        theme_advanced_resizing : false,
                                        content_css : pathCSS+"global.css",
                                        document_base_url : ad,
                                        width: "600",
                                        height: "auto",
                                        font_size_style_values : "8pt, 10pt, 12pt, 14pt, 18pt, 24pt, 36pt",
                                        elements : "nourlconvert,ajaxfilemanager",
                                        file_browser_callback : "ajaxfilemanager",
                                        entity_encoding: "raw",
                                        convert_urls : false,
                                        language : iso

                                        });
                                }
                        function ajaxfilemanager(field_name, url, type, win)
                                {
                                        var ajaxfilemanagerurl = "'.dirname($_SERVER["PHP_SELF"]).'/ajaxfilemanager/ajaxfilemanager.php";
                                        switch (type) {
                                                case "image":
                                                        break;
                                                case "media":
                                                        break;
                                                case "flash":
                                                        break;
                                                case "file":
                                                        break;
                                                default:
                                                        return false;
                                        }


                                        tinyMCE.activeEditor.windowManager.open({
                                                url: "'.dirname($_SERVER["PHP_SELF"]).'/ajaxfilemanager/ajaxfilemanager.php",
                                                width: 782,
                                                height: 440,
                                                inline : "yes",
                                                close_previous : "no"
                                        },{
                                                window : win,
                                                input : field_name
                                        });
                                }

                        </script>
                        <script language="javascript">id_language = Number('.$defaultLanguage.');</script>';

                }
                else if(version_compare(_PS_VERSION_, '1.3.5.0') >= 0)
                {
                        $js .=
                        '
                        <script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce/jscripts/tiny_mce/tiny_mce.js"></script>
                        <script type="text/javascript">
                                function initTinyMCE(){
					tinyMCE.init({
						mode : "textareas",
						theme : "advanced",
						plugins : "safari,pagebreak,style,layer,table,advimage,advlink,inlinepopups,media,searchreplace,contextmenu,paste,directionality,fullscreen",
						// Theme options
						theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
						theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
						theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
						theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,pagebreak",
						theme_advanced_toolbar_location : "top",
						theme_advanced_toolbar_align : "left",
						theme_advanced_statusbar_location : "bottom",
						theme_advanced_resizing : false,
						content_css : "'.__PS_BASE_URI__.'themes/'._THEME_NAME_.'/css/global.css",
						document_base_url : "'.__PS_BASE_URI__.'",
						width: "600",
						height: "auto",
						font_size_style_values : "8pt, 10pt, 12pt, 14pt, 18pt, 24pt, 36pt",
						// Drop lists for link/image/media/template dialogs
						template_external_list_url : "lists/template_list.js",
						external_link_list_url : "lists/link_list.js",
						external_image_list_url : "lists/image_list.js",
						media_external_list_url : "lists/media_list.js",
                                                elements : "nourlconvert,ajaxfilemanager",
                                                file_browser_callback : "ajaxfilemanager",
						convert_urls : false,
						language : iso

					});
                                }
                        </script>
                        <script language="javascript">id_language = Number('.$defaultLanguage.');</script>';
                }

                else{
                        $js .= '
                        <script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce/jscripts/tiny_mce/jquery.tinymce.js"></script>
                        <script type="text/javascript">
                        function initTinyMCE(){
                                element = "textarea.rte";
                                $().ready(function() {
                                        $(element).tinymce({
                                                // Location of TinyMCE script
                                                script_url : "'.__PS_BASE_URI__.'js/tinymce/jscripts/tiny_mce/tiny_mce.js",
                                                // General options
                                                theme : "advanced",
                                                plugins : "safari,pagebreak,style,layer,table,advimage,advlink,inlinepopups,media,searchreplace,contextmenu,paste,directionality,fullscreen",
                                                // Theme options
                                                theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
                                                theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
                                                theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
                                                theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,pagebreak",
                                                theme_advanced_toolbar_location : "top",
                                                theme_advanced_toolbar_align : "left",
                                                theme_advanced_statusbar_location : "bottom",
                                                theme_advanced_resizing : true,
                                                content_css : "'.__PS_BASE_URI__.'themes/'._THEME_NAME_.'/css/global.css",
                                                // Drop lists for link/image/media/template dialogs
                                                template_external_list_url : "lists/template_list.js",
                                                external_link_list_url : "lists/link_list.js",
                                                external_image_list_url : "lists/image_list.js",
                                                media_external_list_url : "lists/media_list.js",
                                                elements : "nourlconvert",
                                                convert_urls : false,
                                                language : "fr"
                                        });
                                });
                        }
                        initTinyMCE();
                        </script>
                        <script language="javascript">id_language = Number('.$defaultLanguage.');</script>

                        ';
                }



                $js .= '
                 <script type="text/javascript">
                        $(document).ready(function() {
                                initTinyMCE();
                                $(\'[name="templates_manager"]\').click(function() {
                                        selected = $(".tab-row").find(".selected")
                                        selected.toggleClass("selected");

                                        $(this).parent().toggleClass("selected");
                                        $(this).parent().fadeOut(100);
                                        $(this).parent().fadeIn(100);
                                        DisplayFormTemplate(true);
                                });


                                $(\'[name="mails_manager"]\').click(function() {
                                        selected = $(".tab-row").find(".selected")
                                        selected.toggleClass("selected");

                                        $(this).parent().toggleClass("selected");
                                        $(this).parent().fadeOut(100);
                                        $(this).parent().fadeIn(100);
                                        DisplayFormMail(true);
                                });

                                $(\'[name="stats_manager"]\').click(function() {
                                        selected = $(".tab-row").find(".selected")
                                        selected.toggleClass("selected");

                                        $(this).parent().toggleClass("selected");
                                        $(this).parent().fadeOut(100);
                                        $(this).parent().fadeIn(100);
                                        DisplayFormStats(true);
                                });

                        });




                        function DisplayFormMail(resetCallBack){
                                url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_mails.php?action=display_form"
                                $.post(url,
                                        function(data){
                                                if(data)
                                                {
                                                        $(".tab-page").html(data);
                                                        initTinyMCE();
                                                        $(".tab-page").fadeIn(100);

                                                        if(resetCallBack == true)
                                                        {
                                                                $(".message_callback").html(" ");
                                                                $(".message_callback").fadeIn(100);
                                                        }
                                                }
                                });
                        }



                        function DisplayFormStats(resetCallBack){
                                url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_stats.php?action=display_form"
                                $.post(url,
                                        function(data){
                                                if(data)
                                                {
                                                        $(".tab-page").html(data);
                                                        initTinyMCE();
                                                        $(".tab-page").fadeIn(100);

                                                        if(resetCallBack == true)
                                                        {
                                                                $(".message_callback").html(" ");
                                                                $(".message_callback").fadeIn(100);
                                                        }
                                                }
                                });
                        }





                        function DisplayFormTemplate(resetCallBack){
                                url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_templates.php?action=display_form";
                                $.post(url,
                                        function(data){
                                                if(data)
                                                {
                                                        $(".tab-page").html(data);
                                                        $(".tab-page").fadeIn(100);

                                                        if(resetCallBack == true)
                                                        {
                                                                $(".message_callback").html(" ");
                                                                $(".message_callback").fadeIn(100);
                                                        }
                                                }
                                });
                        }


                        function AddTemplateDisplayForm(resetCallBack){
                                url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_templates.php?action=add_template";
                                $.post(url,
                                        function(data){
                                                if(data){
                                                        $("#add_template_form").html(data);
                                                        initTinyMCE();
                                                        $("#add_template_form").fadeIn(100);

                                                        if(resetCallBack == true)
                                                        {
                                                                $(".message_callback").html(" ");
                                                                $(".message_callback").fadeIn(100);
                                                        }
                                                }
                                });

                        }


                        function AddElementDisplayForm(element){
                                url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_templates.php?action=add_" + element;
                                $.post(url,
                                        function(data){
                                                if(data){
                                                        $("#add_template_form").html(data);
                                                        initTinyMCE();
                                                        $("#add_template_form").fadeIn(100);
                                                }
                                });
                        }


                        function SaveElement(element){
                        tinyMCE.triggerSave();
                                url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_templates.php?action=save_" + element;
                                url = url + "&" + $("#form_add_" + element).serialize();

                                $.post(url,
                                        function(data){
                                                if(data)
                                                {
                                                        $("#add_" + element + "_form").fadeOut(100);
                                
                                                        DisplayFormTemplate();
                                                        AddTemplateDisplayForm();
                                                        $(".message_callback").html(data);
                                                        $(".message_callback").fadeIn(100);
                                                }

                                });

                        }


                        function DeleteElement(element, id){
                                url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_templates.php?action=delete_" + element;
                                url = url + "&id_" + element + "=" + id;

                                $.post(url,
                                        function(data){
                                                if(data)
                                                {
                                                        $("#add_" + element + "_form").fadeOut(100);
                                                        DisplayFormTemplate();
                                                        AddTemplateDisplayForm();
                                                        $(".message_callback").html(data);
                                                        $(".message_callback").fadeIn(100);
                                                }
                                });
                        }



                        function EditElement(element, id){
                                url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_templates.php?action=edit_" + element;
                                url = url + "&id_" + element + "=" + id;

                                $.post(url,
                                        function(data){
                                                if(data)
                                                {
                                                        $("#add_template_form").html(data);
                                                        initTinyMCE();
                                                        $("#add_template_form").fadeIn(100);
                                                }

                                });
                        }



                        function SendMails(test){
                               DisplaySending();
                               setTimeout(function(){
                                        tinyMCE.triggerSave();
                                        url = "'.__PS_BASE_URI__.'modules/sendnewsletter/manage_mails.php?action=send_mails";
                                        //url = url + "&" + $("#form_send_mails").serialize(true);
                                        if(test)
                                                url = url + "&test=test";

                                        $.post(url,
                                                {url : $("#form_send_mails").serialize(true)},
                                                function(data){
                                                        if(data)
                                                        {
                                                                
                                                                //$("#form_send_mails").form.reset();
                                                                $(".attempt_sending").html("");
                                                                $(".attempt_sending").fadeIn(100);
                                                                $(".message_callback").html(data);
                                                                //deleteForm();
                                                                $(".message_callback").fadeIn(100);
                                                        }
                                        });
                                }, 500);
                        }

                        function DisplaySending(){
                                $(".message_callback").html("<img style=\'margin:auto 40%;\'src=\''.__PS_BASE_URI__.'modules/sendnewsletter/ajax-loader.gif\'/>");
                                $(".attempt_sending").html("<img src=\''.__PS_BASE_URI__.'modules/sendnewsletter/ajax-loader.gif\'/>");
                                $(".message_callback").fadeIn(50);
                                $(".attempt_sending").fadeIn(50);
                        }


                        function deleteForm () {
                                $(":input","#form_send_mails", ":textarea")
                                .not(":button, :submit, :reset, :hidden, .not_delete")
                                .val("")
                                .removeAttr("checked")
                                .removeAttr("selected");
                        }
                </script>
                ';


                return $js;
        }





        public function display_form_templates()
        {
                $templates = $this->getTemplate();
                $headers = $this->getHeader();
                $footers = $this->getFooter();

                $return = '
                <span>
                        <a href="javascript:AddTemplateDisplayForm()">
                                <img title="Add a new template" src="'.__PS_BASE_URI__.'img/admin/add.gif"/>
                                '.$this->l('Add a template').'
                        </a>
                </span>

                <div class="clear">&nbsp;</div>
                <div id = "add_template_form" style="display:none"></div>

                <div class="clear">&nbsp;</div>
                <fieldset>
                        <legend>'.$this->l('List of templates').'</legend>
                        <table class="table">

                                <thead>
                                        <tr>
                                                <th></th>
                                                <th>'.$this->l('Name').'</th>
                                                <th>'.$this->l('Header').'</th>
                                                <th>'.$this->l('Footer').'</th>
                                                <th>'.$this->l('Action').'</th>
                                        </tr>
                                </thead>

                                <tbody>';

                if(count($templates))
                {
                        foreach ($templates as $template)
                        {
                                $return .= '<tr>
                                                <td>'.$template['id_template'].'</td>
                                                <td>'.$template['name'].'</td>
                                                <td>'.$template['header'].'</td>
                                                <td>'.$template['footer'].'</td>
                                                <td>
                                                        <a href = "javascript:DeleteElement(\'template\', '.$template['id_template'].')">
                                                                <img alt="delete template" src="'._PS_ADMIN_IMG_.'delete.gif"/>
                                                        </a>
                                                        <a href = "javascript:EditElement(\'template\', '.$template['id_template'].')">
                                                                <img alt="edit template" src="'._PS_ADMIN_IMG_.'edit.gif"/>
                                                        </a>
                                                </td>
                                        </tr>';
                        }
                }

                $return .=
                                '</tbody>
                        </table>
                </fieldset>

                <div class="clear">&nbsp;</div>
                <fieldset>
                        <legend>'.$this->l('List of headers').'</legend>
                        <table class="table">
                                <thead>
                                        <tr>
                                                <th></th>
                                                <th>'.$this->l('Name').'</th>
                                                <th>'.$this->l('Action').'</th>
                                        </tr>
                                </thead>
                                <tbody>';

                if(count($headers))
                {
                        foreach ($headers as $header)
                        {
                                $return .= '<tr>
                                                <td>'.$header['id_header'].'</td>
                                                <td>'.$header['name'].'</td>
                                                <td>
                                                        <a href = "javascript:DeleteElement(\'header\', '.$header['id_header'].')">
                                                                <img alt="delete header" src="'._PS_ADMIN_IMG_.'delete.gif"/>
                                                        </a>
                                                        <a href = "javascript:EditElement(\'header\', '.$header['id_header'].')">
                                                                <img alt="edit header" src="'._PS_ADMIN_IMG_.'edit.gif"/>
                                                        </a>
                                                </td>
                                        </tr>';
                        }
                }
                $return .= '</tbody>
                        </table>
                        <div class="clear">&nbsp;</div>
                        <span>
                                <a href="javascript:AddElementDisplayForm(\'header\')">
                                        <img title="Add a new header" src="'.__PS_BASE_URI__.'img/admin/add.gif"/>
                                                '.$this->l('Add an header').'
                                </a>
                        </span>
                </fieldset>


                <div class="clear">&nbsp;</div>
                <fieldset>
                        <legend>'.$this->l('List of footers').'</legend>
                        <table class="table">
                                <thead>
                                        <tr>
                                                <th></th>
                                                <th>'.$this->l('Name').'</th>
                                                <th>'.$this->l('Action').'</th>
                                        </tr>
                                </thead>
                                <tbody>';

                if(count($footers))
                {
                        foreach ($footers as $footer)
                        {
                                $return .= '<tr>
                                        <td>'.$footer['id_footer'].'</td>
                                        <td>'.$footer['name'].'</td>
                                        <td>
                                                <a href = "javascript:DeleteElement(\'footer\', '.$footer['id_footer'].')">
                                                        <img alt="delete footer" src="'._PS_ADMIN_IMG_.'delete.gif"/>
                                                </a>
                                                <a href = "javascript:EditElement(\'footer\', '.$footer['id_footer'].')">
                                                        <img alt="edit footer" src="'._PS_ADMIN_IMG_.'edit.gif"/>
                                                </a>
                                        </td>
                                </tr>';
                        }
                }

                $return .= '</tbody>
                </table>
                        <div class="clear">&nbsp;</div>
                        <span>
                        <a href="javascript:AddElementDisplayForm(\'footer\')">
                                <img title="Add a new footer" src="'.__PS_BASE_URI__.'img/admin/add.gif"/>
                                        '.$this->l('Add an footer').'
                        </a>
                        </span>
                </fieldset>';

                return $return;
        }


        function display_form_add_element($element)
        {
                switch ($element) {
                        case 'footer':
                                return $this->displayFormAddElement('footer');

                        case 'header':
                                return $this->displayFormAddElement('header');

                        default:
                        {
                                $headers = $this->getHeader();
                                $footers = $this->getFooter();

                                if(!count($headers))
                                {
                                        return $this->displayError($this->l('Please edit at least one header')).
                                        $this->displayFormAddElement('header');
                                }

                                if(!count($footers))
                                {
                                        return $this->displayError($this->l('Please edit at least one footer')).
                                        $this->displayFormAddElement('footer');
                                }
                                return $this->displayFormAddElement('template');
                        }
                }
        }


        public function edit_element($element)
        {
                $element = trim($element);
                $array = array('template', 'header', 'footer');
                if(!in_array($element, $array))
                return;

                $id = (int)Tools::getValue('id_'.$element);
                if($element == 'template')
                        $data = $this->getTemplate($id);
                else $data = $this->getElement($element, $id);

                return $this->displayFormAddElement($element, $data);
        }

}