<?php

class OrderHistory extends OrderHistoryCore
{
	
	public function changeIdOrderState($new_order_state = NULL, $id_order)
	{
		if ($new_order_state != NULL)
		{
		
			Hook::updateOrderStatus((int)($new_order_state), (int)($id_order));
			$order = new Order((int)($id_order));
			
			/* Best sellers */
			$newOS = new OrderState((int)($new_order_state), $order->id_lang);
			$oldOrderStatus = OrderHistory::getLastOrderState((int)($id_order));
			$cart = Cart::getCartByOrderId($id_order);
			$isValidated = $this->isValidated();
			if (Validate::isLoadedObject($cart))
				foreach ($cart->getProducts() as $product)
				{
				
					/* If becoming logable => adding sale */
					if ($newOS->logable AND (!$oldOrderStatus OR !$oldOrderStatus->logable))
						ProductSale::addProductSale($product['id_product'], $product['cart_quantity']);
					/* If becoming unlogable => removing sale */
					elseif (!$newOS->logable AND ($oldOrderStatus AND $oldOrderStatus->logable))
						ProductSale::removeProductSale($product['id_product'], $product['cart_quantity']);
					if (!$isValidated AND $newOS->logable AND isset($oldOrderStatus) AND $oldOrderStatus AND $oldOrderStatus->id == Configuration::get('PS_OS_ERROR'))
					{
						Product::updateQuantity($product);
					}
				}
			
			$this->id_order_state = (int)($new_order_state);
			
			/* Change invoice number of order ? */
			if (!Validate::isLoadedObject($newOS) OR !Validate::isLoadedObject($order))
			die(Tools::displayError('Invalid new order state'));
				
			
			/* The order is valid only if the invoice is available and the order is not cancelled */
			$order->valid = $newOS->logable;
			$order->update();

			if ($newOS->invoice AND !$order->invoice_number)
				$order->setInvoice();
				
				
			if ($newOS->delivery && $order->delivery_date=="0000-00-00 00:00:00")
			{
				$order->delivery_date = date('Y-m-d H:i:s');
				$order->update();
			}	
			
			Hook::postUpdateOrderStatus((int)($new_order_state), (int)($id_order));
		}
	}

	
}
