<?php
/*
* 2011-2012 Vinum Master
*
*  @author Vinum Master  <webmaster@vinummaster.com>
*  @copyright  2011-2012 Vinum Master
*  @version  1.51 // Compatible PS 1.5
*  
*/
include('../../config/config.inc.php');

$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
$importURL = Configuration::get('VINUM_EXPINET_IMPORTURL');
$exportURL= Configuration::get('VINUM_EXPINET_EXPORTURL');
$carriersString= Configuration::get('VINUM_EXPINET_CARRIERS');
$stateExport = Configuration::get('VINUM_EXPINET_STATE_EXPORT');

$expertFRCarrier=Configuration::get('VINUM_EXPINET_EXPERT_FR'); 
$accessFRCarrier=Configuration::get('VINUM_EXPINET_ACCESS_FR');
$expertINTCarrier=Configuration::get('VINUM_EXPINET_EXPERT_INT');
$expertOMCarrier= Configuration::get('VINUM_EXPINET_EXPERT_OM');
$accessOMCarrier= Configuration::get('VINUM_EXPINET_ACCESS_OM');
$socolCarrier= Configuration::get('VINUM_EXPINET_SOCOLISSIMO');
	
	

$directory = dirname(_PS_MODULE_DIR_).'/modules/presta2expinet/';
$filename = $directory.'export.csv';
$filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/presta2expinet/export.csv';
$adminDirectory= dirname(__FILE__).'/';

@unlink($filename);
$fp = fopen($filename, 'wb');
fclose($fp);
	

$id_order=$_GET['id_order'];
$weight=$_GET['weight'];
$size=$_GET['size'];
$assurance=$_GET['assurance'];
$recommandation=$_GET['recommandation'];

$order=New Order($id_order);

$products=$order->getProductsDetail();
$TotalWeight=round($order->getTotalWeight(),2);
$addressDelivery = new Address($order->id_address_delivery, (int)($id_lang));
$country=New Country($addressDelivery->id_country);
$socolissimoOrderInfos['id_cart']="";
$socolissimoLiberteOrderInfos['cart_id']="";
if(Module::isEnabled("socolissimo"))
$socolissimoOrderInfos = getDeliveryInfos((int)($orderInfos->id_cart), (int)($orderInfos->id_customer));
if(Module::isEnabled("soliberte"))
$socolissimoLiberteOrderInfos = getLiberteDeliveryInfos((int)($orderInfos->id_cart), (int)($orderInfos->id_customer));
 $customer=new Customer((int)($order->id_customer));		
$carrier=$order->id_carrier;
    
    $type="COL";
    
    if($expertFRCarrier==$carrier)
    $type="COL";
    if($accessFRCarrier==$carrier)
    $type="COLD"; 
    if($expertINTCarrier==$carrier)
    $type="COLI"; 
    if($expertOMCarrier==$carrier)
    $type="CDS"; 
     if($accessOMCarrier==$carrier)
    $type="COM"; 
  
          								
	addToFeed('"EXP";');
	addToFeed('"'.$order->id.'";');
	addToFeed('"'.$order->id_customer.'";');
	
    if ($socolissimoOrderInfos['id_cart'] == "" && $socolissimoLiberteOrderInfos['cart_id'] == "")
   	{
		
		addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->company)).'";');
		addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->firstname)).'";');
		addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->lastname)).'";');
		addToFeed('"'.utf8_decode($addressDelivery->address1).'";');
		addToFeed('"'.utf8_decode($addressDelivery->address2).'";');
		addToFeed('"'.$addressDelivery->postcode.'";');
		addToFeed('"'.utf8_decode($addressDelivery->city).'";');
		addToFeed('"'.$country->iso_code.'";');
		addToFeed('"'.utf8_decode(str_replace("\r\n"," ",$addressDelivery->other)).'";');
		addToFeed('"'.$addressDelivery->phone.'";');
		addToFeed('"'.$weight.'";');
		addToFeed('"'.$addressDelivery->phone_mobile.'";');
		addToFeed('"'.$customer->email.'";'); //mail
		addToFeed('"";'); //CodePointRetrait
        addToFeed('"'.$type.'";');  //CodeProduit
        addToFeed('"'.Configuration::get('PS_SHOP_NAME').'";'); //NomCommercialChargeur=21
		addToFeed('"";'); //CodePorte1
		addToFeed('"";'); //CodePorte2
	}	
	if($socolissimoOrderInfos['id_cart']!="")
	{
			switch ($socolissimoOrderInfos['delivery_mode'])
			{
				case 'DOM':
				case 'DOS':
					addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->company)).'";');
					addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->firstname)).'";');
	    			addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->lastname)).'";');
					addToFeed('"'.utf8_decode($addressDelivery->address1).'";');
					addToFeed('"'.utf8_decode($addressDelivery->address2).'";');
					addToFeed('"'.$addressDelivery->postcode.'";');
					addToFeed('"'.utf8_decode($addressDelivery->city).'";');
					addToFeed('"'.$country->iso_code.'";');
					addToFeed('"'.utf8_decode(str_replace("\r\n"," ",$addressDelivery->other)).'";');
					addToFeed('"'.$addressDelivery->phone.'";');
					addToFeed('"'.$weight.'";');
					addToFeed('"'.$addressDelivery->phone_mobile.'";');
					addToFeed('"'.$customer->email.'";'); //mail
					addToFeed('"";'); //CodePointRetrait=19
					addToFeed('"'.$socolissimoOrderInfos['delivery_mode'].'";');  //CodeProduit
					addToFeed('"'.Configuration::get('PS_SHOP_NAME').'";'); //NomCommercialChargeur
					addToFeed('"'.$socolissimoOrderInfos['cedoorcode1'].'";');  //CodePorte1
					addToFeed('"'.$socolissimoOrderInfos['cedoorcode2'].'";');  //CodePorte2
				break;	
				case 'RDV':
					addToFeed('"'.str_replace('"','""',utf8_decode($socolissimoOrderInfos['cecompanyname'])).'";');
					addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->firstname)).'";');
					addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->lastname)).'";');
					addToFeed('"'.utf8_decode($addressDelivery->address1).'";');
					addToFeed('"'.utf8_decode($addressDelivery->address2).'";');
					addToFeed('"'.$addressDelivery->postcode.'";');
					addToFeed('"'.utf8_decode($addressDelivery->city).'";');
					addToFeed('"'.$country->iso_code.'";');
					addToFeed('"'.utf8_decode(str_replace("\r\n"," ",$socolissimoOrderInfos['cedeliveryinformation'])).'";');
					addToFeed('"'.$addressDelivery->phone.'";');
					addToFeed('"'.$weight.'";');
					addToFeed('"'.$socolissimoOrderInfos['cephonenumber'].'";');
					addToFeed('"'.$socolissimoOrderInfos['ceemail'].'";'); //mail
					addToFeed('"";'); //CodePointRetrait
					addToFeed('"RDV";');  //CodeProduit
					addToFeed('"'.Configuration::get('PS_SHOP_NAME').'";'); //NomCommercialChargeur=21
					addToFeed('"'.$socolissimoOrderInfos['cedoorcode1'].'";');  //Code Porte 1
					addToFeed('"'.$socolissimoOrderInfos['cedoorcode2'].'";');  //Code Porte 2
				break;
				case 'BPR':
				case 'A2P':
				case 'MRL':
				case 'CIT':
				case 'ACP':
				case 'CDI':
					addToFeed('"'.str_replace('"','""',utf8_decode($socolissimoOrderInfos['cecompanyname'])).'";');
					if($socolissimoOrderInfos['cefirstname']!="")
					addToFeed('"'.str_replace('"','""',utf8_decode($socolissimoOrderInfos['cefirstname'])).'";');
					else
					addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->firstname)).'";');
					if($socolissimoOrderInfos['cename']!="")
					addToFeed('"'.str_replace('"','""',utf8_decode($socolissimoOrderInfos['cename'])).'";');
					else
					addToFeed('"'.str_replace('"','""',utf8_decode($addressDelivery->lastname)).'";');
					addToFeed('"'.utf8_decode($addressDelivery->address1).'";');
					addToFeed('"'.utf8_decode($addressDelivery->address2).'";');
					addToFeed('"'.$addressDelivery->postcode.'";');
					addToFeed('"'.utf8_decode($addressDelivery->city).'";');
					addToFeed('"'.$country->iso_code.'";');
					addToFeed('"'.utf8_decode(str_replace("\r\n"," ",$socolissimoOrderInfos['cedeliveryinformation'])).'";');
					addToFeed('"'.$addressDelivery->phone.'";');
					addToFeed('"'.$weight.'";');
					addToFeed('"'.$socolissimoOrderInfos['cephonenumber'].'";');
					addToFeed('"'.$socolissimoOrderInfos['ceemail'].'";'); //mail
					addToFeed('"'.$socolissimoOrderInfos['prid'].'";'); //CodePointRetrait
					addToFeed('"'.$socolissimoOrderInfos['delivery_mode'].'";');  //CodeProduit
					addToFeed('"'.Configuration::get('PS_SHOP_NAME').'";'); //NomCommercialChargeur
					addToFeed('"'.$socolissimoOrderInfos['cedoorcode1'].'";');  //CodePorte1
					addToFeed('"'.$socolissimoOrderInfos['cedoorcode2'].'";');  //CodePorte2
				break;
			}
	}
    if ($socolissimoLiberteOrderInfos['cart_id'] != "") // Pour module SoColissimo Liberte
        {
            switch ($socolissimoLiberteOrderInfos['type'])
            {
                case 'DOM':
                case 'DOS':
                    addToFeed('"' . str_replace('"', '""', utf8_decode($addressDelivery->company)) .
                        '";');
                    addToFeed('"' . str_replace('"', '""', utf8_decode($addressDelivery->firstname)) .
                        '";');
                    addToFeed('"' . str_replace('"', '""', utf8_decode($addressDelivery->lastname)) .
                        '";');
                    addToFeed('"' . utf8_decode($addressDelivery->address1) . '";');
                    addToFeed('"' . utf8_decode($addressDelivery->address2) . '";');
                    addToFeed('"' . $addressDelivery->postcode . '";');
                    addToFeed('"' . utf8_decode($addressDelivery->city) . '";');
                    addToFeed('"' . $country->iso_code . '";');
                    addToFeed('"' . utf8_decode(str_replace("\r\n", " ", $addressDelivery->other)) .
                        '";');
                    addToFeed('"' . $addressDelivery->phone . '";');
                    addToFeed('"' . $order['weight'] . '";');
                    addToFeed('"' . $addressDelivery->phone_mobile . '";');
                    addToFeed('"' . $customer->email . '";'); //mail
                    addToFeed('"";'); //CodePointRetrait=19
                    addToFeed('"' . $socolissimoLiberteOrderInfos['type'] . '";'); //CodeProduit
                    addToFeed('"' . Configuration::get('PS_SHOP_NAME') . '";'); //NomCommercialChargeur
                    addToFeed('"";'); //CodePorte1
                    addToFeed('"";'); //CodePorte2
                    break;
                case 'RDV':
                    addToFeed('"' . str_replace('"', '""', utf8_decode($socolissimoLiberteOrderInfos['company'])) .
                        '";');
                    addToFeed('"' . str_replace('"', '""', utf8_decode($socolissimoLiberteOrderInfos['firstname'])) .
                        '";');
                    addToFeed('"' . str_replace('"', '""', utf8_decode($socolissimoLiberteOrderInfos['lastname'])) .
                        '";');
                    addToFeed('"' . utf8_decode($addressDelivery->address1) . '";');
                    addToFeed('"' . utf8_decode($addressDelivery->address2) . '";');
                    addToFeed('"' . $addressDelivery->postcode . '";');
                    addToFeed('"' . utf8_decode($addressDelivery->city) . '";');
                    addToFeed('"' . $country->iso_code . '";');
                    addToFeed('"' . utf8_decode(str_replace("\r\n", " ", $socolissimoLiberteOrderInfos['informations'])) .
                        '";');
                    addToFeed('"' . $addressDelivery->phone . '";');
                    addToFeed('"' . $order['weight'] . '";');
                    addToFeed('"' . $socolissimoLiberteOrderInfos['telephone'] . '";');
                    addToFeed('"' . $socolissimoLiberteOrderInfos['email'] . '";'); //mail
                    addToFeed('"";'); //CodePointRetrait
                    addToFeed('"' . $socolissimoLiberteOrderInfos['type'] . '";'); //CodeProduit
                    addToFeed('"' . Configuration::get('PS_SHOP_NAME') . '";'); //NomCommercialChargeur=21
                    addToFeed('"";'); //CodePorte1
                    addToFeed('"";'); //CodePorte2
                    break;
                case 'BPR':
                case 'A2P':
                case 'MRL':
                case 'CIT':
                case 'ACP':
                case 'CDI':
                    addToFeed('"' . str_replace('"', '""', utf8_decode($socolissimoLiberteOrderInfos['company'])) .
                        '";');
                    if ($socolissimoLiberteOrderInfos['firstname'] != "")
                        addToFeed('"' . str_replace('"', '""', utf8_decode($socolissimoLiberteOrderInfos['firstname'])) .
                            '";');
                    else
                        addToFeed('"' . str_replace('"', '""', utf8_decode($addressDelivery->firstname)) .
                            '";');
                    if ($socolissimoLiberteOrderInfos['lastname'] != "")
                        addToFeed('"' . str_replace('"', '""', utf8_decode($socolissimoLiberteOrderInfos['lastname'])) .
                            '";');
                    else
                        addToFeed('"' . str_replace('"', '""', utf8_decode($addressDelivery->lastname)) .
                            '";');
                    addToFeed('"' . utf8_decode($addressDelivery->address1) . '";');
                    addToFeed('"' . utf8_decode($addressDelivery->address2) . '";');
                    addToFeed('"' . $addressDelivery->postcode . '";');
                    addToFeed('"' . utf8_decode($addressDelivery->city) . '";');
                    addToFeed('"' . $country->iso_code . '";');
                    addToFeed('"' . utf8_decode(str_replace("\r\n", " ", $socolissimoLiberteOrderInfos['informations'])) .
                        '";');
                    addToFeed('"' . $addressDelivery->phone . '";');
                    addToFeed('"' . $order['weight'] . '";');
                    addToFeed('"' . $socolissimoLiberteOrderInfos['telephone'] . '";');
                    addToFeed('"' . $socolissimoLiberteOrderInfos['email'] . '";'); //mail
                    addToFeed('"' . $socolissimoLiberteOrderInfos['point_id'] . '";'); //CodePointRetrait
                    addToFeed('"' . $socolissimoLiberteOrderInfos['type'] . '";'); //CodeProduit
                    addToFeed('"' . Configuration::get('PS_SHOP_NAME') . '";'); //NomCommercialChargeur
                    addToFeed('"";'); //CodePorte1
                    addToFeed('"";'); //CodePorte2
                    break;

            }
        }
	if($order->module=="cashondelivery")
		addToFeed('"'.$order->total_paid.'";');
	else
	addToFeed('"0";');
	addToFeed('"'.$size.'";');
    addToFeed('"'.$assurance.'";');
    addToFeed('"'.$recommandation.'"');	
    					
	addToFeed("\r\n");
					
		foreach($products as $product)
		{
			addToFeed('"CN2";');
			addToFeed('"'.utf8_decode($product['product_name']).'";');
			addToFeed('"'.$product['product_quantity'].'";');
			addToFeed('"'.$product['product_weight'].'";');
			addToFeed('"'.round($product['product_price'],2).'";');
			addToFeed('"000000";');
			addToFeed('"FR"');
			addToFeed("\r\n");
        }
		
		

function addToFeed($str)
{
Global $filename;
	if(file_exists($filename))
	{
		$fp = fopen($filename, 'ab');
		fwrite($fp, $str, strlen($str));
		fclose($fp);
	}
}
function getDeliveryInfos($idCart, $idCustomer)
{
         $result = Db::getInstance()->getRow('SELECT * FROM ' . _DB_PREFIX_ .
        'socolissimo_delivery_info WHERE id_cart = ' . (int)($idCart) .
        ' AND id_customer = ' . (int)($idCustomer));
    return $result;
}
function getLiberteDeliveryInfos($idCart, $idCustomer)
{
     $resultL = Db::getInstance()->getRow('SELECT * FROM ' . _DB_PREFIX_ .
        'so_delivery WHERE id_cart = ' . (int)($idCart) .
        ' AND id_customer = ' . (int)($idCustomer));   
    return $resultL;
} 
?>