<?php

/**
    @author Tiagop
	email : contact@tiagop.com
 **/

class Fblikes extends Module
{	
	private $_html = '';
	private $_postErrors = array();
	
	private static $settings = null;
	public static $default_values = array("fan_profile_id" => "185550966885",
									"fan_active" => 1,
									"fan_stream" => 0,
									"fan_connections" => "6",
									"fan_width" => "190",
									"fan_height" => "330",
									"fan_display_header" => 1,
									
									"button_active" => 1,
									"button_layout" => "standard",
									"button_show_faces" => 1,
									"button_width" => 450,
									"button_verb" => "like",
									"button_font" => "",
									"button_color" => "light");
	function __construct()
	{
		$this->name = 'fblikes';
 	 	$this->version = '1.0';
 	 	$this->tab = 'Tools';
		
		parent::__construct();
		
		$this->displayName = $this->l('Facebook likes module');
		$this->description = $this->l('Display a block with your Facebook fan page and Like button');
	}
	
	public function install()
	{
	 	if (!parent::install()) return false;
		Configuration::updateValue('FBLIKES_SETTINGS',serialize(self::$default_values));
	 	
		if(!$this->registerHook('rightColumn')) return false;
		if(!$this->registerHook('productFooter')) return false;
		return true;
	}
	
	public function uninstall()
	{
		if (!Configuration::deleteByName('FBLIKES_SETTINGS') OR !parent::uninstall()) return false;
		return true;
	}
	
	public static function getConf(){
		if(is_null(self::$settings)){
			$config = Configuration::get('FBLIKES_SETTINGS');
			$options = self::$default_values;
			if($config) $options = array_merge($options,unserialize((string)$config));
			self::$settings = $options;
		}
		return self::$settings;
	}
	
	public function hookExtraLeft($params)
	{
		$settings = self::getConf();
		if($settings['button_active'] == 1){ 
			global $smarty, $cookie;
			$smarty->assign(array('settings' => $settings,'like_page_url' => $this->curPageURL()));
			return $this->display(__FILE__, 'likebutton.tpl');
		}
	}
	
	public function hookExtraRight($params)
	{
		return $this->hookExtraLeft($params);
	}
	
	public function hookProductFooter($params)
	{
		return $this->hookExtraLeft($params);
	}
	
	public function hookFooter($params)
	{
		return $this->hookExtraLeft($params);
	}
	
	public function hookExtra($params)
	{
		return $this->hookExtraLeft($params);
	}
	
	public function hookHeader($params)
	{
		return $this->hookExtraLeft($params);
	}
	
	public function hookLeftColumn($params)
	{	
		global $smarty;	  
		$settings = self::getConf();
		if($settings['fan_active'] == 1){ 
			if($settings['fan_profile_id'] == "" || $settings['fan_profile_id'] == 0) return false;
			$smarty->assign(array('settings' => $settings));
			return $this->display(__FILE__, 'likebox.tpl');
		}
	}
	
	public function hookRightColumn($params)
	{
		return $this->hookLeftColumn($params);
	}

	
	private function _postProcess()
	{	
		if (Tools::isSubmit('submitFacebookfan'))
		{	
			$pref = $_POST['pref'];
			
			if($pref['fan_active'] && ($pref['fan_profile_id'] == "" || intval($pref['fan_profile_id']) == 0)){
					$this->_postErrors[] = $this->l('Page ID is required and must be a number');
			}
			if($pref['fan_active'] && (!intval($pref['fan_width']) || !intval($pref['fan_height'])) ){
				$this->_postErrors[] = $this->l('Width, Height and Connections must be numbers');
			}
			if($pref['button_active'] && !intval($pref['button_width'])){
				$this->_postErrors[] = $this->l('Button width must be a number');
			}
			
			$checkboxes = array('fan_active','fan_stream','fan_display_header','button_active','button_show_faces');
			foreach($checkboxes as $input){
				if(!isset($pref[$input])) $pref[$input] = 0;
			}
			
			if(count($this->_postErrors)) return;
	
			$new_values = serialize(array_merge(self::$default_values,$pref));
			Configuration::updateValue('FBLIKES_SETTINGS',$new_values);
			$this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" /> '.$this->l('Settings updated').'</div>';
		}
	}

	private function _displayForm()
	{	
		$token = '&token='.$_GET['token'];
		$values = !empty($_POST) ? Tools::getValue('pref') : array_merge(self::$default_values,self::getConf());
		
		$this->_html .='<form name="settingForm" action="index.php?tab=AdminModules&configure='.$this->name.$token.'" method="post">
				  <fieldset>
				  <legend>'.$this->l('Facebook Like Box Settings').'</legend>
				    <p style="float:right;"><a href="http://developers.facebook.com/docs/reference/plugins/like-box" target="_blank">Facebook Documentation</a></p>
					<div class="clear"></div>';
							  
			$this->_html .=	'<label>'.$this->l('Active Like box').'</label> 
							 <div class="margin-form">
								 <input type="checkbox" name="pref[fan_active]" value="1" '.(isset($values['fan_active']) && $values['fan_active'] == '1' ? 'checked' : '').' /> 
							 </div>
							 <div class="clear"></div><br />
							 
							<label>'.$this->l('Facebook Page Identification').'</label> 
							 <div class="margin-form">
								Page Id <input type="text" name="pref[fan_profile_id]" value="'.(isset($values['fan_profile_id']) ? $values['fan_profile_id'] : "").'" size="20" />
								<p class="clear">'.$this->l('You will find PAGE_ID in the url of your facebook page').'</p>
							 </div>
							 
							 <div class="clear"></div><br />
							 
							 <label>'.$this->l('Display page news stream').'</label> 
							 <div class="margin-form">
								 <input type="checkbox" name="pref[fan_stream]" value="1" '.(isset($values['fan_stream']) && $values['fan_stream'] == '1' ? 'checked' : '').' /> 
							 </div>
							 <div class="clear"></div><br />
							 
							 <label>'.$this->l('Number of fans to display').'</label> 
							 <div class="margin-form">
								 <input type="text" name="pref[fan_connections]" value="'.(isset($values['fan_connections']) ? $values['fan_connections'] : "").'" size="3" /> 
								 '.$this->l('0 for hide fans, default 10, max 100 fans').'
							 </div>
							 <div class="clear"></div><br />
							 
							 <label>'.$this->l('Display header').'</label> 
							 <div class="margin-form">
								 <input type="checkbox" name="pref[fan_display_header]" value="1" '.(isset($values['fan_display_header']) && $values['fan_display_header'] == '1' ? 'checked' : '').' /> 
							 </div>
							 <div class="clear"></div><br />
							 
							 <label>'.$this->l('Block size').'</label>
							 <div class="margin-form">
							 &nbsp;&nbsp; '.$this->l('Width').' <input type="text" name="pref[fan_width]" value="'.$values['fan_width'].'" size="3" /> px
							 &nbsp;&nbsp; '.$this->l('Height').' <input type="text" name="pref[fan_height]" value="'.$values['fan_height'].'" size="3" /> px
							 </div>
							 <div class="clear"></div><br />
							 
							  <div class="margin-form">
								 <p class="hint clear" style="display: block;font-size:11px; width:400px;">'.$this->l('If you change the number of connections shown or display stream feed, you may need to edit the height to ensure they are all visible.').'</p>
							  </div>
							 
							 </fieldset>
							 <div class="clear"></div><br />
							
							 <fieldset>
							 <legend>'.$this->l('Facebook like Button Settings').'</legend>
							  
							  <p style="float:right;"><a href="http://developers.facebook.com/docs/reference/plugins/like" target="_blank">Facebook Documentation</a></p>
							  <div class="clear"></div>
							  
							 <label>'.$this->l('Active like button').'</label> 
							 <div class="margin-form">
								 <input type="checkbox" name="pref[button_active]" value="1" '.(isset($values['button_active']) && $values['button_active'] == '1' ? 'checked' : '').' /> 
							 </div>
							 <div class="clear"></div><br />
								
									<label>'.$this->l('Layout Style').'</label> 
									<div class="margin-form">
										<select name="pref[button_layout]">
											<option value="standard" '.($values['button_layout'] == "standard" ? "selected" : "").'>'.$this->l('Standard').' &nbsp;</option>
											<option value="button_count" '.($values['button_layout'] == "button_count" ? "selected" : "").'>'.$this->l('Button count').' &nbsp;</option>
											<option value="box_count" '.($values['button_layout'] == "box_count" ? "selected" : "").'>'.$this->l('Box count').' &nbsp;</option>
										</select>
									</div>
									<div class="clear"></div><br />
									
									<label>'.$this->l('Show Faces').'</label>  
									<div class="margin-form">
									<input type="checkbox" name="pref[button_show_faces]" value="1" '.((isset($values['button_show_faces']) && $values['button_show_faces'] == '1') ? 'checked' : '').'/>
									</div>
									<div class="clear"></div><br />
									
									<label>'.$this->l('Width').'</label>
									<div class="margin-form">
										<input type="text" name="pref[button_width]" value="'.$values['button_width'].'" size="3" /> px
									</div>
									<div class="clear"><br />
									
									<label>'.$this->l('Verb to display').'</label> 
									<div class="margin-form">
										<select name="pref[button_verb]">
											<option value="like" '.($values['button_verb'] == "like" ? "selected" : "").'>'.$this->l('Like').' &nbsp;</option>
											<option value="recommend" '.($values['button_verb'] == "recommend" ? "selected" : "").'>'.$this->l('Recommend').' &nbsp;</option>
										</select>
									</div>
									<div class="clear"></div><br />
									
									<label>'.$this->l('Font').'</label> 
									<div class="margin-form">
										<select name="pref[button_font]">
											<option '.($values['button_font'] == "" ? "selected" : "").' ></option>
											<option '.($values['button_font'] == "arial" ? "selected" : "").' value="arial">arial</option>
											<option '.($values['button_font'] == "lucida grande" ? "selected" : "").' value="lucida grande">lucida grande</option>
											<option '.($values['button_font'] == "segoe ui" ? "selected" : "").' value="segoe ui">segoe ui</option>
											<option '.($values['button_font'] == "tahoma" ? "selected" : "").' value="tahoma">tahoma</option>
											<option '.($values['button_font'] == "trebuchet ms" ? "selected" : "").' value="trebuchet ms">trebuchet ms</option>
											<option '.($values['button_font'] == "verdana" ? "selected" : "").' value="verdana">verdana</option>
										</select>
									</div>
									<div class="clear"></div><br />
									
									<label>'.$this->l('Button color').'</label> 
									<div class="margin-form">
										<select name="pref[button_color]">
											<option value="light" '.($values['button_color'] == "light" ? "selected" : "").'>'.$this->l('Light').' &nbsp;</option>
											<option value="dark" '.($values['button_color'] == "dark" ? "selected" : "").'>'.$this->l('Dark').' &nbsp;</option>
										</select>
									</div>
									<div class="clear"></div><br />
									
							 </fieldset>
							  
							 <br />
							 <p style="float:left; width:100px;">
							 <input class="button" name="submitFacebookfan" value="'.$this->l('Update settings').'" type="submit" />
							 </p>
							 
							 <p class="hint" style="display: block;font-size:11px; width:400px; float:right;">'
							 .$this->l('To see your changes in front office, refresh your page with ctrl + F5').
							 '<br /><br />'
							 .$this->l('You can change positions in modules &gt; positions').
							 '</p>';
							
			$this->_html .= '<div class="clear"></div><br /></form>';
	}
	
	public function getContent(){
		$this->_html = '<h2><img src="'.__PS_BASE_URI__.'modules/fblikes/img/facebook-icon.png" alt="facebook">&nbsp;Facebook LIKES Prestashop module</h2>';
		if (!empty($_POST))
		{
			$this->_postProcess();
			if(count($this->_postErrors))
				foreach ($this->_postErrors AS $err) $this->_html .= '<div class="alert error">'. $err .'</div>';		
		}
		$this->_displayForm();
		return $this->_html;
	}	

	public function curPageURL() {
		 $pageURL = 'http';
		 if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
		 $pageURL .= "://";
		 if ($_SERVER["SERVER_PORT"] != "80") {
		  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		 } else {
		  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		 }
		 return urlencode($pageURL);
	}
	
}

?>