<?php
/* 
 * Noir Ô Naturel, simple module to integrate the tpl contains into the header
 * without modifying the standard headr.
 *  
 * It includes two buttons to navigate to other parts of the web-site 
 *  
 */

if (!defined('_PS_VERSION_'))
	exit;
	
class nnBulles extends Module
{
    
    public function __construct()
    {
        $this->name = 'nnbulles';
        $this->tab = 'front_office_features';
        $this->version = 1.0;
        $this->author = 'Noir Ô Naturel';
        $this->need_instance = 0;
        // Override for development
        $this->is_configurable = 0;
        
        parent::__construct();
        
        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('N&N : Bulles');
        $this->description = $this->l('For integrating big buttons into the page header');
    }
    
    /**
     * Module installation (i.e. called when cliking on install button in administration/module tab
     */
    function install()
    {
    
        // Proceed with standard installation
        if (
          // Parent installation
          !parent::install() 
        
          // Hook registration on header for css inclusion and top of page
          || !$this->registerHook('header') 
          || !$this->registerHook('top')
          
        )
        return false;

        return true;
    }

    /**
     * Called when deinstalling the module, reverse installation
     */     
    public function uninstall()
    {
        if (!parent::uninstall()) 
        return false;
    
        return true;
    }
    
    /**
     * Hook Top call
     */     
    public function hookTop($param)
    {
        global $smarty;                
        return ($this->display(__FILE__, '/nnbulles.tpl'));
    }
     
    /**
     *  Hook to include the style sheet
     */
    function hookHeader($params)
	{
	   Tools::addCSS(($this->_path).'nnbulles.css', 'all');		
	}

}
