<?php
/*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA

*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

include_once _PS_MODULE_DIR_.'nngallery/nnGalleryItem.php';

class nngallery extends Module
{
	public function __construct()
	{
		$this->name = 'nngallery';
		$this->tab = 'front_office_features';
		$this->version = '0.0';
		$this->author = 'Noir Ô Naturel';
		$this->need_instance = 0;
		$this->secure_key = Tools::encrypt($this->name);

		parent::__construct();

		$this->displayName = $this->l('N&N : Gallery for home page');
		$this->description = $this->l('Displays selected categories in the homepage');
	}

	public function install()
	{
		$res = parent::install();
		// Hooks
		$res &= $this->registerHook('displayHome');
		$res &= $this->registerHook('actionShopDataDuplication');
		// Configuration

//		$res &= Configuration::updateValue('NNGALLERY_NBITEMS', 6);

		// Table creation
		$res &= $this->createTables();
		// Samples 
		if ($res) {
			$this->installSamples();
		}
		return $res;
	}
	
	public function uninstall()
	{
		// Deletes tables 
		$res = $this->deleteTables();
		// Unsets configuration 
		
//		$res &= Configuration::deleteByName('NNGALLERY_NBITEMS');
		
		// Parent removal 
		$res &= parent::uninstall();
		return $res;
	}

	protected function createTables()
	{
		// Gallery shop 
		$res = (bool)Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'nngallery_shop` (
				`id_nngallery_items` int(10) unsigned NOT NULL AUTO_INCREMENT,
				`id_shop` int(10) unsigned NOT NULL,
				PRIMARY KEY (`id_nngallery_items`, `id_shop`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');

		// Gallery items
		$res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'nngallery_items` (
			  `id_nngallery_items` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `position` int(10) unsigned,
			  `active` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
			  PRIMARY KEY (`id_nngallery_items`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');

		// Gallery items lang 
		$res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'nngallery_items_lang` (
			  `id_nngallery_items` int(10) unsigned NOT NULL,
			  `id_lang` int(10) unsigned NOT NULL,
			  `name` varchar(255) NOT NULL,
			  `title` varchar(255) NOT NULL,
			  `subtitle` varchar(255),
			  `description` text,
			  `url` varchar(255) NOT NULL,
			  `legend` varchar(255) NOT NULL,
			  `image` varchar(255) NOT NULL,
			  PRIMARY KEY (`id_nngallery_items`,`id_lang`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');

		return $res;
	}

	protected function dropTables()
	{
		$items = $this->getItems();
		foreach ($items as $item)
		{
			$to_del = new nnGalleryItem($item['id_nngallery_items']);
			$to_del->delete();
		}
		return Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'nngallery_shop` , `'._DB_PREFIX_.'nngallery_items` , `'._DB_PREFIX_.'nngallery_items_lang`;
		');
	}

	protected function installSamples()
	{
		$languages = Language::getLanguages(false);
		for ($i = 1; $i <= 6; ++$i)
		{
			$item = new nnGalleryItem();
			$item->position = $i;
			$item->active = 1;
			$item->name = ''.$i;
			foreach ($languages as $language)
			{
				$item->title[$language['id_lang']] = 'Sample '.$i;
				$item->subtitle[$language['id_lang']] = 'Excepteur sint occaecat cupidatat non proident';
				$item->description[$language['id_lang']] = 'Lorem ipsum dolor sit amet, consectetur adipisicing elit';
				$item->url[$language['id_lang']] = 'http://www.prestashop.com';
				$item->legend[$language['id_lang']] = 'sample-'.$i;
				$item->image[$language['id_lang']] = 'sample-'.$i.'.jpg';
			}
			$item->add();
		}
	}

	public function getContent()
	{
		$this->_html .= $this->headerHTML();
		$this->_html .= '<h2>'.$this->displayName.'.</h2>';

		// Validate & process
		if (Tools::isSubmit('submitGalleryItem') ||
			Tools::isSubmit('deleteGalleryItem') ||
			Tools::isSubmit('submitGallery') ||
			Tools::isSubmit('changeStatus'))
		{
			if ($this->_postValidation())
				$this->_postProcess();
			$this->_displayForm();
		}
		elseif (Tools::isSubmit('addGalleryItem')) {
			$this->_displayItemForm();
		}
		elseif (Tools::isSubmit('editGalleryItem') && 
			 	$this->itemExists((int)Tools::getValue('editGalleryItem'))) {
			$this->_displayItemForm();
		}
		else
			$this->_displayForm();

		return $this->_html;
	}

	private function _displayForm()
	{
		// Gets Gallery Items
		$items = $this->getItems();
/*
		// Begin fieldset
		$this->_html .= '
		<fieldset>
			<legend><img src="'._PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/logo.gif" alt="" /> '.$this->l('Gallery configuration').'</legend>';
		// Begin form 
		$this->_html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">';
		// Height field 
		$this->_html .= '
			<label>'.$this->l('Height:').'</label>
			<div class="margin-form">
				<input type="text" name="NNHOMESLIDER_HEIGHT" id="speed" size="3" value="'.Tools::safeOutput(Configuration::get('NNHOMESLIDER_HEIGHT')).'" /> px
			</div>';
		// Width field 
		$this->_html .= '
		<label>'.$this->l('Width:').'</label>
		<div class="margin-form">
			<input type="text" name="NNHOMESLIDER_WIDTH" id="pause" size="3" value="'.Tools::safeOutput(Configuration::get('NNHOMESLIDER_WIDTH')).'" /> px
		</div>';
		// Speed field 
		$this->_html .= '
			<label>'.$this->l('Speed:').'</label>
			<div class="margin-form">
				<input type="text" name="NNHOMESLIDER_SPEED" id="speed" size="3" value="'.Tools::safeOutput(Configuration::get('NNHOMESLIDER_SPEED')).'" /> ms
			</div>';
		// Pause field 
		$this->_html .= '
		<label>'.$this->l('Pause:').'</label>
		<div class="margin-form">
			<input type="text" name="NNHOMESLIDER_PAUSE" id="pause" size="3" value="'.Tools::safeOutput(Configuration::get('NNHOMESLIDER_PAUSE')).'" /> ms
		</div>';
		// Loop field
		$this->_html .= '
		<label for="loop_on">'.$this->l('Loop:').'</label>
		<div class="margin-form">
			<img src="../img/admin/enabled.gif" alt="Yes" title="Yes" />
			<input type="radio" name="NNHOMESLIDER_LOOP" id="loop_on" '.(Configuration::get('NNHOMESLIDER_LOOP') == 1 ? 'checked="checked"' : '').' value="1" />
			<label class="t" for="loop_on">'.$this->l('Yes').'</label>
			<img src="../img/admin/disabled.gif" alt="No" title="No" style="margin-left: 10px;" />
			<input type="radio" name="NNHOMESLIDER_LOOP" id="loop_off" '.(Configuration::get('NNHOMESLIDER_LOOP') == 0 ? 'checked="checked" ' : '').' value="0" />
			<label class="t" for="loop_off">'.$this->l('No').'</label>
		</div>';
		// Save 
		$this->_html .= '
		<div class="margin-form">
			<input type="submit" class="button" name="submitSlider" value="'.$this->l('Save').'" />
		</div>';
		// End form 
		$this->_html .= '</form>';
		// End fieldset slider 
		$this->_html .= '</fieldset>';

		$this->_html .= '<br /><br />';
*/

		// Begin fieldset gallery items 
		$this->_html .= '
		<fieldset>
			<legend><img src="'._PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/logo.gif" alt="" /> '.$this->l('Gallery items configuration').'</legend>
			<strong>
				<a href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&addGalleryItem">
					<img src="'._PS_ADMIN_IMG_.'add.gif" alt="" /> '.$this->l('Add gallery item').'
				</a>
			</strong>';

		// Display notice if there are no items yet 
		if (!$items)
			$this->_html .= '<p style="margin-left: 40px;">'.$this->l('You have not yet added any gallery item.').'</p>';
		else // Display items 
		{
			$this->_html .= '
			<div id="galleryItemsContent" style="width: 400px; margin-top: 30px;">
				<ul id="galleryItems">';

			foreach ($items as $item)
			{
				$this->_html .= '
					<li id="item_'.$item['id_item'].'">
						<strong>#'.$item['id_item'].'</strong> '.$item['title'].'
						<p style="float: right">'.
							$this->displayStatus($item['id_item'], $item['active']).'
							<a href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&editGalleryItem='.(int)($item['id_item']).'" title="'.$this->l('Edit').'"><img src="'._PS_ADMIN_IMG_.'edit.gif" alt="" /></a>
							<a href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&deleteGalleryItem='.(int)($item['id_item']).'" title="'.$this->l('Delete').'"><img src="'._PS_ADMIN_IMG_.'delete.gif" alt="" /></a>
						</p>
					</li>';
			}
			$this->_html .= '</ul></div>';
		}
		// End fieldset
		$this->_html .= '</fieldset>';
	}

	private function _displayItemForm()
	{
		// Sets Item : depends if edited or added 
		$item = null;
		if (Tools::isSubmit('editGalleryItem') && $this->itemExists((int)Tools::getValue('editGalleryItem')))
			$item = new nnGalleryItem((int)Tools::getValue('editGalleryItem'));
		// Checks if directory is writable 
		if (!is_writable('.'))
			$this->adminDisplayWarning(sprintf($this->l('Modules %s must be writable (CHMOD 755 / 777)'), $this->name));

		// Gets languages and sets which div requires translations 
		$id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');
		$languages = Language::getLanguages(false);
		$divLangName = 'title¤subtitle¤description¤url¤legend¤image';
		$this->_html .= '<script type="text/javascript">id_language = Number('.$id_lang_default.');</script>';

		// Form 
		$this->_html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" enctype="multipart/form-data">';

		// Fieldset Upload
		$this->_html .= '
		<fieldset class="width3">
			<br />
			<legend><img src="'._PS_ADMIN_IMG_.'add.gif" alt="" />1 - '.$this->l('Upload your item').'</legend>';
		// Image 
		$this->_html .= '<label>'.$this->l('Select a file:').' * </label><div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '<div id="image_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">';
			$this->_html .= '<input type="file" name="image_'.$language['id_lang'].'" id="image_'.$language['id_lang'].'" size="30" value="'.(isset($item->image[$language['id_lang']]) ? $item->image[$language['id_lang']] : '').'"/>';
			// Sets image as hidden in case it does not change 
			if ($item && $item->image[$language['id_lang']])
				$this->_html .= '<input type="hidden" name="image_old_'.$language['id_lang'].'" value="'.($item->image[$language['id_lang']]).'" id="image_old_'.$language['id_lang'].'" />';
			// Display image 
			if ($item && $item->image[$language['id_lang']])
				$this->_html .= '<input type="hidden" name="has_picture" value="1" /><img src="'.__PS_BASE_URI__.'modules/'.$this->name.'/images/'.$item->image[$language['id_lang']].'" width="'.(Configuration::get('NNHOMESLIDER_WIDTH')/2).'" height="'.(Configuration::get('NNHOMESLIDER_HEIGHT')/2).'" alt=""/>';
			$this->_html .= '</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'image', true);
		// End Fieldset Upload 
		$this->_html .= '</fieldset><br /><br />';

		// Fieldset edit/add 
		$this->_html .= '<fieldset class="width3">';
		if (Tools::isSubmit('addGalleryItem')) // Configure legend 
			$this->_html .= '<legend><img src="'._PS_ADMIN_IMG_.'add.gif" alt="" /> 2 - '.$this->l('Configure your gallery item').'</legend>';
		elseif (Tools::isSubmit('editGalleryItem')) // Edit legend 
			$this->_html .= '<legend><img src="'._PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/logo.gif" alt="" /> 2 - '.$this->l('Edit your gallery item').'</legend>';
		// Sets gallery item id as hidden 
		if ($item && Tools::getValue('editGalleryItem'))
			$this->_html .= '<input type="hidden" name="id_item" value="'.$item->id.'" id="id_item" />';
		// Sets position as hidden 
		$this->_html .= '<input type="hidden" name="position" value="'.(($item != null) ? ($item->position) : ($this->getNextPosition())).'" id="position" />';

		// Form content 

		// Name
		$this->_html .= '<br /><label>'.$this->l('Name:').' * </label><div class="margin-form">';
		$this->_html .= '
				<div id="name" style="display:block;float:left;">
					<input type="text" name="name" id="name" size="30" value="'.(isset($item->name) ? $item->name : '').'"/>
				</div>';
		$this->_html .= '</div><br /><br />';

		// Title 
		$this->_html .= '<br /><label>'.$this->l('Title:').' * </label><div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '
					<div id="title_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
						<input type="text" name="title_'.$language['id_lang'].'" id="title_'.$language['id_lang'].'" size="30" value="'.(isset($item->title[$language['id_lang']]) ? $item->title[$language['id_lang']] : '').'"/>
					</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'title', true);
		$this->_html .= '</div><br /><br />';

		// Subtitle
		$this->_html .= '
		<label>'.$this->l('Subtitle:').' </label>
		<div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '<div id="subtitle_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
				<textarea name="subtitle_'.$language['id_lang'].'" rows="10" cols="29">'.(isset($item->description[$language['id_lang']]) ? $item->subtitle[$language['id_lang']] : '').'</textarea>
			</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'subtitle', true);
		$this->_html .= '</div><div class="clear"></div><br />';

		// Description 
		$this->_html .= '
		<label>'.$this->l('Description:').' </label>
		<div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '<div id="description_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
				<textarea name="description_'.$language['id_lang'].'" rows="10" cols="29">'.(isset($item->description[$language['id_lang']]) ? $item->description[$language['id_lang']] : '').'</textarea>
			</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'description', true);
		$this->_html .= '</div><div class="clear"></div><br />';

		// URL 
		$this->_html .= '<label>'.$this->l('URL:').' * </label><div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '
					<div id="url_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
						<input type="text" name="url_'.$language['id_lang'].'" id="url_'.$language['id_lang'].'" size="30" value="'.(isset($item->url[$language['id_lang']]) ? $item->url[$language['id_lang']] : '').'"/>
					</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'url', true);
		$this->_html .= '</div><br /><br />';

		// Legend 
		$this->_html .= '<label>'.$this->l('Legend:').' * </label><div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '
					<div id="legend_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
						<input type="text" name="legend_'.$language['id_lang'].'" id="legend_'.$language['id_lang'].'" size="30" value="'.(isset($item->legend[$language['id_lang']]) ? $item->legend[$language['id_lang']] : '').'"/>
					</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'legend', true);
		$this->_html .= '</div><br /><br />';

		// Active 
		$this->_html .= '
		<label for="active_on">'.$this->l('Active:').'</label>
		<div class="margin-form">
			<img src="../img/admin/enabled.gif" alt="Yes" title="Yes" />
			<input type="radio" name="active_item" id="active_on" '.(($item && (isset($item->active) && (int)$item->active == 0)) ? '' : 'checked="checked" ').' value="1" />
			<label class="t" for="active_on">'.$this->l('Yes').'</label>
			<img src="../img/admin/disabled.gif" alt="No" title="No" style="margin-left: 10px;" />
			<input type="radio" name="active_item" id="active_off" '.(($item && (isset($item->active) && (int)$item->active == 0)) ? 'checked="checked" ' : '').' value="0" />
			<label class="t" for="active_off">'.$this->l('No').'</label>
		</div>';

		// Save 
		$this->_html .= '
		<p class="center">
			<input style="min-height:26px" type="submit" class="button" name="submitGalleryItem" value="'.$this->l('Save').'" />
			<a class="button" style="position:relative; padding:4px 3px;" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'">'.$this->l('Cancel').'</a>
		</p>';

		// End of fieldset & form 
		$this->_html .= '
			<p>*'.$this->l('Required fields').'</p>
			</fieldset>
		</form>';
	}

	private function _postValidation()
	{
		$errors = array();

		// Validation for Gallery configuration 
		if (Tools::isSubmit('submitGallery'))
		{

			if (!Validate::isInt(Tools::getValue('NNHOMESLIDER_SPEED')) || !Validate::isInt(Tools::getValue('NNHOMESLIDER_PAUSE')) ||
				!Validate::isInt(Tools::getValue('NNHOMESLIDER_WIDTH')) || !Validate::isInt(Tools::getValue('NNHOMESLIDER_HEIGHT')))
					$errors[] = $this->l('Invalid values');
		} 
		// Validation for status 
		elseif (Tools::isSubmit('changeStatus'))
		{
			if (!Validate::isInt(Tools::getValue('id_item')))
				$errors[] = $this->l('Invalid item');
		}
		// Validation for Gallery Item 
		elseif (Tools::isSubmit('submitGalleryItem'))
		{
			// Checks state (active) 
			if (!Validate::isInt(Tools::getValue('active_item')) || (Tools::getValue('active_item') != 0 && Tools::getValue('active_item') != 1))
				$errors[] = $this->l('Invalid item state');
			// Checks position 
			if (!Validate::isInt(Tools::getValue('position')) || (Tools::getValue('position') < 0))
				$errors[] = $this->l('Invalid item position');
			// If edit : checks id_item 
			if (Tools::isSubmit('id_item'))
			{
				if (!Validate::isInt(Tools::getValue('id_item')) && !$this->itemExists(Tools::getValue('id_item')))
					$errors[] = $this->l('Invalid id_item');
			}
			// Checks name
			if (Tools::strlen(Tools::getValue('name')) == 0)
				$errors[] = $this->l('Name is not set');
			if (Tools::strlen(Tools::getValue('name')) > 255)
				$errors[] = $this->l('Name is too long');

			// Checks title/subtitle/description/url/legend/image 
			$languages = Language::getLanguages(false);
			foreach ($languages as $language)
			{
				if (Tools::strlen(Tools::getValue('title_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The title is too long.');
				if (Tools::strlen(Tools::getValue('subtitle_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The subtitle is too long.');
				if (Tools::strlen(Tools::getValue('description_'.$language['id_lang'])) > 4000)
					$errors[] = $this->l('The description is too long.');
				if (Tools::strlen(Tools::getValue('url_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The URL is too long.');
				if (Tools::strlen(Tools::getValue('url_'.$language['id_lang'])) > 0 && !Validate::isUrl(Tools::getValue('url_'.$language['id_lang'])))
					$errors[] = $this->l('The URL format is not correct.');
				if (Tools::strlen(Tools::getValue('legend_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The legend is too long.');
				if (Tools::getValue('image_'.$language['id_lang']) != null && !Validate::isFileName(Tools::getValue('image_'.$language['id_lang'])))
					$errors[] = $this->l('Invalid filename');
				if (Tools::getValue('image_old_'.$language['id_lang']) != null && !Validate::isFileName(Tools::getValue('image_old_'.$language['id_lang'])))
					$errors[] = $this->l('Invalid filename');
			}

			// Checks existing title/url/legend/image for default lang 
			$id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');
			if (Tools::strlen(Tools::getValue('title_'.$id_lang_default)) == 0)
				$errors[] = $this->l('The title is not set.');
			if (Tools::strlen(Tools::getValue('url_'.$id_lang_default)) == 0)
				$errors[] = $this->l('The URL is not set.');
			if (Tools::strlen(Tools::getValue('legend_'.$id_lang_default)) == 0)
				$errors[] = $this->l('The legend is not set.');
			if (!Tools::isSubmit('has_picture') && (!isset($_FILES['image_'.$id_lang_default]) || empty($_FILES['image_'.$id_lang_default]['tmp_name'])))
				$errors[] = $this->l('The image is not set.');
			if (Tools::getValue('image_old_'.$id_lang_default) && !Validate::isFileName(Tools::getValue('image_old_'.$id_lang_default)))
				$errors[] = $this->l('The image is not set.');

		} // Validation for deletion 
		elseif (Tools::isSubmit('deleteGalleryItem') && (!Validate::isInt(Tools::getValue('deleteGalleryItem')) || !$this->itemExists((int)Tools::getValue('deleteGalleryItem'))))
			$errors[] = $this->l('Invalid item to delete');

		// Display errors if needed 
		if (count($errors))
		{
			$this->_html .= $this->displayError(implode('<br />', $errors));
			return false;
		}

		// Returns if validation is ok 
		return true;
	}

	private function _postProcess()
	{
		$errors = array();

		// Processes Gallery 
		if (Tools::isSubmit('submitGallery'))
		{
			$res = Configuration::updateValue('NNHOMESLIDER_WIDTH', (int)Tools::getValue('NNHOMESLIDER_WIDTH'));
			$res &= Configuration::updateValue('NNHOMESLIDER_HEIGHT', (int)Tools::getValue('NNHOMESLIDER_HEIGHT'));
			$res &= Configuration::updateValue('NNHOMESLIDER_SPEED', (int)Tools::getValue('NNHOMESLIDER_SPEED'));
			$res &= Configuration::updateValue('NNHOMESLIDER_PAUSE', (int)Tools::getValue('NNHOMESLIDER_PAUSE'));
			$res &= Configuration::updateValue('NNHOMESLIDER_LOOP', (int)Tools::getValue('NNHOMESLIDER_LOOP'));
			$this->clearCache();			
			if (!$res)
				$errors[] = $this->displayError($this->l('The configuration could not be updated.'));
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		} // Process Item status 
		elseif (Tools::isSubmit('changeStatus') && Tools::isSubmit('editGalleryItem'))
		{
			$item = new nnGalleryItem((int)Tools::getValue('editGalleryItem'));
			if ($item->active == 0)
				$item->active = 1;
			else
				$item->active = 0;
			$res = $item->update();
			$this->clearCache();
			$this->_html .= ($res ? $this->displayConfirmation($this->l('Configuration updated')) : $this->displayError($this->l('The configuration could not be updated.')));
		}
		// Processes Item 
		elseif (Tools::isSubmit('submitGalleryItem'))
		{
			// Sets ID if needed 
			if (Tools::getValue('id_item'))
			{
				$item = new nnGalleryItem((int)Tools::getValue('id_item'));
				if (!Validate::isLoadedObject($item))
				{
					$this->_html .= $this->displayError($this->l('Invalid id_item'));
					return;
				}
			}
			else
				$item = new nnGalleryItem();
			// Sets name
			$item->name = Tools::getValue('name');
			// Sets position 
			$item->position = (int)Tools::getValue('position');
			// Sets active 
			$item->active = (int)Tools::getValue('active_item');

			// Sets each langue fields 
			$languages = Language::getLanguages(false);
			foreach ($languages as $language)
			{
				$item->title[$language['id_lang']] = Tools::getValue('title_'.$language['id_lang']);
				$item->subtitle[$language['id_lang']] = Tools::getValue('subtitle_'.$language['id_lang']);

				$item->url[$language['id_lang']] = Tools::getValue('url_'.$language['id_lang']);
				$item->legend[$language['id_lang']] = Tools::getValue('legend_'.$language['id_lang']);
				$item->description[$language['id_lang']] = Tools::getValue('description_'.$language['id_lang']);

				// Uploads image and sets item 
				$type = strtolower(substr(strrchr($_FILES['image_'.$language['id_lang']]['name'], '.'), 1));
				$imagesize = array();
				$imagesize = @getimagesize($_FILES['image_'.$language['id_lang']]['tmp_name']);
				if (isset($_FILES['image_'.$language['id_lang']]) &&
					isset($_FILES['image_'.$language['id_lang']]['tmp_name']) &&
					!empty($_FILES['image_'.$language['id_lang']]['tmp_name']) &&
					!empty($imagesize) &&
					in_array(strtolower(substr(strrchr($imagesize['mime'], '/'), 1)), array('jpg', 'gif', 'jpeg', 'png')) &&
					in_array($type, array('jpg', 'gif', 'jpeg', 'png')))
				{
					$temp_name = tempnam(_PS_TMP_IMG_DIR_, 'PS');
					$salt = sha1(microtime());
					if ($error = ImageManager::validateUpload($_FILES['image_'.$language['id_lang']]))
						$errors[] = $error;
					elseif (!$temp_name || !move_uploaded_file($_FILES['image_'.$language['id_lang']]['tmp_name'], $temp_name))
						return false;
					elseif (!ImageManager::resize($temp_name, dirname(__FILE__).'/images/'.Tools::encrypt($_FILES['image_'.$language['id_lang']]['name'].$salt).'.'.$type, null, null, $type))
						$errors[] = $this->displayError($this->l('An error occurred during the image upload process.'));
					if (isset($temp_name))
						@unlink($temp_name);
					$item->image[$language['id_lang']] = Tools::encrypt($_FILES['image_'.($language['id_lang'])]['name'].$salt).'.'.$type;
				}
				elseif (Tools::getValue('image_old_'.$language['id_lang']) != '')
					$item->image[$language['id_lang']] = Tools::getValue('image_old_'.$language['id_lang']);
			}

			// Processes if no errors  
			if (!$errors)
			{
				// Adds 
				if (!Tools::getValue('id_item'))
				{
					if (!$item->add())
						$errors[] = $this->displayError($this->l('The item could not be added.'));
				}
				// Update 
				elseif (!$item->update())
					$errors[] = $this->displayError($this->l('The item could not be updated.'));
				$this->clearCache();
			}
		} // Deletes 
		elseif (Tools::isSubmit('deleteGalleryItem'))
		{
			$item = new nnGalleryItem((int)Tools::getValue('deleteGalleryItem'));
			$res = $item->delete();
			$this->clearCache();
			if (!$res)
				$this->_html .= $this->displayError('Could not delete');
			else
				$this->_html .= $this->displayConfirmation($this->l('Item deleted'));
		}

		// Display errors if needed 
		if (count($errors))
			$this->_html .= $this->displayError(implode('<br />', $errors));
		elseif (Tools::isSubmit('submitItem') && Tools::getValue('id_item'))
			$this->_html .= $this->displayConfirmation($this->l('Item updated'));
		elseif (Tools::isSubmit('submitItem'))
			$this->_html .= $this->displayConfirmation($this->l('Item added'));
	}

	private function _prepareHook()
	{
		if (!$this->isCached('nngallery.tpl', $this->getCacheId()))
		{
			$gallery = array(
				'width' => Configuration::get('NNHOMESLIDER_WIDTH'),
				'height' => Configuration::get('NNHOMESLIDER_HEIGHT'),
				'speed' => Configuration::get('NNHOMESLIDER_SPEED'),
				'pause' => Configuration::get('NNHOMESLIDER_PAUSE'),
				'loop' => Configuration::get('NNHOMESLIDER_LOOP'),
			);

			$items = $this->getItems(true);
			if (!$items)
				return false;

			$this->smarty->assign('gallery_items', $items);
			$this->smarty->assign('gallery', $gallery);
		}

		return true;
	}

	public function hookDisplayHome()
	{
		if(!$this->_prepareHook())
			return;

		// Check if not a mobile theme
		if ($this->context->getMobileDevice() != false)
			return false;

		/* 
		$this->context->controller->addJS($this->_path.'js/jquery.bxSlider.min.js');
		$this->context->controller->addCSS($this->_path.'bx_styles.css');
		$this->context->controller->addJS($this->_path.'js/homeslider.js');
		$this->context->controller->addJS($this->_path.'js/homeslider.js')
		*/

		return $this->display(__FILE__, 'nngallery.tpl', $this->getCacheId());
	}

	public function hookDisplayHome_2()
	{
		return $this->hookDisplayHome();
	}

	public function hookDisplayHome_3()
	{
		return $this->hookDisplayHome();
	}

	public function hookDisplayHome_4()
	{
		return $this->hookDisplayHome();
	}

	public function clearCache()
	{
		$this->_clearCache('nngallery.tpl');
	}

	public function hookActionShopDataDuplication($params)
	{
		Db::getInstance()->execute('
		INSERT IGNORE INTO '._DB_PREFIX_.'nngallery_shop (id_nngallery_items, id_shop)
		SELECT id_nngallery_items, '.(int)$params['new_id_shop'].'
		FROM '._DB_PREFIX_.'nngallery_shop
		WHERE id_shop = '.(int)$params['old_id_shop']);
		$this->clearCache();
	}

	public function headerHTML()
	{
		if (Tools::getValue('controller') != 'AdminModules' && Tools::getValue('configure') != $this->name)
			return;

		$this->context->controller->addJqueryUI('ui.sortable');
		// Style & js for fieldset 'items configuration' 
		$html = '
		<style>
		#galleryItems li {
			list-style: none;
			margin: 0 0 4px 0;
			padding: 10px;
			background-color: #F4E6C9;
			border: #CCCCCC solid 1px;
			color:#000;
		}
		</style>
		
		<script type="text/javascript">
			$(function() {
				var $myItems = $("#galleryItems");
				$myItems.sortable({
					opacity: 0.6,
					cursor: "move",
					update: function() {
						var order = $(this).sortable("serialize") + "&action=updateItemsPosition";
						$.post("'.$this->context->shop->physical_uri.$this->context->shop->virtual_uri.'modules/'.$this->name.'/ajax_'.$this->name.'.php?secure_key='.$this->secure_key.'", order);
						}
					});
				$myItems.hover(function() {
					$(this).css("cursor","move");
					},
					function() {
					$(this).css("cursor","auto");
				});
			});
		</script>';

		return $html;
	}

	public function getNextPosition()
	{
		$row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('
				SELECT MAX(hss.`position`) AS `next_position`
				FROM `'._DB_PREFIX_.'nngallery_items` hss, `'._DB_PREFIX_.'nngallery_shop` hs
				WHERE hss.`id_nngallery_items` = hs.`id_nngallery_items` AND hs.`id_shop` = '.(int)$this->context->shop->id
		);

		return (++$row['next_position']);
	}

	public function getItems($active = null)
	{
		$this->context = Context::getContext();
		$id_shop = $this->context->shop->id;
		$id_lang = $this->context->language->id;

		return Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
			SELECT hs.`id_nngallery_items` as id_item,
					   hssl.`image`,
					   hss.`position`,
					   hss.`active`,
					   hss.`name`,
					   hssl.`title`,
					   hssl.`subtitle`,
					   hssl.`url`,
					   hssl.`legend`,
					   hssl.`description`
			FROM '._DB_PREFIX_.'nngallery_shop hs
			LEFT JOIN '._DB_PREFIX_.'nngallery_items hss ON (hs.id_nngallery_items = hss.id_nngallery_items)
			LEFT JOIN '._DB_PREFIX_.'nngallery_items_lang hssl ON (hss.id_nngallery_items = hssl.id_nngallery_items)
			WHERE (id_shop = '.(int)$id_shop.')
			AND hssl.id_lang = '.(int)$id_lang.
			($active ? ' AND hss.`active` = 1' : ' ').'
			ORDER BY hss.position');
	}

	public function displayStatus($id_item, $active)
	{
		$title = ((int)$active == 0 ? $this->l('Disabled') : $this->l('Enabled'));
		$img = ((int)$active == 0 ? 'disabled.gif' : 'enabled.gif');
		$html = '<a href="'.AdminController::$currentIndex.
				'&configure='.$this->name.'
				&token='.Tools::getAdminTokenLite('AdminModules').'
				&changeStatus&id_item='.(int)$id_item.'" title="'.$title.'"><img src="'._PS_ADMIN_IMG_.''.$img.'" alt="" /></a>';
		return $html;
	}

	public function itemExists($id_item)
	{
		$req = 'SELECT hs.`id_nngallery_items` as id_item
				FROM `'._DB_PREFIX_.'nngallery_shop` hs
				WHERE hs.`id_nngallery_items` = '.(int)$id_item;
		$row = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($req);
		return ($row);
	}


}

