<?php
/*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/**
 * @since 1.5.0
 * @version 1.2 (2012-03-14)
 */

if (!defined('_PS_VERSION_'))
	exit;

include_once(_PS_MODULE_DIR_.'nnhomeslider/nnHomeSlide.php');

class nnHomeSlider extends Module
{
	private $_html = '';

	public function __construct()
	{
		$this->name = 'nnhomeslider';
		$this->tab = 'front_office_features';
		$this->version = '1.2.2';
		$this->author = 'Noir Ô Naturel et PrestaShop';
		$this->need_instance = 0;
		$this->secure_key = Tools::encrypt($this->name);

		parent::__construct();

		$this->displayName = $this->l('N&N : Image slider for your homepage.');
		$this->description = $this->l('Adds an image slider to your homepage.');
	}

	/**
	 * @see Module::install()
	 */
	public function install()
	{
		/* Adds Module */
		if (parent::install() && $this->registerHook('displayHome') && $this->registerHook('actionShopDataDuplication'))
		{
			/* Sets up configuration */
			$res = Configuration::updateValue('NNHOMESLIDER_WIDTH', '535');
			$res &= Configuration::updateValue('NNHOMESLIDER_HEIGHT', '300');
			$res &= Configuration::updateValue('NNHOMESLIDER_SPEED', '500');
			$res &= Configuration::updateValue('NNHOMESLIDER_PAUSE', '3000');
			$res &= Configuration::updateValue('NNHOMESLIDER_LOOP', '1');
			/* Creates tables */
			$res &= $this->createTables();

			/* Adds samples */
			/*
			if ($res)
				$this->installSamples();
			*/

			return $res;
		}
		return false;
	}

	/**
	 * Adds samples
	 */
	private function installSamples()
	{
		$languages = Language::getLanguages(false);
		for ($i = 1; $i <= 5; ++$i)
		{
			$slide = new nnHomeSlide();
			$slide->position = $i;
			$slide->active = 1;
			//$slide->image = 'sample-'.$i.'.jpg';
			foreach ($languages as $language)
			{
				$slide->title[$language['id_lang']] = 'Sample '.$i;
				$slide->subtitle[$language['id_lang']] = 'Excepteur sint occaecat cupidatat non proident';
				$slide->paragraph[$language['id_lang']] = '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</p>';
				$slide->description[$language['id_lang']] = 'This is a sample picture';
				$slide->legend[$language['id_lang']] = 'sample-'.$i;
				$slide->url[$language['id_lang']] = 'http://www.prestashop.com';
			}
			$slide->add();
		}
	}

	/**
	 * @see Module::uninstall()
	 */
	public function uninstall()
	{
		/* Deletes Module */
		if (parent::uninstall())
		{
			/* Deletes tables */
			$res = $this->deleteTables();
			/* Unsets configuration */
			$res &= Configuration::deleteByName('NNHOMESLIDER_WIDTH');
			$res &= Configuration::deleteByName('NNHOMESLIDER_HEIGHT');
			$res &= Configuration::deleteByName('NNHOMESLIDER_SPEED');
			$res &= Configuration::deleteByName('NNHOMESLIDER_PAUSE');
			$res &= Configuration::deleteByName('NNHOMESLIDER_LOOP');
			return $res;
		}
		return false;
	}

	/**
	 * Creates tables
	 */
	protected function createTables()
	{
		return nnHomeSlide::createTables();
	}

	/**
	 * deletes tables
	 */
	protected function deleteTables()
	{
		return nnHomeSlide::deleteTables();
	}

	public function getContent()
	{
		$this->_html .= $this->headerHTML();
		$this->_html .= '<h2>'.$this->displayName.'.</h2>';

		/* Validate & process */
		if (Tools::isSubmit('submitSlide') || Tools::isSubmit('delete_id_slide') ||
			Tools::isSubmit('submitSlider') ||
			Tools::isSubmit('changeStatus'))
		{
			if ($this->_postValidation())
				$this->_postProcess();
			$this->_displayForm();
		}
		elseif (Tools::isSubmit('addSlide') || (Tools::isSubmit('id_slide') && $this->slideExists((int)Tools::getValue('id_slide'))))
			$this->_displayAddForm();
		else
			$this->_displayForm();

		return $this->_html;
	}

	private function _displayForm()
	{
		/* Gets Slides */
		$slides = $this->getSlides();

		/* Begin fieldset slider */
		$this->_html .= '
		<fieldset>
			<legend><img src="'._PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/logo.gif" alt="" /> '.$this->l('Slider configuration').'</legend>';
		/* Begin form */
		$this->_html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">';
		/* Height field */
		$this->_html .= '
			<label>'.$this->l('Height:').'</label>
			<div class="margin-form">
				<input type="text" name="NNHOMESLIDER_HEIGHT" id="speed" size="3" value="'.Tools::safeOutput(Configuration::get('NNHOMESLIDER_HEIGHT')).'" /> px
			</div>';
		/* Width field */
		$this->_html .= '
		<label>'.$this->l('Width:').'</label>
		<div class="margin-form">
			<input type="text" name="NNHOMESLIDER_WIDTH" id="pause" size="3" value="'.Tools::safeOutput(Configuration::get('NNHOMESLIDER_WIDTH')).'" /> px
		</div>';
		/* Speed field */
		$this->_html .= '
			<label>'.$this->l('Speed:').'</label>
			<div class="margin-form">
				<input type="text" name="NNHOMESLIDER_SPEED" id="speed" size="3" value="'.Tools::safeOutput(Configuration::get('NNHOMESLIDER_SPEED')).'" /> ms
			</div>';
		/* Pause field */
		$this->_html .= '
		<label>'.$this->l('Pause:').'</label>
		<div class="margin-form">
			<input type="text" name="NNHOMESLIDER_PAUSE" id="pause" size="3" value="'.Tools::safeOutput(Configuration::get('NNHOMESLIDER_PAUSE')).'" /> ms
		</div>';
		/* Loop field */
		$this->_html .= '
		<label for="loop_on">'.$this->l('Loop:').'</label>
		<div class="margin-form">
			<img src="../img/admin/enabled.gif" alt="Yes" title="Yes" />
			<input type="radio" name="NNHOMESLIDER_LOOP" id="loop_on" '.(Configuration::get('NNHOMESLIDER_LOOP') == 1 ? 'checked="checked"' : '').' value="1" />
			<label class="t" for="loop_on">'.$this->l('Yes').'</label>
			<img src="../img/admin/disabled.gif" alt="No" title="No" style="margin-left: 10px;" />
			<input type="radio" name="NNHOMESLIDER_LOOP" id="loop_off" '.(Configuration::get('NNHOMESLIDER_LOOP') == 0 ? 'checked="checked" ' : '').' value="0" />
			<label class="t" for="loop_off">'.$this->l('No').'</label>
		</div>';
		/* Save */
		$this->_html .= '
		<div class="margin-form">
			<input type="submit" class="button" name="submitSlider" value="'.$this->l('Save').'" />
		</div>';
		/* End form */
		$this->_html .= '</form>';
		/* End fieldset slider */
		$this->_html .= '</fieldset>';

		$this->_html .= '<br /><br />';

		/* Begin fieldset slides */
		$this->_html .= '
		<fieldset>
			<legend><img src="'._PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/logo.gif" alt="" /> '.$this->l('Slides configuration').'</legend>
			<strong>
				<a href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&addSlide">
					<img src="'._PS_ADMIN_IMG_.'add.gif" alt="" /> '.$this->l('Add Slide').'
				</a>
			</strong>';

		/* Display notice if there are no slides yet */
		if (!$slides)
			$this->_html .= '<p style="margin-left: 40px;">'.$this->l('You have not yet added any slides.').'</p>';
		else /* Display slides */
		{
			$this->_html .= '
			<div id="slidesContent" style="width: 400px; margin-top: 30px;">
				<ul id="slides">';

			foreach ($slides as $slide)
			{
				$this->_html .= '
					<li id="slides_'.$slide['id_slide'].'">
						<strong>#'.$slide['id_slide'].'</strong> '.$slide['title'].'
						<p style="float: right">'.
							$this->displayStatus($slide['id_slide'], $slide['active']).'
							<a href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&id_slide='.(int)($slide['id_slide']).'" title="'.$this->l('Edit').'"><img src="'._PS_ADMIN_IMG_.'edit.gif" alt="" /></a>
							<a href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&delete_id_slide='.(int)($slide['id_slide']).'" title="'.$this->l('Delete').'"><img src="'._PS_ADMIN_IMG_.'delete.gif" alt="" /></a>
						</p>
					</li>';
			}
			$this->_html .= '</ul></div>';
		}
		// End fieldset
		$this->_html .= '</fieldset>';
	}

	private function _displayAddForm()
	{
		/* Sets Slide : depends if edited or added */
		$slide = null;
		if (Tools::isSubmit('id_slide') && $this->slideExists((int)Tools::getValue('id_slide')))
			$slide = new nnHomeSlide((int)Tools::getValue('id_slide'));
		/* Checks if directory is writable */
		if (!is_writable('.'))
			$this->adminDisplayWarning(sprintf($this->l('Modules %s must be writable (CHMOD 755 / 777)'), $this->name));

		/* Gets languages and sets which div requires translations */
		$id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');
		$languages = Language::getLanguages(false);
		$divLangName = 'image¤title¤url¤legend¤description';
		$this->_html .= '<script type="text/javascript">id_language = Number('.$id_lang_default.');</script>';


		/* ACO: Init tiny mce */
		$iso = $this->context->language->iso_code;
		$this->_html .= '
			<script type="text/javascript">	
				var iso = \''.(file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en').'\' ;
				var pathCSS = \''._THEME_CSS_DIR_.'\' ;
				var ad = \''.dirname($_SERVER['PHP_SELF']).'\' ;
			</script>
			<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
			<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>
			<script language="javascript" type="text/javascript">
				id_language = Number('.$id_lang_default.');
				tinySetup();
			</script>';

		/* Form */
		$this->_html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" enctype="multipart/form-data">';

		/* Fieldset Upload */
		$this->_html .= '
		<fieldset class="width3">
			<br />
			<legend><img src="'._PS_ADMIN_IMG_.'add.gif" alt="" />1 - '.$this->l('Upload your slide').'</legend>';
		/* Image */
		$this->_html .= '<label>'.$this->l('Select a file:').' * </label><div class="margin-form">';
		/* ACO: instead of images - use scene
		foreach ($languages as $language)
		{
			$this->_html .= '<div id="image_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">';
			$this->_html .= '<input type="file" name="image_'.$language['id_lang'].'" id="image_'.$language['id_lang'].'" size="30" value="'.(isset($slide->image[$language['id_lang']]) ? $slide->image[$language['id_lang']] : '').'"/>';
			/* Sets image as hidden in case it does not change */
		/*
			if ($slide && $slide->image[$language['id_lang']])
				$this->_html .= '<input type="hidden" name="image_old_'.$language['id_lang'].'" value="'.($slide->image[$language['id_lang']]).'" id="image_old_'.$language['id_lang'].'" />';
			/* Display image */
		/*
			if ($slide && $slide->image[$language['id_lang']])
				// ACO: $this->_html .= '<input type="hidden" name="has_picture" value="1" /><img src="'.__PS_BASE_URI__.'modules/'.$this->name.'/images/'.$slide->image[$language['id_lang']].'" width="'.(Configuration::get('NNHOMESLIDER_WIDTH')/2).'" height="'.(Configuration::get('NNHOMESLIDER_HEIGHT')/2).'" alt=""/>';
				$this->_html .= '<input type="hidden" name="has_picture" value="1" /><img src="'.$slide->image_link[$language['id_lang']].'" width="'.(Configuration::get('NNHOMESLIDER_WIDTH')/2).'" height="'.(Configuration::get('NNHOMESLIDER_HEIGHT')/2).'" alt=""/>';
			$this->_html .= '</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'image', true);
		*/
		$this->_html .= '<div style="display:block; float: left;">';
		$this->_html .= '<input type="file" name="image" id="image" size="30" value="'.($slide ? $slide->id : '').'"/>';
		/* Sets image as hidden in case it does not change */
		if ($slide)
			$this->_html .= '<input type="hidden" name="image_old" value="'.($slide->id).'" id="image_old" />';
		/* Display image */
		if ($slide && $slide->getScene())
			$this->_html .= '
				<input type="hidden" name="has_picture" value="1" />
				<img id="large_scene_image" alt="" src="'._THEME_SCENE_DIR_.$slide->getScene()->id.'-scene_default.jpg?rand='.(int)rand().'" />
			';
		/*<img src="'.__PS_BASE_URI__.'modules/'.$this->name.'/images/'.$slide->image.'" width="'.(Configuration::get('NNHOMESLIDER_WIDTH')/2).'" height="'.(Configuration::get('NNHOMESLIDER_HEIGHT')/2).'" alt=""/>
		*/

		$this->_html .= '</div>';


		/* End Fieldset Upload */
		$this->_html .= '</fieldset><br /><br />';

		/* Fieldset edit/add */
		$this->_html .= '<fieldset class="width3">';
		if (Tools::isSubmit('addSlide')) /* Configure legend */
			$this->_html .= '<legend><img src="'._PS_ADMIN_IMG_.'add.gif" alt="" /> 2 - '.$this->l('Configure your slide').'</legend>';
		elseif (Tools::isSubmit('id_slide')) /* Edit legend */
			$this->_html .= '<legend><img src="'._PS_BASE_URL_.__PS_BASE_URI__.'modules/'.$this->name.'/logo.gif" alt="" /> 2 - '.$this->l('Edit your slide').'</legend>';
		/* Sets id slide as hidden */
		if ($slide && Tools::getValue('id_slide'))
			$this->_html .= '<input type="hidden" name="id_slide" value="'.$slide->id.'" id="id_slide" />';
		/* Sets position as hidden */
		$this->_html .= '<input type="hidden" name="position" value="'.(($slide != null) ? ($slide->position) : ($this->getNextPosition())).'" id="position" />';

		/* Form content */

		/* Title */
		$this->_html .= '<br /><label>'.$this->l('Title:').' * </label><div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '
					<div id="title_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
						<input type="text" name="title_'.$language['id_lang'].'" id="title_'.$language['id_lang'].'" size="30" value="'.(isset($slide->title[$language['id_lang']]) ? $slide->title[$language['id_lang']] : '').'"/>
					</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'title', true);
		$this->_html .= '</div><br /><br />';

		/* Subtitle */
		$this->_html .= '
		<label>'.$this->l('Subtitle:').' </label>
		<div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '<div id="subtitle_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
				<textarea name="subtitle_'.$language['id_lang'].'" rows="10" cols="29">'.(isset($slide->description[$language['id_lang']]) ? $slide->subtitle[$language['id_lang']] : '').'</textarea>
			</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'subtitle', true);
		$this->_html .= '</div><div class="clear"></div><br />';

		/* Paragraph */
		$this->_html .= '
		<label>'.$this->l('Paragraph:').' </label>
		<div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '<div id="paragraph_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
				<textarea class="rte" name="paragraph_'.$language['id_lang'].'" rows="25" cols="120">'.(isset($slide->paragraph[$language['id_lang']]) ? $slide->paragraph[$language['id_lang']] : '').'</textarea>
			</div>';
/*			stripslashes(htmlspecialchars($slide->paragraph[$language['id_lang']] : '') */
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'paragraph', true);
		$this->_html .= '</div><div class="clear"></div><br />';

		/* URL */
		$this->_html .= '<label>'.$this->l('URL:').' * </label><div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '
					<div id="url_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
						<input type="text" name="url_'.$language['id_lang'].'" id="url_'.$language['id_lang'].'" size="30" value="'.(isset($slide->url[$language['id_lang']]) ? $slide->url[$language['id_lang']] : '').'"/>
					</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'url', true);
		$this->_html .= '</div><br /><br />';

		/* Legend */
		$this->_html .= '<label>'.$this->l('Legend:').' * </label><div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '
					<div id="legend_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
						<input type="text" name="legend_'.$language['id_lang'].'" id="legend_'.$language['id_lang'].'" size="30" value="'.(isset($slide->legend[$language['id_lang']]) ? $slide->legend[$language['id_lang']] : '').'"/>
					</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'legend', true);
		$this->_html .= '</div><br /><br />';

		/* Description */
		$this->_html .= '
		<label>'.$this->l('Description:').' </label>
		<div class="margin-form">';
		foreach ($languages as $language)
		{
			$this->_html .= '<div id="description_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang_default ? 'block' : 'none').';float: left;">
				<textarea name="description_'.$language['id_lang'].'" rows="10" cols="29">'.(isset($slide->description[$language['id_lang']]) ? $slide->description[$language['id_lang']] : '').'</textarea>
			</div>';
		}
		$this->_html .= $this->displayFlags($languages, $id_lang_default, $divLangName, 'description', true);
		$this->_html .= '</div><div class="clear"></div><br />';

		/* Active */
		$this->_html .= '
		<label for="active_on">'.$this->l('Active:').'</label>
		<div class="margin-form">
			<img src="../img/admin/enabled.gif" alt="Yes" title="Yes" />
			<input type="radio" name="active_slide" id="active_on" '.(($slide && (isset($slide->active) && (int)$slide->active == 0)) ? '' : 'checked="checked" ').' value="1" />
			<label class="t" for="active_on">'.$this->l('Yes').'</label>
			<img src="../img/admin/disabled.gif" alt="No" title="No" style="margin-left: 10px;" />
			<input type="radio" name="active_slide" id="active_off" '.(($slide && (isset($slide->active) && (int)$slide->active == 0)) ? 'checked="checked" ' : '').' value="0" />
			<label class="t" for="active_off">'.$this->l('No').'</label>
		</div>';

		/* Save */
		$this->_html .= '
		<p class="center">
			<input style="min-height:26px" type="submit" class="button" name="submitSlide" value="'.$this->l('Save').'" />
			<a class="button" style="position:relative; padding:4px 3px;" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'">'.$this->l('Cancel').'</a>
		</p>';

		/* End of fieldset & form */
		$this->_html .= '
			<p>*'.$this->l('Required fields').'</p>
			</fieldset>
		</form>';
	}

	private function _postValidation()
	{
		$errors = array();

		/* Validation for Slider configuration */
		if (Tools::isSubmit('submitSlider'))
		{
			if (!Validate::isInt(Tools::getValue('NNHOMESLIDER_SPEED')) || !Validate::isInt(Tools::getValue('NNHOMESLIDER_PAUSE')) ||
				!Validate::isInt(Tools::getValue('NNHOMESLIDER_WIDTH')) || !Validate::isInt(Tools::getValue('NNHOMESLIDER_HEIGHT')))
					$errors[] = $this->l('Invalid values');
		} /* Validation for status */
		elseif (Tools::isSubmit('changeStatus'))
		{
			if (!Validate::isInt(Tools::getValue('id_slide')))
				$errors[] = $this->l('Invalid slide');
		}
		/* Validation for Slide */
		elseif (Tools::isSubmit('submitSlide'))
		{
			/* Checks state (active) */
			if (!Validate::isInt(Tools::getValue('active_slide')) || (Tools::getValue('active_slide') != 0 && Tools::getValue('active_slide') != 1))
				$errors[] = $this->l('Invalid slide state');
			/* Checks position */
			if (!Validate::isInt(Tools::getValue('position')) || (Tools::getValue('position') < 0))
				$errors[] = $this->l('Invalid slide position');
			/* If edit : checks id_slide */
			if (Tools::isSubmit('id_slide'))
			{
				if (!Validate::isInt(Tools::getValue('id_slide')) && !$this->slideExists(Tools::getValue('id_slide')))
					$errors[] = $this->l('Invalid id_slide');
			}
			/* Checks title/url/legend/description/image */
			$languages = Language::getLanguages(false);
			foreach ($languages as $language)
			{
				if (Tools::strlen(Tools::getValue('title_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The title is too long.');
				if (Tools::strlen(Tools::getValue('legend_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The legend is too long.');
				if (Tools::strlen(Tools::getValue('url_'.$language['id_lang'])) > 255)
					$errors[] = $this->l('The URL is too long.');
				if (Tools::strlen(Tools::getValue('description_'.$language['id_lang'])) > 4000)
					$errors[] = $this->l('The description is too long.');
				if (Tools::strlen(Tools::getValue('url_'.$language['id_lang'])) > 0 && !Validate::isUrl(Tools::getValue('url_'.$language['id_lang'])))
					$errors[] = $this->l('The URL format is not correct.');
			}

			/* Checks title/url/legend/description for default lang */
			$id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');
			if (Tools::strlen(Tools::getValue('title_'.$id_lang_default)) == 0)
				$errors[] = $this->l('The title is not set.');
			if (Tools::strlen(Tools::getValue('legend_'.$id_lang_default)) == 0)
				$errors[] = $this->l('The legend is not set.');
			if (Tools::strlen(Tools::getValue('url_'.$id_lang_default)) == 0)
				$errors[] = $this->l('The URL is not set.');

/*
			if (Tools::getValue('image') != null && !Validate::isFileName(Tools::getValue('image')))
				$errors[] = $this->l('Invalid filename for image');
			if (Tools::getValue('image_old') != null && !Validate::isFileName(Tools::getValue('image_old')))
				$errors[] = $this->l('Invalid filename for image_old');
*/
			if (!Tools::isSubmit('has_picture') && (!isset($_FILES['image']) || empty($_FILES['image']['tmp_name'])))
				$errors[] = $this->l('The image is not set.');
/*
			if (Tools::getValue('image_old') && !Validate::isFileName(Tools::getValue('image_old')))
				$errors[] = $this->l('The image_old is not set.');
*/

		} /* Validation for deletion */
		elseif (Tools::isSubmit('delete_id_slide') && (!Validate::isInt(Tools::getValue('delete_id_slide')) || !$this->slideExists((int)Tools::getValue('delete_id_slide'))))
			$errors[] = $this->l('Invalid id_slide');

		/* Display errors if needed */
		if (count($errors))
		{
			$this->_html .= $this->displayError(implode('<br />', $errors));
			return false;
		}

		/* Returns if validation is ok */
		return true;
	}

	private function _postProcess()
	{
		$errors = array();

		/* Processes Slider */
		if (Tools::isSubmit('submitSlider'))
		{
			$res = Configuration::updateValue('NNHOMESLIDER_WIDTH', (int)Tools::getValue('NNHOMESLIDER_WIDTH'));
			$res &= Configuration::updateValue('NNHOMESLIDER_HEIGHT', (int)Tools::getValue('NNHOMESLIDER_HEIGHT'));
			$res &= Configuration::updateValue('NNHOMESLIDER_SPEED', (int)Tools::getValue('NNHOMESLIDER_SPEED'));
			$res &= Configuration::updateValue('NNHOMESLIDER_PAUSE', (int)Tools::getValue('NNHOMESLIDER_PAUSE'));
			$res &= Configuration::updateValue('NNHOMESLIDER_LOOP', (int)Tools::getValue('NNHOMESLIDER_LOOP'));
			$this->clearCache();			
			if (!$res)
				$errors[] = $this->displayError($this->l('The configuration could not be updated.'));
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		} /* Process Slide status */
		elseif (Tools::isSubmit('changeStatus') && Tools::isSubmit('id_slide'))
		{
			$slide = new nnHomeSlide((int)Tools::getValue('id_slide'));
			if ($slide->active == 0)
				$slide->active = 1;
			else
				$slide->active = 0;
			$res = $slide->update();
			$this->clearCache();
			$this->_html .= ($res ? $this->displayConfirmation($this->l('Configuration updated')) : $this->displayError($this->l('The configuration could not be updated.')));
		}
		/* Processes Slide */
		elseif (Tools::isSubmit('submitSlide'))
		{
			/* Sets ID if needed */
			if (Tools::getValue('id_slide'))
			{
				$slide = new nnHomeSlide((int)Tools::getValue('id_slide'));
				if (!Validate::isLoadedObject($slide))
				{
					$this->_html .= $this->displayError($this->l('Invalid id_slide'));
					return;
				}
			}
			else
				$slide = new nnHomeSlide();

			/* Sets position */
			$slide->position = (int)Tools::getValue('position');
			/* Sets active */
			$slide->active = (int)Tools::getValue('active_slide');

			/* Sets each langue fields */
			$languages = Language::getLanguages(false);
			foreach ($languages as $language)
			{
				$slide->title[$language['id_lang']] = Tools::getValue('title_'.$language['id_lang']);
				$slide->subtitle[$language['id_lang']] = Tools::getValue('subtitle_'.$language['id_lang']);
				$slide->paragraph[$language['id_lang']] = Tools::getValue('paragraph_'.$language['id_lang']);

				$slide->url[$language['id_lang']] = Tools::getValue('url_'.$language['id_lang']);
				$slide->legend[$language['id_lang']] = Tools::getValue('legend_'.$language['id_lang']);
				$slide->description[$language['id_lang']] = Tools::getValue('description_'.$language['id_lang']);
			}

			/* Processes if no errors  */
			if (!$errors)
			{
				/* Adds */
				if (!Tools::getValue('id_slide'))
				{
					if (!$slide->add())
						$errors[] = $this->displayError($this->l('The slide could not be added.'));
				}
				/* Update */
				elseif (!$slide->update())
					$errors[] = $this->displayError($this->l('The slide could not be updated.'));
				$this->clearCache();
			}

			/* Save the scene in case picture has changed */
			if (!$errors)
			{
				/* Uploads image and sets slide */
				$imagesize = array();
				$imagesize = @getimagesize($_FILES['image']['tmp_name']);
				$type = strtolower(substr(strrchr($_FILES['image']['name'], '.'), 1));
				if (isset($_FILES['image']) &&
					isset($_FILES['image']['tmp_name']) &&
					!empty($_FILES['image']['tmp_name']) &&
					!empty($imagesize) &&
					in_array(strtolower(substr(strrchr($imagesize['mime'], '/'), 1)), array('jpg', 'gif', 'jpeg', 'png')) &&
					in_array($type, array('jpg', 'gif', 'jpeg', 'png')))
				{
					$this->uploadImage($slide->getScene(), 'image', 'scenes/', $type );
				}
			}

		} /* Deletes */
		elseif (Tools::isSubmit('delete_id_slide'))
		{
			$slide = new nnHomeSlide((int)Tools::getValue('delete_id_slide'));
			$res = $slide->delete();
			$this->clearCache();
			if (!$res)
				$this->_html .= $this->displayError('Could not delete');
			else
				$this->_html .= $this->displayConfirmation($this->l('Slide deleted'));
		}

		/* Display errors if needed */
		if (count($errors))
			$this->_html .= $this->displayError(implode('<br />', $errors));
		elseif (Tools::isSubmit('submitSlide') && Tools::getValue('id_slide'))
			$this->_html .= $this->displayConfirmation($this->l('Slide updated'));
		elseif (Tools::isSubmit('submitSlide'))
			$this->_html .= $this->displayConfirmation($this->l('Slide added'));
	}

	private function _prepareHook()
	{
		if (!$this->isCached('nnhomeslider.tpl', $this->getCacheId()))
		{
			$slider = array(
				'width' => Configuration::get('NNHOMESLIDER_WIDTH'),
				'height' => Configuration::get('NNHOMESLIDER_HEIGHT'),
				'speed' => Configuration::get('NNHOMESLIDER_SPEED'),
				'pause' => Configuration::get('NNHOMESLIDER_PAUSE'),
				'loop' => Configuration::get('NNHOMESLIDER_LOOP'),
			);

			$slides = $this->getSlides(true);
			if (!$slides)
				return false;

			$this->smarty->assign('homeslider_slides', $slides);
			$this->smarty->assign('homeslider', $slider);
		}

		return true;
	}

	public function hookDisplayHome()
	{
		if(!$this->_prepareHook())
			return;

		// Check if not a mobile theme
		if ($this->context->getMobileDevice() != false)
			return false;

		/* $this->context->controller->addJS($this->_path.'js/jquery.bxSlider.min.js');
		$this->context->controller->addCSS($this->_path.'bx_styles.css');
		$this->context->controller->addJS($this->_path.'js/homeslider.js');
		$this->context->controller->addJS($this->_path.'js/homeslider.js')
		*/
		return $this->display(__FILE__, 'nnhomeslider.tpl', $this->getCacheId());
	}

	public function clearCache()
	{
		$this->_clearCache('nnhomeslider.tpl');
	}

	public function hookActionShopDataDuplication($params)
	{
		nnHomeSlide::shopDataDuplication((int)$params['new_id_shop'],(int)$params['old_id_shop']);
		$this->clearCache();
	}

	public function headerHTML()
	{
		if (Tools::getValue('controller') != 'AdminModules' && Tools::getValue('configure') != $this->name)
			return;

		$this->context->controller->addJqueryUI('ui.sortable');
		/* Style & js for fieldset 'slides configuration' */
		$html = '
		<style>
		#slides li {
			list-style: none;
			margin: 0 0 4px 0;
			padding: 10px;
			background-color: #F4E6C9;
			border: #CCCCCC solid 1px;
			color:#000;
		}
		</style>
		
		<script type="text/javascript">
			$(function() {
				var $mySlides = $("#slides");
				$mySlides.sortable({
					opacity: 0.6,
					cursor: "move",
					update: function() {
						var order = $(this).sortable("serialize") + "&action=updateSlidesPosition";
						$.post("'.$this->context->shop->physical_uri.$this->context->shop->virtual_uri.'modules/'.$this->name.'/ajax_'.$this->name.'.php?secure_key='.$this->secure_key.'", order);
						}
					});
				$mySlides.hover(function() {
					$(this).css("cursor","move");
					},
					function() {
					$(this).css("cursor","auto");
				});
			});
		</script>';

		return $html;
	}

	public function getNextPosition()
	{
		return nnHomeSlide::getNextPosition();
	}

	public function getSlides($active = null)
	{
		return nnHomeSlide::getSlides($active);
	}

	public function displayStatus($id_slide, $active)
	{
		$title = ((int)$active == 0 ? $this->l('Disabled') : $this->l('Enabled'));
		$img = ((int)$active == 0 ? 'disabled.gif' : 'enabled.gif');
		$html = '<a href="'.AdminController::$currentIndex.
				'&configure='.$this->name.'
				&token='.Tools::getAdminTokenLite('AdminModules').'
				&changeStatus&id_slide='.(int)$id_slide.'" title="'.$title.'"><img src="'._PS_ADMIN_IMG_.''.$img.'" alt="" /></a>';
		return $html;
	}

	public function slideExists($id_slide)
	{
		return nnHomeSlide::slideExists($id_slide);
	}

	protected function uploadImage($scene, $name, $dir, $ext = false, $width = null, $height = null)
	{
		$object = $scene;
		$id = $scene->id;
		$imageType = 'jpg';
		$errors = array();

		if (isset($_FILES['image']['tmp_name']) && !empty($_FILES['image']['tmp_name']))
		{
			// Delete old image
			if (Validate::isLoadedObject($object))
				$object->deleteImage();
			else
				return false;

			// Check image validity
			$max_size = isset($this->max_image_size) ? $this->max_image_size : 0;
			if ($error = ImageManager::validateUpload($_FILES[$name], Tools::getMaxUploadSize($max_size)))
				$errors[] = $error;

			$tmp_name = tempnam(_PS_TMP_IMG_DIR_, 'PS');
			if (!$tmp_name)
				return false;

			if (!move_uploaded_file($_FILES[$name]['tmp_name'], $tmp_name))
				return false;

			// Evaluate the memory required to resize the image: if it's too much, you can't resize it.
			if (!ImageManager::checkImageMemoryLimit($tmp_name))
				$errors[] = Tools::displayError('Due to memory limit restrictions, this image cannot be loaded. Please increase your memory_limit value via your server\'s configuration settings. ');

			// Copy new image
			if (empty($errors) && !ImageManager::resize($tmp_name, _PS_IMG_DIR_.$dir.$id.'.'.$imageType, (int)$width, (int)$height, ($ext ? $ext : $imageType)))
				$errors[] = Tools::displayError('An error occurred while uploading the image.');


			/* Display errors if needed */
			if (count($errors))
			{
				$this->_html .= $this->displayError(implode('<br />', $errors));
				return false;
			}

			if ($this->afterImageUpload($scene))
			{
				unlink($tmp_name);
				return true;
			}
			return false;
		}
		return true;
	}

	protected function afterImageUpload($scene)
	{
		$obj = $scene;

		if ($obj->id && (isset($_FILES['image']) || isset($_FILES['thumb'])))
		{
			$base_img_path = _PS_SCENE_IMG_DIR_.$obj->id.'.jpg';
			$images_types = ImageType::getImagesTypes('scenes');

			foreach ($images_types as $k => $image_type)
			{						
				if ($image_type['name'] == 'scene_default' AND isset($_FILES['image']) AND isset($_FILES['image']['tmp_name']) AND !$_FILES['image']['error'])				
					ImageManager::resize(
						$base_img_path,
						_PS_SCENE_IMG_DIR_.$obj->id.'-'.stripslashes($image_type['name']).'.jpg',
						(int)$image_type['width'],
						(int)$image_type['height']);					
				else if ($image_type['name'] == 'm_scene_default')
				{				
					if (isset($_FILES['thumb']) && !$_FILES['thumb']['error'])
						$base_thumb_path = _PS_SCENE_THUMB_IMG_DIR_.$obj->id.'.jpg';
					else
						$base_thumb_path = $base_img_path;
					ImageManager::resize(
						$base_thumb_path,
						_PS_SCENE_THUMB_IMG_DIR_.$obj->id.'-'.stripslashes($image_type['name']).'.jpg',
						(int)$image_type['width'],
						(int)$image_type['height']);
				}
			}
		}

		return true;
	}





}
