(function() {

    if ('undefined' === typeof COMMENT) {
        COMMENT = {};
    }

    /**
     * Clear comment form
     */
    function _clearCommentForm() {
        $('#id_new_comment_form').trigger("reset");
        $('#content').value = '';
        $('#commentCustomerName').value = '';
        $('.star[value="3"]').checked = true;
        $('.star[value="3"]').trigger("click");
        $('#new_comment_form_error ul').empty();
    }

    /** 
     * Vote for a comment
     */
    function _onCommentVote(e) {
        // Kill default behaviour
        e.preventDefault();

        var id_product_comment = $(this).data('id-product-comment');
        var is_usefull = $(this).data('is-usefull');
        var parent = $(this).parent();

        $.ajax({
            url: productcomments_controller_url + '?rand=' + new Date().getTime(),
            data: {
                id_product_comment: id_product_comment,
                action: 'comment_is_usefull',
                value: is_usefull
            },
            type: 'POST',
            headers: {
                "cache-control": "no-cache"
            },
            success: function(result) {
                parent.fadeOut('slow', function() {
                    parent.remove();
                });
            }
        });
    }

    /**
     * When reporting a comment
     */
    function _onCommentReport(e) {
        // Kill default behaviour
        e.preventDefault();

        if (confirm(confirm_report_message)) {
            var idProductComment = $(this).data('id-product-comment');
            var parent = $(this).parent();

            $.ajax({
                url: productcomments_controller_url + '?rand=' + new Date().getTime(),
                data: {
                    id_product_comment: idProductComment,
                    action: 'report_abuse'
                },
                type: 'POST',
                headers: {
                    "cache-control": "no-cache"
                },
                success: function(result) {
                    parent.fadeOut('slow', function() {
                        parent.remove();
                    });
                }
            });
        }
    }

    /**
     * New message
     */
    function _onNewMessage(e) {
        // Kill default behaviour
        e.preventDefault();

        // Form element
        url_options = parseInt(productcomments_url_rewrite) ? '?' : '&';
        $.ajax({
            url: productcomments_controller_url + url_options + 'action=add_comment&secure_key=' + secure_key + '&rand=' + new Date().getTime(),
            data: $('#id_new_comment_form').serialize(),
            type: 'POST',
            headers: {
                "cache-control": "no-cache"
            },
            dataType: "json",
            success: function(data) {
                if (data.result) {
                    var $modal = $('#new_comment_modal');
                    $modal.on('hide.bs.modal', function(e) {
                        _clearCommentForm();
                        window.location.reload();
                    })
                    $modal.modal('show');
                } else {
                    //console.log('Error');
                    $('#new_comment_form_error ul').html('');
                    $.each(data.errors, function(index, value) {
                        $('#new_comment_form_error ul').append('<li>' + value + '</li>');
                    });
                    $('#new_comment_form_error').slideDown('slow');
                }
            },
            error: function(xhr, text, error) {
                console.log(text);
            }
        });
        return false;
    }

    COMMENT.init = function() {

        /* Transform input radio control into star control */
        $('input[type=radio].star').rating();

        /* Register a callback to vote for a comment */
        $('.js-comment-vote').click(_onCommentVote);

        /* Register a callback to report a comment */
        $('.js-comment-report').click(_onCommentReport);

        /* Register a callback to submit a new message */
        $('#submitNewMessage').click(_onNewMessage);
    };

})();