<?php
/* 
 * Noir Ô Naturel, simple module to customize how product description is displayed
 *
 * As of standard, it is displayed in a single tab, this hook will split the 
 * description into three separate values, using H2 paragraphs as splitter 
 * It then fills the smarty env with those three values for display as separate 
 * tabs.     
 *
 * The same could probably be achieved using smarty coding directly, 
 * however I don't know smarty. 
 *  
 */

if (!defined('_PS_VERSION_'))
	exit;
	
class nnProductDescription extends Module
{
    public function __construct()
    {
        $this->name = 'nnproductdescription';
        $this->tab = 'front_office_features';
        $this->version = 1.0;
        $this->author = 'Noir Ô Naturel';
        $this->need_instance = 0;
        // Override for development
        $this->is_configurable = 0;

        parent::__construct();
        
        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('N&N : Product Description');
        $this->description = $this->l('Allow splitting product description according to H2');

        $this->_initialized = false;

    }
    
    /**
     * Module installation (i.e. called when cliking on install button in administration/module tab
     */
    function install()
    {
    
        // Proceed with standard installation
        if (
          // Parent installation
          !parent::install() 
        
          // Hook registration on product page
          || !$this->registerHook('displayProduct_3')
          || !$this->registerHook('header')
          
        )
        return false;

        return true;
    }
        
    /**
     * Called when deinstalling the module, reverse installation
     */     
    public function uninstall()
    {
        if (!parent::uninstall()) 
        return false;
    
        return true;
    }

    /**
     * Init content
     */
    public function initContent() 
    {
        if ($this->_initialized) {
            return;
        }

        global $smarty;
        
        // Check if product was assigned to smarty
        // if not useless to proceed as product is not available for display
        $product = $smarty->getTemplateVars('product');

        if (isset($product) && isset($product->description)) {

            // Split according to Header H2 
            $tab = preg_split ( 
                '/(<[h|H]2>.*<\/[h|H]2>)/' ,    // pattern 
                $product->description , // string to split
                $limit = 4, // nb delimiters => 3      
                PREG_SPLIT_DELIM_CAPTURE // include delimiter 
            );
            // $tab should contain in full : text part, first h2, text part, second h2, text part, third h2, rest of description
            // however h2 content is not kept, that explains the following manipulations
            $nb = count($tab);
            $vars['nn_description_1'] = ( $nb > 2 ? $tab[2] : $product->description );
            if ($nb > 3) {
                $vars['nn_description_2'] = ( $nb > 4 ? $tab[4] : $tab[3] );
                if ($nb > 5) {
                    $vars['nn_description_3'] = ( $nb > 6 ? $tab[6] : $tab[5] ); 
                }
            }
            
            $smarty->assign($vars);
        }

        $this->_initialized = true;

    }

    /**
     * Hook call
     */
    public function hookDisplayProduct_3($params)
    {
        $this->initContent();
        return ($this->display(__FILE__, '/nnProductDescription.tpl'));
    }
    
    /**
     *  Hook to include the style sheet
     */
    function hookHeader($params)
	{
        $this->context->controller->addCSS(($this->_path).'css/default.css', 'all');
	}

}
