<?php

class presta2expinet extends Module
{
		private $_postErrors = array();
		
	
	
	function __construct()
	{
		global $cookie;
		$this->_cookie = $cookie;
		$this->name = 'presta2expinet';
		$this->tab = 'export';
		$this->version = '1.2';
		
		/* The parent construct is required for translations */
		parent::__construct();
		
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Presta 2 Expeditor Inet');
		$this->description = $this->l('Export your orders to Expeditor Inet.');
		
		$this->_directory = dirname(__FILE__).'/';
		$this->_filename = $this->_directory.'export.csv';
		$this->_filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/presta2expinet/export.csv';
	
		
	}

	function install()
	{
		if (!Configuration::updateValue('VINUM_EXPINET_STATE_ENVOIE', 4) OR !parent::install() )
			return false;
		if (!Configuration::updateValue('VINUM_EXPINET_STATE_EXPORT', 3))
			return false;	
		if (!Configuration::updateValue('VINUM_EXPINET_CARRIERS', ''))
			return false;
		if (!$this->registerHook('adminOrder'))
			return false;
				
		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		
		$tab=new tab();
		$tab->name[$id_lang]= 'Expeditor Inet';
		$tab->class_name= 'AdminExpinet';	
		$tab->id_parent=Tab::getIdFromClassName('AdminOrders'); 
		$tab->add();	
			
		return true;
	}
	
	  function uninstall()
    {
        if (!parent::uninstall()
			OR !Configuration::deleteByName('VINUM_EXPINET_STATE_ENVOIE')
			OR !Configuration::deleteByName('VINUM_EXPINET_STATE_EXPORT')
			OR !Configuration::deleteByName('VINUM_EXPINET_CARRIERS')
		  )
			return false;
		$idtab=tab::getIdFromClassName('AdminExpinet');
		$tab=new tab($idtab);
		$tab->delete();	
		return true;	
    }
	
		private function _postValidation()
	{
		@unlink($this->_filename);
		$fp = fopen($this->_filename, 'wb');
		fclose($fp);
		if (!file_exists($this->_filename))
		{
		$this->_html .='<div class="warning confirm">
  				<img src="../img/admin/warning.gif" alt="" title="" />
  				'.$this->l('Cannot write').' '.realpath($this->_filename).'
  			</div>';
		}
	}
	
	private function _addToFeed($str)
	{
		if(file_exists($this->_filename))
		{
			$fp = fopen($this->_filename, 'ab');
			fwrite($fp, $str, strlen($str));
			fclose($fp);
		}
	}
	

	function getContent()
	{
	
		set_time_limit(0);
		
			if (!empty($_POST))
			{
			   	$this->_postValidation();
			}
				$this->_html = '<h2>'.$this->displayName.'</h2>';

			if (isset($_POST['submit']))
			{
			$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
			
				$carriers=$_POST['carrierBox'];
				$stateShipped=$_POST['shipped'];
				$stateExport=$_POST['stateExport'];
				$carriersString=implode(",", $carriers);
				Configuration::updateValue('VINUM_EXPINET_STATE_ENVOIE', $stateShipped);
				Configuration::updateValue('VINUM_EXPINET_STATE_EXPORT', $stateExport);
				Configuration::updateValue('VINUM_EXPINET_CARRIERS', $carriersString);
				
				$this->_html .= '<div class="conf confirm">
							<img src="../img/admin/ok.gif" alt="" title="" />
						  <p>'.$this->l('Your settings have been updated').'<br /><br /></div>';
					

					
			}	
	
			
			$this->_html.='
			<fieldset class="width3" style="width:900px;">
				
				
					
			</fieldset><br><br>';
			
				$this->_html.=$this->_displayForm();
	
			
			return $this->_html;
		
	
	}

	private function _displayForm()
	{
		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		$stateShipped = Configuration::get('VINUM_EXPINET_STATE_ENVOIE');
		$stateExport = Configuration::get('VINUM_EXPINET_STATE_EXPORT');
		$CarriersString= Configuration::get('VINUM_EXPINET_CARRIERS');
		$arrayCarriers=explode(",",$CarriersString);
		
		
	
		$form='
		<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
	  <form method="post">';
	  		$states=OrderState::getOrderStates($id_lang);
			
	  $form.='<label style="text-align: left">'.$this->l('Export State :').'</label>
					<div class="margin-form" style="margin-top:10px">
					<select id="stateExport" name="stateExport">';
					foreach($states as $state)
					{
						$form .='<option value='.$state['id_order_state'];
						if($state['id_order_state']==$stateExport)
						{
							$form .=' selected>'.$state['name'].'</option>';
						}
						else
						{
							$form .='>'.$state['name'].'</option>';
						}
					}
						$form .='</select>
						<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Select state for which the orders can be exported to Expeditor Inet. (By default:Preparation in progress)').'</p></div><br>';
	  
		$form.='<label style="text-align: left">'.$this->l('Shipped State :').'</label>
					<div class="margin-form" style="margin-top:10px">
					<select id="shipped" name="shipped">';
					foreach($states as $state)
					{
						$form .='<option value='.$state['id_order_state'];
						if($state['id_order_state']==$stateShipped)
						{
							$form .=' selected>'.$state['name'].'</option>';
						}
						else
						{
							$form .='>'.$state['name'].'</option>';
						}
					}
						$form .='</select>
					<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Select state for which the orders are shipped.(By default:Shipped)').'</p></div><br>';
			
				$carriers=Carrier::getCarriers($id_lang, true , false,false, NULL, ALL_CARRIERS);

					if (sizeof($carriers))
					{
						
					$form.='<center><label>'.$this->l('Carriers:').' </label></center>
					<table cellspacing="0" cellpadding="0" class="table" style="width: 29.5em;">
						<tr>
							<th><input type="checkbox" name="checkme" class="noborder" onclick="checkDelBoxes(this.form, \'carrierBox[]\', this.checked)" /></th>
							<th>'.$this->l('ID').'</th>
							<th>'.$this->l('Carrier name').'</th>
						</tr>';
						$irow = 0;
						
						foreach ($carriers as $carrier)
						{
							if(in_array($carrier['id_carrier'],$arrayCarriers))
							$checked=true;
							else
							$checked=false;
							
							$form.='<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">';
							if($checked)
							{
							$form.='<td>'.'<input type="checkbox" name="carrierBox[]" class="carrierBox" id="carrierBox_'.$carrier['id_carrier'].'" value="'.$carrier['id_carrier'].'" checked='.$checked.' /></td>
								<td>'.$carrier['id_carrier'].'</td>
								<td><label for="carrierBox_'.$carrier['id_carrier'].'" class="t">'.$carrier['name'].'</label></td>';
							}	
							else
							{
							$form.='<td>'.'<input type="checkbox" name="carrierBox[]" class="carrierBox" id="carrierBox_'.$carrier['id_carrier'].'" value="'.$carrier['id_carrier'].'" /></td>
								<td>'.$carrier['id_carrier'].'</td>
								<td><label for="carrierBox_'.$carrier['id_carrier'].'" class="t">'.$carrier['name'].'</label></td>';
						
							}
							$form.='</tr>';
						}
						
					$form.='</table><div class="margin-form" style="margin-top:10px">
					<p style="padding:0px; margin:10px 0px 10px 0px;">'.$this->l('Check all carriers you want to link to Expeditor Inet').'</p>
					</div>';
					} else
						$form.='<p>'.$this->l('No carrier created').'</p>';
					  	
		    $form.='  <center><input type="submit" name="submit" value="'.$this->l('Submit').'" /><br><br>';
	
		$form.='</form></fieldset>';
		
		return $form;
	
	}
 function hookAdminOrder($params)
 {
 $filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'modules/presta2expinet/export.csv';
 $orderInfo=new Order($params['id_order']);
 $weight=Tools::ps_round($orderInfo->getTotalWeight(),2);
 
		$display='
<br /><fieldset style="width: 400px">
			<legend><img src="../modules/'.$this->name.'/modem.png" /> '.$this->l('Export Order To Expeditor Inet').'</legend>
	
	<script language="JavaScript">
    <!--
	function getXMLHttpRequest()
					{
						var xhr = null;
	
						if (window.XMLHttpRequest || window.ActiveXObject)
						{
							if (window.ActiveXObject) 
							{
								try
								{
									xhr = new ActiveXObject("Msxml2.XMLHTTP");
								} catch(e)
								{
									xhr = new ActiveXObject("Microsoft.XMLHTTP");
								}
							} else 
							{
								xhr = new XMLHttpRequest(); 
							}
						} 
						else
						{
							alert("Votre navigateur ne supporte pas l\'objet XMLHTTPRequest...");
							return null;
						}
	
						return xhr;
					}
		
    function request(callback) {

	var xhr = getXMLHttpRequest();
	
	
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && (xhr.status == 200 || xhr.status == 0)) {
		
			callback(xhr.responseText);
			document.getElementById("loader").style.display = "none";
		}
		else if (xhr.readyState < 4)
		{
			document.getElementById("loader").style.display = "inline";
		}
	};
	with(document.myForm) 
	{
		newweight=(weight.value).replace(",",".");
		size="N";
		if(sizeBox.checked)
		size="O";
			
	}	
	
	xhr.open("GET", "../modules/presta2expinet/oneOrderExport.php?id_order='.$params["id_order"].'&weight="+newweight+"&size="+size, true);
	xhr.send(null);
}
	function readData(sData) {
	document.getElementById(\'fileLink\').style.display=\'block\';
}
    -->
    </script>';
	
	if($orderInfo->getCurrentState()==Configuration::get('VINUM_EXPINET_STATE_EXPORT'))
	{
		$display.='<center>
		<form name="myForm">
		Changer le Poids : <input type="text" name="weight" id="weight" value="'.$weight.'" size="7"/>'.Configuration::get('PS_WEIGHT_UNIT').'<br><br>
		Colis Hors Gabarit : <input type="checkbox" name="sizeBox"  id="sizeBox" /><br><br>
		  <input type="button" value="'.$this->l('Export Order to CSV file').'" name="button1" onClick="request(readData);"><br>
		<span id="loader" style="display: none;"><img src="../modules/presta2expinet/loader.gif" alt="loading" /></span>		 
		 
		</form> 
		</center>
		
		<div id="fileLink" style="display:none;">
						<br>Votre fichier CSV est en ligne à l\'adresse suivante :<br /><br><a href="'.$filename_http.'" target="_blanck"><b>'.$filename_http.'</b></a></p>
						</div>';
	}	
	else	
	{
     $display.='Le statut de la commande n\'est pas compatible avec l\'export vers Expeditor Inet';
	}
	$display.='	</fieldset>';
		
		return $display;
}

}