<?php

if (!defined('_CAN_LOAD_FILES_'))
	exit;

require( _PS_MODULE_DIR_.'/productrating/rating/_drawrating.php');
require( _PS_MODULE_DIR_.'/productrating/rating/_config-rating.php');

class productrating extends Module
{
	function __construct()
	{
		$this->name = 'productrating';
		$this->tab 	= 'Product Rating';
		$this->version = '1.0';
		

		$this->l_rating	= $this->l('Give your rating now');
		$this->l_rating	= $this->l('Rating');
		$this->l_cast	= $this->l('cast');
		$this->l_votes	= $this->l('votes');
		$this->l_vote	= $this->l('vote');
		$this->l_out	= $this->l('out of');
		$this->l_thank	= $this->l('Thanks for voting!');	

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Product ratings');
		$this->description = $this->l('Add Product ratings');
	}
	
	function traduz($termo)
	{
		return $this->l($termo);
	}

	function install()
	{
		if (!parent::install() OR !$this->registerHook('extraRight') OR !$this->registerHook('header'))
			return false;
		
		Configuration::updateValue('RATING_SHOW_CATEGORY', 0);
		Configuration::updateValue('RATING_NUMBER', 10);
		Configuration::updateValue('RATING_STAR', '0001.gif');
		Configuration::updateValue('RATING_BGCL', 'f1f2f4');
		Configuration::updateValue('RATING_BDCL', 'd0d3d8');
		
		if (!Db::getInstance()->Execute('
		CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'ratings` (
  			`id` INT(10) unsigned NOT NULL PRIMARY KEY,
  			`total_votes` INT(10) unsigned NOT NULL default 0,
  			`total_value` INT(10) unsigned NOT NULL default 0,
  			`used_ips` LONGTEXT
			) ENGINE='.(defined(_MYSQL_ENGINE_)?_MYSQL_ENGINE_:"MyISAM").' DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci')
		)
	 		return false;
		
		return true;
	}

	public function uninstall()
    {
		Configuration::deleteByName('RATING_SHOW_CATEGORY');
		Configuration::deleteByName('RATING_NUMBER');
		Configuration::deleteByName('RATING_STAR');
		Configuration::deleteByName('RATING_BGCL');
		Configuration::deleteByName('RATING_BDCL');
	 	if (!Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'ratings'))
	 		return false;
		return parent::uninstall();
    } 
    
	

	public function pegaArquivos()
	{
		$diretorio = dirname(__FILE__).'/rating/stars/';
		
		$ponteiro = opendir($diretorio);

		while ($nome_itens = readdir($ponteiro))
		{
			$itens[] = $nome_itens;
		}
		
		sort($itens);

		foreach ($itens as $listar)
		{
			if ($listar != '.' && $listar != '..' && $listar != 'Thumbs.db' && $listar != 'index.php')
			{
				if (!is_dir($listar))
				{
					$arquivos[] = $listar;
				}
			}
		}
		
		return $arquivos;	
	}

	function hookHeader($params)
	{
		global $smarty;
		
		$smarty->assign(array(
			'rating_show_category' => Configuration::get('RATING_SHOW_CATEGORY'),
			'bdcolor' => Configuration::get('RATING_BDCL'),
			'bgcolor' => Configuration::get('RATING_BGCL'), 
			'star' => Configuration::get('RATING_STAR')
		));
		
		return $this->display(__FILE__, 'productrating-header.tpl');
	}

	function hookextraRight($params)
	{
		global $smarty, $cookie, $page_name, $logged;

		$rating	= rating_bar( Tools::getValue('id_product'), Configuration::get('RATING_NUMBER'));
		$static	= rating_bar( Tools::getValue('id_product'), Configuration::get('RATING_NUMBER'), 'static');

		$smarty->assign(array(
			'onllog' => Configuration::get('RATING_ONLG'),
			'rating' => $rating,
			'result' => $static
		));

		return $this->display(__FILE__, 'productrating.tpl');
	}
}
