var ajaxCart = {
    overrideButtonsInThePage: function() {
        $('.ajax_add_to_cart_button').unbind('click').click(function() {
            var idProduct = $(this).attr('rel').replace('ajax_id_product_', '');
            var tailles = $(this).attr('href').split('id_product_attribute=');
            var taille = tailles[1];
            var idCombination = taille;
            ajaxCart.add(idProduct, idCombination, false, this, 1, false, false, taille);
            return false;
        });
        $('body#product p#add_to_cart input, .archi_button0').unbind('click').click(function() {
            ajaxCart.add($('#product_page_product_id').val(), $('#idCombination').val(), true, null, $('#quantity_wanted').val(), null);
            return false;
        });
        $('#cart_block_list .ajax_cart_block_remove_link').unbind('click').click(function() {
            return false;
        });
    },
    expand: function() {
        if ($('#cart_block #cart_block_list').hasClass('collapsed')) {}
    },
    refresh: function() {
        $.ajax({
            type: 'GET',
            url: baseDir + 'cart.php',
            async: true,
            cache: false,
            dataType: "json",
            data: 'ajax=true&token=' + static_token,
            success: function(jsonData) {
                ajaxCart.updateCart(jsonData);
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {}
        });
    },
    collapse: function() {
        if ($('#cart_block #cart_block_list').hasClass('expanded')) {}
    },
    add: function(idProduct, idCombination, addedFromProductPage, callerElement, quantity, whishlist) {
        if (addedFromProductPage && !checkCustomizations()) {
            alert(fieldRequired);
            return;
        }
        if (addedFromProductPage) {
            $('body#product p#add_to_cart input').attr('disabled', 'disabled').removeClass('exclusive').addClass('exclusive_disabled');
            $('.filled').removeClass('filled');
        } else
            $('.ajax_add_to_cart_button').attr('disabled', 'disabled'); if ($('#cart_block #cart_block_list').hasClass('collapsed'))
            this.expand();
        $.ajax({
            type: 'POST',
            url: baseDir + 'cart.php',
            async: true,
            cache: false,
            dataType: "json",
            data: 'add=1&ajax=true&qty=' + ((quantity && quantity != null) ? quantity : '1') + '&id_product=' + idProduct + '&token=' + static_token + ((parseInt(idCombination) && idCombination != null) ? '&ipa=' + parseInt(idCombination) : ''),
            success: function(jsonData) {
                if (whishlist && !jsonData.errors)
                    WishlistAddProductCart(whishlist[0], idProduct, idCombination, whishlist[1]);
                var elementToTransfert = null;
                if (callerElement && callerElement != null)
                    $(callerElement).parents().each(function() {
                        if ($(this).is('.ajax_block_product')) elementToTransfert = $(this);
                    });
                else
                    elementToTransfert = $(addedFromProductPage ? '.archi_button0' : ('.ajax_block_product_id_' + idProduct)); if (elementToTransfert == null)
                    elementToTransfert = $('li#ma_chaussette_num_' + idProduct + ' h3 a');
                var $picture = $('<div id="etoile"><img src="' + baseDir + 'themes/archi_14/img/chaussette.png" /></div>');
                var pictureOffsetOriginal = elementToTransfert.offset();
                $picture.css({
                    'position': 'absolute',
                    'top': pictureOffsetOriginal.top,
                    'left': pictureOffsetOriginal.left,
                    'z-index': 99999
                });
                $picture.appendTo('body');
                var pictureOffset = $picture.offset();
                var cartBlockOffset = $('#etoile_noire').offset();
                $('#etoile').animate({
                    top: (parseInt(cartBlockOffset.top) - 30) + 'px',
                    left: (parseInt(cartBlockOffset.left)) + 'px'
                }, 1000, function() {
                    $('#etoile').remove();
                    ajaxCart.updateCart(jsonData);
                    var qte = parseFloat($(".archi_price").html());
                    var franko = parseFloat(36 - qte);
                    franko = Math.round(franko * 100) / 100;
                    if (franko == 1) {
                        $(".pluriel").addClass("cacher");
                    }
                    if (franko <= 0) {
                        $(".franco").addClass("franco_vert");
                        $(".franco").removeClass("franco_rouge");
                        var franco_ok = $(".franco_ok").html();
                        $(".franco").html(franco_ok);
                    } else {
                        $(".franco").addClass("franco_rouge");
                        $(".franco").removeClass("franco_vert");
                    }
                    qte = $(".reste_franco").html(franko);
                });
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                alert("TECHNICAL ERROR: unable to add the product.\n\nDetails:\nError thrown: " + XMLHttpRequest + "\n" + 'Text status: ' + textStatus);
                if (addedFromProductPage)
                    $('body#product p#add_to_cart input').removeAttr('disabled').addClass('exclusive').removeClass('exclusive_disabled');
                else
                    $('.ajax_add_to_cart_button').removeAttr('disabled');
            }
        });
    },
    remove: function(idProduct, idCombination, customizationId) {
        $.ajax({
            type: 'POST',
            url: baseDir + 'cart.php',
            async: true,
            cache: false,
            dataType: "json",
            data: 'delete=1&id_product=' + idProduct + '&ipa=' + ((idCombination != null && parseInt(idCombination)) ? idCombination : '') + ((customizationId && customizationId != null) ? '&id_customization=' + customizationId : '') + '&token=' + static_token + '&ajax=true',
            success: function(jsonData) {
                ajaxCart.updateCart(jsonData);
                if ($('body').attr('id') == 'order' || $('body').attr('id') == 'order-opc')
                    deletProductFromSummary(idProduct + '_' + idCombination);
            },
            error: function() {
                alert('ERROR: unable to delete the product');
            }
        });
    },
    hideOldProducts: function(jsonData) {
        if ($('#cart_block #cart_block_list dl.products').length > 0) {
            var removedProductId = null;
            var removedProductData = null;
            var removedProductDomId = null;
            $('#cart_block_list dl.products dt').each(function() {
                var domIdProduct = $(this).attr('id');
                var firstCut = domIdProduct.replace('cart_block_product_', '');
                var ids = firstCut.split('_');
                var stayInTheCart = false;
                for (aProduct in jsonData.products) {
                    if (jsonData.products[aProduct]['id'] == ids[0] && (!ids[1] || jsonData.products[aProduct]['idCombination'] == ids[1])) {
                        stayInTheCart = true;
                        ajaxCart.hideOldProductCustomizations(jsonData.products[aProduct], domIdProduct);
                    }
                }
                if (!stayInTheCart) {
                    removedProductId = $(this).attr('id');
                }
            });
            if (removedProductId != null) {
                var firstCut = removedProductId.replace('cart_block_product_', '');
                var ids = firstCut.split('_');
                $('#' + removedProductId).addClass('strike').fadeTo('slow', 0, function() {
                    $(this).slideUp('slow', function() {
                        $(this).remove();
                        if ($('#cart_block dl.products dt').length == 0) {
                            $('p#cart_block_no_products:hidden').slideDown('fast');
                            $('div#cart_block dl.products').remove();
                        }
                    });
                });
                $('dd#cart_block_combination_of_' + ids[0] + (ids[1] ? '_' + ids[1] : '')).fadeTo('fast', 0, function() {
                    $(this).slideUp('fast', function() {
                        $(this).remove();
                    });
                });
            }
        }
    },
    hideOldProductCustomizations: function(product, domIdProduct) {
        var customizationList = $('#cart_block #cart_block_list ul#customization_' + product['id'] + '_' + product['idCombination']);
        if (customizationList.length > 0) {
            $(customizationList).find("li").each(function() {
                $(this).find("div").each(function() {
                    var customizationDiv = $(this).attr('id');
                    var tmp = customizationDiv.replace('deleteCustomizableProduct_', '');
                    var ids = tmp.split('_');
                    if ((parseInt(product.idCombination) == parseInt(ids[2])) && !ajaxCart.doesCustomizationStillExist(product, ids[0]))
                        $('#' + customizationDiv).parent().addClass('strike').fadeTo('slow', 0, function() {
                            $(this).slideUp('slow');
                            $(this).remove();
                        });
                });
            });
        }
        var removeLinks = $('#cart_block_product_' + domIdProduct).find('a.ajax_cart_block_remove_link');
        if (!product.hasCustomizedDatas && !removeLinks.length)
            $('#' + domIdProduct + ' span.remove_link').html('<a class="ajax_cart_block_remove_link" rel="nofollow" href="' + baseDir + 'cart.php?delete&amp;id_product=' + product['id'] + '&amp;ipa=' + product['idCombination'] + '&amp;token=' + static_token + '" title="' + removingLinkText + '"> </a>');
    },
    doesCustomizationStillExist: function(product, customizationId) {
        var exists = false;
        $(product.customizedDatas).each(function() {
            if (this.customizationId == customizationId) {
                exists = true;
                return false;
            }
        });
        return (exists);
    },
    refreshVouchers: function(jsonData) {
        if (jsonData.discounts.length == 0)
            $('#vouchers').remove();
        else {
            $('.bloc_cart_voucher').each(function() {
                var idElmt = $(this).attr('id').replace('bloc_cart_voucher_', '');
                var toDelete = true;
                for (i = 0; i < jsonData.discounts.length; i++) {
                    if (jsonData.discounts[i].id == idElmt) {
                        $('#bloc_cart_voucher_' + idElmt + ' td.price').text(jsonData.discounts[i].price);
                        toDelete = false;
                    }
                }
                if (toDelete) {
                    $('#bloc_cart_voucher_' + idElmt).fadeTo('fast', 0, function() {
                        $(this).remove();
                    });
                }
            });
        }
    },
    updateProductQuantity: function(product, quantity) {
        $('dt#cart_block_product_' + product.id + (product.idCombination ? '_' + product.idCombination : '') + ' .quantity').fadeTo('fast', 0, function() {
            $(this).text(quantity);
            $(this).fadeTo('fast', 1, function() {
                $(this).fadeTo('fast', 0, function() {
                    $(this).fadeTo('fast', 1, function() {
                        $(this).fadeTo('fast', 0, function() {
                            $(this).fadeTo('fast', 1);
                        });
                    });
                });
            });
        });
    },
    displayNewProducts: function(jsonData) {
        $(jsonData.products).each(function() {
            if (this.id != undefined) {
                if ($('div#cart_block dl.products').length == 0)
                    $('p#cart_block_no_products:visible').fadeTo('fast', 0, function() {
                        $(this).slideUp('fast').fadeTo(0, 1);
                    }).before('<dl class="products"></dl>');
                var domIdProduct = this.id + (this.idCombination ? '_' + this.idCombination : '');
                var domIdProductAttribute = this.id + '_' + (this.idCombination ? this.idCombination : '0');
                if ($('#cart_block dt#cart_block_product_' + domIdProduct).length == 0) {
                    var productId = parseInt(this.id);
                    var productAttributeId = (this.hasAttributes ? parseInt(this.attributes) : 0);
                    var content = '<dt id="cart_block_product_' + domIdProduct + '">';
                    content += '<a class="cart_block_product_name" href="' + this.link + '" title="' + this.name + '">' + this.name + '</a>';
                    content += '<span class="taille_cho7">' + this.attributes + '</span>';
                    content += '<span class="quantity-formated"><span class="quantity">' + this.quantity + '</span></span>';
                    content += '<span class="remove_link"><a class="ajax_cart_block_remove_link" href="' + baseDir + 'cart.php?delete&amp;id_product=' + productId + '&amp;token=' + static_token + (this.hasAttributes ? '&amp;ipa=' + parseInt(this.attributes) : '') + '"> </a></span>';
                    content += '<span class="price">' + this.priceByLine + '</span>';
                    content += '<span class="spacer_panier"></span></dt>';
                    $('#cart_block dl.products').append(content);
                } else {
                    var jsonProduct = this;
                    if ($('dt#cart_block_product_' + domIdProduct + ' .quantity').text() != jsonProduct.quantity || $('dt#cart_block_product_' + domIdProduct + ' .price').text() != jsonProduct.priceByLine) {
                        $('dt#cart_block_product_' + domIdProduct + ' .price').text(jsonProduct.priceByLine);
                        ajaxCart.updateProductQuantity(jsonProduct, jsonProduct.quantity);
                        if (jsonProduct.hasCustomizedDatas) {
                            customizationFormatedDatas = ajaxCart.displayNewCustomizedDatas(jsonProduct);
                            if (!$('#cart_block ul#customization_' + domIdProductAttribute).length) {
                                if (jsonProduct.hasAttributes)
                                    $('#cart_block dd#cart_block_combination_of_' + domIdProduct).append(customizationFormatedDatas);
                                else
                                    $('#cart_block dl.products').append(customizationFormatedDatas);
                            } else
                                $('#cart_block ul#customization_' + domIdProductAttribute).append(customizationFormatedDatas);
                        }
                    }
                }
                $('#cart_block dl.products .hidden').slideDown('slow').removeClass('hidden');
                var removeLinks = $('#cart_block_product_' + domIdProduct).find('a.ajax_cart_block_remove_link');
                if (this.hasCustomizedDatas && removeLinks.length)
                    $(removeLinks).each(function() {
                        $(this).remove();
                    });
            }
        });
    },
    displayNewCustomizedDatas: function(product) {
        var content = '';
        var productId = parseInt(product.id);
        var productAttributeId = typeof(product.idCombination) == 'undefined' ? 0 : parseInt(product.idCombination);
        var hasAlreadyCustomizations = $('#cart_block ul#customization_' + productId + '_' + productAttributeId).length;
        if (!hasAlreadyCustomizations) {
            if (!product.hasAttributes) content += '<dd id="cart_block_combination_of_' + productId + '" class="hidden">';
            content += '<ul class="cart_block_customizations" id="customization_' + productId + '_' + productAttributeId + '">';
        }
        $(product.customizedDatas).each(function() {
            var done = 0;
            customizationId = parseInt(this.customizationId);
            productAttributeId = typeof(product.idCombination) == 'undefined' ? 0 : parseInt(product.idCombination);
            if ($('#cart_block').find("div[id^=deleteCustomizableProduct_" + customizationId + "_]").length)
                return ('');
            content += '<li name="customization"><div class="deleteCustomizableProduct" id="deleteCustomizableProduct_' + customizationId + '_' + productId + '_' + (productAttributeId ? productAttributeId : '0') + '"><a  rel="nofollow" class="ajax_cart_block_remove_link" href="' + baseDir + 'cart.php?delete&amp;id_product=' + productId + '&amp;ipa=' + productAttributeId + '&amp;id_customization=' + customizationId + '&amp;token=' + static_token + '"> </a></div><span class="quantity-formated"><span class="quantity">' + parseInt(this.quantity) + '</span>x</span>';
            $(this.datas).each(function() {
                if (this['type'] == CUSTOMIZE_TEXTFIELD) {
                    $(this.datas).each(function() {
                        if (this['index'] == 0) {
                            content += this.truncatedValue.replace(/<br \/>/g, ' ');
                            done = 1;
                            return false;
                        }
                    })
                }
            });
            if (!done)
                content += customizationIdMessage + customizationId;
            if (!hasAlreadyCustomizations) content += '</li>';
            if (customizationId) {
                $('#uploadable_files li div.customizationUploadBrowse img').remove();
                $('#text_fields li input').attr('value', '');
            }
        });
        if (!hasAlreadyCustomizations) {
            content += '</ul>';
            if (!product.hasAttributes) content += '</dd>';
        }
        return (content);
    },
    updateCart: function(jsonData) {
        if (jsonData.hasError) {
            var errors = '';
            for (error in jsonData.errors)
                if (error != 'indexOf')
                    errors += jsonData.errors[error] + "\n";
            alert(errors);
        } else {
            ajaxCart.expand();
            ajaxCart.updateCartEverywhere(jsonData);
            ajaxCart.hideOldProducts(jsonData);
            ajaxCart.displayNewProducts(jsonData);
            ajaxCart.refreshVouchers(jsonData);
            $('#cart_block dl.products dt').removeClass('first_item').removeClass('last_item').removeClass('item');
            $('#cart_block dl.products dt:first').addClass('first_item');
            $('#cart_block dl.products dt:not(:first,:last)').addClass('item');
            $('#cart_block dl.products dt:last').addClass('last_item');
            ajaxCart.overrideButtonsInThePage();
        }
    },
    updateCartEverywhere: function(jsonData) {
        $('.archi_price').text(jsonData.arch_total);
        $('.ajax_cart_total').text(jsonData.productTotal);
        $('.ajax_cart_shipping_cost').text(jsonData.shippingCost);
        $('.ajax_cart_tax_cost').text(jsonData.taxCost);
        $('.cart_block_wrapping_cost').text(jsonData.wrappingCost);
        $('.ajax_block_cart_total').text(jsonData.total);
        if (parseInt(jsonData.nbTotalProducts) > 0) {
            $('.ajax_cart_no_product').hide();
            $('.ajax_cart_quantity').text(jsonData.nbTotalProducts);
            $('.ajax_cart_quantity').fadeIn('slow');
            $('.ajax_cart_total').fadeIn('slow');
            if (parseInt(jsonData.nbTotalProducts) > 1) {
                $('.ajax_cart_product_txt').each(function() {
                    $(this).hide();
                });
                $('.ajax_cart_product_txt_s').each(function() {
                    $(this).show();
                });
            } else {
                $('.ajax_cart_product_txt').each(function() {
                    $(this).show();
                });
                $('.ajax_cart_product_txt_s').each(function() {
                    $(this).hide();
                });
            }
        } else {
            $('.ajax_cart_product_txt_s, .ajax_cart_product_txt, .ajax_cart_total').each(function() {
                $(this).hide();
            });
            $('.ajax_cart_no_product, .ajax_cart_product_txt').show('slow');
        }
    }
};