<?php
/*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

include_once(_PS_MODULE_DIR_.'nnblockwp/ExceptionThrower.php');

class nnBlockWp extends Module
{

	private static $_default_request = 'api/get_category_posts?slug=cosmeto-bio&count=5&order=DESC&order_by=date';

	public function __construct()
	{
		$this->name = 'nnblockwp';
		$this->tab = 'front_office_features';
		$this->version = '1.0';

		parent::__construct();

		$this->displayName = $this->l('NN : WordPress block');
		$this->description = $this->l('Display WordPress blog entries');
	}
	
	public function install()
	{
		return parent::install()
			&& Configuration::updateValue('nnblockwp_url', '')
			&& Configuration::updateValue('nnblockwp_request', nnBlockWp::$_default_request)
			&& $this->registerHook('displayRightColumn')
			&& $this->registerHook('displayHeader');
	}
	
	public function uninstall()
	{
		// Delete configuration
		return Configuration::deleteByName('nnblockwp_url') 
			&& Configuration::deleteByName('nnblockwp_request')
			&& parent::uninstall();
	}
	
	public function getContent()
	{
		$html = '';
		// If we try to update the settings
		if (Tools::isSubmit('submitModule'))
		{				
			Configuration::updateValue('nnblockwp_url', Tools::getValue('url'));
			Configuration::updateValue('nnblockwp_request', Tools::getValue('request'));
			$this->_clearCache('nnblockwp.tpl');
			$html .= '<div class="conf confirm">'.$this->l('Configuration updated').'</div>';
		}
		$html .= '
		<h2>'.$this->displayName.'</h2>
		<form action="'.Tools::htmlentitiesutf8($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<p>
				<label for="url">'.$this->l('URL :').'</label>
				<input type="text" id="url" name="url" style="width:500px;" value="'.((Configuration::get('nnblockwp_url') != '') ? Tools::safeOutput(Configuration::get('nnblockwp_url')) : '').'" />
				</p>
				<div class="clear">&nbsp;</div>

				<p>
				<label for="request">'.$this->l('Request :').'</label>
				<input type="text" id="request" name="request" style="width:500px;" placeholder="'.nnBlockWp::$_default_request.'" value="'.((Configuration::get('nnblockwp_request') != '') ? Tools::safeOutput(Configuration::get('nnblockwp_request')) : '').'" />
				</p>
				<div class="clear">&nbsp;</div>

				<div class="margin-form">
					<input type="submit" name="submitModule" value="'.$this->l('Update settings').'" class="button" /></center>
				</div>
			</fieldset>
		</form>';

		return $html;
	}

	public function hookDisplayHeader()
	{
		//$this->context->controller->addCSS(($this->_path).'nnblockwp.css', 'all');
		//Should Also include js for collapsing rules
	}
	
	public function hookDisplayRightColumn()
	{
		global $smarty;
		$res = '';

		/** url */
		$url = Configuration::get('nnblockwp_url');
		if (!isset($url) || $url === '') {
			return;
		}

		$criteria = Configuration::get('nnblockwp_request');
		if (!isset($criteria) || $criteria === '') {
			return;
		}

		/** Additional criterias to format response */
		$request = $url.'/'.$criteria.'&json_unescaped_unicode&include=id,type,slug,url,title,title_plain,excerpt,date,categories,tags,author';

		/** Call web service */
		$ctx = stream_context_create(array(
			// http://fr2.php.net/manual/en/context.php
			// http://fr2.php.net/manual/en/function.file-get-contents.php
		    'http' => array(
		    	// see http://fr2.php.net/manual/en/context.http.php for possible options
		        'timeout' => 5 // timeout de 5s
		        )
		    )
		);
		$json = false;
		ExceptionThrower::Start(); // to catch warnings
		try {
			$json = file_get_contents($request, false, $ctx, -1, 40000);
		}
		catch (Exception $e) {
			echo 'Failed request "'.$request.'" Caught exception: "'.$e->getMessage().'"';
		}
		ExceptionThrower::Stop();

		/** Extract articles */
		$articles = array();
		if ( $json !== false ) {
			$data = json_decode($json);
			/** Expected result */
			/*
			{ 
				"status": "ok", "count": 5, "pages": 10, 
				"category": { "id": 23, "slug": "cosmeto-bio", "title": "Cosm\u00e9to bio", "description": "", "parent": 35, "post_count": 47 }, 
				"posts": [ 
					{ 	"id": 591, "type": "post", "slug": "recettes-naturelles-anti-poux-pour-nos-enfants", 
						"url": "http:\/\/leblog.noireonaturel.com\/beaute-noire\/recettes-naturelles-anti-poux-pour-nos-enfants.html", 
						"title": "Recettes naturelles anti-poux pour nos enfants !", 
						"title_plain": "Recettes naturelles anti-poux pour nos enfants !", 
						"excerpt": "<p>C&#8217;est le printemps mais les poux sont toujours d&#8217;actualit\u00e9 ...",
						"date": "2012-03-28 13:39:29", 
						"categories": [ 
							{ "id": 4, "slug": "beaute-noire", "title": "Beaut\u00e9 Noire", "description": "", "parent": 0, "post_count": 61 }, 
							...
						],
						"tags": [ 
							{ "id": 111, "slug": "masque-demelant-bio", "title": "masque d\u00e9melant bio", "description": "", "post_count": 2 },
							...
						],
						"author": { "id": 2, "slug": "karambole", "name": "Karambole", "first_name": "", "last_name": "", "nickname": "Karambole", "url": "", "description": "" } 
					},
					...
				]
			}
			*/
			foreach ($data->posts as &$post) {
				$dateTime = DateTime::createFromFormat('Y-m-d H:i:s',$post->date);
				if ($dateTime !== FALSE)
					$post->timestamp = $dateTime->getTimestamp();
				else 
					$post->timestamp = NULL;
				foreach ($post->categories as &$category) {
					$category->url = $url.'/categorie/'.$category->slug;
				}
				foreach ($post->tags as &$tag) {
					$tag->url = $url.'/mot-cle/'.$tag->slug;
				}
				$articles[] = $post;
			}
		}

		/** Pass-on to template */
		if (!$this->isCached('nnblockwp.tpl', $this->getCacheId())) {
			$smarty->assign(array(
				'articles' => $articles
			));
			return $this->display(__FILE__, 'nnblockwp.tpl', $this->getCacheId());
		}
	}
	
	public function hookDisplayLeftColumn()
	{
		return $this->hookDisplayRightColumn();
	}

	public function hookDisplayCategoryBottom()
	{
		return $this->hookDisplayRightColumn();
	}

}
?>
