{*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<!-- NN Block WP -->
{if is_array($articles) && count($articles) > 0 }
<section class="block">
	<header class="block__header">
		<a class="block__toggle is-opened" href="#blog-detail" data-toggle="collapse" title="Détail">
			<h2 class="block__title">{l s='Les conseils du blog' mod='nnblockwp'}</h2>
		</a>
		<p class="block__summary">{l s='Sur le blog, vous trouverez de nombreux conseils beauté.' mod='nnblockwp'}</p>
	</header>
	<div id="blog-detail" class="block__content collapse in">
		<div class="block__inner">
			{foreach from=$articles item='article'}
			{* get known categories *}
			{assign var='knownCategories' value=[]}
			{foreach from=$article->categories key='key' item='category'}
				{if $category->slug == 'soin-du-cheveu'}
					{$knownCategories[]='hair'}
				{elseif $category->slug == 'cosmeto-bio'}
					{$knownCategories[]='skin'}
				{elseif $category->slug == 'sapotille'}
					{$knownCategories[]='sapotille'}
				{/if}
			{/foreach}
			<article class="blog-entry">
				<h3 class="blog-entry__title">
					{foreach from=$knownCategories item='cat'}<i class="sprite bg--{$cat}"></i> {/foreach}{$article->title|escape:'htmlall':'UTF-8'}
				</h3>
				<div id="blog-entry-{$article->id}" class="collapse">
					<div class="blog-entry__summary">
						{$article->excerpt}
						<p>
							<a href="{$article->url}" title="{l s='Voir la suite sur le blog...' mod='nnblockwp'}">{l s='Voir la suite sur le blog...' mod='nnblockwp'}</a>
						</p>
					</div>
					<footer>
						<ul>
							<li class="blog-entry__date">
								{l s='Publié le' mod='nnblockwp'}
								<time datetime="{$article->timestamp|date_format:"%Y-%m-%dT%TZ"}">{$article->timestamp|date_format:"%x"}</time>
							</li>
							{if is_array($article->categories) && count($article->categories) > 0}
							<li class="blog-entry__category">
								{l s='Catégories : ' mod='nnblockwp'}{foreach from=$article->categories key='key' item='category'}{if $key != 0}, {/if}<a href="{$category->url}" title="{$category->title|escape:'htmlall':'UTF-8'}">{$category->title|escape:'htmlall':'UTF-8'}</a>{/foreach}
							</li>
							{/if}
							{if is_array($article->tags) && count($article->tags) > 0}
							<li class="blog-entry__tags">
								{l s='Etiquetté avec : ' mod='nnblockwp'}{foreach from=$article->tags key='key' item='tag'}{if $key != 0}, {/if}<a href="{$tag->url}" title="{$tag->title|escape:'htmlall':'UTF-8'}">{$tag->title|escape:'htmlall':'UTF-8'}</a>{/foreach}
							</li>
							{/if}
						</ul>
					</footer>
				</div>
				<a href="#blog-entry-{$article->id}" class="blog-entry__toggle collapsed" data-toggle="collapse" title="{l s='Détail' mod='nnblockwp'}">{l s='Détail' mod='nnblockwp'}</a>
			</article>
			{/foreach}
		</div>
	</div>
</section>
{/if}
<!-- End NN Block WP -->