{*
 * Noir Ô Naturel
 * Display selected category logos for current product in dedicated tab
 * see {$HOOK_PRODUCT_TAB_CONTENT} in <theme>/product.tpl for integration point
*}

{if $categories}
<section class="block" id="b-labels">
    <header class="block__header">
        <a class="block__toggle collapsed" href="#b-labels-details" data-toggle="collapse" data-parent="#s-about" title="Détail">
            <h4 class="block__title">Labels</h4>
        </a>
    </header>
    <div class="block__content collapse" id="b-labels-details">
        <div class="block__inner">
            <div class="product-labels">
                <ul class="inline_list">
                    {foreach from=$categories item=category}
                        <li>
                            <a href="{$link->getCategoryLink($category.id_category, $category.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$category.name|escape:'htmlall':'UTF-8'}">
                                {if $category.id_image}
                                    <img src="{$link->getCatImageLink($category.link_rewrite, $category.id_image, 'medium')}" alt="{$category.name|escape:'htmlall':'UTF-8'}" width="{$mediumSize.width}" height="{$mediumSize.height}" />
                                {else}
                                    <img src="{$img_cat_dir}default-medium.jpg" alt="{$categoryProduct.name|htmlspecialchars}" width="{$mediumSize.width}" height="{$mediumSize.height}" />
                                {/if}
                                <br>{$category.name|truncate:15|escape:'htmlall':'UTF-8'}
                            </a>
                        </li>
                    {/foreach}
                </ul>
            </div>
        </div>
    </div>
</section>
{/if}

