<?php
/*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class nnProductComments extends Module
{

	public function __construct()
	{
		$this->name = 'nnproductcomments';
		$this->tab = 'front_office_features';
		$this->version = '1.0';
		$this->author = 'Noir Ô Naturel';
		$this->need_instance = 0;
		$this->secure_key = Tools::encrypt($this->name);

		parent::__construct();

		$this->displayName = $this->l('N&N : Product Comments');
		$this->description = $this->l('Allows users to post reviews.');
	}

	public function install()
	{
		if  ( !parent::install() ||
			 !$this->registerHook('header') ||
			 !$this->registerHook('displayProduct_4')
			)
				return false;
		return true;
	}

	public function uninstall()
	{
		if (!parent::uninstall())
				return false;
		return true;
	}

    public function hookDisplayProduct_4($params)
    {

    	require_once(dirname(__FILE__).'/../productcomments/ProductComment.php');
		require_once(dirname(__FILE__).'/../productcomments/ProductCommentCriterion.php');

		$this->context->controller->addJS($this->_path.'../productcomments/js/jquery.rating.pack.js');
		$this->context->controller->addJS($this->_path.'../productcomments/js/jquery.textareaCounter.plugin.js');
		$this->context->controller->addJS($this->_path.'js/productcomments.js');
		
		$id_guest = (!$id_customer = (int)$this->context->cookie->id_customer) ? (int)$this->context->cookie->id_guest : false;
		$customerComment = ProductComment::getByCustomer((int)(Tools::getValue('id_product')), (int)$this->context->cookie->id_customer, true, (int)$id_guest);

		$averages = ProductComment::getAveragesByProduct((int)Tools::getValue('id_product'), $this->context->language->id);
		$averageTotal = 0;
		foreach ($averages as $average)
			$averageTotal += (float)($average);
		$averageTotal = count($averages) ? ($averageTotal / count($averages)) : 0;

		$image = Product::getCover((int)Tools::getValue('id_product'));

		$this->context->smarty->assign(array(
			'logged' => (int)$this->context->customer->isLogged(true),
			'action_url' => '',
			'comments' => ProductComment::getByProduct((int)Tools::getValue('id_product'), 1, null, $this->context->cookie->id_customer),
			'criterions' => ProductCommentCriterion::getByProduct((int)Tools::getValue('id_product'), $this->context->language->id),
			'averages' => $averages,
			'product_comment_path' => $this->_path,
			'averageTotal' => $averageTotal,
			'allow_guests' => (int)Configuration::get('PRODUCT_COMMENTS_ALLOW_GUESTS'),
			'too_early' => ($customerComment && (strtotime($customerComment['date_add']) + Configuration::get('PRODUCT_COMMENTS_MINIMAL_TIME')) > time()),
			'delay' => Configuration::get('PRODUCT_COMMENTS_MINIMAL_TIME'),
			'id_product_comment_form' => (int)Tools::getValue('id_product'),
			'secure_key' => $this->secure_key,
			'productcomment_cover' => (int)Tools::getValue('id_product').'-'.(int)$image['id_image'],
			'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
			'nbComments' => (int)ProductComment::getCommentNumber((int)Tools::getValue('id_product')),
			'productcomments_controller_url' => $this->context->link->getModuleLink('productcomments'),
			'productcomments_url_rewriting_activated' => Configuration::get('PS_REWRITING_SETTINGS', 0),
			'moderation_active' => (int)Configuration::get('PRODUCT_COMMENTS_MODERATE')
		));

		$this->context->controller->pagination((int)ProductComment::getCommentNumber((int)Tools::getValue('id_product')));

		return ($this->display(__FILE__, '/nnProductComments.tpl'));
	}

	public function hookHeader()
	{
		$this->context->controller->addCSS($this->_path.'../productcomments/productcomments.css', 'all');
	}

}
