{*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<script type="text/javascript">
var productcomments_controller_url = '{$productcomments_controller_url}';
var confirm_report_message = '{l s='Are you sure you want report this comment?' mod='productcomments' js=1}';
var secure_key = '{$secure_key}';
var productcomments_url_rewrite = '{$productcomments_url_rewriting_activated}';
</script>

<section class="block block--hide-header" id="b_give_advice">
    <header class="block__header">
        <a class="block__toggle collapsed" href="#b_give_advice__content" data-toggle="collapse" title="Détail">
            <h4 class="block__title">Donner son avis</h4>
        </a>
    </header>
    <div class="block__content collapse" id="b_give_advice__content">
        <div class="block__inner">
            <form class="comment-add" id="id_new_comment_form" action="#">
                <!-- Error field in case of error -->
                <div id="new_comment_form_error" class="error" style="display: none; padding: 15px 25px">
                    <ul></ul>
                </div>
                <!-- Modal displayed in case of success -->
                <div id="new_comment_modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h4 class="modal-title" id="new_comment_modal_label">{l s='New comment' mod='productcomments'}</h4>
                      </div>
                      <div class="modal-body">
                        <p>{if $moderation_active}{l s='Your comment has been added and will be available once approved by a moderator' mod='productcomments'}{else}{l s='Your comment has been added!' mod='productcomments'}{/if}</p>
                      </div>
                      <div class="modal-footer">
                        <button id="new_comment_modal_close" type="button" class="btn btn-default" data-dismiss="modal">{l s='OK' mod='productcomments'}</button>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- Field set for comment -->
                <fieldset class="comment-add__comment">
                    <ul class="form-fields form-fields--wide">
                        <li>
                            <textarea id="content" name="content" rows="6" placeholder="Laisser un commentaire..."></textarea>
                        </li>
                        {if $criterions|@count > 0}
                            {foreach from=$criterions item='criterion'}
                        <li>
                            <label>Votre évaluation</label>
                            <div class="comment-add__star text-input">
                                <div>
                                    <input class="star" type="radio" name="criterion[{$criterion.id_product_comment_criterion|round}]" value="1" />
                                    <input class="star" type="radio" name="criterion[{$criterion.id_product_comment_criterion|round}]" value="2" />
                                    <input class="star" type="radio" name="criterion[{$criterion.id_product_comment_criterion|round}]" value="3" checked="checked" />
                                    <input class="star" type="radio" name="criterion[{$criterion.id_product_comment_criterion|round}]" value="4" />
                                    <input class="star" type="radio" name="criterion[{$criterion.id_product_comment_criterion|round}]" value="5" />
                                </div>
                            </div>
                        </li>
                            {/foreach}
                        {/if}
                        {if $allow_guests == true && $logged == 0}
                        <li>
                            <label>Choisir un nom:</label>
                            <input placeholder="Nom" id="commentCustomerName" name="customer_name" maxlength="30" type="text" value="{if isset($smarty.post.comment_create_name)}{$smarty.post.comment_create_name|stripslashes}{/if}">
                        </li>
                        {/if}
                    </ul>
                </fieldset>
                <fieldset class="comment-add__validate">
                    <ul class="form-fields">
                        <li>
                            <input id="id_product_comment_send" name="id_product" type="hidden" value='{$id_product_comment_form}' />
                            <input id="comment_title" name="title" type="hidden" value="Title" />
                            <button class="callout-button" id="submitNewMessage" name="submitMessage" type="submit">{l s='Send' mod='productcomments'}</button>
                        </li>
                        <li>
                        </li>
                    </ul>
                </fieldset>
            </form>
        </div>
    </div>
</section>

{if isset($product) && $product}
<!--
<div style="display: none;">
	<div id="new_comment_form">
		<form id="id_new_comment_form" action="#">
			<div class="new_comment_form_content">

<!--
				<label for="comment_title">{l s='Title' mod='productcomments'}: <sup class="required">*</sup></label>
				<input id="comment_title" name="title" type="text" value=""/>
-->

<!--
				{if $allow_guests == true && $logged == 0}
				<label>{l s='Your name' mod='productcomments'}: <sup class="required">*</sup></label>
				<input id="commentCustomerName" name="customer_name" type="text" value=""/>
				{/if}
-->
<!--
				<div id="new_comment_form_footer">
					<p class="fl required"><sup>*</sup> {l s='Required fields' mod='productcomments'}</p>
					<p class="fr">
						<button id="submitNewMessage" name="submitMessage" type="submit">{l s='Send' mod='productcomments'}</button>&nbsp;
						{l s='or' mod='productcomments'}&nbsp;<a href="#" onclick="$.fancybox.close();">{l s='Cancel' mod='productcomments'}</a>
					</p>
					<div class="clearfix"></div>
				</div>
			</div>
		</form>
	</div>
</div>
-->
<!-- End fancybox -->
{/if}

<section class="block block--hide-header" id="b_see_advices">
    <header class="block__header">
        <a class="block__toggle" href="#b_see_advices__content" data-toggle="collapse" title="Détail">
            <h4 class="block__title">Voir tous les avis</h4>
        </a>
    </header>
    <div class="block__content collapse in" id="b_see_advices__content">
        <div class="block__inner">
            <div class="comment-list">
        		{if !$comments}
            	<div class="comment-list__no-comment">
            		{if (!$too_early AND ($logged OR $allow_guests))}
					<p class="align_center">
						<a id="new_comment_tab_btn" class="open-comment-form" href="#new_comment_form">{l s='Be the first to write your review' mod='productcomments'} !</a>
					</p>
					{else}
					<p class="align_center">{l s='No customer comments for the moment.' mod='productcomments'}</p>
					{/if}
                </div>
                {else}
                <ul class="comment-list__items">
					{foreach from=$comments item=comment}
						{if $comment.content}
                    <li class="" id="{$comment.id_product_comment}">
                        <div class="comment">
                            <!--
                            <div class="comment__avatar">
                                <img src="img/avatar.png" alt="Photo d'avatar">
                            </div>
                            -->
                            <div class="comment__body">
                                <header class="comment__header">
                                    <span class="comment__author">{$comment.customer_name|escape:'html':'UTF-8'}</span>
                                    <div class="comment__time">
                                        <span class="comment__bullet">•</span>
                                        <a href="#" title="{dateFormat date=$comment.date_add|escape:'html':'UTF-8' full=0}">{dateFormat date=$comment.date_add|escape:'html':'UTF-8' full=0}</a>
                                    </div>
                                    <ul class="comment__menu">
                                        <li>
                                            <a class="comment__toggle" href="#comment_{$comment.id_product_comment}" data-toggle="collapse" title="Réduire"><span class="to-collapse">−</span><span class="to-expand">+</span></a>
                                        </li>
                                        {if !isset($comment.customer_report) || !$comment.customer_report}
                                        <li>
                                            <a class="comment__report js-comment-report" href="#" data-id-product-comment="{$comment.id_product_comment}" title="Signaler un abus">
                                                <i aria-hidden="true" class="sprite sprite--small bg--flag"></i>
                                            </a>
                                        </li>
                                        {/if}
                                    </ul>
                                    {if $comment.grade > 0}
                                    <div class="comment__grade">
                                        {section name="i" start=0 loop=5 step=1}
                                            {if $comment.grade le $smarty.section.i.index}
                                        <i class="sprite bg--star-off"></i>
                                            {else}
                                        <i class="sprite bg--star-on"></i>
                                            {/if}
                                        {/section}
                                    </div>
                                    {/if}
                                </header>
                                <div class="comment__content collapse in" id="comment_{$comment.id_product_comment}">
                                    {* {if isset($comment.title) && $comment.title }
                                	<h5 class="comment__title">{$comment.title}</h5>
                                    {/if} *}
                                    <p class="comment__text">{$comment.content|escape:'html':'UTF-8'|nl2br}</p>
                                	<ul class="comment__footer">
                                		{if $comment.total_advice > 0}
										<li class="comment__voting flyout--alt">{$comment.total_useful}/{$comment.total_advice}<span class="flyout__content">{l s='%1$d out of %2$d people found this review useful.' sprintf=[$comment.total_useful,$comment.total_advice] mod='productcomments'}</span>
										</li>
                                        {if !isset($comment.customer_advice) || !$comment.customer_advice}
										<li class="comment__bullet" aria-hidden="true">•
                                        </li>
                                        {/if}
                                        {/if}
                                		{if !isset($comment.customer_advice) || !$comment.customer_advice}
                                        <li>
											<a href="#" class="comment__vote--up flyout--alt js-comment-vote" data-is-usefull="1" data-id-product-comment="{$comment.id_product_comment}" title="Votez pour ce commentaire">
												<i aria-hidden="true" class="sprite bg--caret-up"></i>
												{if $logged != 1}
												<span class="flyout__content">Vous devez être connecté pour voter pour ce commentaire.</span>
												{/if}
											</a>
											<a class="comment__vote--down flyout--alt js-comment-vote" data-is-usefull="0" data-id-product-comment="{$comment.id_product_comment}" title="Commentaire inutile">
												<i aria-hidden="true" class="sprite bg--caret-down"></i>
												{if $logged != 1}
												<span class="flyout__content">Vous devez être connecté pour voter contre ce commentaire.</span>
												{/if}
											</a>
										</li>
										{/if}
									</ul>
                                </div>
                            </div>
                        </div>
                    </li>
                    	{/if}
                    {/foreach}
                </ul>
                <div class="comment-list__more" style="display:none">
                    <a href="#" class="btn">Afficher plus de commentaires</a>
                </div>
                {/if}
            </div>
        </div>
    </div>
</section>



