<?php

// Include WordPress 
define('WP_USE_THEMES', false);
require('wp-load.php');

//print_r($_GET);

// Query
$args = 'category_name=Cosméto bio&posts_per_page=5&orderby=date&order=DESC';
query_posts( $args );

// Entête html
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="fr-FR">
<head profile="http://gmpg.org/xfn/11">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>Posts</title>
	<style type="text/css">
		/* CSS reset */

		html,
		body,
		div,
		span,
		applet,
		object,
		iframe,
		h1,
		h2,
		h3,
		h4,
		h5,
		h6,
		p,
		blockquote,
		pre,
		a,
		abbr,
		acronym,
		address,
		big,
		cite,
		code,
		del,
		dfn,
		em,
		font,
		img,
		ins,
		kbd,
		q,
		s,
		samp,
		small,
		strike,
		strong,
		sub,
		sup,
		tt,
		var,
		dl,
		dt,
		dd,
		ol,
		ul,
		li,
		fieldset,
		form,
		label,
		legend,
		table,
		caption,
		tbody,
		tfoot,
		thead,
		tr,
		th,
		td {
		    margin: 0;
		    padding: 0;
		    border: 0;
		    font-family: inherit;
		    font-size: 100%;
		    font-style: inherit;
		    font-weight: inherit;
		    vertical-align: baseline;
		    outline: 0;
		}

		:focus {
		    outline: 0;
		}

		ol,
		ul {
		    list-style: none;
		}

		/* Std entries */

		@-webkit-viewport {
		  width: device-width;
		  zoom: 1.0;
		}

		@-moz-viewport {
		  width: device-width;
		  zoom: 1.0;
		}

		@-ms-viewport {
		  width: device-width;
		  zoom: 1.0;
		}

		@-o-viewport {
		  width: device-width;
		  zoom: 1.0;
		}

		@viewport {
		  width: device-width;
		  zoom: 1.0;
		}

		html {
			overflow-y: scroll;
			min-height: 100%;
			background: none repeat scroll 0% 0% #f1f1f1;
			font: 0.875em/1.42857 "Quattrocento Sans", Arial, "Helvetica Neue", Helvetica, sans-serif;
			-webkit-font-smoothing: antialiased;
			-webkit-overflow-scrolling: touch;
			-webkit-tap-highlight-color: #f6f5f5;
			-webkit-text-size-adjust: 100%;
			-ms-text-size-adjust: 100%;
		}

		html {
		  font-size: 14px;
		}

		@media only screen and (min-width: 480px) {
		  /* line 68, inuit.css.override/base/_main.scss */
		  html {
		    font-size: 16px;
		  }
		}
		@media only screen and (min-width: 600px) {
		  /* line 68, inuit.css.override/base/_main.scss */
		  html {
		    font-size: 16px;
		  }
		}
		@media only screen and (min-width: 768px) {
		  /* line 68, inuit.css.override/base/_main.scss */
		  html {
		    font-size: 18px;
		  }
		}
		@media only screen and (min-width: 992px) {
		  /* line 68, inuit.css.override/base/_main.scss */
		  html {
		    font-size: 20px;
		  }
		}
		@media only screen and (min-width: 1382px) {
		  /* line 68, inuit.css.override/base/_main.scss */
		  html {
		    font-size: 22px;
		  }
		}

		body {
			position: relative;
			margin: 0px;
			padding: 0px;
			min-height: 100%;
			width: 100%;
			background: none repeat scroll 0% 0% transparent;
			color: rgb(35, 31, 32);
			font-size: 100%;
		}

		*::-moz-selection {
		    background-color: white;
		    color: rgb(180, 13, 52);
		    text-shadow: none;
		}

		textarea, table, td, th, code, pre, samp, div, p {
		    word-wrap: break-word;
		    -moz-hyphens: auto;
		}

		*, *:before, *:after {
		    -moz-box-sizing: border-box;
		}

		ul, ol, dl, p {
		    text-align: left;
		}

		ul {
		    list-style: none outside none;
		}

		a {
		    color: rgb(180, 13, 52);
		    text-decoration: none;
		    outline: 0px none;
		    line-height: inherit;
		}
		a {
		    background: none repeat scroll 0% 0% transparent;
		}

		/* Specific entries */

		.collapsable {
			transition: opacity 0.25s linear 0s;
			overflow: visible;
			height: auto;
			opacity: 1;
		}
		.collapsable.is-closed {
			-webkit-transition: height 0.25s ease-in;
			-moz-transition: height 0.25s ease-in;
			-ms-transition: height 0.25s ease-in;
			-o-transition: height 0.25s ease-in;
			transition: height 0.25s ease-in;
			position: relative;
			overflow: hidden;
			height: 0;
			opacity: 0;
		}
		.sprite {
			position: relative;
			display: inline-block;
			overflow: hidden;
			/* margin-right: 0.5em; */
			width: 1.14286em;
			height: 1.14286em;
			background-position: 50% 50%;
			background-origin: content-box;
			background-size: auto auto;
			vertical-align: middle;
			text-align: center;
			font-weight: normal;
			font-style: normal;
			line-height: 1;
		}

		.blog-entry {
		    position: relative;
			display: block;
		    padding: 0.71429em 0;
		    border-bottom: 0.14286em solid #dfdfdd;
		    word-wrap: break-word;
			-moz-hyphens: auto;
		}

		.blog-entry footer > ul {
		    position: relative;
		    margin: 0;
		    padding-left: 0;
		    list-style-type: none;
		}

		.blog-entry footer > ul > li {
		    margin: 0 0 1.25em 0;
		    font-size: 1.14286em;
		    line-height: 1.25;
		    color: #a09e99;
		}

		.blog-entry__title {
			margin: 0px 0px 0.68966em;
		    padding-right: 1.42857em;
		    color: rgb(192, 72, 100);
			word-wrap: break-word;
			-moz-hyphens: auto;
		    font-weight: 200;
		    font-size: 1.28571em;
			font-family: "Quattrocento",Georgia,serif;
		    line-height: 1.11111;
			text-rendering: optimizelegibility;
		}

		.blog-entry__hidden {
		    display: none;
		}

		.blog-entry__summary p {
		    -moz-column-gap: 1.25em;
		    -moz-column-rule: 0.0625em solid transparent;
		    margin: 0 0 1.25em 0;
		    font-size: 1.14286em;
		    line-height: 1.25;
		    -moz-columns: 1 auto;
		}

		/*
			.blog-entry__category {
			    display: block;
			    float: left;
			    width: 2em;
			    margin-right: 1.42857em;
			}
		*/

		.blog-entry__date {
		}

		.blog-entry__tags, .blog-entry__category {
		    clear: left;
		}

		.blog-entry__toggle {
		    display: inline-block;
		    position: relative;
		    position: absolute;
		    top: 0.71429em;
		    right: 0.71429em;
		    zoom: 1;
		    width: 1.14286em;
		    width: 1.42857em;
		    height: 1.14286em;
		    height: 1.42857em;
		    text-align: center;
		    font-style: normal;
		    font-weight: normal;
		    line-height: 1;
		    vertical-align: middle;
		    background-position: 50% 50%;
		    background-size: auto auto;
		    background-origin: content-box;
		    /*
		   * H5BP method image replacement:
		   * github.com/h5bp/html5-boilerplate/commit/adecc5da035d6d76b77e3fa95c6abde841073da2
		   */
			overflow: hidden;
		    *text-indent: -9999px;
		}

		.blog-entry__toggle:before {
		    content: "";
		    display: block;
		    width: 0;
		    height: 100%;
		}

		.blog-entry__title--has-categories {
		    padding-right: 0;
		    font-size: 1.14286em;
		    line-height: 1.25;
		}

		.blog-entry__title .blog-entry__category {
		    float: left;
		    margin-right: 1em;
		}

		.blog-entry__title .blog-entry__category i {
		    width: 2.5em;
		    height: 2.5em;
		}

		.bg--hair {
		    background-image: url("data:image/svg+xml;charset=US-ASCII,%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%20standalone%3D%22no%22%3F%3E%3Csvg%20%20%20xmlns%3Adc%3D%22http%3A%2F%2Fpurl.org%2Fdc%2Felements%2F1.1%2F%22%20%20%20xmlns%3Acc%3D%22http%3A%2F%2Fcreativecommons.org%2Fns%23%22%20%20%20xmlns%3Ardf%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2F02%2F22-rdf-syntax-ns%23%22%20%20%20xmlns%3Asvg%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20%20xmlns%3Asodipodi%3D%22http%3A%2F%2Fsodipodi.sourceforge.net%2FDTD%2Fsodipodi-0.dtd%22%20%20%20xmlns%3Ainkscape%3D%22http%3A%2F%2Fwww.inkscape.org%2Fnamespaces%2Finkscape%22%20%20%20xml%3Aspace%3D%22preserve%22%20%20%20height%3D%22100%25%22%20%20%20width%3D%22100%25%22%20%20%20version%3D%221.1%22%20%20%20enable-background%3D%22new%200%200%2050%2050%22%20%20%20viewBox%3D%220%200%201792%201792%22%20%20%20id%3D%22svg2%22%20%20%20inkscape%3Aversion%3D%220.48.4%20r9939%22%20%20%20sodipodi%3Adocname%3D%22logo_hair.svg%22%3E%3Csodipodi%3Anamedview%20%20%20pagecolor%3D%22%23ffffff%22%20%20%20bordercolor%3D%22%23666666%22%20%20%20borderopacity%3D%221%22%20%20%20objecttolerance%3D%2210%22%20%20%20gridtolerance%3D%2210%22%20%20%20guidetolerance%3D%2210%22%20%20%20inkscape%3Apageopacity%3D%220%22%20%20%20inkscape%3Apageshadow%3D%222%22%20%20%20inkscape%3Awindow-width%3D%221525%22%20%20%20inkscape%3Awindow-height%3D%22877%22%20%20%20id%3D%22namedview10%22%20%20%20showgrid%3D%22false%22%20%20%20inkscape%3Azoom%3D%220.20056438%22%20%20%20inkscape%3Acx%3D%221194.0114%22%20%20%20inkscape%3Acy%3D%22424.49331%22%20%20%20inkscape%3Awindow-x%3D%22-8%22%20%20%20inkscape%3Awindow-y%3D%22-8%22%20%20%20inkscape%3Awindow-maximized%3D%221%22%20%20%20inkscape%3Acurrent-layer%3D%22svg2%22%20%2F%3E%20%3Cmetadata%20%20%20id%3D%22metadata4%22%3E%20%20%3Crdf%3ARDF%3E%20%20%20%3Ccc%3AWork%20%20%20rdf%3Aabout%3D%22%22%3E%20%20%20%20%3Cdc%3Aformat%3Eimage%2Fsvg%2Bxml%3C%2Fdc%3Aformat%3E%20%20%20%20%3Cdc%3Atype%20%20%20rdf%3Aresource%3D%22http%3A%2F%2Fpurl.org%2Fdc%2Fdcmitype%2FStillImage%22%20%2F%3E%20%20%20%20%3Cdc%3Atitle%20%2F%3E%20%20%20%3C%2Fcc%3AWork%3E%20%20%3C%2Frdf%3ARDF%3E%20%3C%2Fmetadata%3E%20%3Cdefs%20%20%20id%3D%22defs6%22%20%2F%3E%20%3Cpath%20%20%20sodipodi%3Anodetypes%3D%22cccccccscccccccccccccccccc%22%20%20%20inkscape%3Aconnector-curvature%3D%220%22%20%20%20id%3D%22path8%22%20%20%20d%3D%22m%201629.564%2C777.11323%20c%209.997%2C-79.9611%2046.0045%2C-132.9782%2066.4359%2C-202.4715%20-21.6391%2C-52.8207%20-34.4824%2C-8.1616%20-83.8358%2C-33.2179%2031.9834%2C-49.5853%20-5.4571%2C-145.378%20-33.218%2C-185.0715%20-60.1188%2C-85.9238%20-217.9149%2C-69.9337%20-253.0892%2C-186.6534%20-77.8908%2C19.1943%20-203.6255%2C-20.769%20-268.9074%2C-66.43589%20-80.82149%2C-17.902021%20-152.4827%2C19.99405%20-167.6716%2C-34.799781%20-7.19887%2C-0.889%20-13.59641%2C-0.92883%20-18.98169%2C0%20-37.69704%2C6.50171%20-35.4903%2C53.179941%20-64.85412%2C68.017771%20-79.87497%2C5.3756%20-238.82616%2C-14.96773%20-253.08926%2C101.2357%20-134.29422%2C-130.75606%20-158.14029%2C155.3715%20-268.90733%2C101.2357%20-26.87808%2C203.6609%20-158.11245%2C302.6441%20-185.071521%2C506.1785%20-14.75004%2C54.1105%2043.784441%2C35.5717%2050.617851%2C68.0177%20-49.530071%2C169.71657%2079.56114%2C207.33577%200%2C319.52517%2069.0225%2C71.4218%20109.0182%2C171.4118%20200.8896%2C219.8713%20l%200%2C68.0177%20c%2034.62767%2C49.6308%20122.89356%2C45.8269%20118.63559%2C134.4537%2070.13052%2C-42.1039%2064.0822%2C47.4578%20117.05378%2C68.0177%20163.1059%2C-6.1839%20154.10098%2C15.0133%20291.05264%2C-17.3998%20l%20-52.9035%2C-224.2701%20C%20707.71815%2C1106.2919%20765.89689%2C1153.5834%20765.89689%2C1153.5834%20l%2047.45424%2C-248.34377%20219.87127%2C-230.944%20336.9251%2C-18.9817%20254.671%2C118.6356%200%2C4.7455%22%20%20%20style%3D%22fill%3A%23000000%3Bfill-rule%3Aevenodd%22%20%2F%3E%3C%2Fsvg%3E");
		    background-repeat: no-repeat;
		}

		.bg--skin { 
			background-image: url('data:image/svg+xml;charset=US-ASCII,%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%20standalone%3D%22no%22%3F%3E%3Csvg%20%20%20xmlns%3Adc%3D%22http%3A%2F%2Fpurl.org%2Fdc%2Felements%2F1.1%2F%22%20%20%20xmlns%3Acc%3D%22http%3A%2F%2Fcreativecommons.org%2Fns%23%22%20%20%20xmlns%3Ardf%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2F02%2F22-rdf-syntax-ns%23%22%20%20%20xmlns%3Asvg%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20%20xmlns%3Asodipodi%3D%22http%3A%2F%2Fsodipodi.sourceforge.net%2FDTD%2Fsodipodi-0.dtd%22%20%20%20xmlns%3Ainkscape%3D%22http%3A%2F%2Fwww.inkscape.org%2Fnamespaces%2Finkscape%22%20%20%20xml%3Aspace%3D%22preserve%22%20%20%20height%3D%22100%25%22%20%20%20width%3D%22100%25%22%20%20%20version%3D%221.1%22%20%20%20enable-background%3D%22new%200%200%2050%2050%22%20%20%20viewBox%3D%220%200%201792%201792%22%20%20%20id%3D%22svg2%22%20%20%20inkscape%3Aversion%3D%220.48.4%20r9939%22%20%20%20sodipodi%3Adocname%3D%22skin.svg%22%3E%3Csodipodi%3Anamedview%20%20%20pagecolor%3D%22%23ffffff%22%20%20%20bordercolor%3D%22%23666666%22%20%20%20borderopacity%3D%221%22%20%20%20objecttolerance%3D%2210%22%20%20%20gridtolerance%3D%2210%22%20%20%20guidetolerance%3D%2210%22%20%20%20inkscape%3Apageopacity%3D%220%22%20%20%20inkscape%3Apageshadow%3D%222%22%20%20%20inkscape%3Awindow-width%3D%221525%22%20%20%20inkscape%3Awindow-height%3D%22877%22%20%20%20id%3D%22namedview10%22%20%20%20showgrid%3D%22false%22%20%20%20inkscape%3Azoom%3D%220.41785106%22%20%20%20inkscape%3Acx%3D%22786.53532%22%20%20%20inkscape%3Acy%3D%22741.13944%22%20%20%20inkscape%3Awindow-x%3D%22-8%22%20%20%20inkscape%3Awindow-y%3D%22-8%22%20%20%20inkscape%3Awindow-maximized%3D%221%22%20%20%20inkscape%3Acurrent-layer%3D%22svg2%22%20%2F%3E%20%3Cmetadata%20%20%20id%3D%22metadata4%22%3E%20%20%3Crdf%3ARDF%3E%20%20%20%3Ccc%3AWork%20%20%20rdf%3Aabout%3D%22%22%3E%20%20%20%20%3Cdc%3Aformat%3Eimage%2Fsvg%2Bxml%3C%2Fdc%3Aformat%3E%20%20%20%20%3Cdc%3Atype%20%20%20rdf%3Aresource%3D%22http%3A%2F%2Fpurl.org%2Fdc%2Fdcmitype%2FStillImage%22%20%2F%3E%20%20%20%20%3Cdc%3Atitle%20%2F%3E%20%20%20%3C%2Fcc%3AWork%3E%20%20%3C%2Frdf%3ARDF%3E%20%3C%2Fmetadata%3E%20%3Cdefs%20%20%20id%3D%22defs6%22%20%2F%3E%20%3Cpath%20%20%20sodipodi%3Anodetypes%3D%22cccccccccccsscccccccccccccccccccccccccccccccccacca%22%20%20%20inkscape%3Aconnector-curvature%3D%220%22%20%20%20id%3D%22path8-8%22%20%20%20d%3D%22m%201184.0948%2C96.00764%20-338.09472%2C19.04759%20-220.63456%2C231.74565%20-47.61897%2C249.2059%20c%200%2C0%20-57.67442%2C-47.8033%2058.73007%2C328.5709%20l%2052.38086%2C225.39652%20c%20-1.96012%2C0.4571%20-2.86069%2C-0.4572%20-4.76189%2C0%20-0.0711%2C0.5384%200.0711%2C1.0514%200%2C1.5848%20-34.68023%2C258.0587%20-300.3316%2C283.4961%20-488.88809%2C387.3009%20l%203.1746%2C4.7593%20c%2060.72371%2C41.2876%20101.42485%2C62.1053%20142.85691%2C74.6031%2041.43206%2C12.4973%2082.91272%2C17.9108%20144.4442%2C31.746%2060.78004%2C13.666%20172.67649%2C37.0935%20234.92025%2C39.6825%2064.61328%2C2.6869%20222.22186%2C6.3492%20222.22186%2C6.3492%20l%20152.38068%2C-11.1111%20136.5077%2C-55.5555%20c%200.6878%2C-3.6419%200.8595%2C-7.4768%201.5873%2C-11.1111%20-2.8109%2C1.3664%20-5.1148%2C3.4082%20-7.9365%2C4.7594%20-157.521%2C-64.2539%20-185.3482%2C-288.1926%20-68.2538%2C-422.2216%20118.8925%2C-6.3238%20185.8841%2C39.6571%20304.7614%2C33.3333%2060.7303%2C-23.7714%2013.2698%2C-154.6832%2099.9998%2C-152.3807%203.0664%2C-36.9274%20-12.3814%2C-53.8666%20-49.2062%2C-50.7936%2072.2608%2C-14.2547%2050.6123%2C-64.20512%2031.7459%2C-99.99982%20-6.8698%2C20.4058%20-29.4236%2C25.8509%20-33.3332%2C49.2063%20-40.8992%2C-6.686%20-2.3503%2C-61.3907%2031.7459%2C-50.7936%20-8.1799%2C-15.3808%20-15.6815%2C-28.066%20-14.2857%2C-33.3333%2013.5924%2C-51.4447%2067.1314%2C-26.8875%2068.2539%2C-84.1268%20-18.9816%2C-82.5345%20-74.6503%2C-128.589%20-101.5871%2C-203.1743%2068.0344%2C-118.9788%2025.5491%2C-315.5347%20-50.7936%2C-390.4755%20l%20-4.7619%2C1.5847%200%2C-4.7593%20-255.5551%2C-119.04746%20z%20m%20358.7295%2C833.33194%20c%200.3404%2C0.64%201.2445%2C0.9346%201.5873%2C1.5848%200.2337%2C-0.6959%201.3902%2C-0.8533%201.5873%2C-1.5848%20-0.9544%2C-0.4063%20-2.2125%2C0.3048%20-3.1746%2C0%20z%20m%20-225.3964%2C-614.2847%20c%2018.0148%2C-0.045%2037.2444%2C1.2699%2058.73%2C4.7594%20-25.4678%2C99.4533%2042.9892%2C116.0846%2068.2539%2C119.0474%20-52.5896%2C44.2361%20-18.3035%2C70.6193%20-84.1269%2C101.5871%20-43.175%2C0.7467%20-21.1682%2C-13.6462%20-17.4602%2C-34.9205%20-49.4222%2C-4.4191%20-52.1554%2C39.3401%20-101.5872%2C34.9205%2022.8419%2C89.9605%20115.9211%2C109.3586%20134.9204%2C203.1743%20-218.3186%2C-52.357%20-328.9521%2C-427.8992%20-58.73%2C-428.5707%20z%20m%20144.4442%2C342.8566%20c%2062.7402%2C27.4133%20100.6093%2C78.951%2099.9998%2C169.841%20-83.7835%2C17.1093%20-53.0894%2C-54.0408%20-117.4601%2C-17.4603%2039.1385%2C-47.5783%20-21.2815%2C-97.3509%2017.4603%2C-152.3807%20z%22%20%20%20style%3D%22fill%3A%23000000%3Bfill-rule%3Aevenodd%22%20%2F%3E%3C%2Fsvg%3E'); 
			background-repeat: no-repeat; 
		}

		.blog-entry__toggle {
			background-image: url('data:image/svg+xml;charset=US-ASCII,%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%20standalone%3D%22no%22%3F%3E%3Csvg%20%20%20xmlns%3Adc%3D%22http%3A%2F%2Fpurl.org%2Fdc%2Felements%2F1.1%2F%22%20%20%20xmlns%3Acc%3D%22http%3A%2F%2Fcreativecommons.org%2Fns%23%22%20%20%20xmlns%3Ardf%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2F02%2F22-rdf-syntax-ns%23%22%20%20%20xmlns%3Asvg%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20%20xmlns%3Asodipodi%3D%22http%3A%2F%2Fsodipodi.sourceforge.net%2FDTD%2Fsodipodi-0.dtd%22%20%20%20xmlns%3Ainkscape%3D%22http%3A%2F%2Fwww.inkscape.org%2Fnamespaces%2Finkscape%22%20%20%20viewBox%3D%220%200%2030%2030%22%20%20%20id%3D%22svg2%22%20%20%20version%3D%221.1%22%20%20%20inkscape%3Aversion%3D%220.48.4%20r9939%22%20%20%20width%3D%22100%25%22%20%20%20height%3D%22100%25%22%20%20%20sodipodi%3Adocname%3D%22minus.svg%22%3E%20%20%3Cmetadata%20%20%20%20%20id%3D%22metadata16%22%3E%20%20%20%20%3Crdf%3ARDF%3E%20%20%20%20%20%20%3Ccc%3AWork%20%20%20%20%20%20%20%20%20rdf%3Aabout%3D%22%22%3E%20%20%20%20%20%20%20%20%3Cdc%3Aformat%3Eimage%2Fsvg%2Bxml%3C%2Fdc%3Aformat%3E%20%20%20%20%20%20%20%20%3Cdc%3Atype%20%20%20%20%20%20%20%20%20%20%20rdf%3Aresource%3D%22http%3A%2F%2Fpurl.org%2Fdc%2Fdcmitype%2FStillImage%22%20%2F%3E%20%20%20%20%20%20%3C%2Fcc%3AWork%3E%20%20%20%20%3C%2Frdf%3ARDF%3E%20%20%3C%2Fmetadata%3E%20%20%3Cdefs%20%20%20%20%20id%3D%22defs14%22%20%2F%3E%20%20%3Csodipodi%3Anamedview%20%20%20%20%20pagecolor%3D%22%23ffffff%22%20%20%20%20%20bordercolor%3D%22%23666666%22%20%20%20%20%20borderopacity%3D%221%22%20%20%20%20%20objecttolerance%3D%2210%22%20%20%20%20%20gridtolerance%3D%2210%22%20%20%20%20%20guidetolerance%3D%2210%22%20%20%20%20%20inkscape%3Apageopacity%3D%220%22%20%20%20%20%20inkscape%3Apageshadow%3D%222%22%20%20%20%20%20inkscape%3Awindow-width%3D%221525%22%20%20%20%20%20inkscape%3Awindow-height%3D%22877%22%20%20%20%20%20id%3D%22namedview12%22%20%20%20%20%20showgrid%3D%22false%22%20%20%20%20%20inkscape%3Azoom%3D%2221.817708%22%20%20%20%20%20inkscape%3Acx%3D%2215%22%20%20%20%20%20inkscape%3Acy%3D%2215%22%20%20%20%20%20inkscape%3Awindow-x%3D%22-8%22%20%20%20%20%20inkscape%3Awindow-y%3D%22-8%22%20%20%20%20%20inkscape%3Awindow-maximized%3D%221%22%20%20%20%20%20inkscape%3Acurrent-layer%3D%22svg2%22%20%2F%3E%20%20%3Ccircle%20%20%20%20%20cx%3D%2212%22%20%20%20%20%20cy%3D%2212%22%20%20%20%20%20r%3D%2212%22%20%20%20%20%20id%3D%22circle4%22%20%20%20%20%20sodipodi%3Acx%3D%2212%22%20%20%20%20%20sodipodi%3Acy%3D%2212%22%20%20%20%20%20sodipodi%3Arx%3D%2212%22%20%20%20%20%20sodipodi%3Ary%3D%2212%22%20%20%20%20%20transform%3D%22translate(3%2C3)%22%20%20%20%20%20style%3D%22fill%3A%23bbbbbb%22%20%2F%3E%20%20%3Ccircle%20%20%20%20%20cx%3D%2212%22%20%20%20%20%20cy%3D%2212%22%20%20%20%20%20r%3D%2210%22%20%20%20%20%20id%3D%22circle6%22%20%20%20%20%20sodipodi%3Acx%3D%2212%22%20%20%20%20%20sodipodi%3Acy%3D%2212%22%20%20%20%20%20sodipodi%3Arx%3D%2210%22%20%20%20%20%20sodipodi%3Ary%3D%2210%22%20%20%20%20%20transform%3D%22translate(3%2C3)%22%20%20%20%20%20style%3D%22fill%3A%232b2b2b%22%20%2F%3E%20%20%3Crect%20%20%20%20%20x%3D%2210%22%20%20%20%20%20y%3D%2214%22%20%20%20%20%20width%3D%2210%22%20%20%20%20%20height%3D%222%22%20%20%20%20%20id%3D%22rect8%22%20%20%20%20%20style%3D%22fill%3A%23bbbbbb%22%20%2F%3E%20%20%3Cpath%20%20%20%20%20fill%3D%22%23fff%22%20%20%20%20%20d%3D%22M12%2060c-6.627%200-12%205.373-12%2012s5.373%2012%2012%2012%2012-5.373%2012-12-5.373-12-12-12zm0%2022c-5.523%200-10-4.478-10-10s4.477-10%2010-10%2010%204.478%2010%2010-4.477%2010-10%2010z%22%20%20%20%20%20id%3D%22path10%22%20%2F%3E%3C%2Fsvg%3E');
			background-repeat: no-repeat; 
		}

		.blog-entry__toggle.is-closed { 
			background-image: url('data:image/svg+xml;charset=US-ASCII,%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%20standalone%3D%22no%22%3F%3E%3Csvg%20%20%20xmlns%3Adc%3D%22http%3A%2F%2Fpurl.org%2Fdc%2Felements%2F1.1%2F%22%20%20%20xmlns%3Acc%3D%22http%3A%2F%2Fcreativecommons.org%2Fns%23%22%20%20%20xmlns%3Ardf%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2F02%2F22-rdf-syntax-ns%23%22%20%20%20xmlns%3Asvg%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20%20xmlns%3Asodipodi%3D%22http%3A%2F%2Fsodipodi.sourceforge.net%2FDTD%2Fsodipodi-0.dtd%22%20%20%20xmlns%3Ainkscape%3D%22http%3A%2F%2Fwww.inkscape.org%2Fnamespaces%2Finkscape%22%20%20%20viewBox%3D%220%200%2030%2030%22%20%20%20id%3D%22svg2%22%20%20%20version%3D%221.1%22%20%20%20inkscape%3Aversion%3D%220.48.4%20r9939%22%20%20%20width%3D%22100%25%22%20%20%20height%3D%22100%25%22%20%20%20sodipodi%3Adocname%3D%22plus.svg%22%3E%20%20%3Cmetadata%20%20%20%20%20id%3D%22metadata16%22%3E%20%20%20%20%3Crdf%3ARDF%3E%20%20%20%20%20%20%3Ccc%3AWork%20%20%20%20%20%20%20%20%20rdf%3Aabout%3D%22%22%3E%20%20%20%20%20%20%20%20%3Cdc%3Aformat%3Eimage%2Fsvg%2Bxml%3C%2Fdc%3Aformat%3E%20%20%20%20%20%20%20%20%3Cdc%3Atype%20%20%20%20%20%20%20%20%20%20%20rdf%3Aresource%3D%22http%3A%2F%2Fpurl.org%2Fdc%2Fdcmitype%2FStillImage%22%20%2F%3E%20%20%20%20%20%20%3C%2Fcc%3AWork%3E%20%20%20%20%3C%2Frdf%3ARDF%3E%20%20%3C%2Fmetadata%3E%20%20%3Cdefs%20%20%20%20%20id%3D%22defs14%22%20%2F%3E%20%20%3Csodipodi%3Anamedview%20%20%20%20%20pagecolor%3D%22%23ffffff%22%20%20%20%20%20bordercolor%3D%22%23666666%22%20%20%20%20%20borderopacity%3D%221%22%20%20%20%20%20objecttolerance%3D%2210%22%20%20%20%20%20gridtolerance%3D%2210%22%20%20%20%20%20guidetolerance%3D%2210%22%20%20%20%20%20inkscape%3Apageopacity%3D%220%22%20%20%20%20%20inkscape%3Apageshadow%3D%222%22%20%20%20%20%20inkscape%3Awindow-width%3D%221525%22%20%20%20%20%20inkscape%3Awindow-height%3D%22877%22%20%20%20%20%20id%3D%22namedview12%22%20%20%20%20%20showgrid%3D%22false%22%20%20%20%20%20inkscape%3Azoom%3D%2221.817708%22%20%20%20%20%20inkscape%3Acx%3D%228.5831941%22%20%20%20%20%20inkscape%3Acy%3D%2215%22%20%20%20%20%20inkscape%3Awindow-x%3D%22-8%22%20%20%20%20%20inkscape%3Awindow-y%3D%22-8%22%20%20%20%20%20inkscape%3Awindow-maximized%3D%221%22%20%20%20%20%20inkscape%3Acurrent-layer%3D%22svg2%22%20%2F%3E%20%20%3Crect%20%20%20%20%20x%3D%227%22%20%20%20%20%20y%3D%2271%22%20%20%20%20%20fill%3D%22%23fff%22%20%20%20%20%20width%3D%2210%22%20%20%20%20%20height%3D%222%22%20%20%20%20%20id%3D%22rect4%22%20%2F%3E%20%20%3Cg%20%20%20%20%20id%3D%22g2993%22%20%20%20%20%20transform%3D%22translate(3%2C3)%22%3E%20%20%20%20%3Ccircle%20%20%20%20%20%20%20id%3D%22circle6%22%20%20%20%20%20%20%20r%3D%2212%22%20%20%20%20%20%20%20cy%3D%2212%22%20%20%20%20%20%20%20cx%3D%2212%22%20%20%20%20%20%20%20sodipodi%3Acx%3D%2212%22%20%20%20%20%20%20%20sodipodi%3Acy%3D%2212%22%20%20%20%20%20%20%20sodipodi%3Arx%3D%2212%22%20%20%20%20%20%20%20sodipodi%3Ary%3D%2212%22%20%20%20%20%20%20%20style%3D%22fill%3A%23bbbbbb%22%20%20%20%20%20%20%20d%3D%22M%2024%2C12%20C%2024%2C18.627417%2018.627417%2C24%2012%2C24%205.372583%2C24%200%2C18.627417%200%2C12%200%2C5.372583%205.372583%2C0%2012%2C0%2018.627417%2C0%2024%2C5.372583%2024%2C12%20z%22%20%2F%3E%20%20%20%20%3Ccircle%20%20%20%20%20%20%20id%3D%22circle8%22%20%20%20%20%20%20%20r%3D%2210%22%20%20%20%20%20%20%20cy%3D%2212%22%20%20%20%20%20%20%20cx%3D%2212%22%20%20%20%20%20%20%20sodipodi%3Acx%3D%2212%22%20%20%20%20%20%20%20sodipodi%3Acy%3D%2212%22%20%20%20%20%20%20%20sodipodi%3Arx%3D%2210%22%20%20%20%20%20%20%20sodipodi%3Ary%3D%2210%22%20%20%20%20%20%20%20style%3D%22fill%3A%232b2b2b%22%20%20%20%20%20%20%20d%3D%22M%2022%2C12%20C%2022%2C17.522847%2017.522847%2C22%2012%2C22%206.4771525%2C22%202%2C17.522847%202%2C12%202%2C6.4771525%206.4771525%2C2%2012%2C2%2017.522847%2C2%2022%2C6.4771525%2022%2C12%20z%22%20%2F%3E%20%20%20%20%3Cpolygon%20%20%20%20%20%20%20id%3D%22polygon10%22%20%20%20%20%20%20%20points%3D%2213%2C7%2011%2C7%2011%2C11%207%2C11%207%2C13%2011%2C13%2011%2C17%2013%2C17%2013%2C13%2017%2C13%2017%2C11%2013%2C11%20%22%20%20%20%20%20%20%20style%3D%22fill%3A%23bbbbbb%22%20%2F%3E%20%20%3C%2Fg%3E%3C%2Fsvg%3E');
			background-repeat: no-repeat; 
		}
	</style>
	<!-- get jquery from google cdn -->
	<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
	<script type="text/javascript" src="bootstrap-collapse.js"></script>
</head>
<body>

<?php
// Loop through posts
while ( have_posts() ): the_post();

	$categories = get_the_category();
	$htmlCat = '';
	$htmlCatClasse = '';
	if($categories){
		foreach($categories as $category) {
			/* $htmlCat .= '<a href="'.get_category_link( $category->term_id ).'" title="' . esc_attr( sprintf( __( "View all posts in %s" ), $category->name ) ) . '">'.$category->cat_name.'</a>'.$separator; */
			if ($category->cat_name === 'Soin du cheveu') {
				$htmlCat .= '<i class="sprite bg--hair"></i> ';
			}
			if ($category->cat_name === 'Cosméto bio') {
				$htmlCat .= '<i class="sprite bg--skin"></i> ';
			}
		}
		if ($htmlCat !== '') {
			$htmlCat = '<div class="blog-entry__category">'.$htmlCat.'</div>';
			$htmlCatClasse = 'blog-entry__title--has-categories';
		}
	}
	$id=get_the_ID();

?>

<article class="blog-entry">
	<h3 class="blog-entry__title <?php echo $htmlCatClasse ?><?php echo $htmlCat ?><?php the_title() ?></h3>
	<div id="blog-entry-<?php echo $id ?>" class="collapsable is-closed">
		 <div class="blog-entry__summary">
		 	<?php the_excerpt(); ?>
			<p>
				<a href="<?php the_permalink() ?>">Voir la suite sur le blog...</a>
			</p>
		</div>
		<footer>
			<ul>
				<li class="blog-entry__date">
					Publié le <time datetime="<?php echo get_the_date('DateTime::DATE_W3C'); ?>"><?php echo get_the_date(); ?></time>
				</li>
				<li class="blog-entry__category">
					Catégories : <?php the_category (','); ?>
				</li>
				<li class="blog-entry__tags">
					<?php the_tags ('Étiquetté avec : ',', ', ''); ?>
				</li>
			</ul>
		</footer>
	</div>
	<a href="#blog-entry-<?php echo $id ?>" class="blog-entry__toggle is-closed" data-toggle="collapse" title="Détail">Détail</a>
</article>

<?php endwhile;

// Reset query
wp_reset_query();

?>

</body>
</html>



