{*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<div class="page__center-canceled-margin">

{include file="$tpl_dir./breadcrumb.tpl"}

{include file="$tpl_dir./errors.tpl"}

{if isset($category)}
{if $category->id AND $category->active}
<!-- navbar -->
<div class="section-navbar" data-magellan-expedition="fixed">
    <ol>
        <li>
            <a class="active" data-magellan-arrival="a-top" href="#a-top" title="Critères de recherche">
                <span>Sélection</span>
            </a>
        </li>
        <li>
            <a data-magellan-arrival="a-products" href="#a-products" title="Les produits sélectionnés">
                <span>Catalogue</span>
            </a>
        </li>
        <li>
            <a data-magellan-arrival="a-advice" href="#a-advice" title="Avis">
                <span>Conseils beauté</span>
            </a>
        </li>
    </ol>
</div>
<!-- Search section -->
<section class="section">
	<header class="section__header section__header--is-hidden">
		<h2 class="section__title">Sélection</h2>
		<a class="section__icon section__icon--down" href="#a-products" title="Suivant">Suivant</a>
	</header>
	<div class="section__content">
		{$HOOK_CATEGORY_TOP}
	</div>
</section>
<!-- Product section -->
<a class="section-navbar__target" name="a-products" data-magellan-destination="a-products"></a>
<section class="section section--for-category">
	<header class="section__header">
		<h2 class="section__title">Catalogue</h2>
		<a class="section__icon section__icon--up" href="#a-top" title="Précédent">Précédent</a>
		<a class="section__icon section__icon--down" href="#a-advice" title="Suivant">Suivant</a>
	</header>
	<div class="section__content">
		{if $products}
		<section class="block section__subcontent--large" id="b-products">
			<div class="block__content collapse in" id="b-products__detail">
				<div class="block__inner">
					{include file="./product-list.tpl" products=$products}
				</div>
			</div>
		</section>
		{/if}
	</div>
</section>
<!-- Advice section -->
<a class="section-navbar__target" name="a-advice" data-magellan-destination="a-advice"></a>
<section class="section">
	<header class="section__header">
		<h2 class="section__title">Conseils beauté</h2>
		<a class="section__icon section__icon--up" href="#a-products" title="Précédent">Précédent</a>
		<a class="section__icon section__icon--down" href="#a-bottom" title="Suivant">Suivant</a>
	</header>
	<div class="section__content">
		{if $category->description || $category->id_image}
		<section class="block" id="category">
			<div class="block__content">
				<article id="article-1" class="article">
					<header>
						<!-- Category image -->
						{if $category->id_image}
						<a href="#" title="">
							<div class="img-container section__subcontent--cancel-padding-top-left-right">
								<img 
									id="categoryImage" 
									class="article__image"
									data-src="{$link->getCatImageLink($category->link_rewrite, $category->id_image, '480x271')|escape:'html'}"
									data-aspect-ratio="1.77"
									title="{$category->name|escape:'htmlall':'UTF-8'}"
									alt="{$category->name|escape:'htmlall':'UTF-8'}"
								/>
							</div>
							<!-- <h2>À voir</h2> -->
						</a>
						{/if}
						{if $category->description}
						<div>
							{if strlen($category->description) > 120}
								<div id="category-description-short">{$description_short}</div>
								<div id="category-description-full" style="display:none;">{$category->description}</div>
								<a class="article__more-link" href="#" onclick="$('#category-description-short').hide(); $('#category-description-full').show(); $(this).hide(); return false;" title="{l s='More'}">{l s='More'}</a>
							{else}
								<div>{$category->description}</div>
							{/if}
						</div>
						{/if}
					</header>
				</article>
			</div>
		</section>
		{/if}
		{$HOOK_CATEGORY_BOTTOM}
	</div>
</section>
<!-- Bottom section -->
<a class="section-navbar__target" name="a-bottom"></a>
<section class="section">
    <header class="section__header">
        <a class="section__icon section__icon--up" href="#a-advice" title="Précédent">Précédent</a>
        <a class="section__icon section__icon--top" href="#a-top" title="Top">Top</a>
    </header>
</section>
{elseif $category->id}
<p class="warning">{l s='This category is currently unavailable.'}</p>
{/if}
{/if}

</div>