module.exports = function(grunt) {
    // Project configuration.
    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),

        // ACO : ajout de grunticon
        grunticon: {
            myIcons: {
                options: {
                    // required config
                    src: 'svg/',
                    dest: '../css/icons/',

                    // optional grunticon config properties

                    // CSS filenames
                    datasvgcss: "icons.svg.css",
                    datapngcss: "icons.png.css",
                    urlpngcss: "icons.fallback.css",

                    // preview HTML filename
                    previewhtml: "preview.html",

                    // grunticon loader code snippet filename
                    loadersnippet: "grunticon.loader.txt",

                    // folder name (within dest) for png output
                    pngfolder: "png/",

                    // prefix for CSS classnames
                    cssprefix: "bg--",

                    // css file path prefix - this defaults to "/" and will be placed before the "dest" path when stylesheets 
                    // are loaded. This allows root-relative referencing of the CSS. If you don't want a prefix path, set to to ""
                    cssbasepath: "/",

                    // custom selectors
                    customselectors: {

                        "arrow-down": ".bg-before--arrow-down:before, .bg-after--arrow-down:after",
                        "arrow-left": ".bg-before--arrow-left:before, .bg-after--arrow-left:after",
                        "arrow-right": ".bg-before--arrow-right:before, .bg-after--arrow-right:after",
                        "arrow-up": ".bg-before--arrow-up:before, .bg-after--arrow-up:after",
                        "cancel": ".bg-before--cancel:before, .bg-after--cancel, \
.cancel, .has-search .filter-search__indicator",
                        "caret-bottom": ".bg-before--caret-bottom:before, .bg-after--caret-bottom:after, \
.section__icon--bottom",

                        "caret-down": ".bg-before--caret-down:before, .bg-after--caret-down:after, \
.section__icon--down",

                        "caret-left": ".bg-before--caret-left:before, .bg-after--caret-left:after, \
.section__icon--left",

                        "caret-right": ".bg-before--caret-right:before, .bg-after--caret-right:after, \
.section__icon--right",

                        "caret-top": ".bg-before--caret-top:before, .bg-after--caret-top:after, \
.section__icon--top",

                        "caret-up": ".bg-before--caret-up:before, .bg-after--caret-up:after, \
.section__icon--up",

                        "cart": ".bg-before--cart:before, .bg-after--cart:after",
                        "cart-white": ".bg-before--cart-white:before, .bg-after--cart-white:after",
                        "close": ".bg-before--close:before, .bg-after--close:after, \
.menu-toggle.is-opened",

                        "contract": ".bg-before--contract:before, .bg-after--contract:after",
                        "delete": ".bg-before--delete:before, .bg-after--delete:after",
                        "delivery": ".bg-before--delivery:before, .bg-after--delivery:after",
                        "elephant": ".bg-before--elephant:before, .bg-after--elephant:after",
                        "eye": ".bg-before--eye:before, .bg-after--eye:after",
                        "facebook": ".bg-before--facebook:before, .bg-after--facebook:after",
                        "facebook-primary": ".bg-before--facebook-primary:before, .bg-after--facebook-primary:after, \
.sharing__item--facebook",

                        "flag": ".bg-before--flag:before, .bg-after--flag:after",
                        "gear": ".bg-before--gear:before, .bg-after--gear:after",
                        "gift": ".bg-before--gift:before, .bg-after--gift:after",
                        "giraf": ".bg-before--giraf:before, .bg-after--giraf:after",
                        "google": ".bg-before--google:before, .bg-after--google:after",
                        "google-primary": ".bg-before--google-primary:before, .bg-after--google-primary:after, \
.sharing__item--google",

                        "hair": ".bg-before--hair:before, .bg-after--hair:after",
                        "help": ".bg-before--help:before, .bg-after--help:after",

                        "home": ".bg-before--home:before, .bg-after--home:after, \
.section__icon--home",

                        "impala": ".bg-before--impala:before, .bg-after--impala:after",
                        "info": ".bg-before--info:before, .bg-after--info:after",
                        "leave": ".bg-before--leave:before, .bg__leave--info:after",

                        "letter": ".bg-before--letter:before, .bg-after--letter:after",
                        "letter-white": ".bg-before--letter-white:before, .bg-after--letter-white:after",
                        "letter-primary": ".bg-before--letter-primary:before, .bg-after--letter-primary:after, \
.sharing__item--email",

                        "logo": ".bg-before--logo:before, .bg-after--logo:after",
                        "menu": ".bg-before--menu:before, .bg-after--menu:after",

                        "menu-white": ".bg-before--menu-white:before, .bg-after--menu-white:after, \
.menu-toggle",

                        "minus": ".bg-before--minus:before, .bg-after--minus:after, \
.blog-entry__toggle",

                        "new": ".bg-before--new:before, .bg-after--new:after",
                        "ok": ".bg-before--ok:before, .bg-after--ok:after",

                        "operator-minus": ".bg-before--operator-minus:before, .bg-after--operator-minus:after, \
.block__toggle:after",
                        "operator-minus-white": ".bg-before--operator-minus-white:before, .bg-after--operator-minus-white:after",

                        "operator-plus": ".bg-before--operator-plus:before, .bg-after--operator-plus:after, \
.block__toggle.collapsed:after",
                        "operator-plus-white": ".bg-before--operator-plus-white:before, .bg-after--operator-plus-white:after",

                        "plus": ".bg-before--plus:before, .bg-after--plus:after, \
.blog-entry__toggle.collapsed",

                        "plus-white": ".bg-before--plus-white:before, .bg-after--plus-white:after",
                        "portevoix": ".bg-before--portevoix:before, .bg-after--portevoix:after",
                        "printer-primary": ".bg-before--printer-primary:before, .bg-after--printer-primary:after, \
.sharing__item--printer",

                        "reader-next": ".bg-before--reader-next:before, .bg-after--reader-next:after, \
.orbit-next > span",

                        "reader-pause": ".bg-before--reader-pause:before, .bg-after--reader-pause:after, \
.orbit-timer > span",

                        "reader-play": ".bg-before--reader-play:before, .bg-after--reader-play:after, \
.orbit-timer.paused > span",

                        "reader-previous": ".bg-before--reader-previous:before, .bg-after--reader-previous:after, \
.orbit-prev > span",

                        "recycle": ".bg-before--recycle:before, .bg-after--recycle:after",
                        "register": ".bg-before--register:before, .bg-after--register:after",
                        "rss": ".bg-before--rss:before, .bg-after--rss:after",
                        "sapotille": ".bg-before--sapotille:before, .bg-after--sapotille:after",
                        "search": ".bg-before--search:before, .bg-after--search:after, \
.filter-search__indicator",
                        "secure": ".bg-before--secure:before, .bg-after--secure:after",
                        "share": ".bg-before--share:before, .bg-after--share:after",
                        "skin": ".bg-before--skin:before, .bg-after--skin:after",
                        "smile": ".bg-before--smile:before, .bg-after--smile:after",
                        "star-on": ".bg-before--star-on:before, .bg-after--star-on:after, .star.star_on, .star.star_hover, .star a:hover",
                        "star-off": ".bg-before--star-off:before, .bg-after--star-off:after, .star",
                        "twitter": ".bg-before--twitter:before, .bg-after--twitter:after",
                        "twitter-white": ".bg-before--twitter-white:before, .bg-after--twitter-white:after",
                        "twitter-primary": ".bg-before--twitter-primary:before, .bg-after--twitter-primary:after, \
.sharing__item--twitter",

                        "two-stars": ".bg-before--two-stars:before, .bg-after--two-stars:after",
                        "user": ".bg-before--user:before, .bg-after--user:after",
                        "youtube": ".bg-before--youtube:before, .bg-after--youtube:after",
                    }

                }
            }
        }

    });

    // ACO: ajout de grunticon
    grunt.loadNpmTasks('grunt-grunticon');

    //grunt.registerTask('default', 'lint qunit concat min grunticon');
    grunt.registerTask('default', 'grunticon');

};