// Initialize global object
(function() {

    if ('undefined' === typeof BRICK) {
        BRICK = {};
    }

    BRICK.current_column_width = 0;

    /**
     * Helper function to get current device
     * see implementation in css _main.scss
     */
    function _getDevice() {
        if (window.getComputedStyle) {
            var body = document.querySelector('body');
            var txt = window.getComputedStyle(body, ':after').content;
            if (txt.length > 0 && txt.charAt(0) == '"') {
                txt = txt.substr(1, txt.length - 2);
            }
            console.log('BRICK._getDevice : detected ' + txt);
            return txt;
        } else {
            throw 'Unabled to check current device';
        }
    }

    /**
     * Extends Isotope with special layout for centered masonry container
     * @see http://isotope.metafizzy.co/custom-layout-modes/centered-masonry.html
     */
    function _initIsotope() {
        $.Isotope.prototype._getCenteredMasonryColumns = function() {
            this.width = this.element.width();
            var parentWidth = this.element.parent().width();
            // i.e. options.masonry && options.masonry.columnWidth
            var colW = this.options.masonry && this.options.masonry.columnWidth ||
            // or use the size of the first item
            this.$filteredAtoms.outerWidth(true) ||
            // if there's no items, use size of container
            parentWidth;

            var cols = Math.floor(parentWidth / colW);
            cols = Math.max(cols, 1);

            // i.e. this.masonry.cols = ....
            this.masonry.cols = cols;
            // i.e. this.masonry.columnWidth = ...
            this.masonry.columnWidth = colW;

            console.log('BRICK._initIsotope : colW:' + colW + ', parentWidth:' + parentWidth + ', cols:' + cols);

        };

        $.Isotope.prototype._masonryReset = function() {
            console.log('BRICK._mansoryReset start');
            // layout-specific props
            this.masonry = {};
            // FIXME shouldn't have to call this again
            this._getCenteredMasonryColumns();
            var i = this.masonry.cols;
            this.masonry.colYs = [];
            while (i--) {
                this.masonry.colYs.push(0);
            }
            console.log('BRICK._mansoryReset end');
        };

        $.Isotope.prototype._masonryResizeChanged = function() {
            var prevColCount = this.masonry.cols;
            // get updated colCount
            this._getCenteredMasonryColumns();
            return (this.masonry.cols !== prevColCount);
        };

        $.Isotope.prototype._masonryGetContainerSize = function() {
            var unusedCols = 0,
                i = this.masonry.cols;
            // count unused columns
            while (--i) {
                if (this.masonry.colYs[i] !== 0) {
                    break;
                }
                unusedCols++;
            }
            var ret = {
                height: Math.max.apply(Math, this.masonry.colYs),
                // fit container to columns that have been used;
                width: (this.masonry.cols - unusedCols) * this.masonry.columnWidth
            };
            return ret;
        };
    };

    /**
     * Retourne le nombre de colonnes
     */
    function _getColumnWidth() {
        var dev = _getDevice();
        var cw = 320 / 2;
        switch (dev) {
            case "palm":
                cw = 320 / 2;
                break;
            case "palm-wide":
                cw = 480 / 2;
                break;
            case "lap":
                cw = 600 / 3;
                break;
            case "lap-wide":
                cw = 768 / 3;
                break;
            case "desk":
                cw = 992 / 4;
                break;
            case "desk-wide":
                cw = 1382 / 5;
                break;
            default:
                throw "Unknown device " + dev;
                break;
        }
        return cw;
    }

    /** 
     * Activation de Isotope à l'aide de la librairie enquire, uniquement si min-width est 480px
     * En deça n'utilise pas isotope (i.e. pas visible de toute façon)
     * - match pour appeler le plugin isotope
     * - unmatch pour désactiver le plugin
     */
    function _registerIsotope() {

        enquire.register("(min-width: 480px)", {

            // REQUIRED
            // Triggered when the media query transitions
            // *from an unmatched to a matched state*
            match: function() {
                console.log('BRICK.match start');
                var $wall = $(".wall");
                var cw = _getColumnWidth();

                // Montre toutes les briques avant d'appliquer le filtre
                $wall.find(".brick").show();

                // Activate isotope
                $wall.isotope({
                    // options
                    animationEngine: 'css',
                    layoutMode: 'masonry',
                    itemSelector: '.brick',
                    transformsEnabled: true,
                    resizable: false,
                    filter: ':not(.brick--is-filtered)',
                    masonry: {
                        columnWidth: cw
                    }
                });

                // Setup trigger on window resize (that will also trigger for this transition)
                $(window).smartresize(function() {
                    var cw = _getColumnWidth();
                    if (cw != BRICK.current_column_width) {
                        console.log('BRICK.smartresize column width change from ' + BRICK.current_column_width + ' to ' + cw);
                        $wall.isotope({
                            masonry: {
                                columnWidth: cw
                            }
                        });
                        BRICK.current_column_width = cw;
                    }
                });

                console.log('BRICK.match end');
            },

            // OPTIONAL, If supplied, triggered when the media query transitions
            // from a matched state to an unmatched state
            unmatch: function() {
                console.log('BRICK.unmatch start');
                var options = {
                    filter: ''
                };
                $(window).unbind("smartresize"); /* Unbind personal callback */
                var $wall = $(".wall");
                $wall.isotope(options);
                $wall.isotope('destroy');
                $wall.find(".brick--is-filtered").hide();
                BRICK.current_column_width = 0;
                console.log('BRICK.unmatch end');
            },

            // OPTIONAL, If supplied, triggered once immediately upon registration of the handler
            setup: function() {},

            // OPTIONAL, defaults to false
            // If set to true, defers execution the setup function
            // until the media query is first matched. still triggered just once
            deferSetup: false

        });

    };

    // Initialisation
    BRICK.init = function() {
        console.log('BRICK.init start');
        try {
            _initIsotope();
            _registerIsotope();
        } catch (e) {
            console.log('Error while registering Isotope ' + e);
        }
        // Show the wall
        $(".js .wall").css('visibility', 'visible');
        console.log('BRICK.init end');
    };

    // Rendering
    BRICK.render = function() {
        console.log('BRICK.render start');
        var $wall = $(".wall");
        if ($('.isotope').size() > 0) {
            console.log('BRICK.render isotope');
            $wall.find(".brick").show();
            $wall.isotope({
                filter: ':not(.brick--is-filtered)'
            });
        } else {
            console.log('BRICK.render std');
            $wall.find(".brick").show();
            $wall.find(".brick--is-filtered").hide();
        }
        // Refresh images
        if (typeof foresight !== "undefined") {
            console.log('BRICK.render image reload');
            foresight.reload();
        }
        console.log('BRICK.render end');
    }

})();