/**
 * Support for sharing
 */
(function() {

    if ('undefined' == typeof SHARING) {
        SHARING = {};
    }

    // PRIVATE MEMBERS
    var $buttons;
    var prefix = "sharing__item sharing__item--";


    function _init_buttons() {
        $buttons.each(function(i, button) {
            var $button = $(button);

            $button.on("mouseenter", function() {
                $buttons.stop().fadeTo(0, 0.6);
                $button.stop().fadeTo(0, 1);
            })
                .on("mouseleave", function() {
                    $buttons.fadeTo(300, 1);
                });

            if ($button[0].nodeName !== "A") {
                return;
            }

            var website = $button.attr("class").substr(prefix.length);
            var params = _get_button_params(website);

            $button.on("click", function(e) {
                //tracking.events(["SHARING", website]);
                var params = _get_button_params(website);
                window.open(params.href, '', "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");
                e.preventDefault();
            });
        });
    }

    function _get_button_params(website) {
        var page_url = document.location.toString().replace(/\/#([^/]+)\/$/, "/$1/"),
            encoded_url = encodeURIComponent(page_url),
            encoded_title = encodeURIComponent(document.title),
            params = {
                href: null,
                onclick: null
            };

        switch (website) {
            case "facebook":
                params.href = "https://www.facebook.com/sharer.php?u=" + encoded_url + "";
                break;

            case "twitter":
                params.href = "https://twitter.com/intent/tweet?text=" + encoded_title + " " + encoded_url + " via @noireonaturel";
                break;

            case "google":
                params.href = "https://plus.google.com/share?url=" + encoded_url + "&hl=fr";
                break;

            case "email":
                var subject = encodeURIComponent('Noire Ô Naturel'),
                    br = "%0a%0a",
                    message = encodeURIComponent('Salut! qu\'en penses-tu ?');
                message += br + encoded_url;
                message += br + encodeURIComponent('À bientôt !');
                params.href = "mailto:?subject=" + subject + "&body=" + message;
                break;
        }

        return params;
    }

    SHARING.init = function() {
        console.log('SHARING.init start');
        $buttons = $(".sharing > *");
        _init_buttons();
        console.log('SHARING.init end');
    };

})();