// ==========================================================================
// Showcase for product
// ==========================================================================

(function() {

    if ('undefined' === typeof SHOWCASE) {
        SHOWCASE = {};
    }

    function _on_thumb_click(event) {
        event.preventDefault();

        var $thumbnail = $(event.currentTarget),
            index = $thumbnail.attr("data-image-index");
        $thumbnail.closest(".showcase__thumbnails-list").find(".showcase__thumbnail.is-active").removeClass("is-active");
        $thumbnail.addClass("is-active");

        var $image = $thumbnail.closest(".showcase").find('.showcase__images-list-item[data-image-index="' + index + '"]'),
            $image_parent = $image.parent();
        $image.detach();
        $image.appendTo($image_parent);
        $image.siblings().fadeOut();
        $image.fadeIn();
    }

    SHOWCASE.init = function() {
        console.log('SHOWCASE.init start');
        $(".showcase__thumbnails-area").on("click", ".showcase__thumbnail", _on_thumb_click);
        // active le zoom
        $(".showcase__images-area .showcase__image").each(function() {
            $(this).parent().zoom({
                url: $(this).attr("data-url-full")
            });
        });
        console.log('SHOWCASE.init end');
    }

})();