/**
 * Prevent error with consoles
 */
// Avoid `console` errors in browsers that lack a console.
(function() {
    var method;
    var noop = function() {};
    var methods = ['assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error', 'exception', 'group', 'groupCollapsed', 'groupEnd',
    'info', 'log', 'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd', 'timeStamp', 'trace', 'warn'
    ];
    var length = methods.length;
    var console = (window.console = window.console || {});

    while (length--) {
        method = methods[length];
        // Only stub undefined methods.
        if (!console[method]) {
            console[method] = noop;
        }
    }
}());

//show a JS debug
function dbg(value) {
    var active = false; //true for active
    var firefox = true; //true if debug under firefox

    if (active)
        if (firefox)
            console.log(value);
        else
            alert(value);
}

/*
 * Preventing double submit using firefox
 * adapted from : http://duckranger.com/2012/01/double-submit-prevention-disabled-buttons-firefox-and-the-back-button/
 *
 * To use, add the following any time a button need disabling before submitting
 * <button type="submit" onclick="disableMe(this);document.myform.submit();">
 *
 */

// Handler for refreshing disabled buttons
function pageShowHandler(event) {
    if (event.persisted) {
        var $disabledElems = $('[markDisabled=1]');
        $disabledElems.attr('markDisabled', 0);
        $disabledElemens.attr('disabled', false);
        /*
        for (var i = 0; i < arrElements.length; i++) {
            var btn = arrElements[i];
            if (btn.markDisabled && btn.markDisabled == 1) {
                btn.markDisabled = 0;
                btn.disabled = false;
            }
        }
        */
        window.removeEventListener('pageshow', pageShowHandler, false);
    }
}

// Function to disable submit button
function disableSubmit(el) {
    el.disabled = true;
    el.markDisabled = true
    if (window.addEventListener) {
        //This is an Internet Explorer issue. addEventListener wasn't supported before IE9,
        //and it breaks your page on IE8 and below...
        window.addEventListener('pageshow', pageShowHandler, false);
    }
}

// Function to enable submit button
function enableSubmit(el) {
    if (el.markDisabled && el.markDisabled == 1) {
        el.markDisabled = 0;
        el.disabled = false;
    }
}


function checkCustomizations() {
    var pattern = new RegExp(' ?filled ?');

    if (typeof customizationFields != 'undefined')
        for (var i = 0; i < customizationFields.length; i++) {
            /* If the field is required and empty then we abort */
            if (parseInt(customizationFields[i][1]) == 1 && ($('#' + customizationFields[i][0]).html() == '' || $('#' + customizationFields[i][0]).text() != $('#' + customizationFields[i][0]).val()) && !pattern.test($('#' + customizationFields[i][0]).attr('class')))
                return false;
        }
    return true;
}

function emptyCustomizations() {
    if (typeof(customizationFields) == 'undefined') return;

    $('.customization_block .success').fadeOut(function() {
        $(this).remove();
    });
    $('.customization_block .error').fadeOut(function() {
        $(this).remove();
    });
    for (var i = 0; i < customizationFields.length; i++) {
        $('#' + customizationFields[i][0]).html('');
        $('#' + customizationFields[i][0]).val('');
    }
}

//return a formatted price
function formatCurrency(price, currencyFormat, currencySign, currencyBlank) {
    // if you modified this function, don't forget to modify the PHP function displayPrice (in the Tools.php class)
    blank = '';
    price = parseFloat(price.toFixed(6));
    price = ps_round(price, priceDisplayPrecision);
    if (currencyBlank > 0)
        blank = ' ';
    if (currencyFormat == 1)
        return currencySign + blank + formatNumber(price, priceDisplayPrecision, ',', '.');
    if (currencyFormat == 2)
        return (formatNumber(price, priceDisplayPrecision, ' ', ',') + blank + currencySign);
    if (currencyFormat == 3)
        return (currencySign + blank + formatNumber(price, priceDisplayPrecision, '.', ','));
    if (currencyFormat == 4)
        return (formatNumber(price, priceDisplayPrecision, ',', '.') + blank + currencySign);
    if (currencyFormat == 5)
        return (currencySign + blank + formatNumber(price, priceDisplayPrecision, '\'', '.'));
    return price;
}

//return a formatted number
function formatNumber(value, numberOfDecimal, thousenSeparator, virgule) {
    value = value.toFixed(numberOfDecimal);
    var val_string = value + '';
    var tmp = val_string.split('.');
    var abs_val_string = (tmp.length === 2) ? tmp[0] : val_string;
    var deci_string = ('0.' + (tmp.length === 2 ? tmp[1] : 0)).substr(2);
    var nb = abs_val_string.length;

    for (var i = 1; i < 4; i++)
        if (value >= Math.pow(10, (3 * i)))
            abs_val_string = abs_val_string.substring(0, nb - (3 * i)) + thousenSeparator + abs_val_string.substring(nb - (3 * i));

    if (parseInt(numberOfDecimal) === 0)
        return abs_val_string;
    return abs_val_string + virgule + (deci_string > 0 ? deci_string : '00');
}


function ps_round(value, precision) {
    if (typeof(roundMode) === 'undefined')
        roundMode = 2;
    if (typeof(precision) === 'undefined')
        precision = 2;

    method = roundMode;
    if (method === 0)
        return ceilf(value, precision);
    else if (method === 1)
        return floorf(value, precision);
    precisionFactor = precision === 0 ? 1 : Math.pow(10, precision);
    return Math.round(value * precisionFactor) / precisionFactor;
}