{*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{if $opc}
	{assign var="back_order_page" value="order-opc.php"}
	{else}
	{assign var="back_order_page" value="order.php"}
{/if}

{if $PS_CATALOG_MODE}
	{capture name=path}{l s='Your shopping cart'}{/capture}
	{include file="$tpl_dir./breadcrumb.tpl"}
	<h2 id="cart_title">{l s='Your shopping cart'}</h2>
	<p class="warning">{l s='Your new order was not accepted.'}</p>
{else}
<script type="text/javascript" src="{$base_dir}js/jquery/plugins/jquery.typewatch.js"></script>
<script type="text/javascript" src="{$js_dir}jquery.fancybox.js"></script>
<script src="{$js_dir}prestashop.statesManagement.js"></script>
<script src="{$js_dir}prestashop.order-opc.js"></script>
<script src="{$js_dir}prestashop.order-address.js"></script>
<script src="{$js_dir}prestashop.cart-summary.js"></script>
<script type="text/javascript">
	// <![CDATA[
	var imgDir = '{$img_dir}';
	var authenticationUrl = '{$link->getPageLink("authentication", true)|addslashes}';
	var orderOpcUrl = '{$link->getPageLink("order-opc", true)|addslashes}';
	var historyUrl = '{$link->getPageLink("history", true)|addslashes}';
	var guestTrackingUrl = '{$link->getPageLink("guest-tracking", true)|addslashes}';
	var addressUrl = '{$link->getPageLink("address", true, NULL, "back={$back_order_page}")|addslashes}';
	var orderProcess = 'order-opc';
	var guestCheckoutEnabled = {$PS_GUEST_CHECKOUT_ENABLED|intval};
	var currencySign = '{$currencySign|html_entity_decode:2:"UTF-8"}';
	var currencyRate = '{$currencyRate|floatval}';
	var currencyFormat = '{$currencyFormat|intval}';
	var currencyBlank = '{$currencyBlank|intval}';
	var displayPrice = {$priceDisplay};
	var taxEnabled = {$use_taxes};
	var conditionEnabled = {$conditions|intval};
	var countries = new Array();
	var countriesNeedIDNumber = new Array();
	var countriesNeedZipCode = new Array();
	var vat_management = {$vat_management|intval};
	
	var txtWithTax = "{l s='(tax incl.)' js=1}";
	var txtWithoutTax = "{l s='(tax excl.)' js=1}";
	var txtHasBeenSelected = "{l s='has been selected' js=1}";
	var txtNoCarrierIsSelected = "{l s='No carrier has been selected' js=1}";
	var txtNoCarrierIsNeeded = "{l s='No carrier is needed for this order' js=1}";
	var txtConditionsIsNotNeeded = "{l s='You do not need to accept the Terms of Service for this order.' js=1}";
	var txtTOSIsAccepted = "{l s='The service terms have been accepted' js=1}";
	var txtTOSIsNotAccepted = "{l s='The service terms have not been accepted' js=1}";
	var txtThereis = "{l s='There is' js=1}";
	var txtErrors = "{l s='Error(s)' js=1}";
	var txtDeliveryAddress = "{l s='Delivery address' js=1}";
	var txtInvoiceAddress = "{l s='Invoice address' js=1}";
	var txtModifyMyAddress = "{l s='Modify my address' js=1}";
	var txtInstantCheckout = "{l s='Instant checkout' js=1}";
	var txtSelectAnAddressFirst = "{l s='Please start by selecting an address.' js=1}";
	var errorCarrier = "{$errorCarrier}";
	var errorTOS = "{$errorTOS}";
	var checkedCarrier = "{if isset($checked)}{$checked}{else}0{/if}";

	var addresses = new Array();
	var isLogged = {$isLogged|intval};
	var isGuest = {$isGuest|intval};
	var isVirtualCart = {$isVirtualCart|intval};
	var isPaymentStep = {$isPaymentStep|intval};
	//]]>
</script>
	{if $productNumber}
<div class="page__center-canceled-margin">
<!-- navbar -->
<div class="section-navbar" data-magellan-expedition="fixed">
    <ol>
        <li>
            <a class="active" data-magellan-arrival="a-top" href="#a-top" title="Achats">
                <span>Récapitulatif</span>
            </a>
        </li>
        <li>
            <a data-magellan-arrival="a-address" href="#a-address" title="Coordonnées">
                <span>Coordonnées</span>
            </a>
        </li>
        <li>
            <a data-magellan-arrival="a-carrier" href="#a-carrier" title="Livraison">
                <span>Livraison</span>
            </a>
        </li>
        <li>
            <a data-magellan-arrival="a-payment" href="#a-payment" title="Paiement">
                <span>Finalisation et paiement</span>
            </a>
        </li>
    </ol>
</div>

<!-- Shopping Cart -->
<section class="section">
	<header class="section__header section__header--is-hidden">
		<h1 class="section__title">Récapitulatif</h1>
		<a class="section__icon section__icon--down" href="#a-address" title="Suivant">Suivant</a>
	</header>
	<div class="section__content">
		{include file="$tpl_dir./shopping-cart.tpl"}
	</div>
</section>
<!-- End Shopping Cart -->

<!-- Section coordonnées -->
<a class="section-navbar__target" name="a-address" data-magellan-destination="a-address"></a>
<section class="section">
	<header class="section__header">
		<h2 class="section__title">Coordonnées</h2>
		<a class="section__icon section__icon--up" href="#a-top" title="Précédent">Précédent</a>
		<a class="section__icon section__icon--down" href="#a-carrier" title="Suivant">Suivant</a>
	</header>
	<div class="section__content">
		{if $isLogged AND !$isGuest}
			{include file="$tpl_dir./order-address.tpl"}
		{else}
			<!-- Create account / Guest account / Login block -->
			{include file="$tpl_dir./order-opc-new-account.tpl"}
			<!-- END Create account / Guest account / Login block -->
		{/if}
	</div>
</section>

<!-- Carrier -->
<a class="section-navbar__target" name="a-carrier" data-magellan-destination="a-carrier"></a>
<section class="section">
	<header class="section__header">
		<h2 class="section__title">Livraison</h2>
		<a class="section__icon section__icon--up" href="#a-address" title="Précédent">Précédent</a>
		<a class="section__icon section__icon--down" href="#a-payment" title="Suivant">Suivant</a>
	</header>
	<div class="section__content">
		{include file="$tpl_dir./order-carrier.tpl"}
	</div>
</section>
<!-- END Carrier -->

<!-- Payment -->
<a class="section-navbar__target" name="a-payment" data-magellan-destination="a-payment"></a>
<section class="section">
	<header class="section__header">
		<h2 class="section__title">Finalisation et paiement</h2>
		<a class="section__icon section__icon--up" href="#a-carrier" title="Précédent">Précédent</a>
		<a class="section__icon section__icon--down" href="#a-bottom" title="Suivant">Suivant</a>
	</header>
	<div class="section__content">
		{include file="$tpl_dir./order-payment.tpl"}
	</div>
</section>
<!-- END Payment -->

<!-- Bottom section -->
<a class="section-navbar__target" name="a-bottom"></a>
<section class="section">
    <header class="section__header">
        <a class="section__icon section__icon--up" href="#a-payment" title="Précédent">Précédent</a>
        <a class="section__icon section__icon--top" href="#a-top" title="Top">Top</a>
    </header>
</section>

</div>
	{else}
		{capture name=path}{l s='Your shopping cart'}{/capture}
		{include file="$tpl_dir./breadcrumb.tpl"}
		<h2>{l s='Your shopping cart'}</h2>
		<p class="warning">{l s='Your shopping cart is empty.'}</p>
	{/if}
{/if}
