<!-- page__center-canceled-margin -->
<div class="page__center-canceled-margin">

{include file="$tpl_dir./errors.tpl"}
{if $errors|@count == 0}

<!-- Load specific js -->
<script src="{$js_dir}prestashop.product.js"></script>


<script type="text/javascript">
// <![CDATA[

// PrestaShop internal settings
var currencySign = '{$currencySign|html_entity_decode:2:"UTF-8"}';
var currencyRate = '{$currencyRate|floatval}';
var currencyFormat = '{$currencyFormat|intval}';
var currencyBlank = '{$currencyBlank|intval}';
var taxRate = {$tax_rate|floatval};
var jqZoomEnabled = {if $jqZoomEnabled}true{else}false{/if};

//JS Hook
var oosHookJsCodeFunctions = new Array();

// Parameters
var id_product = '{$product->id|intval}';
var productHasAttributes = {if isset($groups)}true{else}false{/if};
var quantitiesDisplayAllowed = {if $display_qties == 1}true{else}false{/if};
var quantityAvailable = {if $display_qties == 1 && $product->quantity}{$product->quantity}{else}0{/if};
var allowBuyWhenOutOfStock = {if $allow_oosp == 1}true{else}false{/if};
var availableNowValue = '{$product->available_now|escape:'quotes':'UTF-8'}';
var availableLaterValue = '{$product->available_later|escape:'quotes':'UTF-8'}';
var productPriceTaxExcluded = {$product->getPriceWithoutReduct(true)|default:'null'} - {$product->ecotax};
var productBasePriceTaxExcluded = {$product->base_price} - {$product->ecotax};

var reduction_percent = {if $product->specificPrice AND $product->specificPrice.reduction AND $product->specificPrice.reduction_type == 'percentage'}{$product->specificPrice.reduction*100}{else}0{/if};
var reduction_price = {if $product->specificPrice AND $product->specificPrice.reduction AND $product->specificPrice.reduction_type == 'amount'}{$product->specificPrice.reduction|floatval}{else}0{/if};
var specific_price = {if $product->specificPrice AND $product->specificPrice.price}{$product->specificPrice.price}{else}0{/if};
var product_specific_price = new Array();
{foreach from=$product->specificPrice key='key_specific_price' item='specific_price_value'}
    product_specific_price['{$key_specific_price}'] = '{$specific_price_value}';
{/foreach}
var specific_currency = {if $product->specificPrice AND $product->specificPrice.id_currency}true{else}false{/if};
var group_reduction = '{$group_reduction}';
var default_eco_tax = {$product->ecotax};
var ecotaxTax_rate = {$ecotaxTax_rate};
var currentDate = '{$smarty.now|date_format:'%Y-%m-%d %H:%M:%S'}';
var maxQuantityToAllowDisplayOfLastQuantityMessage = {$last_qties};
var noTaxForThisProduct = {if $no_tax == 1}true{else}false{/if};
var displayPrice = {$priceDisplay};
var productReference = '{$product->reference|escape:'htmlall':'UTF-8'}';
var productAvailableForOrder = {if (isset($restricted_country_mode) AND $restricted_country_mode) OR $PS_CATALOG_MODE}'0'{else}'{$product->available_for_order}'{/if};
var productShowPrice = '{if !$PS_CATALOG_MODE}{$product->show_price}{else}0{/if}';
var productUnitPriceRatio = '{$product->unit_price_ratio}';
var idDefaultImage = {if isset($cover.id_image_only)}{$cover.id_image_only}{else}0{/if};
var stock_management = {$stock_management|intval};
{if !isset($priceDisplayPrecision)}
    {assign var='priceDisplayPrecision' value=2}
{/if}
{if !$priceDisplay || $priceDisplay == 2}
    {assign var='productPrice' value=$product->getPrice(true, $smarty.const.NULL, $priceDisplayPrecision)}
    {assign var='productPriceWithoutReduction' value=$product->getPriceWithoutReduct(false, $smarty.const.NULL)}
{elseif $priceDisplay == 1}
    {assign var='productPrice' value=$product->getPrice(false, $smarty.const.NULL, $priceDisplayPrecision)}
    {assign var='productPriceWithoutReduction' value=$product->getPriceWithoutReduct(true, $smarty.const.NULL)}
{/if}


var productPriceWithoutReduction = '{$productPriceWithoutReduction}';
var productPrice = '{$productPrice}';

// Customizable field
var img_ps_dir = '{$img_ps_dir}';
var customizationFields = new Array();
{assign var='imgIndex' value=0}
{assign var='textFieldIndex' value=0}
{foreach from=$customizationFields item='field' name='customizationFields'}
    {assign var="key" value="pictures_`$product->id`_`$field.id_customization_field`"}
    customizationFields[{$smarty.foreach.customizationFields.index|intval}] = new Array();
    customizationFields[{$smarty.foreach.customizationFields.index|intval}][0] = '{if $field.type|intval == 0}img{$imgIndex++}{else}textField{$textFieldIndex++}{/if}';
    customizationFields[{$smarty.foreach.customizationFields.index|intval}][1] = {if $field.type|intval == 0 && isset($pictures.$key) && $pictures.$key}2{else}{$field.required|intval}{/if};
{/foreach}

// Images
var img_prod_dir = '{$img_prod_dir}';
var combinationImages = new Array();

{if isset($combinationImages)}
    {foreach from=$combinationImages item='combination' key='combinationId' name='f_combinationImages'}
        combinationImages[{$combinationId}] = new Array();
        {foreach from=$combination item='image' name='f_combinationImage'}
            combinationImages[{$combinationId}][{$smarty.foreach.f_combinationImage.index}] = {$image.id_image|intval};
        {/foreach}
    {/foreach}
{/if}

combinationImages[0] = new Array();
{if isset($images)}
    {foreach from=$images item='image' name='f_defaultImages'}
        combinationImages[0][{$smarty.foreach.f_defaultImages.index}] = {$image.id_image};
    {/foreach}
{/if}

// Translations
var doesntExist = '{l s='This combination does not exist for this product. Please select another combination.' js=1}';
var doesntExistNoMore = '{l s='This product is no longer in stock' js=1}';
var doesntExistNoMoreBut = '{l s='with those attributes but is available with others.' js=1}';
var uploading_in_progress = '{l s='Uploading in progress, please be patient.' js=1}';
var fieldRequired = '{l s='Please fill in all the required fields before saving your customization.' js=1}';

{if isset($groups)}
    // Combinations
    {foreach from=$combinations key=idCombination item=combination}
        var specific_price_combination = new Array();
        var available_date = new Array();
        specific_price_combination['reduction_percent'] = {if $combination.specific_price AND $combination.specific_price.reduction AND $combination.specific_price.reduction_type == 'percentage'}{$combination.specific_price.reduction*100}{else}0{/if};
        specific_price_combination['reduction_price'] = {if $combination.specific_price AND $combination.specific_price.reduction AND $combination.specific_price.reduction_type == 'amount'}{$combination.specific_price.reduction}{else}0{/if};
        specific_price_combination['price'] = {if $combination.specific_price AND $combination.specific_price.price}{$combination.specific_price.price}{else}0{/if};
        specific_price_combination['reduction_type'] = '{if $combination.specific_price}{$combination.specific_price.reduction_type}{/if}';
        specific_price_combination['id_product_attribute'] = {if $combination.specific_price}{$combination.specific_price.id_product_attribute|intval}{else}0{/if};
        available_date['date'] = '{$combination.available_date}';
        available_date['date_formatted'] = '{dateFormat date=$combination.available_date full=false}';
        addCombination({$idCombination|intval}, new Array({$combination.list}), {$combination.quantity}, {$combination.price}, {$combination.ecotax}, {$combination.id_image}, '{$combination.reference|addslashes}', {$combination.unit_impact}, {$combination.minimal_quantity}, available_date, specific_price_combination);
    {/foreach}
{/if}

{if isset($attributesCombinations)}
    // Combinations attributes informations
    var attributesCombinations = new Array();
    {foreach from=$attributesCombinations key=id item=aC}
        tabInfos = new Array();
        tabInfos['id_attribute'] = '{$aC.id_attribute|intval}';
        tabInfos['attribute'] = '{$aC.attribute}';
        tabInfos['group'] = '{$aC.group}';
        tabInfos['id_attribute_group'] = '{$aC.id_attribute_group|intval}';
        attributesCombinations.push(tabInfos);
    {/foreach}
{/if}
//]]>
</script>

<div class="section-navbar section-navbar--is-hidden" data-magellan-expedition="fixed">
<!-- <div class="section-navbar" data-magellan-expedition="fixed"> -->
    <ol>
        <li>
            <a class="active" data-magellan-arrival="a-top" href="#a-top" title="Produit">
                <span>Produit
                </span>
            </a>
        </li>
        <li>
            <a data-magellan-arrival="a-order" href="#a-order" title="Commander">
                <span>Commander
                </span>
            </a>
        </li>
        <li>
            <a data-magellan-arrival="a-about" href="#a-about" title="Infos">
                <span>Infos
                </span>
            </a>
        </li>
        <li>
            <a data-magellan-arrival="a-comment" href="#a-comment" title="Avis">
                <span>Avis</span>
            </a>
        </li>
    </ol>
</div>
<section class="section">
    <header class="section__header section__header--is-hidden">
        <h4 class="section__title">Produits sélectionnés</h4>
        <a class="section__icon section__icon--left" href="#" title="Produit précédent">Produit précédent</a>
        <a class="section__icon section__icon--right" href="#" title="Produit suivant">Produit suivant</a>
    </header>
    <!-- s-top -->
    <div class="section__content" id="s-top">
        <div class="block product-header block--no-border">
            <!--<h2 class="product__category">Cheveux</h2>-->
            <h1 class="product-header__title">{$product->name|escape:'htmlall':'UTF-8'}</h1>
            {if $product->quantity <= 0 || $product->available_now}
            <h2 class="product-header__subtitle{if $product->quantity <= 0} class="warning_inline"{/if}">{if $product->quantity <= 0}{if $allow_oosp}{$product->available_later}{else}{l s='This product is no longer in stock'}{/if}{else}{$product->available_now}{/if}</h2>
            {/if}
            <!--                            
            <div class="product-header__content">
                <span class="product-header__size">250&nbsp;ml
                </span>
                <a class="product-header__reviews bg--two-stars" href="">Avis (2)</a>
                <span class="product-header__price">76,00&nbsp;€
                </span>
            </div>
            -->
        </div>
        <div class="block showcase">
            <div class="showcase__images-area">
                <!-- product imgages -->
                <ul class="showcase__images-list">
                    {if isset($images)}
                        {foreach from=$images item=image name=thumbnails}
                            {assign var=imageIds value="`$product->id`-`$image.id_image`"}
                            {if !empty($image.legend)}
                                {assign var=imageTitlte value=$image.legend|escape:'htmlall':'UTF-8'}
                            {else}
                                {assign var=imageTitlte value=$product->name|escape:'htmlall':'UTF-8'}
                            {/if}

                    <li class="showcase__images-list-item" data-image-index="{$image.position}">
                        <img 
                            class="showcase__image" 
                            data-src="{$link->getImageLink($product->link_rewrite, $imageIds, '480x480')|escape:'html'}"
                            data-url-full="{$link->getImageLink($product->link_rewrite, $imageIds, '1200x1200')|escape:'html'}" 
                            data-aspect-ratio="1"
                            title="{$imageTitlte}"
                            alt="{$imageTitlte}"
                         />
                    </li>
                        {/foreach}
                    {else}
                    <li class="showcase__images-list-item" data-image-index="0">
                        <img src="{$img_prod_dir}{$lang_iso}-default-large_default.jpg" id="bigpic" alt="" title="{$product->name|escape:'htmlall':'UTF-8'}" width="{$largeSize.width}" height="{$largeSize.height}" />
                        <span class="span_link">{l s='Maximize'}</span>
                    </li>
                    {/if}
                </ul>
            </div>
            {if !$content_only}
                <!-- ACO: sharing block -->
                <div class="sharing">
                    <a class="sharing__item sharing__item--facebook" title="Partager sur Facebook" rel="nofollow">Partager sur Facebook</a>
                    <a class="sharing__item sharing__item--twitter" title="Partager sur Twitter" rel="nofollow">Partager sur Twitter</a>
                    <a class="sharing__item sharing__item--google" title="Partager sur Google+" rel="nofollow">Partager sur Google+</a>
                    <a class="sharing__item sharing__item--email" title="Partager par courriel" rel="nofollow">Partager par courriel</a>
                    <a class="sharing__item sharing__item--printer" href="javascript:print();" title="Imprimer" rel="nofollow">Imprimer</a>
                </div>
                <!-- usefull links-->
                {if $HOOK_EXTRA_LEFT}
                <ul id="usefull_link_block" class="clearfix inline">
                    {if $HOOK_EXTRA_LEFT}{$HOOK_EXTRA_LEFT}{/if}
                    {*
                    <li class="print">
                        <a href="javascript:print();">
                            {l s='Print'}
                        </a>
                    </li>
                    *}
                    {if $have_image && !$jqZoomEnabled}{/if}
                </ul>
                {/if}
            {/if}
            <p class="showcase__help">Zoom en survolant</p>
            {if isset($images) && count($images) > 0}
            <!-- thumbnails -->
            <div class="showcase__thumbnails-area">
                <ul class="showcase__thumbnails-list">
                    {if isset($images)}
                    {foreach from=$images item=image name=thumbnails}
                    {assign var=imageIds value="`$product->id`-`$image.id_image`"}
                    {if !empty($image.legend)}
                        {assign var=imageTitlte value=$image.legend|escape:'htmlall':'UTF-8'}
                    {else}
                        {assign var=imageTitlte value=$product->name|escape:'htmlall':'UTF-8'}
                    {/if}
                    <li class="showcase__thumbnails-list-item">
                        <a href="#" class="showcase__thumbnail{if $smarty.foreach.thumbnails.first} is-active{/if}" data-image-index="{$image.position}" title="{$imageTitlte}">
                            <img 
                                data-src="{$link->getImageLink($product->link_rewrite, $imageIds, '100x100')|escape:'html'}" 
                                data-aspect-ratio="1" 
                                title="{$imageTitlte}" 
                                alt="{$imageTitlte}" 
                            />
                        </a>
                    </li>
                    {/foreach}
                    {/if}
                </ul>
            </div>
            {/if}
        </div>
        <div class="block product-description">
            {if $product->show_price AND !isset($restricted_country_mode) AND !$PS_CATALOG_MODE}
            <!-- prices -->
            <div class="product-description__price">
                {if $priceDisplay >= 0 && $priceDisplay <= 2}
                <span class="product-description__price-val">{convertPrice price=$productPrice}</span>
                {/if}
                <span class="product-description__price-txt">+&nbsp;livraison</span>
            </div>
            {/if}
            {if $product->description_short}
            <div class="product-description__text text">
                {$product->description_short}
            </div>
            {/if}
            <ul class="product-description__reference">
                <li><span>{l s='Référence :'} </span><span>{$product->reference|escape:'htmlall':'UTF-8'}</span>
                </li>
                {if isset($features) && $features}
                <!-- product's features -->
                    {foreach from=$features item=feature}
                        {if isset($feature.value)}
                <li><span>{$feature.name|escape:'htmlall':'UTF-8'} : </span><span>{$feature.value|escape:'htmlall':'UTF-8'}</span></li>
                        {/if}
                    {/foreach}
                {/if}
            </ul>
        </div>
    </div>
    <!-- s-top end -->
</section>
<a class="section-navbar__target" name="a-order" data-magellan-destination="a-order"></a>
<section class="section">
    <header class="section__header">
        <h2 class="section__title">Commander</h2>
        <a class="section__icon section__icon--up" href="#a-top" title="Précédent">Précédent</a>
        <a class="section__icon section__icon--down" href="#a-about" title="Suivant">Suivant</a>
    </header>
    <!-- s-order -->
    <div class="section__content" id="s-order">
        <section class="block">
            <form id="buy_block" class="product-order form{if $PS_CATALOG_MODE AND !isset($groups) AND $product->quantity > 0}hidden{/if}" action="{$link->getPageLink('cart')|escape:'html'}" method="post" autocomplete="off">
                <!-- hidden datas -->
                <p class="hidden">
                    <input type="hidden" name="token" value="{$static_token}" />
                    <input type="hidden" name="id_product" value="{$product->id|intval}" id="product_page_product_id" />
                    <input type="hidden" name="add" value="1" />
                    <input type="hidden" name="id_product_attribute" id="idCombination" value="" />
                </p>
                <ul class="form-fields form-fields--inline">
                    <!-- quantity wanted -->
                    <li{if (!$allow_oosp && $product->quantity <= 0) OR $virtual OR !$product->available_for_order OR $PS_CATALOG_MODE} style="display: none;"{/if}>
                        <label class="product-order__qty-label hecto" for="product-qty">{l s='Quantity:'}</label>
                        <input class="product-order__qty deca one-sixth" id="quantity_wanted" maxlength="3" name="qty" placeholder="1" size="2" title="Quantité" type="text" inputmode="numeric" value="{if isset($quantityBackup)}{$quantityBackup|intval}{else}{if $product->minimal_quantity > 1}{$product->minimal_quantity}{else}1{/if}{/if}" {if $product->minimal_quantity > 1}onkeyup="checkMinimalQuantity({$product->minimal_quantity});"{/if} >
                        <a href="#" data-field-qty="qty" class="btn button-minus product_quantity_down">
                            <span><i class="sprite bg--operator-minus-white"></i></span>
                        </a>
                        <a href="#" data-field-qty="qty" class="btn button-plus product_quantity_up ">
                            <span><i class="sprite bg--operator-plus-white"></i></span>
                        </a>
                        <span class="clearfix">&nbsp;</span>

                        <!-- minimal quantity wanted -->
                        <small class="extra-help" {if $product->minimal_quantity <= 1 OR !$product->available_for_order OR $PS_CATALOG_MODE}style="display: none;"{/if}>
                            {l s='This product is not sold individually. You must select at least'} <b id="minimal_quantity_label">{$product->minimal_quantity}</b> {l s='quantity for this product.'}
                            {if $product->minimal_quantity > 1}
                                <script type="text/javascript">
                                    checkMinimalQuantity();
                                </script>
                            {/if}
                        </small>
                    </li>
                    <li id="add_to_cart">
                        <button type="submit" name="Submit" class="callout-button callout-button--icon-after bg-after--cart-white">{l s='Add to cart'}</button>
                        <!-- <button type="submit" name="Submit" class="btn hecto one-whole exclusive product-order__add-to-cart">{l s='Add to cart'}<i class="sprite sprite--large bg--cart-white "></i></button> -->
                    </li>
                </ul>
            </form>
        </section>
        <section class="block">
            <ul class="reassuring">
                <li>
                    <a href="#" title="secure">
                        <i class="bg--secure"></i>
                        <p>Paiement sécurisé</p>
                    </a>
                </li>
                <li>
                    <a href="#" title="près de chez soi">
                        <i class="bg--delivery"></i>
                        <p>Livraison près de chez soi</p>
                    </a>
                </li>
                <li>
                    <a href="#" title="retour facile">
                        <i class="bg--recycle"></i>
                        <p>Retour facile</p>
                    </a>
                </li>
                <li>
                    <a href="#" title="livraison gratuite">
                        <i class="bg--gift"></i>
                        <p>Livraison offerte dès 35 € d'achat</p>
                    </a>
                </li>
            </ul>
        </section>
    </div>
    <!-- s-order end -->
</section>
<a class="section-navbar__target" name="a-about" data-magellan-destination="a-about" id="a-about"></a>
<section class="section block-accordion">
    <header class="section__header">
        <h2 class="section__title section__title--is-hidden">Infos</h2>
        <a class="section__icon section__icon--up" href="#a-order" title="Précédent">Précédent</a>
        <a class="section__icon section__icon--down" href="#a-comment" title="Suivant">Suivant</a>
    </header>
    <!-- s-about -->
    <div class="section__content" id="s-about">
        {$HOOK_PRODUCT_3}
    </div>
    <!-- s-about end -->
</section>
<a class="section-navbar__target" name="a-comment" data-magellan-destination="a-comment" id="a-comment"></a>
<section class="section">
    <header class="section__header">
        <h2 class="section__title section__title--is-hidden">Avise</h2>
        <a class="section__icon section__icon--up" href="#a-about" title="Précédent">Précédent</a>
        <a class="section__icon section__icon--down" href="#a-bottom" title="Suivant">Suivant</a>
    </header>
    <!-- s-comment -->
    <div class="section__content" id="s-comment">
        {$HOOK_PRODUCT_4}
        {$HOOK_PRODUCT_TAB_CONTENT}
    </div>
    <!-- s-comment end -->
</section>
<a class="section-navbar__target" name="a-bottom" id="a-bottom"></a>
<section class="section" id="s-bottom">
    <header class="section__header">
        <a class="section__icon section__icon--up" href="#a-comment" title="Précédent">Précédent</a>
        <a class="section__icon section__icon--top" href="#a-top" title="Home">Home</a>
    </header>
</section>
{/if}
</div>
<!-- page__center-canceled-margin end -->
