# Contributing to inuit.css

So, you want to contribute to inuit.css? That’s awesome!

However, I do ask that you follow a few small rules…

## Bugs and issues

If you believe you have a bug or issue that needs investigating:

* Search existing issues to avoid opening a duplicate.
* Please open an issue and be as descriptive as possible.
* If you can, accompany the report with a reduced test case via
  [jsFiddle](http://jsfiddle.net/) or similar.

## Pull requests

If submitting a pull request:

* Follow the predefined code style used in the framework (I’m afraid that means
  no spaces before opening braces and after colons (I’m weird like that)).
* Read my [Git workflow for inuit.css](http://csswizardry.com/2012/12/my-git-workflow-for-inuit-css/)
  and try and keep as close to that as possible.
* Carry out all your work in a topic branch with a suitable name, e.g.
  `fix/grids`, `feature/new-object` etc.
* Commit sensibly and, if needs be, rebase your branch to tidy your commits up.
* Ensure inuit.css still compiles without error through both the standalone
  library and the web template.
* Submit all pull requests against the `incoming` branch. Any pull requests
  submitted against `master` **will** be declined.
* Advise on versioning if possible; if the changes require a version bump or
  merely a patch bump, please let me know.

## Feature requests

I am open to requests for adding new features, but please bear in mind:

* Make sure it fits in the with ideals and scope of the project; inuit.css has a
  very specific purpose and all features need tp tie in with this.
* Have a go at adding the new functionality yourself and opening a pull request.
* **Discuss any features before attempting to develop them yourself;** I would
  hate for anyone to spend a tonne of time on something that I end up rejecting.
